<?php

/*
 * This file is part of Composer.
 *
 * (c) Nils Adermann <naderman@naderman.de>
 *     Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Composer;

use Composer\Autoload\ClassLoader;
use Composer\Semver\VersionParser;

/**
 * This class is copied in every Composer installed project and available to all
 *
 * To require it's presence, you can require `composer-runtime-api ^2.0`
 */
class InstalledVersions
{
    private static $installed = array (
  'root' => 
  array (
    'pretty_version' => 'dev-5.1-dev',
    'version' => 'dev-5.1-dev',
    'aliases' => 
    array (
    ),
    'reference' => '5c65f2b4f3427aa87bf3eb818af2caf6921e845a',
    'name' => 'joomla/joomla-cms',
  ),
  'versions' => 
  array (
    'algo26-matthias/idna-convert' => 
    array (
      'pretty_version' => 'v3.1.0',
      'version' => '3.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '340a4dc65f6b0d9884853a3d32895d82f0c1502a',
    ),
    'brick/math' => 
    array (
      'pretty_version' => '0.11.0',
      'version' => '0.11.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '0ad82ce168c82ba30d1c01ec86116ab52f589478',
    ),
    'composer/ca-bundle' => 
    array (
      'pretty_version' => '1.3.7',
      'version' => '1.3.7.0',
      'aliases' => 
      array (
      ),
      'reference' => '76e46335014860eec1aa5a724799a00a2e47cc85',
    ),
    'defuse/php-encryption' => 
    array (
      'pretty_version' => 'v2.4.0',
      'version' => '2.4.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'f53396c2d34225064647a05ca76c1da9d99e5828',
    ),
    'doctrine/inflector' => 
    array (
      'pretty_version' => '1.4.4',
      'version' => '1.4.4.0',
      'aliases' => 
      array (
      ),
      'reference' => '4bd5c1cdfcd00e9e2d8c484f79150f67e5d355d9',
    ),
    'dragonmantank/cron-expression' => 
    array (
      'pretty_version' => 'v3.3.3',
      'version' => '3.3.3.0',
      'aliases' => 
      array (
      ),
      'reference' => 'adfb1f505deb6384dc8b39804c5065dd3c8c8c0a',
    ),
    'enshrined/svg-sanitize' => 
    array (
      'pretty_version' => '0.15.4',
      'version' => '0.15.4.0',
      'aliases' => 
      array (
      ),
      'reference' => 'e50b83a2f1f296ca61394fe88fbfe3e896a84cf4',
    ),
    'fig/link-util' => 
    array (
      'pretty_version' => '1.2.0',
      'version' => '1.2.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '10e52348a2e9ad4581f2bf3e16458f0861a88c6a',
    ),
    'google/recaptcha' => 
    array (
      'pretty_version' => '1.3.0',
      'version' => '1.3.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'd59a801e98a4e9174814a6d71bbc268dff1202df',
    ),
    'jakeasmith/http_build_url' => 
    array (
      'pretty_version' => '1.0.1',
      'version' => '1.0.1.0',
      'aliases' => 
      array (
      ),
      'reference' => '93c273e77cb1edead0cf8bcf8cd2003428e74e37',
    ),
    'jfcherng/php-color-output' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '6c7bf16686cc6a291647fcb87491640a2d5edd20',
    ),
    'jfcherng/php-diff' => 
    array (
      'pretty_version' => '6.15.3',
      'version' => '6.15.3.0',
      'aliases' => 
      array (
      ),
      'reference' => '39be09756f8eda115299add3f34dc64b4bc32b66',
    ),
    'jfcherng/php-mb-string' => 
    array (
      'pretty_version' => '2.0.1',
      'version' => '2.0.1.0',
      'aliases' => 
      array (
      ),
      'reference' => '8407bfefde47849c9e7c9594e6de2ac85a0f845d',
    ),
    'jfcherng/php-sequence-matcher' => 
    array (
      'pretty_version' => '4.0.3',
      'version' => '4.0.3.0',
      'aliases' => 
      array (
      ),
      'reference' => 'd2038ac29627340a7458609072a8ba355e80ec5b',
    ),
    'joomla/application' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '96d279d19d7551746f97f7702cf92ad050eac01f',
    ),
    'joomla/archive' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '843ec2ae8f539b2aaed0846113dbb2cb52bae1e1',
    ),
    'joomla/authentication' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'c8caa1b772c9ff7442115f68f6d1a6db1f633e8a',
    ),
    'joomla/console' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'e105c751a53b63d5ff932c122e31ddf5480aa66d',
    ),
    'joomla/crypt' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '2f1c4e43eeb520557887a9e6ed6b2747485ee78d',
    ),
    'joomla/data' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '1fd9dbac7a19c761874784ea4c8215c3c3ff775b',
    ),
    'joomla/database' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'd440247b1e07710f22d5e07650393fbd9364b01e',
    ),
    'joomla/di' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'ec3866463257b3d4bfbd5ed0900a5e5505b909cb',
    ),
    'joomla/event' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'b259ffdb574067ec74953693cb61a9690291920e',
    ),
    'joomla/filesystem' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '1398fe1b3acbd97c5237cd9b405530a1f7d49daa',
    ),
    'joomla/filter' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'b589b6a6c40ace650e2f55ed404994bd99ac3d4a',
    ),
    'joomla/http' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'ec389a64def1d71d145fdcc06895cbd960f5d805',
    ),
    'joomla/input' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '3ab947f2baf8b8f08b8ecc11f7ada91092a75354',
    ),
    'joomla/joomla-cms' => 
    array (
      'pretty_version' => 'dev-5.1-dev',
      'version' => 'dev-5.1-dev',
      'aliases' => 
      array (
      ),
      'reference' => '5c65f2b4f3427aa87bf3eb818af2caf6921e845a',
    ),
    'joomla/language' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'd2008ccb727f3a582579496d1fba9a4af840c03c',
    ),
    'joomla/oauth1' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'bf390ed9288a6b858853880efc41620dd8d08a2d',
    ),
    'joomla/oauth2' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '70f61fe09a9e7d261684194f8d55a2035e84dbcc',
    ),
    'joomla/registry' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'dc57ab21856e79d45e5a44cf6d41253a2414d110',
    ),
    'joomla/router' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '951c2fa144b459cc35d9fe69193e970a3ef86893',
    ),
    'joomla/session' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'be15f3eee054802c3d8dfeabb2e42ecbe5a4c574',
    ),
    'joomla/string' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '9d76d779450745679c2fa591add238b5dd3f203f',
    ),
    'joomla/uri' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '42862cc99be6dc75587e6ce6eb29e0c33de6ffa2',
    ),
    'joomla/utilities' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '0b85f5c876b7b81046648402db4b84168be96d9a',
    ),
    'laminas/laminas-diactoros' => 
    array (
      'pretty_version' => '2.25.2',
      'version' => '2.25.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '9f3f4bf5b99c9538b6f1dbcc20f6fec357914f9e',
    ),
    'lcobucci/clock' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '039ef98c6b57b101d10bd11d8fdfda12cbd996dc',
    ),
    'lcobucci/jwt' => 
    array (
      'pretty_version' => '4.3.0',
      'version' => '4.3.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '4d7de2fe0d51a96418c0d04004986e410e87f6b4',
    ),
    'maximebf/debugbar' => 
    array (
      'pretty_version' => 'v1.19.0',
      'version' => '1.19.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '30f65f18f7ac086255a77a079f8e0dcdd35e828e',
    ),
    'mtdowling/cron-expression' => 
    array (
      'replaced' => 
      array (
        0 => '^1.0',
      ),
    ),
    'paragonie/constant_time_encoding' => 
    array (
      'pretty_version' => 'v2.6.3',
      'version' => '2.6.3.0',
      'aliases' => 
      array (
      ),
      'reference' => '58c3f47f650c94ec05a151692652a868995d2938',
    ),
    'paragonie/random_compat' => 
    array (
      'replaced' => 
      array (
        0 => '9.99.99',
      ),
    ),
    'paragonie/sodium_compat' => 
    array (
      'pretty_version' => 'v1.20.0',
      'version' => '1.20.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'e592a3e06d1fa0d43988c7c7d9948ca836f644b6',
    ),
    'phpmailer/phpmailer' => 
    array (
      'pretty_version' => 'v6.8.1',
      'version' => '6.8.1.0',
      'aliases' => 
      array (
      ),
      'reference' => 'e88da8d679acc3824ff231fdc553565b802ac016',
    ),
    'phpseclib/bcmath_compat' => 
    array (
      'pretty_version' => '2.0.1',
      'version' => '2.0.1.0',
      'aliases' => 
      array (
      ),
      'reference' => '2ffea8bfe1702b4535a7b3c2649c4301968e9a3c',
    ),
    'phpseclib/phpseclib' => 
    array (
      'pretty_version' => '3.0.23',
      'version' => '3.0.23.0',
      'aliases' => 
      array (
      ),
      'reference' => '866cc78fbd82462ffd880e3f65692afe928bed50',
    ),
    'psr/clock' => 
    array (
      'pretty_version' => '1.0.0',
      'version' => '1.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'e41a24703d4560fd0acb709162f73b8adfc3aa0d',
    ),
    'psr/clock-implementation' => 
    array (
      'provided' => 
      array (
        0 => '1.0',
      ),
    ),
    'psr/container' => 
    array (
      'pretty_version' => '1.1.2',
      'version' => '1.1.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '513e0666f7216c7459170d56df27dfcefe1689ea',
    ),
    'psr/container-implementation' => 
    array (
      'provided' => 
      array (
        0 => '~1.0',
      ),
    ),
    'psr/event-dispatcher' => 
    array (
      'pretty_version' => '1.0.0',
      'version' => '1.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'dbefd12671e8a14ec7f180cab83036ed26714bb0',
    ),
    'psr/http-client' => 
    array (
      'pretty_version' => '1.0.3',
      'version' => '1.0.3.0',
      'aliases' => 
      array (
      ),
      'reference' => 'bb5906edc1c324c9a05aa0873d40117941e5fa90',
    ),
    'psr/http-factory' => 
    array (
      'pretty_version' => '1.0.2',
      'version' => '1.0.2.0',
      'aliases' => 
      array (
      ),
      'reference' => 'e616d01114759c4c489f93b099585439f795fe35',
    ),
    'psr/http-factory-implementation' => 
    array (
      'provided' => 
      array (
        0 => '1.0',
      ),
    ),
    'psr/http-message' => 
    array (
      'pretty_version' => '1.1',
      'version' => '1.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'cb6ce4845ce34a8ad9e68117c10ee90a29919eba',
    ),
    'psr/http-message-implementation' => 
    array (
      'provided' => 
      array (
        0 => '1.0',
      ),
    ),
    'psr/link' => 
    array (
      'pretty_version' => '1.1.1',
      'version' => '1.1.1.0',
      'aliases' => 
      array (
      ),
      'reference' => '846c25f58a1f02b93a00f2404e3626b6bf9b7807',
    ),
    'psr/link-implementation' => 
    array (
      'provided' => 
      array (
        0 => '1.0',
        1 => '1.0|2.0',
      ),
    ),
    'psr/log' => 
    array (
      'pretty_version' => '3.0.0',
      'version' => '3.0.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'fe5ea303b0887d5caefd3d431c3e61ad47037001',
    ),
    'psr/log-implementation' => 
    array (
      'provided' => 
      array (
        0 => '1.0|2.0|3.0',
      ),
    ),
    'spomky-labs/cbor-php' => 
    array (
      'pretty_version' => '3.0.2',
      'version' => '3.0.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '81d5dff7a1101d680729b5789f4359d01b15e6c5',
    ),
    'spomky-labs/pki-framework' => 
    array (
      'pretty_version' => '1.1.0',
      'version' => '1.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'd3ba688bf40e7c6e0dabf065ee18fc210734e760',
    ),
    'symfony/console' => 
    array (
      'pretty_version' => 'v6.3.4',
      'version' => '6.3.4.0',
      'aliases' => 
      array (
      ),
      'reference' => 'eca495f2ee845130855ddf1cf18460c38966c8b6',
    ),
    'symfony/deprecation-contracts' => 
    array (
      'pretty_version' => 'v3.3.0',
      'version' => '3.3.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '7c3aff79d10325257a001fcf92d991f24fc967cf',
    ),
    'symfony/error-handler' => 
    array (
      'pretty_version' => 'v6.3.2',
      'version' => '6.3.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '85fd65ed295c4078367c784e8a5a6cee30348b7a',
    ),
    'symfony/ldap' => 
    array (
      'pretty_version' => 'v6.3.0',
      'version' => '6.3.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '5f1308de5d3a1ca9e5c6ef6bb4b736e5dd6f3508',
    ),
    'symfony/options-resolver' => 
    array (
      'pretty_version' => 'v6.3.0',
      'version' => '6.3.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'a10f19f5198d589d5c33333cffe98dc9820332dd',
    ),
    'symfony/polyfill-ctype' => 
    array (
      'pretty_version' => 'v1.28.0',
      'version' => '1.28.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'ea208ce43cbb04af6867b4fdddb1bdbf84cc28cb',
    ),
    'symfony/polyfill-iconv' => 
    array (
      'pretty_version' => 'v1.28.0',
      'version' => '1.28.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '6de50471469b8c9afc38164452ab2b6170ee71c1',
    ),
    'symfony/polyfill-intl-grapheme' => 
    array (
      'pretty_version' => 'v1.28.0',
      'version' => '1.28.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '875e90aeea2777b6f135677f618529449334a612',
    ),
    'symfony/polyfill-intl-normalizer' => 
    array (
      'pretty_version' => 'v1.28.0',
      'version' => '1.28.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '8c4ad05dd0120b6a53c1ca374dca2ad0a1c4ed92',
    ),
    'symfony/polyfill-mbstring' => 
    array (
      'pretty_version' => 'v1.28.0',
      'version' => '1.28.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '42292d99c55abe617799667f454222c54c60e229',
    ),
    'symfony/polyfill-php70' => 
    array (
      'replaced' => 
      array (
        0 => '*',
      ),
    ),
    'symfony/polyfill-php71' => 
    array (
      'replaced' => 
      array (
        0 => '*',
      ),
    ),
    'symfony/polyfill-php72' => 
    array (
      'replaced' => 
      array (
        0 => '*',
      ),
    ),
    'symfony/polyfill-php73' => 
    array (
      'replaced' => 
      array (
        0 => '*',
      ),
    ),
    'symfony/polyfill-php74' => 
    array (
      'replaced' => 
      array (
        0 => '*',
      ),
    ),
    'symfony/polyfill-php80' => 
    array (
      'replaced' => 
      array (
        0 => '*',
      ),
    ),
    'symfony/polyfill-php81' => 
    array (
      'replaced' => 
      array (
        0 => '*',
      ),
    ),
    'symfony/polyfill-uuid' => 
    array (
      'pretty_version' => 'v1.28.0',
      'version' => '1.28.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '9c44518a5aff8da565c8a55dbe85d2769e6f630e',
    ),
    'symfony/service-contracts' => 
    array (
      'pretty_version' => 'v2.5.2',
      'version' => '2.5.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '4b426aac47d6427cc1a1d0f7e2ac724627f5966c',
    ),
    'symfony/string' => 
    array (
      'pretty_version' => 'v6.3.2',
      'version' => '6.3.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '53d1a83225002635bca3482fcbf963001313fb68',
    ),
    'symfony/uid' => 
    array (
      'pretty_version' => 'v6.3.0',
      'version' => '6.3.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '01b0f20b1351d997711c56f1638f7a8c3061e384',
    ),
    'symfony/var-dumper' => 
    array (
      'pretty_version' => 'v6.3.4',
      'version' => '6.3.4.0',
      'aliases' => 
      array (
      ),
      'reference' => '2027be14f8ae8eae999ceadebcda5b4909b81d45',
    ),
    'symfony/web-link' => 
    array (
      'pretty_version' => 'v6.3.0',
      'version' => '6.3.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '0989ca617d0703cdca501a245f10e194ff22315b',
    ),
    'symfony/yaml' => 
    array (
      'pretty_version' => 'v6.3.3',
      'version' => '6.3.3.0',
      'aliases' => 
      array (
      ),
      'reference' => 'e23292e8c07c85b971b44c1c4b87af52133e2add',
    ),
    'tobscure/json-api' => 
    array (
      'pretty_version' => 'dev-joomla-backports',
      'version' => 'dev-joomla-backports',
      'aliases' => 
      array (
        0 => '9999999-dev',
      ),
      'reference' => 'a56f59df9e0fc95b1421a5210e1cdf208c9f91d2',
    ),
    'typo3/phar-stream-wrapper' => 
    array (
      'pretty_version' => 'v3.1.7',
      'version' => '3.1.7.0',
      'aliases' => 
      array (
      ),
      'reference' => '5cc2f04a4e2f5c7e9cc02a3bdf80fae0f3e11a8c',
    ),
    'voku/portable-ascii' => 
    array (
      'pretty_version' => '2.0.1',
      'version' => '2.0.1.0',
      'aliases' => 
      array (
      ),
      'reference' => 'b56450eed252f6801410d810c8e1727224ae0743',
    ),
    'voku/portable-utf8' => 
    array (
      'pretty_version' => '6.0.13',
      'version' => '6.0.13.0',
      'aliases' => 
      array (
      ),
      'reference' => 'b8ce36bf26593e5c2e81b1850ef0ffb299d2043f',
    ),
    'wamania/php-stemmer' => 
    array (
      'pretty_version' => 'v3.0.1',
      'version' => '3.0.1.0',
      'aliases' => 
      array (
      ),
      'reference' => '8ea32b6fa27d6888587fe860b64a8763525c5a66',
    ),
    'web-auth/cose-lib' => 
    array (
      'pretty_version' => '4.2.3',
      'version' => '4.2.3.0',
      'aliases' => 
      array (
      ),
      'reference' => '0ecad86d2d034ea22e2205d81c8cdec13d93a991',
    ),
    'web-auth/metadata-service' => 
    array (
      'pretty_version' => '4.5.2',
      'version' => '4.5.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '82b3a517894987db1f8959a9320b9891515af9e7',
    ),
    'web-auth/webauthn-lib' => 
    array (
      'pretty_version' => '4.5.2',
      'version' => '4.5.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '30c5e891c6418abef6d87a4351132b01b1828a98',
    ),
    'web-token/jwt-core' => 
    array (
      'pretty_version' => '3.2.8',
      'version' => '3.2.8.0',
      'aliases' => 
      array (
      ),
      'reference' => '2bc6e99a60910d0f495682acd8b23d3eef9865a3',
    ),
    'web-token/jwt-signature' => 
    array (
      'pretty_version' => '3.2.8',
      'version' => '3.2.8.0',
      'aliases' => 
      array (
      ),
      'reference' => '156e0b0ef534e53eecf23a32a92ee6d8cb4fdac4',
    ),
    'web-token/jwt-signature-algorithm-ecdsa' => 
    array (
      'pretty_version' => '3.2.8',
      'version' => '3.2.8.0',
      'aliases' => 
      array (
      ),
      'reference' => '34b119d6b5eca53914ad3b96660e5bd7fb5538b9',
    ),
    'web-token/jwt-signature-algorithm-eddsa' => 
    array (
      'pretty_version' => '3.2.8',
      'version' => '3.2.8.0',
      'aliases' => 
      array (
      ),
      'reference' => '2ee185c4378671e5b0fd0a47021f3df74246f9b3',
    ),
    'web-token/jwt-signature-algorithm-experimental' => 
    array (
      'pretty_version' => '3.2.8',
      'version' => '3.2.8.0',
      'aliases' => 
      array (
      ),
      'reference' => '5839b18e271440121ca950c5bc126c1c2163dcc2',
    ),
    'web-token/jwt-signature-algorithm-hmac' => 
    array (
      'pretty_version' => '3.2.8',
      'version' => '3.2.8.0',
      'aliases' => 
      array (
      ),
      'reference' => '16b091bb8d41bd0f0897f04195ce1e99b24ca15b',
    ),
    'web-token/jwt-signature-algorithm-none' => 
    array (
      'pretty_version' => '3.2.8',
      'version' => '3.2.8.0',
      'aliases' => 
      array (
      ),
      'reference' => 'db776b4b44e0ae1aaf78e58d28a899c4c0fd4c7b',
    ),
    'web-token/jwt-signature-algorithm-rsa' => 
    array (
      'pretty_version' => '3.2.8',
      'version' => '3.2.8.0',
      'aliases' => 
      array (
      ),
      'reference' => '1015c68cc4e7d7a355e40bba6beeee3fe21b5572',
    ),
    'web-token/signature-pack' => 
    array (
      'pretty_version' => '3.2.8',
      'version' => '3.2.8.0',
      'aliases' => 
      array (
      ),
      'reference' => 'c41146a621cbb3a1b3053be4a7d05912d6d23de7',
    ),
    'webmozart/assert' => 
    array (
      'pretty_version' => '1.11.0',
      'version' => '1.11.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '11cb2199493b2f8a3b53e7f19068fc6aac760991',
    ),
    'willdurand/negotiation' => 
    array (
      'pretty_version' => '3.1.0',
      'version' => '3.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '68e9ea0553ef6e2ee8db5c1d98829f111e623ec2',
    ),
  ),
);
    private static $canGetVendors;
    private static $installedByVendor = array();

    /**
     * Returns a list of all package names which are present, either by being installed, replaced or provided
     *
     * @return string[]
     * @psalm-return list<string>
     */
    public static function getInstalledPackages()
    {
        $packages = array();
        foreach (self::getInstalled() as $installed) {
            $packages[] = array_keys($installed['versions']);
        }


        if (1 === \count($packages)) {
            return $packages[0];
        }

        return array_keys(array_flip(\call_user_func_array('array_merge', $packages)));
    }

    /**
     * Checks whether the given package is installed
     *
     * This also returns true if the package name is provided or replaced by another package
     *
     * @param  string $packageName
     * @return bool
     */
    public static function isInstalled($packageName)
    {
        foreach (self::getInstalled() as $installed) {
            if (isset($installed['versions'][$packageName])) {
                return true;
            }
        }

        return false;
    }

    /**
     * Checks whether the given package satisfies a version constraint
     *
     * e.g. If you want to know whether version 2.3+ of package foo/bar is installed, you would call:
     *
     *   Composer\InstalledVersions::satisfies(new VersionParser, 'foo/bar', '^2.3')
     *
     * @param VersionParser $parser      Install composer/semver to have access to this class and functionality
     * @param string        $packageName
     * @param string|null   $constraint  A version constraint to check for, if you pass one you have to make sure composer/semver is required by your package
     *
     * @return bool
     */
    public static function satisfies(VersionParser $parser, $packageName, $constraint)
    {
        $constraint = $parser->parseConstraints($constraint);
        $provided = $parser->parseConstraints(self::getVersionRanges($packageName));

        return $provided->matches($constraint);
    }

    /**
     * Returns a version constraint representing all the range(s) which are installed for a given package
     *
     * It is easier to use this via isInstalled() with the $constraint argument if you need to check
     * whether a given version of a package is installed, and not just whether it exists
     *
     * @param  string $packageName
     * @return string Version constraint usable with composer/semver
     */
    public static function getVersionRanges($packageName)
    {
        foreach (self::getInstalled() as $installed) {
            if (!isset($installed['versions'][$packageName])) {
                continue;
            }

            $ranges = array();
            if (isset($installed['versions'][$packageName]['pretty_version'])) {
                $ranges[] = $installed['versions'][$packageName]['pretty_version'];
            }
            if (array_key_exists('aliases', $installed['versions'][$packageName])) {
                $ranges = array_merge($ranges, $installed['versions'][$packageName]['aliases']);
            }
            if (array_key_exists('replaced', $installed['versions'][$packageName])) {
                $ranges = array_merge($ranges, $installed['versions'][$packageName]['replaced']);
            }
            if (array_key_exists('provided', $installed['versions'][$packageName])) {
                $ranges = array_merge($ranges, $installed['versions'][$packageName]['provided']);
            }

            return implode(' || ', $ranges);
        }

        throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
    }

    /**
     * @param  string      $packageName
     * @return string|null If the package is being replaced or provided but is not really installed, null will be returned as version, use satisfies or getVersionRanges if you need to know if a given version is present
     */
    public static function getVersion($packageName)
    {
        foreach (self::getInstalled() as $installed) {
            if (!isset($installed['versions'][$packageName])) {
                continue;
            }

            if (!isset($installed['versions'][$packageName]['version'])) {
                return null;
            }

            return $installed['versions'][$packageName]['version'];
        }

        throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
    }

    /**
     * @param  string      $packageName
     * @return string|null If the package is being replaced or provided but is not really installed, null will be returned as version, use satisfies or getVersionRanges if you need to know if a given version is present
     */
    public static function getPrettyVersion($packageName)
    {
        foreach (self::getInstalled() as $installed) {
            if (!isset($installed['versions'][$packageName])) {
                continue;
            }

            if (!isset($installed['versions'][$packageName]['pretty_version'])) {
                return null;
            }

            return $installed['versions'][$packageName]['pretty_version'];
        }

        throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
    }

    /**
     * @param  string      $packageName
     * @return string|null If the package is being replaced or provided but is not really installed, null will be returned as reference
     */
    public static function getReference($packageName)
    {
        foreach (self::getInstalled() as $installed) {
            if (!isset($installed['versions'][$packageName])) {
                continue;
            }

            if (!isset($installed['versions'][$packageName]['reference'])) {
                return null;
            }

            return $installed['versions'][$packageName]['reference'];
        }

        throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
    }

    /**
     * @return array
     * @psalm-return array{name: string, version: string, reference: string, pretty_version: string, aliases: string[]}
     */
    public static function getRootPackage()
    {
        $installed = self::getInstalled();

        return $installed[0]['root'];
    }

    /**
     * Returns the raw installed.php data for custom implementations
     *
     * @return array[]
     * @psalm-return array{root: array{name: string, version: string, reference: string, pretty_version: string, aliases: string[]}, versions: list<string, array{pretty_version: ?string, version: ?string, aliases: ?string[], reference: ?string, replaced: ?string[], provided: ?string[]}>}
     */
    public static function getRawData()
    {
        return self::$installed;
    }

    /**
     * Lets you reload the static array from another file
     *
     * This is only useful for complex integrations in which a project needs to use
     * this class but then also needs to execute another project's autoloader in process,
     * and wants to ensure both projects have access to their version of installed.php.
     *
     * A typical case would be PHPUnit, where it would need to make sure it reads all
     * the data it needs from this class, then call reload() with
     * `require $CWD/vendor/composer/installed.php` (or similar) as input to make sure
     * the project in which it runs can then also use this class safely, without
     * interference between PHPUnit's dependencies and the project's dependencies.
     *
     * @param  array[] $data A vendor/composer/installed.php data set
     * @return void
     *
     * @psalm-param array{root: array{name: string, version: string, reference: string, pretty_version: string, aliases: string[]}, versions: list<string, array{pretty_version: ?string, version: ?string, aliases: ?string[], reference: ?string, replaced: ?string[], provided: ?string[]}>} $data
     */
    public static function reload($data)
    {
        self::$installed = $data;
        self::$installedByVendor = array();
    }

    /**
     * @return array[]
     */
    private static function getInstalled()
    {
        if (null === self::$canGetVendors) {
            self::$canGetVendors = method_exists('Composer\Autoload\ClassLoader', 'getRegisteredLoaders');
        }

        $installed = array();

        if (self::$canGetVendors) {
            // @phpstan-ignore-next-line
            foreach (ClassLoader::getRegisteredLoaders() as $vendorDir => $loader) {
                if (isset(self::$installedByVendor[$vendorDir])) {
                    $installed[] = self::$installedByVendor[$vendorDir];
                } elseif (is_file($vendorDir.'/composer/installed.php')) {
                    $installed[] = self::$installedByVendor[$vendorDir] = require $vendorDir.'/composer/installed.php';
                }
            }
        }

        $installed[] = self::$installed;

        return $installed;
    }
}
