
/*!
  * Sa11y, the accessibility quality assurance assistant.
  * @version 3.0.8
  * @author Adam Chaboryk, Toronto Metropolitan University
  * @license GPL-2.0-or-later
  * @copyright © 2020 - 2024 Toronto Metropolitan University (formerly Ryerson University).
  * @contact adam.chaboryk@torontomu.ca
  * GitHub: git+https://github.com/ryersondmp/sa11y.git | Website: https://sa11y.netlify.app
  * For all acknowledgements, please visit: https://sa11y.netlify.app/acknowledgements/
  * The above copyright notice shall be included in all copies or substantial portions of the Software.
**/
/*! WARNING: This is a machine-generated translation and may contain errors or inaccuracies. */
var cs = {
  // Czech
  strings: {
    LANG_CODE: 'cs',
    MAIN_TOGGLE_LABEL: 'Zkontrolujte přístupnost',
    CONTAINER_LABEL: 'Kontrola přístupnosti',
    ERROR: 'Chyba',
    ERRORS: 'Chyby',
    WARNING: 'Varování',
    WARNINGS: 'Varování',
    GOOD: 'Dobrý',
    ON: 'Zapnuto',
    OFF: 'Vypnuto',
    ALERT_TEXT: 'Upozornění',
    ALERT_CLOSE: 'Zavřít',
    OUTLINE: 'Osnova stránky',
    PAGE_ISSUES: 'Problémy se stránkami',
    SETTINGS: 'Nastavení',
    CONTRAST: 'Kontrast',
    FORM_LABELS: 'Štítky formulářů',
    LINKS_ADVANCED: 'Odkazy (pro pokročilé)',
    DARK_MODE: 'Tmavý režim',
    SHORTCUT_SCREEN_READER: 'Přeskočit na vydání. Klávesová zkratka: Alt S',
    SHORTCUT_TOOLTIP: 'Přeskočit na vydání',
    NEW_TAB: 'Otevře novou kartu',
    PANEL_HEADING: 'Kontrola přístupnosti',
    PANEL_STATUS_NONE: 'Nebyly nalezeny žádné chyby.',
    PANEL_ICON_WARNINGS: 'nalezená varování.',
    PANEL_ICON_TOTAL: 'celkový počet nalezených problémů.',
    NOT_VISIBLE_ALERT: 'Položka, kterou se snažíte zobrazit, není viditelná; může být skrytá nebo se může nacházet uvnitř akordeonu nebo karty. Zde je náhled:',
    ERROR_MISSING_ROOT_TARGET: 'Byla zkontrolována přístupnost celé stránky, protože cílová oblast <code>%(root)</code> neexistuje.',
    HEADING_NOT_VISIBLE_ALERT: 'Záhlaví není viditelné; může být skryté nebo se může nacházet v komponentě akordeonu nebo karty.',
    SKIP_TO_PAGE_ISSUES: 'Přeskočit na stránku Problémy',
    CONSOLE_ERROR_MESSAGE: 'Omlouváme se, ale na této stránce je problém s kontrolou přístupnosti. Můžete ji prosím <a href="%(link)">nahlásit prostřednictvím tohoto formuláře</a> nebo na <a href="%(link)">GitHubu</a>?',

    // Dismiss
    PANEL_DISMISS_BUTTON: 'Zobrazit %(dismissCount) zamítnutých varování',
    DISMISS: 'Odmítnout',
    DISMISSED: 'Zamítnutá varování',
    DISMISS_REMINDER: 'Vezměte prosím na vědomí, že varování jsou pouze <strong>dočasně</strong> zamítnuta. Vymazáním historie prohlížeče a souborů cookie se obnoví všechna dříve zamítnutá varování na všech stránkách.',

    // Export
    DATE: 'Datum',
    PAGE_TITLE: 'Název stránky',
    RESULTS: 'Výsledky',
    EXPORT_RESULTS: 'Exportovat výsledky',
    GENERATED: 'Výsledky generovány s %(tool).',
    PREVIEW: 'Náhled',
    ELEMENT: 'Prvek',
    PATH: 'Cesta',

    // Colour filters
    COLOUR_FILTER: 'Barevný filtr',
    PROTANOPIA: 'Protanopia',
    DEUTERANOPIA: 'Deuteranopia',
    TRITANOPIA: 'Tritanopia',
    MONOCHROMACY: 'Monochromatičnost',
    COLOUR_FILTER_MESSAGE: 'Zkontrolujte, zda nejsou prvky, které jsou obtížně vnímatelné nebo odlišitelné od jiných barev.',
    RED_EYE: 'Červený slepec.',
    GREEN_EYE: 'Zelená roleta.',
    BLUE_EYE: 'Modrá roleta.',
    MONO_EYE: 'Červená, modrá a zelená barva pro nevidomé.',
    COLOUR_FILTER_HIGH_CONTRAST_MESSAGE: 'Barevné filtry nefungují v režimu vysokého kontrastu.',

    // Alternative text stop words
    SUSPICIOUS_ALT_STOPWORDS: [
      'obrázek',
      'grafika',
      'obrázek',
      'foto',
    ],
    PLACEHOLDER_ALT_STOPWORDS: [
      'alt',
      'obrázek',
      'foto',
      'dekorativní',
      'zástupný symbol',
      'zástupný obrázek',
      'distanční rámeček',
    ],
    PARTIAL_ALT_STOPWORDS: [
      'klikněte na',
      'klikněte zde',
      'klikněte zde pro více informací',
      'klikněte zde a dozvíte se více',
      'kliknutím zde',
      'podívejte se',
      'podrobně zde',
      'ke stažení',
      'ke stažení zde',
      'zjistit',
      'zjistit více',
      'formulář',
      'zde',
      'informace',
      'odkaz',
      'naučit se',
      'dozvědět se více',
      'více informací',
      'naučit se',
      'více',
      'stránka',
      'papír',
      'přečtěte si',
      'přečtěte si více',
      'přečtěte si toto',
      'tento',
      'tato stránka',
      'tyto webové stránky',
      'na těchto webových stránkách',
      'zobrazit',
      'prohlédněte si naše',
      'webové stránky',
    ],
    WARNING_ALT_STOPWORDS: [
      'klikněte zde',
    ],
    NEW_WINDOW_PHRASES: [
      'externí',
      'nová karta',
      'nové okno',
      'pop-up',
      'vyskakovat',
    ],
    FILE_TYPE_PHRASES: ['document', 'dokument', 'tabulka', 'výpočtový list', 'komprimovaný soubor', 'archivovaný soubor', 'pracovní list', 'powerpoint', 'prezentace', 'instalace', 'video', 'zvuk', 'pdf'],
    LANG_READABILITY: 'Čitelnost',
    LANG_AVG_SENTENCE: 'Průměrný počet slov na větu:',
    LANG_COMPLEX_WORDS: 'Složitá slova:',
    LANG_TOTAL_WORDS: 'Slova:',
    LANG_VERY_DIFFICULT: 'Velmi obtížné',
    LANG_DIFFICULT: 'Obtížné',
    LANG_FAIRLY_DIFFICULT: 'Poměrně obtížné',
    LANG_GOOD: 'Dobrý',
    READABILITY_NO_P_OR_LI_MESSAGE: 'Nelze vypočítat skóre čitelnosti. Nebyl nalezen žádný odstavec <code>&lt;p&gt;</code> ani obsah seznamu <code>&lt;li&gt;</code>.',
    READABILITY_NOT_ENOUGH_CONTENT_MESSAGE: 'Nedostatečný obsah pro výpočet skóre čitelnosti.',
    HEADING_NON_CONSECUTIVE_LEVEL: 'Použitá úroveň nadpisu, která není po sobě jdoucí. Nadpisy by nikdy neměly přeskakovat úrovně nebo přecházet z <strong>Nadpisu %(prevLevel)</strong> na <strong {r}>Nadpis %(level)</strong>.',
    HEADING_EMPTY: 'Nalezena prázdná rubrika! Chcete-li to opravit, odstraňte tento řádek nebo změňte jeho formát z <strong {r}>Záhlaví %(level)</strong> na <strong>Normální</strong> nebo <strong>Odstavec</strong>.',
    HEADING_LONG: 'Záhlaví je dlouhé! Nadpisy by měly sloužit k uspořádání obsahu a vyjádření struktury. Měly by být stručné, informativní a jedinečné. Udržujte nadpisy kratší než 160 znaků (ne delší než jedna věta). <hr> Počet znaků: <strong {r}>%(headingLength)</strong> Počet znaků je omezen.',
    HEADING_FIRST: 'Prvním nadpisem na stránce by obvykle měl být nadpis 1 nebo nadpis 2. Nadpis 1 by měl být začátkem hlavní části obsahu a je hlavním nadpisem, který popisuje celkový účel stránky. Více informací o <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/">Struktuře nadpisů.</a>.',
    HEADING_MISSING_ONE: 'Chybějící nadpis 1. Nadpis 1 by měl být začátkem hlavní oblasti obsahu a je to hlavní nadpis, který popisuje celkový účel stránky. Více informací o <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/">Struktuře nadpisů.</a>.',
    HEADING_EMPTY_WITH_IMAGE: 'Nadpis neobsahuje žádný text, ale obrázek. Pokud se nejedná o nadpis, změňte jeho formát z <strong {r}>Nadpis %(level)</strong> na <strong>Normální</strong> nebo <strong>Odstavec</strong>. V opačném případě přidejte k obrázku alt text, pokud není ozdobný.',
    PANEL_HEADING_MISSING_ONE: 'Chybí nadpis 1!',
    PANEL_NO_HEADINGS: 'Nebyly nalezeny žádné záhlaví.',
    LINK_EMPTY: 'Odstranění prázdných odkazů bez textu.',
    LINK_EMPTY_LINK_NO_LABEL: 'Odkaz nemá čitelný text, který by byl viditelný pro čtečky obrazovky a další asistenční technologie. Oprava: </li><li>Přidejte stručný text, který popisuje, kam odkaz vede.</li><li>Jestliže se jedná o <a href="https://a11y-101.com/development/icons-and-links">odkaz na ikonu nebo SVG,</a> pravděpodobně chybí popisný štítek.</li><li>Pokud si myslíte, že tento odkaz je chybou způsobenou chybou kopírování/vkládání, zvažte jeho odstranění.</li></ul>.',
    LINK_LABEL: '<strong>Značka odkazu:</strong> %(sanitizedText)',
    LINK_STOPWORD: 'Text odkazu nemusí být z kontextu dostatečně popisný: <strong {r}>%(error)</strong><hr><strong>Tip!</strong> Text odkazu by měl být vždy jasný, jedinečný a smysluplný. Vyhněte se běžným slovům jako &quot;klikněte zde&quot; nebo &quot;dozvědět se více&quot;',
    LINK_BEST_PRACTICES: 'Zvažte nahrazení textu odkazu: <strong {r}>%(error)</strong><hr><ul><li>&quot;Klikněte zde&quot; klade důraz na mechaniku myši, ačkoli mnoho lidí myš nepoužívá nebo si tyto webové stránky prohlíží na mobilním zařízení. Zvažte použití jiného slovesa, které se vztahuje k danému úkolu.</li><li>Vyhněte se používání symbolů HTML jako výzvy k akci, pokud nejsou skryté pro asistenční technologie.</li></ul>',
    LINK_URL: 'Delší a méně srozumitelné adresy URL použité jako text odkazu by mohly být obtížně poslouchatelné pomocí asistenční technologie. Ve většině případů je lepší použít místo adresy URL lidsky čitelný text. Krátké adresy URL (například domovská stránka webu) jsou v pořádku.<hr><strong>Tip!</strong> Text odkazu by měl být vždy jasný, jedinečný a smysluplný, aby mohl být pochopen i mimo kontext.',
    LINK_DOI: 'Pro webové stránky nebo zdroje pouze online doporučuje <a href="https://apastyle.apa.org/style-grammar-guidelines/paper-format/accessibility/urls#:~:text=descriptive%20links">průvodce stylem APA</a> používat popisné odkazy tak, že kolem názvu díla uvedete adresu URL nebo DOI. Delší a méně srozumitelné adresy URL použité jako text odkazu by mohly být při přístupu pomocí asistenčních technologií obtížně srozumitelné.',
    NEW_TAB_WARNING: 'Odkaz se bez varování otevře v nové kartě nebo okně. To může být dezorientující, zejména pro lidi, kteří mají potíže s vnímáním vizuálního obsahu. Za druhé, není vždy vhodné kontrolovat něčí zážitek nebo rozhodovat za něj. Uveďte, že se odkaz otevírá v novém okně, v textu odkazu<hr><strong>Tip!</strong> Naučte se osvědčené postupy: <a href="https://www.nngroup.com/articles/new-browser-windows-and-tabs/">otevírání odkazů v nových oknech a kartách prohlížeče.</a>',
    FILE_TYPE_WARNING: 'Odkaz odkazuje na soubor PDF nebo soubor ke stažení (např. MP3, Zip, dokument Word) bez varování. Typ souboru uveďte v textu odkazu. Pokud se jedná o velký soubor, zvažte uvedení jeho velikosti.<hr><strong>Příklad:</strong> Výkonná zpráva (PDF, 3 MB)',
    LINK_IDENTICAL_NAME: 'Odkaz má stejný text jako jiný odkaz, přestože odkazuje na jinou stránku. Více odkazů se stejným textem může způsobit zmatek u lidí, kteří používají čtečky obrazovky.<hr>Zvažte, zda následující odkaz nebude více popisný, abyste ho lépe odlišili od ostatních odkazů: <strong {r}>%(sanitizedText)</strong>.',
    MISSING_ALT_LINK_BUT_HAS_TEXT_MESSAGE: 'Obrázek se používá jako odkaz s okolním textem, ačkoli atribut alt by měl být označen jako dekorativní nebo nulový.',
    MISSING_ALT_LINK_MESSAGE: 'Obrázek se používá jako odkaz, ale chybí text alt! Ujistěte se, že text alt popisuje, kam odkaz vede.',
    MISSING_ALT_MESSAGE: 'Chybějící text alt! Pokud obrázek vyjadřuje příběh, náladu nebo důležitou informaci, nezapomeňte ho popsat.',
    LINK_ALT_HAS_FILE_EXTENSION: 'Nalezená přípona souboru v textu alt. Ujistěte se, že text alt popisuje cíl odkazu, nikoli doslovný popis obrázku. Odstranit: <strong {r}>%(error)</strong>.<hr><strong>Text alt:</strong> %(altText)',
    LINK_IMAGE_PLACEHOLDER_ALT_MESSAGE: 'Nalezen nepopsaný nebo zástupný text alt v odkazovaném obrázku. Ujistěte se, že text alt popisuje cíl odkazu, nikoli doslovný popis obrázku. Nahraďte následující text alt: <strong {r}>%(altText)</strong>',
    LINK_IMAGE_SUS_ALT_MESSAGE: 'Asistivní technologie již indikují, že se jedná o obrázek, takže &quot;<strong {r}>%(error)</strong>&quot; může být zbytečné. Zajistěte, aby text alt popisoval cíl odkazu, nikoli doslovný popis obrázku. <hr> <strong>Text alt:</strong> %(altText)',
    ALT_HAS_FILE_EXTENSION: 'Nalezená přípona souboru v textu alt. Pokud obrázek vyjadřuje příběh, náladu nebo důležitou informaci, nezapomeňte ho popsat. Odstraňte: <strong {r}>%(error)</strong>.<hr><strong>Text altu:</strong> %(altText)',
    ALT_PLACEHOLDER_MESSAGE: 'Nalezen nepopsaný nebo zástupný text alt. Nahraďte následující alt text něčím smysluplnějším: <strong {r}>%(altText)</strong>.',
    ALT_HAS_SUS_WORD: 'Asistivní technologie již indikují, že se jedná o obrázek, takže &quot;<strong {r}>%(error)</strong>&quot; může být zbytečné. <hr> <strong>Textuální text:</strong> %(altText)',
    LINK_HIDDEN_FOCUSABLE: 'Odkaz má <code>aria-hidden=&quot;true&quot;</code>, ale stále je dostupný pomocí klávesnice. Pokud plánujete skrýt nadbytečný nebo duplicitní odkaz, přidejte také <code>tabindex=&quot;-1&quot;</code>.',
    LINK_IMAGE_NO_ALT_TEXT: 'Obrázek v odkazu je označen jako dekorativní a není v něm žádný text odkazu. Přidejte prosím k obrázku text alt, který popisuje cíl odkazu.',
    LINK_IMAGE_HAS_TEXT: 'Obrázek je označen jako dekorativní, ačkoli odkaz používá okolní text jako popisek.',
    LINK_IMAGE_LONG_ALT: 'Popis Alt textu u odkazovaného obrázku je <strong>příliš dlouhý</strong>. Text alt u odkazovaných obrázků by měl popisovat, kam odkaz vede, nikoli doslovný popis obrázku. <strong>Zvažte, zda jako alt text nepoužít název stránky, na kterou odkazuje.</strong> <hr> <strong>Alt text (<span {r}>%(altLength)</span> znaků):</strong> %(altText)',
    LINK_IMAGE_ALT_WARNING: 'Odkaz na obrázek obsahuje text alt. <strong>Popisuje text alt, kam vás odkaz zavede?</strong> Zvažte, zda jako alt text nepoužít název stránky, na kterou odkazuje. <hr> <strong>Textu alt:</strong> %(altText)',
    LINK_IMAGE_ALT_AND_TEXT_WARNING: 'Odkaz na obrázek obsahuje <strong>jak text alt, tak okolní text odkazu.</strong> Pokud je tento obrázek dekorativní a používá se jako funkční odkaz na jinou stránku, zvažte označení obrázku jako dekorativního nebo nulového - okolní text odkazu by měl být dostačující. <hr> <strong>Textuální text:</strong> %(altText) <hr> <strong>Značka odkazu:</strong> %(sanitizedText)',
    IMAGE_FIGURE_DECORATIVE: 'Obrázek je označen jako <strong>dekorativní</strong> a asistenční technologie jej budou ignorovat. <hr> Přestože byl uveden <strong>nadpis</strong>, obrázek by měl mít ve většině případů také alt text. <ul><li>Titul alt by měl obsahovat stručný popis toho, co je na obrázku.</li><li>Titul by měl obvykle poskytovat kontext, aby obrázek souvisel s okolním obsahem, nebo upozorňovat na konkrétní informaci.</li></ul>Zjistěte více: <a href="https://thoughtbot.com/blog/alt-vs-figcaption#the-figcaption-element">alt versus figcaption.</a>',
    IMAGE_FIGURE_DUPLICATE_ALT: 'Nepoužívejte stejná slova pro text alt i titulek. Čtečky obrazovky budou informace oznamovat dvakrát.<ul><li>Text alt by měl obsahovat stručný popis toho, co je na obrázku.</li><li>Titul by měl obvykle poskytovat kontext, aby obrázek souvisel s okolním obsahem, nebo upozorňovat na konkrétní informaci.</li></ul> Další informace: <a href="https://thoughtbot.com/blog/alt-vs-figcaption#the-figcaption-element">alt versus figcaption.</a> <hr> <strong>Titulky:</strong> %(altText)',
    IMAGE_DECORATIVE: 'Obrázek je označen jako <strong>dekorativní</strong> a asistenční technologie jej budou ignorovat. Pokud obrázek vyjadřuje příběh, náladu nebo důležitou informaci - nezapomeňte přidat alt text.',
    IMAGE_ALT_TOO_LONG: 'Alt text popisu je <strong>příliš dlouhý</strong>. Alt text by měl být stručný, ale výstižný jako <em>tweet</em> (přibližně 100 znaků). Pokud se jedná o složitý obrázek nebo graf, zvažte umístění dlouhého popisu obrázku do textu pod ním nebo do akordeonové komponenty. <hr> <strong>Textuální text (<span {r}>%(altLength)</span> znaků):</strong> %(altText)',
    IMAGE_PASS: '<strong>Textuální text:</strong> %(altText)',
    LABELS_MISSING_IMAGE_INPUT_MESSAGE: 'U tlačítka obrázku chybí text alt. Přidejte prosím text alt a uveďte přístupný název. Například: <em>Hledat</em> nebo <em>Odeslat</em>.',
    LABELS_INPUT_RESET_MESSAGE: 'Tlačítka resetování by se neměla používat, pokud to není výslovně nutné, protože je lze snadno aktivovat omylem. <hr> <strong>Tip!</strong> Přečtěte si, proč <a href="https://www.nngroup.com/articles/reset-and-cancel-buttons/">tlačítka Reset a Cancel představují problém s použitelností.</a>',
    LABELS_ARIA_LABEL_INPUT_MESSAGE: 'Vstup má přístupný název, ale zajistěte, aby byl viditelný i štítek. <hr> <strong>Štítek vstupu:</strong> %(sanitizedText)',
    LABELS_NO_FOR_ATTRIBUTE_MESSAGE: 'K tomuto vstupu není přiřazen žádný štítek. Přidejte atribut <code>for</code> ke štítku, který odpovídá <code>id</code> tohoto vstupu. <hr> ID tohoto vstupu je: <strong>id=&#34;%(id)&#34;</strong>.',
    LABELS_MISSING_LABEL_MESSAGE: 'K tomuto vstupu není přiřazen žádný štítek. Přidejte prosím k tomuto vstupu <code>id</code> a ke štítku přidejte odpovídající atribut <code>for</code>.',
    EMBED_VIDEO: 'Zajistěte, aby <strong>všechna videa byla opatřena skrytými titulky.</strong> Poskytování titulků pro veškerý audio a video obsah je povinným požadavkem úrovně A. Titulky podporují osoby s postižením D/neslyšící nebo nedoslýchavé.',
    EMBED_AUDIO: 'Ujistěte se prosím, že jste poskytli <strong>přepis všech podcastů.</strong> Poskytování přepisů zvukového obsahu je povinným požadavkem úrovně A. Přepisy podporují osoby s poruchou sluchu nebo neslyšící, ale mohou být přínosem pro všechny. Zvažte umístění přepisu pod nebo v rámci akordeonového panelu.',
    EMBED_DATA_VIZ: 'Widgety pro vizualizaci dat, jako je tento, jsou často problematické pro lidi, kteří k navigaci používají klávesnici nebo čtečku obrazovky, a mohou představovat značné potíže pro lidi se slabým zrakem nebo barvoslepostí. Doporučujeme poskytovat stejné informace v alternativním (textovém nebo tabulkovém) formátu pod widgetem. <hr> Další informace o <a href="https://www.w3.org/WAI/tutorials/images/complex">komplexních obrázcích.</a>',
    EMBED_MISSING_TITLE: 'Vložený obsah vyžaduje přístupný název, který popisuje jeho obsah. Uveďte jedinečný atribut <code>title</code> nebo <code>aria-label</code> na elementu <code>iframe</code>. Další informace o <a href="https://web.dev/learn/accessibility/more-html#iframes">iFrame.</a>.',
    EMBED_GENERAL_WARNING: 'Nelze zkontrolovat vložený obsah. Ujistěte se prosím, že obrázky mají alt text, videa mají titulky, text je dostatečně kontrastní a interaktivní komponenty jsou <a href="https://webaim.org/techniques/keyboard/">přístupné z klávesnice.</a>.',
    EMBED_UNFOCUSABLE: '<code>&lt;iframe&gt;</code> s nezaměřitelnými prvky by nemělo mít <code>tabindex="-1"</code>. Vložený obsah nebude přístupný klávesnicí.',
    QA_BAD_LINK: 'Nalezen špatný odkaz. Zdá se, že odkaz vede na vývojové prostředí. <hr> Tento odkaz odkazuje na: <br> <strong {r}>%(el)</strong>',
    QA_BAD_ITALICS: 'Tučné písmo a kurzíva mají sémantický význam a neměly by se <strong>používat</strong> ke zvýraznění celých odstavců. Tučný text by měl být používán k výraznému <strong>zdůraznění</strong> slova nebo slovního spojení. Kurzíva by se měla používat ke zvýraznění vlastních jmen (tj. názvů knih a článků), cizích slov, citátů. Dlouhé citace by měly být formátovány jako blokové citace.',
    QA_PDF: 'Nelze zkontrolovat přístupnost souborů PDF. Soubory PDF jsou považovány za webový obsah a musí být také zpřístupněny. Soubory PDF často obsahují problémy pro lidi, kteří používají čtečky obrazovky (chybějící strukturální značky nebo chybějící popisky formulářových polí), a pro lidi se slabým zrakem (text se při zvětšení nezvětšuje). <ul><li>Jestliže se jedná o formulář, zvažte jako alternativu použití přístupného formuláře HTML.</li><li>Jestliže se jedná o dokument, zvažte jeho převedení na webovou stránku.</li></ul>V opačném případě zkontrolujte <a href="https://helpx.adobe.com/acrobat/using/create-verify-pdf-accessibility.html">PDF pro přístupnost v Acrobatu DC.</a>.',
    QA_DOCUMENT: 'Nelze zkontrolovat přístupnost dokumentu. Propojené dokumenty jsou považovány za webový obsah a musí být rovněž zpřístupněny. Zkontrolujte prosím tento dokument ručně. <ul><li>Zpřístupněte svůj <a href="https://support.google.com/docs/answer/6199477?hl=en">dokument nebo prezentaci v prostředí Google Workspace.</a></li><li>Zpřístupněte své <a href="https://support.microsoft.com/en-us/office/create-accessible-office-documents-868ecfcd-4f00-4224-b881-a65537a7c155">dokumenty Office.</a></li></ul>.',
    QA_PAGE_LANGUAGE: 'Jazyk stránky není deklarován! Prosím <a href="https://www.w3.org/International/questions/qa-html-language-declarations">deklarujte jazyk v tagu HTML.</a>',
    QA_PAGE_TITLE: 'Chybí název stránky! Uveďte prosím <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/title">název stránky.</a>',
    QA_BLOCKQUOTE_MESSAGE: 'Je to nadpis? <strong {r}>%(sanitizedText)</strong> <hr> Blokové uvozovky by se měly používat pouze pro citace. Pokud se má jednat o nadpis, změňte tento blokový citát na sémantický nadpis (např. Nadpis 2 nebo Nadpis 3).',
    QA_FAKE_HEADING: 'Je to nadpis? <strong {r}>%(boldtext)</strong> <hr> Řádek tučného nebo velkého textu může vypadat jako nadpis, ale člověk používající čtečku obrazovky nemůže poznat, že je důležitý, nebo přejít na jeho obsah. Tučný nebo velký text by nikdy neměl nahrazovat sémantické nadpisy (Nadpis 2 až Nadpis 6).',
    QA_SHOULD_BE_LIST: 'Snažíte se vytvořit seznam? Nalezena možná položka seznamu: <strong {r}>%(firstPrefix)</strong> <hr> Ujistěte se, že používáte sémantické seznamy tak, že místo nich použijete tlačítka pro formátování odrážek nebo čísel. Při použití sémantického seznamu jsou asistenční technologie schopny zprostředkovat informace, jako je celkový počet položek a relativní pozice každé položky v seznamu. Další informace o <a href="https://www.w3.org/WAI/tutorials/page-structure/content/#lists">sémantických seznamech.</a>.',
    QA_UPPERCASE_WARNING: 'Nalezena všechna velká písmena. Některé čtečky obrazovky mohou text psaný velkými písmeny interpretovat jako zkratku a budou číst každé písmeno zvlášť. Kromě toho se některým lidem všechna velká písmena hůře čtou a mohou působit dojmem, jako by se jednalo o KŘIK.',
    QA_DUPLICATE_ID: 'Nalezeno <strong>duplicitní ID</strong>. Je známo, že chyby duplicitního ID způsobují asistenčním technologiím problémy při pokusech o interakci s obsahem. <hr> Odstraňte nebo změňte následující ID: <strong {r}>%(id)</strong>.',
    QA_TEXT_UNDERLINE_WARNING: 'Podtržený text může být zaměněn za odkazy. Zvažte použití jiného stylu, například <code>&lt;strong&gt;</code><strong>důležitost</strong><code>&lt;/strong&gt;</code> nebo <code>&lt;em&gt;</code><em>důraz</em><code>&lt;/em&gt;</code>.',
    QA_SUBSCRIPT_WARNING: 'Možnosti formátování dolního a horního indexu by se měly používat pouze ke změně pozice textu kvůli typografickým konvencím nebo normám. Neměly by se <strong>používat</strong> výhradně pro účely prezentace nebo vzhledu. Formátování celých vět představuje problém s čitelností. Mezi vhodné případy použití patří zobrazování exponentů, řadových čísel, jako je 4<sup>th</sup> místo fourth, a chemických vzorců (např. H<sub>2</sub>O).',
    TABLES_MISSING_HEADINGS: 'Chybějící záhlaví tabulky! Přístupné tabulky potřebují značku HTML, která označuje buňky záhlaví a datové buňky a definuje jejich vzájemný vztah. Tyto informace poskytují kontext lidem, kteří používají asistenční technologie. Tabulky by se měly používat pouze pro tabulková data. <hr> Další informace o <a href="https://www.w3.org/WAI/tutorials/tables/">přístupných tabulkách.</a>',
    TABLES_SEMANTIC_HEADING: 'Sémantické nadpisy, jako je Nadpis 2 nebo Nadpis 3, by se měly používat pouze pro části obsahu; <strong>ne</strong> v tabulkách HTML. Nadpisy tabulek označujte místo toho pomocí elementu <code>&lt;th&gt;</code>. <hr> Další informace o <a href="https://www.w3.org/WAI/tutorials/tables/">přístupných tabulkách.</a>',
    TABLES_EMPTY_HEADING: 'Nalezeno prázdné záhlaví tabulky! Záhlaví tabulky by <strong>nikdy</strong> nemělo být prázdné. Je důležité označit záhlaví řádků a/nebo sloupců, aby byl vyjádřen jejich vztah. Tyto informace poskytují kontext osobám, které používají asistenční technologie. Mějte na paměti, že tabulky by se měly používat pouze pro tabulková data. <hr> Další informace o <a href="https://www.w3.org/WAI/tutorials/tables/">přístupných tabulkách.</a>.',
    CONTRAST_ERROR: 'Tento text není dostatečně kontrastní s pozadím. Kontrastní poměr by měl být alespoň 4,5:1 pro normální text a 3:1 pro velký text. <hr> Pro následující text je kontrastní poměr <strong {r}>%(cratio)</strong>: <strong {r}>%(sanitizedText)</strong>.',
    CONTRAST_WARNING: 'Kontrast tohoto textu není znám a je třeba jej ručně zkontrolovat. Ujistěte se, že text a pozadí mají výrazně kontrastní barvy. Kontrastní poměr by měl být alespoň 4,5:1 pro normální text a 3:1 pro velký text. <hr> <strong>Prosím, zkontrolujte:</strong> %(sanitizedText)',
    CONTRAST_INPUT_ERROR: 'Text v tomto vstupu není dostatečně kontrastní s pozadím. Kontrastní poměr by měl být alespoň 4,5:1 pro normální text a 3:1 pro velký text. <hr> Kontrastní poměr: <strong {r}>%(cratio)</strong>.',
  },
};

export { cs as default };
