
/*!
  * Sa11y, the accessibility quality assurance assistant.
  * @version 3.0.8
  * @author Adam Chaboryk, Toronto Metropolitan University
  * @license GPL-2.0-or-later
  * @copyright © 2020 - 2024 Toronto Metropolitan University (formerly Ryerson University).
  * @contact adam.chaboryk@torontomu.ca
  * GitHub: git+https://github.com/ryersondmp/sa11y.git | Website: https://sa11y.netlify.app
  * For all acknowledgements, please visit: https://sa11y.netlify.app/acknowledgements/
  * The above copyright notice shall be included in all copies or substantial portions of the Software.
**/
/*! WARNING: This is a machine-generated translation and may contain errors or inaccuracies. */
var tr = {
  // Turkish
  strings: {
    LANG_CODE: 'tr',
    MAIN_TOGGLE_LABEL: 'Erişilebilirliği Kontrol Edin',
    CONTAINER_LABEL: 'Erişilebilirlik Denetleyicisi',
    ERROR: 'Hata',
    ERRORS: 'Hatalar',
    WARNING: 'Uyarı',
    WARNINGS: 'Uyarılar',
    GOOD: 'İyi',
    ON: 'Açık',
    OFF: 'Kapalı',
    ALERT_TEXT: 'Uyarı',
    ALERT_CLOSE: 'Kapat',
    OUTLINE: 'Sayfa Anahatları',
    PAGE_ISSUES: 'Sayfa Sorunları',
    SETTINGS: 'Ayarlar',
    CONTRAST: 'Kontrast',
    FORM_LABELS: 'Form etiketleri',
    LINKS_ADVANCED: 'Bağlantılar (Gelişmiş)',
    DARK_MODE: 'Karanlık mod',
    SHORTCUT_SCREEN_READER: 'Konuya geç. Klavye kısayolu: Alt S',
    SHORTCUT_TOOLTIP: 'Konuya geç',
    NEW_TAB: 'Yeni sekme açar',
    PANEL_HEADING: 'Erişilebilirlik kontrolü',
    PANEL_STATUS_NONE: 'Hata bulunamadı.',
    PANEL_ICON_WARNINGS: 'uyarılar bulundu.',
    PANEL_ICON_TOTAL: 'toplam sorun bulundu.',
    NOT_VISIBLE_ALERT: 'Görüntülemeye çalıştığınız öğe görünmüyor; gizli veya bir akordeon ya da sekme bileşeninin içinde olabilir. İşte bir önizleme:',
    ERROR_MISSING_ROOT_TARGET: '<code>%(root)</code> hedef alanı mevcut olmadığı için sayfanın tamamı erişilebilirlik açısından kontrol edildi.',
    HEADING_NOT_VISIBLE_ALERT: 'Başlık görünür değildir; gizli veya bir akordeon ya da sekme bileşeninin içinde olabilir.',
    SKIP_TO_PAGE_ISSUES: 'Sayfa Sorunlarına Geç',
    CONSOLE_ERROR_MESSAGE: 'Üzgünüz, ancak bu sayfadaki erişilebilirlik denetleyicisinde bir sorun var. Lütfen <a href="%(link)">bu form</a> aracılığıyla veya <a href="%(link)">GitHub</a> üzerinden bildirebilir misiniz?',

    // Dismiss
    PANEL_DISMISS_BUTTON: 'Göster %(dismissCount) reddedilen uyarılar',
    DISMISS: 'Dağılın',
    DISMISSED: 'Reddedilen uyarılar',
    DISMISS_REMINDER: 'Uyarıların yalnızca <strong>geçici olarak</strong> reddedildiğini lütfen unutmayın. Tarayıcı geçmişinizi ve çerezlerinizi temizlemek, tüm sayfalarda daha önce kapatılan tüm uyarıları geri yükleyecektir.',

    // Export
    DATE: 'Tarih',
    PAGE_TITLE: 'Sayfa başlığı',
    RESULTS: 'Sonuçlar',
    EXPORT_RESULTS: 'Sonuçları dışa aktar',
    GENERATED: '%(tool) ile oluşturulan sonuçlar.',
    PREVIEW: 'Önizleme',
    ELEMENT: 'Öğe',
    PATH: 'Yol',

    // Colour filters
    COLOUR_FILTER: 'Renk filtresi',
    PROTANOPIA: 'Protanopia',
    DEUTERANOPIA: 'Deuteranopia',
    TRITANOPIA: 'Tritanopia',
    MONOCHROMACY: 'Monokromasi',
    COLOUR_FILTER_MESSAGE: 'Algılanması veya diğer renklerden ayırt edilmesi zor olan unsurları kontrol edin.',
    RED_EYE: 'Kırmızı kör.',
    GREEN_EYE: 'Yeşil kör.',
    BLUE_EYE: 'Mavi kör.',
    MONO_EYE: 'Kırmızı, mavi ve yeşil kör.',
    COLOUR_FILTER_HIGH_CONTRAST_MESSAGE: 'Renk filtreleri yüksek kontrast modunda çalışmaz.',

    // Alternative text stop words
    SUSPICIOUS_ALT_STOPWORDS: [
      'görüntü',
      'grafik',
      'resim',
      'fotoğraf',
    ],
    PLACEHOLDER_ALT_STOPWORDS: [
      'alt',
      'görüntü',
      'fotoğraf',
      'dekoratif',
      'yer tutucu',
      'yer tutucu resim',
      'ara parça',
    ],
    PARTIAL_ALT_STOPWORDS: [
      'tıklayın',
      'buraya tıklayın',
      'daha fazlası için buraya tıklayın',
      'daha fazla bi̇lgi̇ i̇çi̇n tiklayin',
      'buraya tıklayarak',
      'kontrol et',
      'burada ayrıntılı',
      'i̇ndir',
      'buradan indirin',
      'buradan indirebilirsiniz',
      'öğrenmek',
      'daha fazla bi̇lgi̇ edi̇ni̇n',
      'daha fazlasını öğrenin',
      'form',
      'burada',
      'bilgi',
      'link',
      'öğrenmek',
      'daha fazla öğren',
      'daha fazla bilgi edinin',
      'öğrenmek',
      'daha fazla',
      'sayfa',
      'kağıt',
      'daha fazla oku',
      'okuyun',
      'bunu okuyun',
      'bu',
      'bu sayfa',
      'bu web sitesi',
      'görünüm',
      'bizi görüntüleyin',
      'web sitesi',
    ],
    WARNING_ALT_STOPWORDS: [
      'buraya tıklayın',
    ],
    NEW_WINDOW_PHRASES: [
      'dış',
      'yeni sekme',
      'yeni pencere',
      'açılır pencere',
    ],
    FILE_TYPE_PHRASES: ['belge', 'elektronik tablo', 'hesaplama sayfası', 'sıkıştırılmış dosya', 'arşivlenmiş dosya', 'çalışma sayfası', 'powerpoint', 'sunum', 'yükle', 'video', 'ses', 'pdf'],
    LANG_READABILITY: 'Okunabilirlik',
    LANG_AVG_SENTENCE: 'Cümle başına ortalama kelime:',
    LANG_COMPLEX_WORDS: 'Karmaşık kelimeler:',
    LANG_TOTAL_WORDS: 'Kelimeler:',
    LANG_VERY_DIFFICULT: 'Çok zor',
    LANG_DIFFICULT: 'Zor',
    LANG_FAIRLY_DIFFICULT: 'Oldukça zor',
    LANG_GOOD: 'İyi',
    READABILITY_NO_P_OR_LI_MESSAGE: 'Okunabilirlik puanı hesaplanamıyor. Paragraf <code>&lt;p&gt;</code> veya liste içeriği <code>&lt;li&gt;</code> bulunamadı.',
    READABILITY_NOT_ENOUGH_CONTENT_MESSAGE: 'Okunabilirlik puanını hesaplamak için yeterli içerik yok.',
    HEADING_NON_CONSECUTIVE_LEVEL: "Ardışık olmayan başlık seviyesi kullanıldı. Başlıklar asla seviye atlamamalı veya <strong>Başlık %(prevLevel)</strong>'den <strong {r}>Başlık %(level)</strong>'e geçmemelidir.",
    HEADING_EMPTY: 'Boş başlık bulundu! Düzeltmek için bu satırı silin veya biçimini <strong {r}>Heading %(level)</strong> yerine <strong>Normal</strong> veya <strong>Paragraph</strong> olarak değiştirin.',
    HEADING_LONG: 'Başlık uzun! Başlıklar içeriği düzenlemek ve yapıyı aktarmak için kullanılmalıdır. Kısa, bilgilendirici ve benzersiz olmalıdırlar. Lütfen başlıkları 160 karakterden az tutun (bir cümleden fazla olmamalıdır). <hr> Karakter sayısı: <strong {r}>%(headingLength)</strong>',
    HEADING_FIRST: 'Bir sayfadaki ilk başlık genellikle Başlık 1 veya Başlık 2 olmalıdır. Başlık 1, ana içerik bölümünün başlangıcı olmalıdır ve sayfanın genel amacını açıklayan ana başlıktır. <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/">Başlık Yapısı hakkında daha fazla bilgi edinin.</a>',
    HEADING_MISSING_ONE: 'Eksik Başlık 1. Başlık 1, ana içerik alanının başlangıcı olmalıdır ve sayfanın genel amacını açıklayan ana başlıktır. <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/">Başlık Yapısı hakkında daha fazla bilgi edinin.</a>',
    HEADING_EMPTY_WITH_IMAGE: 'Başlığın metni yoktur, ancak bir resim içerir. Bu bir başlık değilse, biçimini <strong {r}>Başlık %(level)</strong> yerine <strong>Normal</strong> veya <strong>Paragraf</strong> olarak değiştirin. Aksi takdirde, dekoratif değilse lütfen resme alt metin ekleyin.',
    PANEL_HEADING_MISSING_ONE: 'Başlık 1 eksik!',
    PANEL_NO_HEADINGS: 'Başlık bulunamadı.',
    LINK_EMPTY: 'Herhangi bir metin içermeyen boş bağlantıları kaldırın.',
    LINK_EMPTY_LINK_NO_LABEL: 'Bağlantı, ekran okuyucular ve diğer yardımcı teknolojiler tarafından görülebilen ayırt edilebilir bir metne sahip değil. Düzeltmek için: <ul><li>Bağlantının sizi nereye götürdüğünü açıklayan kısa bir metin ekleyin.</li><li>Bu bir <a href="https://a11y-101.com/development/icons-and-links">ikon bağlantısı veya SVG,</a> ise muhtemelen açıklayıcı bir etiket eksiktir.</li><li>Bu bağlantının bir kopyala/yapıştır hatasından kaynaklanan bir hata olduğunu düşünüyorsanız, silmeyi düşünün.</li></ul>',
    LINK_LABEL: '<strong>Link etiketi:</strong> %(sanitizedText)',
    LINK_STOPWORD: 'Bağlantı metni bağlam dışında yeterince açıklayıcı olmayabilir: <strong {r}>%(error)</strong><hr><strong>İpucu!</strong> Bağlantı metni her zaman açık, benzersiz ve anlamlı olmalıdır. Buraya tıklayın&quot; veya &quot;daha fazla bilgi edinin&quot gibi yaygın kelimelerden kaçının;',
    LINK_BEST_PRACTICES: 'Bağlantı metnini değiştirmeyi düşünün: <strong {r}>%(error)</strong><hr><ul><li>&quot;Buraya tıklayın&quot; birçok kişi fare kullanmadığında veya bu web sitesini bir mobil cihazda görüntülüyor olabileceğinde fare mekaniğine odaklanır. Görevle ilgili farklı bir fiil kullanmayı düşünün.</li><li>Yardımcı teknolojiler için gizli olmadıkça HTML sembollerini eylem çağrısı olarak kullanmaktan kaçının.</li></ul>',
    LINK_URL: "Bağlantı metni olarak kullanılan daha uzun, daha az anlaşılır URL'lerin yardımcı teknoloji ile dinlenmesi zor olabilir. Çoğu durumda, URL yerine insan tarafından okunabilir metin kullanmak daha iyidir. Kısa URL'ler (bir sitenin ana sayfası gibi) uygundur.<hr><strong>İpucu!</strong> Bağlantı metni her zaman açık, benzersiz ve anlamlı olmalıdır, böylece bağlam dışında da anlaşılabilir.",
    LINK_DOI: 'Web sayfaları veya yalnızca çevrimiçi kaynaklar için <a href="https://apastyle.apa.org/style-grammar-guidelines/paper-format/accessibility/urls#:~:text=descriptive%20links">APA Stil kılavuzu,</a> çalışmanın URL\'sini veya DOI\'sini başlığının etrafına sararak açıklayıcı bağlantılar kullanılmasını önerir. Bağlantı metni olarak kullanılan daha uzun, daha az anlaşılır URL\'lerin yardımcı teknoloji ile erişildiğinde anlaşılması zor olabilir.',
    NEW_TAB_WARNING: 'Bağlantı uyarı vermeden yeni bir sekmede veya pencerede açılır. Bunu yapmak, özellikle görsel içeriği algılamakta zorluk çeken kişiler için kafa karıştırıcı olabilir. İkinci olarak, bir kişinin deneyimini kontrol etmek veya onun yerine karar vermek her zaman iyi bir uygulama değildir. Bağlantı metninde bağlantının yeni bir pencerede açıldığını belirtin<hr><strong>İpucu!</strong> En iyi uygulamaları öğrenin: <a href="https://www.nngroup.com/articles/new-browser-windows-and-tabs/">bağlantıları yeni tarayıcı pencerelerinde ve sekmelerinde açma.</a>',
    FILE_TYPE_WARNING: 'Bağlantı, uyarı vermeden bir PDF veya indirilebilir dosyaya (örn. MP3, Zip, Word Doc) işaret ediyor. Bağlantı metni içinde dosya türünü belirtin. Büyük bir dosya ise, dosya boyutunu da eklemeyi düşünün.<hr><strong>Örnek:</strong> Yönetici Raporu (PDF, 3MB)',
    LINK_IDENTICAL_NAME: 'Bağlantı, farklı bir sayfaya işaret etmesine rağmen başka bir bağlantıyla aynı metne sahip. Aynı metne sahip birden fazla bağlantı, ekran okuyucu kullanan kişiler için kafa karışıklığına neden olabilir.<hr>Aşağıdaki bağlantıyı diğer bağlantılardan ayırt etmeye yardımcı olmak için daha açıklayıcı hale getirmeyi düşünün: <strong {r}>%(sanitizedText)</strong>',
    MISSING_ALT_LINK_BUT_HAS_TEXT_MESSAGE: 'Görüntü, çevresindeki metinle birlikte bir bağlantı olarak kullanılıyor, ancak alt özniteliği dekoratif veya boş olarak işaretlenmelidir.',
    MISSING_ALT_LINK_MESSAGE: 'Resim bağlantı olarak kullanılıyor ancak alt metni eksik! Lütfen alt metnin bağlantının sizi nereye götüreceğini açıkladığından emin olun.',
    MISSING_ALT_MESSAGE: 'Eksik alt metin! Görsel bir hikaye, ruh hali veya önemli bir bilgi aktarıyorsa, görseli tanımladığınızdan emin olun.',
    LINK_ALT_HAS_FILE_EXTENSION: 'Alt metin içinde dosya uzantısı bulundu. Alt metnin, görüntünün gerçek bir tanımını değil, bağlantının hedefini açıkladığından emin olun. Kaldırın: <strong {r}>%(error)</strong>.<hr><strong>Alt metin:</strong> %(altText)',
    LINK_IMAGE_PLACEHOLDER_ALT_MESSAGE: 'Bağlantılı bir resim içinde tanımlayıcı olmayan veya yer tutucu alt metin bulundu. Alt metnin, görüntünün gerçek bir tanımını değil, bağlantının hedefini açıkladığından emin olun. Aşağıdaki alt metni değiştirin: <strong {r}>%(altText)</strong>',
    LINK_IMAGE_SUS_ALT_MESSAGE: 'Yardımcı teknolojiler zaten bunun bir resim olduğunu gösterir, bu nedenle &quot;<strong {r}>%(error)</strong>&quot; gereksiz olabilir. Alt metnin, resmin gerçek bir tanımını değil, bağlantının hedefini açıkladığından emin olun. <hr> <strong>Alt metin:</strong> %(altText)',
    ALT_HAS_FILE_EXTENSION: 'Bulunan alt metin içinde dosya uzantısı. Görsel bir hikaye, ruh hali veya önemli bir bilgi aktarıyorsa, görseli tanımladığınızdan emin olun. Kaldırın: <strong {r}>%(error)</strong>.<hr><strong>Alt metin:</strong> %(altText)',
    ALT_PLACEHOLDER_MESSAGE: 'Tanımlayıcı olmayan veya yer tutucu alt metin bulundu. Aşağıdaki alt metni daha anlamlı bir metinle değiştirin: <strong {r}>%(altText)</strong>',
    ALT_HAS_SUS_WORD: 'Yardımcı teknolojiler zaten bunun bir resim olduğunu belirtmektedir, bu nedenle &quot;<strong {r}>%(error)</strong>&quot; gereksiz olabilir. <hr> <strong>Alt metin:</strong> %(altText)',
    LINK_HIDDEN_FOCUSABLE: 'Bağlantıda <code>aria-hidden=&quot;true&quot;</code> özelliği var ancak hala klavye ile odaklanılabilir. Eğer gereksiz veya tekrar eden bir bağlantıyı gizlemeyi düşünüyorsanız, <code>tabindex=&quot;-1&quot;</code> özelliğini de ekleyin.',
    LINK_IMAGE_NO_ALT_TEXT: 'Bağlantı içindeki resim dekoratif olarak işaretlenmiş ve bağlantı metni yok. Lütfen resme bağlantının hedefini açıklayan alt metin ekleyin.',
    LINK_IMAGE_HAS_TEXT: 'Bağlantı, çevresindeki metni açıklayıcı bir etiket olarak kullanmasına rağmen görüntü dekoratif olarak işaretlenmiştir.',
    LINK_IMAGE_LONG_ALT: 'Bağlantılı bir görseldeki alt metin açıklaması <strong>çok uzun</strong>. Bağlantılı görsellerdeki alt metin, görselin birebir açıklamasını değil, bağlantının sizi nereye götürdüğünü açıklamalıdır. <strong>Alt metin olarak bağlantı verilen sayfanın başlığını kullanmayı düşünün.</strong> <hr> <strong>Alt metin (<span {r}>%(altLength)</span> karakter):</strong> %(altText)',
    LINK_IMAGE_ALT_WARNING: 'Resim bağlantısı alt metin içeriyor. <strong>Alt metin bağlantının sizi nereye götürdüğünü açıklıyor mu?</strong> Bağlantı verilen sayfanın başlığını alt metin olarak kullanmayı düşünün. <hr> <strong>Alt metin:</strong> %(altText)',
    LINK_IMAGE_ALT_AND_TEXT_WARNING: 'Resim bağlantısı <strong>hem alt metin hem de çevresindeki bağlantı metnini içerir.</strong> Bu resim dekoratifse ve başka bir sayfaya işlevsel bir bağlantı olarak kullanılıyorsa, resmi dekoratif veya boş olarak işaretlemeyi düşünün - çevresindeki bağlantı metni yeterli olmalıdır. <hr> <strong>Alt metin:</strong> %(altText) <hr> <strong>Link etiketi:</strong> %(sanitizedText)',
    IMAGE_FIGURE_DECORATIVE: 'Resim <strong>dekoratif</strong> olarak işaretlenmiştir ve yardımcı teknoloji tarafından göz ardı edilecektir. <hr> Bir <strong>başlık</strong> verilmiş olsa da, çoğu durumda görselin alt metni de olmalıdır. <ul><li>Alt metin, görselde ne olduğuna dair kısa bir açıklama sağlamalıdır.</li><li>Alt yazı genellikle görseli çevreleyen içerikle ilişkilendirmek için bağlam sağlamalı veya belirli bir bilgi parçasına dikkat çekmelidir.</li></ul>Daha fazla bilgi edinin: <a href="https://thoughtbot.com/blog/alt-vs-figcaption#the-figcaption-element">alt versus figcaption.</a>',
    IMAGE_FIGURE_DUPLICATE_ALT: 'Hem alt hem de başlık metni için aynı kelimeleri kullanmayın. Ekran okuyucular bilgileri iki kez duyuracaktır.<ul><li>Alt metin görselde ne olduğuna dair kısa bir açıklama sağlamalıdır.</li><li>Alt yazı genellikle görseli çevreleyen içerikle ilişkilendirmek için bağlam sağlamalı veya belirli bir bilgi parçasına dikkat çekmelidir.</li></ul> Daha fazla bilgi edinin: <a href="https://thoughtbot.com/blog/alt-vs-figcaption#the-figcaption-element">alt versus figcaption.</a> <hr> <strong>Alt metin:</strong> %(altText)',
    IMAGE_DECORATIVE: 'Görüntü <strong>dekoratif</strong> olarak işaretlenir ve yardımcı teknoloji tarafından göz ardı edilir. Görsel bir hikaye, ruh hali veya önemli bir bilgi aktarıyorsa alt metin eklediğinizden emin olun.',
    IMAGE_ALT_TOO_LONG: 'Alt metin açıklaması <strong>çok uzun</strong>. Alt metin kısa, ancak bir <em>tweet</em> gibi anlamlı olmalıdır (yaklaşık 100 karakter). Bu karmaşık bir görsel veya grafikse, görselin uzun açıklamasını aşağıdaki metne veya bir akordeon bileşenine koymayı düşünün. <hr> <strong>Alt metin (<span {r}>%(altLength)</span> karakter):</strong> %(altText)',
    IMAGE_PASS: '<strong>Alt metin:</strong> %(altText)',
    LABELS_MISSING_IMAGE_INPUT_MESSAGE: 'Resim düğmesinin alt metni eksik. Lütfen erişilebilir bir ad sağlamak için alt metin ekleyin. Örneğin: <em>Arama</em> veya <em>Gönder</em>.',
    LABELS_INPUT_RESET_MESSAGE: 'Sıfırla düğmeleri özellikle gerekmedikçe <strong>kullanılmamalıdır</strong> çünkü yanlışlıkla etkinleştirilmeleri kolaydır. <hr> <strong>İpucu!</strong> <a href="https://www.nngroup.com/articles/reset-and-cancel-buttons/">Reset ve İptal düğmelerinin neden kullanılabilirlik sorunları oluşturduğunu öğrenin.</a>',
    LABELS_ARIA_LABEL_INPUT_MESSAGE: 'Girdinin erişilebilir bir adı vardır, ancak lütfen görünür bir etiket olduğundan da emin olun. <hr> <strong>Giriş etiketi:</strong> %(sanitizedText)',
    LABELS_NO_FOR_ATTRIBUTE_MESSAGE: "Bu girdiyle ilişkilendirilmiş bir etiket yok. Etikete, bu girdinin <code>id</code>'siyle eşleşen bir <code>for</code> niteliği ekleyin. <hr> Bu girdinin kimliği şudur: <strong>id=&#34;%(id)&#34;</strong>",
    LABELS_MISSING_LABEL_MESSAGE: 'Bu girdiyle ilişkilendirilmiş bir etiket yok. Lütfen bu girdiye bir <code>id</code> ekleyin ve etikete eşleşen bir <code>for</code> niteliği ekleyin.',
    EMBED_VIDEO: 'Lütfen <strong>tüm videolarda altyazı olduğundan emin olun.</strong> Tüm ses ve video içerikleri için altyazı sağlanması zorunlu bir A Düzeyi gerekliliğidir. Altyazılar, işitme engelli veya işitme güçlüğü çeken kişileri destekler.',
    EMBED_AUDIO: "Lütfen tüm podcast'ler için bir <strong>transkript sağladığınızdan emin olun.</strong> Ses içeriği için transkript sağlamak zorunlu bir Seviye A gerekliliğidir. Transkriptler işitme engelli veya işitme güçlüğü çeken kişileri destekler, ancak herkese fayda sağlayabilir. Transkripti aşağıya veya bir akordeon panel içine yerleştirmeyi düşünün.",
    EMBED_DATA_VIZ: "Bunun gibi veri görselleştirme araçları, gezinmek için klavye veya ekran okuyucu kullanan kişiler için genellikle sorunludur ve az gören veya renk körlüğü olan kişiler için önemli zorluklar yaratabilir. Aynı bilgilerin widget'ın altında alternatif (metin veya tablo) bir formatta sunulması önerilir. <hr> <a href=\"https://www.w3.org/WAI/tutorials/images/complex\">karmaşık görüntüler hakkında daha fazla bilgi edinin.</a>",
    EMBED_MISSING_TITLE: 'Gömülü içerik, içeriğini açıklayan erişilebilir bir ad gerektirir. Lütfen <code>iframe</code> öğesinde benzersiz bir <code>title</code> veya <code>aria-label</code> özniteliği sağlayın. <a href="https://web.dev/learn/accessibility/more-html#iframes">iFrames.</a> hakkında daha fazla bilgi edinin',
    EMBED_GENERAL_WARNING: 'Gömülü içerik kontrol edilemiyor. Lütfen resimlerin alt metni, videoların alt yazısı, metinlerin yeterli kontrastı ve etkileşimli bileşenlerin <a href="https://webaim.org/techniques/keyboard/">klavye ile erişilebilir olduğundan emin olun.</a>',
    EMBED_UNFOCUSABLE: 'Odaklanılamayan öğeler içeren <code>&lt;iframe&gt;</code>, <code>tabindex="-1"</code> olmamalıdır. Gömülü içerik klavye ile erişilebilir olmayacak.',
    QA_BAD_LINK: 'Kötü bağlantı bulundu. Bağlantı bir geliştirme ortamına işaret ediyor gibi görünüyor. <hr> Bu bağlantı şuraya işaret ediyor: <br> <strong {r}>%(el)</strong>',
    QA_BAD_ITALICS: 'Kalın ve italik etiketlerinin anlamsal bir anlamı vardır ve paragrafların tamamını vurgulamak için <strong>kullanılmamalıdır</strong>. Kalınlaştırılmış metin, bir kelime veya cümleye güçlü bir <strong>vurgu</strong> yapmak için kullanılmalıdır. İtalik yazılar özel isimleri (kitap ve makale başlıkları gibi), yabancı kelimeleri ve alıntıları vurgulamak için kullanılmalıdır. Uzun alıntılar blok alıntı olarak biçimlendirilmelidir.',
    QA_PDF: "PDF'ler erişilebilirlik açısından kontrol edilemiyor. PDF'ler web içeriği olarak kabul edilir ve erişilebilir hale getirilmelidir. PDF'ler genellikle ekran okuyucu kullanan kişiler (eksik yapısal etiketler veya eksik form alanı etiketleri) ve az gören kişiler (metin büyütüldüğünde yeniden akmıyor) için sorunlar içerir. <ul><li>Bu bir form ise, alternatif olarak erişilebilir bir HTML formu kullanmayı düşünün.</li><li>Bu bir belge ise, bir web sayfasına dönüştürmeyi düşünün.</li></ul>Aksi takdirde, lütfen Acrobat DC'de erişilebilirlik için <a href=\"https://helpx.adobe.com/acrobat/using/create-verify-pdf-accessibility.html\">PDF'yi kontrol edin.</a>",
    QA_DOCUMENT: 'Belge erişilebilirlik açısından kontrol edilemiyor. Bağlantılı belgeler web içeriği olarak kabul edilir ve erişilebilir hale getirilmelidir. Lütfen bu belgeyi manuel olarak inceleyin. <ul><li><a href="https://support.google.com/docs/answer/6199477?hl=tr">Google Workspace belgenizi veya sunumunuzu daha erişilebilir hale getirin.</a></li><li><a href="https://support.microsoft.com/tr/office/create-accessible-office-documents-868ecfcd-4f00-4224-b881-a65537a7c155">Ofis belgelerinizi daha erişilebilir hale getirin.</a></li></ul>',
    QA_PAGE_LANGUAGE: 'Sayfa dili bildirilmedi! Lütfen <a href="https://www.w3.org/International/questions/qa-html-language-declarations">declare language on HTML tag.</a>',
    QA_PAGE_TITLE: 'Sayfa başlığı eksik! Lütfen bir <a href="https://developer.mozilla.org/tr/docs/Web/HTML/Element/title">sayfa başlığı sağlayın.</a>',
    QA_BLOCKQUOTE_MESSAGE: 'Bu bir başlık mı? <strong {r}>%(sanitizedText)</strong> <hr>Blok tırnaklar yalnızca alıntılar için kullanılmalıdır. Bunun bir başlık olması amaçlanıyorsa, bu blok alıntıyı anlamsal bir başlığa (örneğin Başlık 2 veya Başlık 3) değiştirin.',
    QA_FAKE_HEADING: "Bu bir başlık mı? <strong {r}>%(boldtext)</strong> <hr>Bir satır kalın veya büyük metin bir başlık gibi görünebilir, ancak ekran okuyucu kullanan biri bunun önemli olduğunu anlayamaz veya içeriğine atlayamaz. Kalın veya büyük metin asla anlamsal başlıkların (Başlık 2'den Başlık 6'ya) yerini almamalıdır.",
    QA_SHOULD_BE_LIST: 'Bir liste oluşturmaya mı çalışıyorsunuz? Olası liste öğesi bulundu: <strong {r}>%(firstPrefix)</strong> <hr> Bunun yerine madde işareti veya sayı biçimlendirme düğmelerini kullanarak anlamsal listeler kullandığınızdan emin olun. Anlamsal bir liste kullanıldığında, yardımcı teknolojiler toplam öğe sayısı ve listedeki her bir öğenin göreli konumu gibi bilgileri iletebilir. <a href="https://www.w3.org/WAI/tutorials/page-structure/content/#lists">anlamsal listeler hakkında daha fazla bilgi edinin.</a>',
    QA_UPPERCASE_WARNING: 'Büyük harfler bulundu. Bazı ekran okuyucular büyük harfle yazılan metni kısaltma olarak yorumlayabilir ve her harfi ayrı ayrı okuyabilir. Ayrıca, bazı kişiler büyük harfleri okumayı daha zor bulabilir ve bu durum BAĞIRMA görüntüsü verebilir.',
    QA_DUPLICATE_ID: '<strong>yinelenen kimlik</strong> bulundu. Yinelenen kimlik hatalarının, içerikle etkileşime girmeye çalışan yardımcı teknolojiler için sorunlara neden olduğu bilinmektedir. <hr> Lütfen aşağıdaki kimliği kaldırın veya değiştirin: <strong {r}>%(id)</strong>',
    QA_TEXT_UNDERLINE_WARNING: 'Altı çizili metin bağlantılarla karıştırılabilir. <code>&lt;strong&gt;</code><strong>strong importance</strong><code>&lt;/strong&gt;</code> veya <code>&lt;em&gt;</code><em>emphasis</em><code>&lt;/em&gt;</code> gibi farklı bir stil kullanmayı düşünün.',
    QA_SUBSCRIPT_WARNING: 'Alt simge ve üst simge biçimlendirme seçenekleri yalnızca tipografik kurallar veya standartlar için metnin konumunu değiştirmek amacıyla kullanılmalıdır. Yalnızca sunum veya görünüm amacıyla <strong>kullanılmamalıdır</strong>. Tüm cümlelerin biçimlendirilmesi okunabilirlik sorunları yaratır. Uygun kullanım durumları arasında üslerin, dördüncü yerine 4<sup>üncü</sup> gibi sıra sayılarının ve kimyasal formüllerin (örneğin H<sub>2</sub>O) gösterilmesi yer alır.',
    TABLES_MISSING_HEADINGS: 'Eksik tablo başlıkları! Erişilebilir tablolar, başlık hücrelerini ve aralarındaki ilişkiyi tanımlayan veri hücrelerini gösteren HTML işaretlemesine ihtiyaç duyar. Bu bilgi, yardımcı teknoloji kullanan kişilere bağlam sağlar. Tablolar yalnızca tablo verileri için kullanılmalıdır. <hr> <a href="https://www.w3.org/WAI/tutorials/tables/">erişilebilir tablolar hakkında daha fazla bilgi edinin.</a>',
    TABLES_SEMANTIC_HEADING: 'Heading 2 veya Heading 3 gibi anlamsal başlıklar yalnızca içerik bölümleri için kullanılmalıdır; HTML tablolarında <strong>değil</strong>. Bunun yerine tablo başlıklarını <code>&lt;th&gt;</code> öğesini kullanarak belirtin. <hr> <a href="https://www.w3.org/WAI/tutorials/tables/">erişilebilir tablolar hakkında daha fazla bilgi edinin.</a>',
    TABLES_EMPTY_HEADING: 'Boş tablo başlığı bulundu! Tablo başlıkları <strong>asla</strong> boş olmamalıdır. İlişkilerini aktarmak için satır ve/veya sütun başlıklarını belirlemek önemlidir. Bu bilgi, yardımcı teknoloji kullanan kişilere bağlam sağlar. Lütfen tabloların yalnızca tablo halindeki veriler için kullanılması gerektiğini unutmayın. <hr> <a href="https://www.w3.org/WAI/tutorials/tables/">erişilebilir tablolar hakkında daha fazla bilgi edinin.</a>',
    CONTRAST_ERROR: "Bu metin arka planla yeterli kontrasta sahip değil. Kontrast oranı normal metin için en az 4,5:1 ve büyük metin için 3:1 olmalıdır. <hr> Aşağıdaki metin için kontrast oranı <strong {r}>%(cratio)</strong>'dur: <strong {r}>%(sanitizedText)</strong>",
    CONTRAST_WARNING: 'Bu metnin kontrastı bilinmemektedir ve manuel olarak gözden geçirilmesi gerekmektedir. Metin ve arka planın güçlü kontrast renklere sahip olduğundan emin olun. Kontrast oranı normal metin için en az 4,5:1 ve büyük metin için 3:1 olmalıdır. <hr> <strong>Lütfen inceleyin:</strong> %(sanitizedText)',
    CONTRAST_INPUT_ERROR: 'Bu girişteki metin arka planla yeterli kontrasta sahip değil. Kontrast oranı normal metin için en az 4,5:1 ve büyük metin için 3:1 olmalıdır. <hr> Kontrast oranı: <strong {r}>%(cratio)</strong>',
  },
};

export { tr as default };
