/*!
  * Sa11y, the accessibility quality assurance assistant.
  * @version 3.0.8
  * @author Adam Chaboryk, Toronto Metropolitan University
  * @license GPL-2.0-or-later
  * @copyright © 2020 - 2024 Toronto Metropolitan University (formerly Ryerson University).
  * @contact adam.chaboryk@torontomu.ca
  * GitHub: git+https://github.com/ryersondmp/sa11y.git | Website: https://sa11y.netlify.app
  * For all acknowledgements, please visit: https://sa11y.netlify.app/acknowledgements/
  * The above copyright notice shall be included in all copies or substantial portions of the Software.
**/
const e={checkRoot:"body",containerIgnore:".sa11y-ignore",contrastIgnore:'.sr-only, [role="menu"] *',outlineIgnore:"",headerIgnore:"",imageIgnore:"",linkIgnore:'nav *, [role="navigation"] *',linkIgnoreSpan:"",linkIgnoreStrings:"",showGoodLinkButton:!0,showHinPageOutline:!1,detectSPArouting:!1,doNotRun:"",dismissAnnotations:!0,headless:!1,selectorPath:!1,shadowComponents:"",autoDetectShadowComponents:!1,panelPosition:"right",altTextMaxCharLength:250,headingMaxCharLength:170,URLTextMaxCharLength:40,URLAsLinkTextWarning:!0,readabilityPlugin:!0,readabilityRoot:"body",readabilityIgnore:"",contrastPlugin:!0,formLabelsPlugin:!0,linksAdvancedPlugin:!0,colourFilterPlugin:!0,customChecks:!0,checkAllHideToggles:!1,exportResultsPlugin:!1,linksToFlag:"",linksToDOI:!0,missingH1:!0,flagLongHeadings:!0,nonConsecutiveHeadingIsError:!0,badLinksQA:!0,strongItalicsQA:!0,pdfQA:!0,documentQA:!0,documentLinks:".ppt, .doc, .xls, .csv, sway.com, docs.google.com",langQA:!0,blockquotesQA:!0,allCapsQA:!0,fakeHeadingsQA:!0,fakeListQA:!0,duplicateIdQA:!0,underlinedTextQA:!0,pageTitleQA:!0,subscriptQA:!0,tablesQA:!0,tablesQAmissingTH:!0,tablesQAsemanticHeadings:!0,tablesQAemptyTH:!0,tablesQAemptyTHisError:!0,embeddedContentAll:!0,embeddedContentAudio:!0,embeddedContentVideo:!0,embeddedContentDataViz:!0,embeddedContentTitles:!0,embeddedContentGeneral:!0,videoContent:"youtube.com, vimeo.com, yuja.com, panopto.com",audioContent:"soundcloud.com, simplecast.com, podbean.com, buzzsprout.com, blubrry.com, transistor.fm, fusebox.fm, libsyn.com",dataVizContent:"datastudio, tableau, lookerstudio, powerbi, qlik"},t={langStrings:{},addI18n(e){this.langStrings=e},_(e){return this.translate(e)},sprintf(e,...t){let n=this._(e);return n=this.prepHTML(n),t&&t.length&&t.forEach((e=>{n=n.replace(/%\([a-zA-z]+\)/,e)})),n},translate(e){return this.langStrings[e]||e},prepHTML:e=>e.replaceAll(/<hr>/g,'<hr aria-hidden="true">').replaceAll(/<a[\s]href=/g,'<a target="_blank" rel="noopener noreferrer" href=').replaceAll(/<\/a>/g,`<span class="visually-hidden"> (${t._("NEW_TAB")})</span></a>`).replaceAll(/{r}/g,'class="red-text"')};const n=e=>{const t=document.createElement("style");t.setAttribute("class","sa11y-css-utilities"),t.textContent="[data-sa11y-overflow]{overflow:auto!important}[data-sa11y-clone-image-text]{display:none!important}[data-sa11y-readability-period]{clip:rect(1px,1px,1px,1px)!important;border:0!important;-webkit-clip-path:inset(50%)!important;clip-path:inset(50%)!important;display:block!important;height:1px!important;overflow:hidden!important;padding:0!important;position:absolute!important;white-space:nowrap!important;width:1px!important}[data-sa11y-error]{outline:5px solid var(--sa11y-error)!important}[data-sa11y-warning]{outline:5px solid var(--sa11y-warning)!important}[data-sa11y-good]{outline:5px solid var(--sa11y-good)!important}[data-sa11y-error-inline]{background-color:var(--sa11y-error)!important;box-shadow:0 0 0 4px var(--sa11y-error)!important;color:var(--sa11y-error-text)!important}[data-sa11y-error-inline],[data-sa11y-warning-inline]{border-color:transparent!important;border-radius:.25em!important}[data-sa11y-warning-inline]{background-color:var(--sa11y-warning)!important;box-shadow:0 0 0 4px var(--sa11y-warning)!important;color:var(--sa11y-warning-text)!important}[data-sa11y-pulse-border]{animation:pulse 2s 3;box-shadow:0;outline:5px solid var(--sa11y-focus-color)!important}[data-sa11y-pulse-border]:focus,[data-sa11y-pulse-border]:hover{animation:none}@keyframes pulse{0%{box-shadow:0 0 0 5px var(--sa11y-focus-color)}70%{box-shadow:0 0 0 12px var(--sa11y-pulse-color)}to{box-shadow:0 0 0 5px var(--sa11y-pulse-color)}}@media (prefers-reduced-motion:reduce){[data-sa11y-pulse-border]{animation:none!important}}@media (forced-colors:active){[data-sa11y-error-inline],[data-sa11y-error],[data-sa11y-good],[data-sa11y-pulse-border],[data-sa11y-warning-inline],[data-sa11y-warning]{forced-color-adjust:none}}",e.shadowRoot.appendChild(t)};const o=function(){const e={};const i={};const a={};const r={};const s={};const l={};return{initializeGlobal:function(t){e.html=document.querySelector("html"),e.headless=t.headless,e.panelPosition=t.panelPosition,e.dismissAnnotations=t.dismissAnnotations,e.contrastPlugin=t.contrastPlugin,e.formLabelsPlugin=t.formLabelsPlugin,e.linksAdvancedPlugin=t.linksAdvancedPlugin,e.colourFilterPlugin=t.colourFilterPlugin,e.checkAllHideToggles=t.checkAllHideToggles,e.exportResultsPlugin=t.exportResultsPlugin,e.Root=document.querySelector(t.checkRoot),e.Root||(e.Root=document.querySelector("body"));let n=!1;"function"==typeof window.matchMedia&&(n=window.matchMedia("(prefers-reduced-motion: reduce)")),e.scrollBehaviour=!n||n.matches?"auto":"smooth",e.langDirection="rtl"===e.html.getAttribute("dir")?"rtl":"ltr",t.documentLinks&&(e.documentLinks=`${t.documentLinks}`)},Global:e,initializePanelSelectors:function(){const e=document.querySelector("sa11y-control-panel").shadowRoot;i.panel=e.getElementById("panel"),i.content=e.getElementById("panel-content"),i.controls=e.getElementById("panel-controls"),i.outline=e.getElementById("outline-panel"),i.outlineContent=e.getElementById("outline-content"),i.outlineList=e.getElementById("outline-list"),i.outlineHeader=e.getElementById("outline-header"),i.notifBadge=e.getElementById("notification-badge"),i.notifCount=e.getElementById("notification-count"),i.notifText=e.getElementById("notification-text"),i.status=e.getElementById("status"),i.pageIssues=e.getElementById("page-issues"),i.pageIssuesList=e.getElementById("page-issues-list"),i.pageIssuesHeader=e.getElementById("page-issues-header"),i.pageIssuesContent=e.getElementById("page-issues-content"),i.settings=e.getElementById("settings-panel"),i.settingsHeader=e.getElementById("settings-header"),i.settingsContent=e.getElementById("settings-content"),i.contrastToggle=e.getElementById("contrast-toggle"),i.labelsToggle=e.getElementById("labels-toggle"),i.linksToggle=e.getElementById("links-advanced-toggle"),i.readabilityToggle=e.getElementById("readability-toggle"),i.themeToggle=e.getElementById("theme-toggle"),i.contrastItem=e.getElementById("contrast-item"),i.labelsItem=e.getElementById("form-labels-item"),i.linksItem=e.getElementById("links-advanced-item"),i.readabilityItem=e.getElementById("readability-item"),i.darkModeItem=e.getElementById("dark-mode-item"),i.colourPanel=e.getElementById("panel-colour-filters"),i.colourFilterItem=e.getElementById("colour-filter-item"),i.colourFilterSelect=e.getElementById("colour-filter-select"),i.colourFilterIcon=e.getElementById("filter-icon"),i.toggle=e.getElementById("toggle"),i.outlineToggle=e.getElementById("outline-toggle"),i.settingsToggle=e.getElementById("settings-toggle"),i.skipButton=e.getElementById("skip-button"),i.dismissButton=e.getElementById("dismiss-button"),i.dismissTooltip=e.getElementById("dismiss-tooltip"),i.skipToPageIssues=e.getElementById("skip-to-page-issues"),i.exportHTML=e.getElementById("export-html"),i.exportCSV=e.getElementById("export-csv"),i.alert=e.getElementById("panel-alert"),i.alertText=e.getElementById("panel-alert-text"),i.alertPreview=e.getElementById("panel-alert-preview"),i.alertClose=e.getElementById("close-alert"),i.readability=e.getElementById("readability-panel"),i.readabilityInfo=e.getElementById("readability-info"),i.readabilityDetails=e.getElementById("readability-details")},Panel:i,initializeReadability:function(n){if(n.readabilityPlugin){a.Root=document.querySelector(n.readabilityRoot),a.Root||(e.Root?(a.Root=e.Root,console.error(`Sa11y configuration error: The selector '${n.readabilityRoot}' used for the property 'readabilityRoot' does not exist. '${e.Root.tagName}' was used as a fallback.`)):a.Root=document.querySelector("body")),a.Lang=t._("LANG_CODE").substring(0,2);const i=["en","fr","es","de","nl","it","sv","fi","da","no","nb","nn","pt"],r=o.Global.html.getAttribute("lang");if(r){const e=r.toLowerCase().substring(0,2);i.includes(e)&&i.includes(a.Lang)?a.Plugin=!0:a.Plugin=!1}else a.Plugin=!1}},Readability:a,initializeExclusions:function(e){if(e.containerIgnore){const t=e.containerIgnore.split(",").map((e=>`${e} *, ${e}`));r.Container=`#wpadminbar *, ${t.join(", ")}`}else r.Container="#wpadminbar *";r.Contrast="script, style, link",e.contrastIgnore&&(r.Contrast=`${e.contrastIgnore}, ${r.Contrast}`),r.Readability='nav li, [role="navigation"] li',e.readabilityIgnore&&(r.Readability=`${e.readabilityIgnore}, ${r.Readability}`),e.headerIgnore&&(r.Headings=`${e.headerIgnore}`),e.outlineIgnore&&(r.Outline=`${e.outlineIgnore}`),r.Images='[role="presentation"]',e.imageIgnore&&(r.Images=`${e.imageIgnore}, ${r.Images}`),r.Links=".anchorjs-link",e.linkIgnore&&(r.Links=`${e.linkIgnore}, ${r.Links}`),e.linkIgnoreSpan&&(r.LinkSpan=e.linkIgnoreSpan)},Exclusions:r,initializeEmbeddedContent:function(e){if(e.videoContent){const t=e.videoContent.split(/\s*[\s,]\s*/).map((e=>`[src*='${e}']`));s.Video=`video, ${t.join(", ")}`}else s.Video="video";if(e.audioContent){const t=e.audioContent.split(/\s*[\s,]\s*/).map((e=>`[src*='${e}']`));s.Audio=`audio, ${t.join(", ")}`}else s.Audio="audio";if(e.dataVizContent){const t=e.dataVizContent.split(/\s*[\s,]\s*/).map((e=>`[src*='${e}']`));s.Visualization=t.join(", ")}else s.Visualization="datastudio.google.com, tableau";s.All=`${s.Video}, ${s.Audio}, ${s.Visualization}`},EmbeddedContent:s,initializeShadowSearch:function(e,t,o){l.Components=function(e){let t;if(e.autoDetectShadowComponents){const o="sa11y-heading-label, sa11y-heading-anchor, sa11y-annotation, sa11y-tooltips, sa11y-dismiss-tooltip, sa11y-control-panel, #sa11y-colour-filters, #sa11y-colour-filters *, script",i=document.querySelector(e.checkRoot),a=i?Array.from(i.querySelectorAll(`*:not(${o})`)):Array.from(document.body.querySelectorAll(`*:not(${o})`)),r=[];a.forEach((e=>{e.shadowRoot&&"open"===e.shadowRoot.mode&&(r.push(e),n(e))}));const s=Array.from(r).map((e=>e.tagName.toLowerCase()));t=1===s.length?`${s.toString()}`:s.join(", ")}else t=e.suppliedShadowComponents||"",t&&document.querySelectorAll(t).forEach((e=>{n(e)}));return t}(e)},Shadow:l}}();function i(e,t,n){let i;"document"===t?i=document:"readability"===t?(i=o.Readability.Root,i||(i=o.Global.Root)):"root"===t?(i=o.Global.Root,i||(i=document.body)):"panel"===t?(i=o.Panel.panel,i||(i=document.body)):(i=document.querySelector(t),i||(i=document.body));const a=o.Shadow.Components,r=a?`, ${a}`:"",s=o.Exclusions.Container,l=void 0!==n?`, ${n}`:"",d=Array.from(i.querySelectorAll(`:is(${e}${r}):not(${s}${l})`));if(a.length){const t=[],n=a.trim().replace(/^,+/,"");if(d.forEach(((o,i)=>{o.matches(n)&&(t[i]=o.shadowRoot.querySelectorAll(`:is(${e}):not(${s}${l})`))})),t.length>0)for(let e=t.length-1;e>=0;e--)t[e]&&d.splice(e,1,...t[e])}return d}function a(e){if(e.getAttribute("hidden"))return!0;return"none"===getComputedStyle(e).getPropertyValue("display")}function r(e){const t=document.createElement("div");return t.textContent=e,t.innerHTML.replaceAll('"',"&quot;").replaceAll("'","&#039;").replaceAll("`","&#x60;")}function s(e){return e.replace(/[^\w. ]/gi,(e=>`&#${e.charCodeAt(0)};`))}function l(e){return e.textContent.replace(/[\r\n]+/g,"").replace(/\s+/g," ").trim()}function d(e){return e.replace(/[\r\n]+/g," ").replace(/\s+/g," ").trim()}function c(e,t){const n="noscript, script, style",o=t?`${n}, ${t}`:n,i=e.cloneNode(!0);return Array.from(i.querySelectorAll(o)).forEach((e=>{e.parentElement.removeChild(e)})),i}function p(e,t,n){let o=e;for(;null!==o;){if(window.getComputedStyle(o).getPropertyValue(t)===n)return o;o=o.parentElement}return null}function u(e){const t=e.getBoundingClientRect(),n=window.pageYOffset||document.documentElement.scrollTop;return{top:t.top+n}}const g={getItem(e){try{return null===localStorage.getItem(e)?sessionStorage.getItem(e):localStorage.getItem(e)}catch(e){return!1}},setItem(e,t){try{localStorage.setItem(e,t)}catch(n){sessionStorage.setItem(e,t)}return!0},removeItem(e){try{localStorage.removeItem(e)}catch(t){sessionStorage.removeItem(e)}return!0}};function m(e){const t="data-sa11y-pulse-border";e.setAttribute(t,""),setTimeout((()=>{e.removeAttribute(t)}),2500)}function f(e){return String(e).replace(/([^0-9a-zA-Z])/g,"").substring(0,256)}function b(){const e=document.querySelector("sa11y-control-panel").shadowRoot,t=e.getElementById("panel-alert"),n=e.getElementById("panel-alert-text"),o=e.getElementById("panel-alert-preview");for(t.classList.remove("active"),o.classList.remove("panel-alert-preview");n.firstChild;)n.removeChild(n.firstChild);for(;o.firstChild;)o.removeChild(o.firstChild)}function h(e,t,n){b();const o=document.querySelector("sa11y-control-panel").shadowRoot,i=o.getElementById("panel-alert"),a=o.getElementById("panel-alert-text"),r=o.getElementById("panel-alert-preview"),s=o.getElementById("close-alert"),l=o.getElementById("skip-button");i.classList.add("active"),a.innerHTML=e;const d=n?`<div class="element-preview">${n}</div>`:"";function c(){b();(l.hasAttribute("disabled")?o.getElementById("toggle"):l).focus()}t&&(r.classList.add("panel-alert-preview"),r.innerHTML=`${d}<div class="preview-message">${t}</div>`),setTimeout((()=>{s.focus()}),300),s.addEventListener("click",c),i.onkeydown=e=>{"Escape"===(e||window.event).key&&i.classList.contains("active")&&c()}}function y(e,t){e.forEach((e=>{i(`[${e}]`,`${t}`).forEach((t=>{t.removeAttribute(e)}))}))}function v(e,t){i(`${e}`,`${t}`).forEach((e=>{e.parentNode.removeChild(e)}))}function x(e,t){e.scrollHeight>t.clientHeight?(t.classList.add("scrollable"),e.setAttribute("tabindex","0")):t.classList.remove("scrollable")}function w(e){const t=e.element,n=`<pre><code>${r(e.htmlPath)}</code></pre>`,o={IMG:e=>{const t=e.closest("a[href]"),o=e.alt?`alt="${s(e.alt)}"`:"alt",i=e.src,a=e.getAttribute("data-src"),r=a&&a.length>3?a:i;return i?t?`<a href="${t.href}" rel="noopener noreferrer"><img src="${r}" ${o}/></a>`:`<img src="${r}" ${o}/>`:n},IFRAME:e=>{const t=e.src,o=e.title?e.title:"",i=e.getAttribute("aria-label");if(t){return`<iframe src="${t}" aria-label="${s(i||""||o)}"></iframe>`}return n},AUDIO:()=>e.htmlPath,VIDEO:()=>e.htmlPath}[t.tagName];return o?o(t):n}const A=function(){const e={};const t={};return{initializeElements:function(t){e.Images=i("img","root",o.Exclusions.Images),e.Headings=i('h1, h2, h3, h4, h5, h6, [role="heading"][aria-level]',"document",o.Exclusions.Headings),e.HeadingOne=i('h1, [role="heading"][aria-level="1"]',"document",o.Exclusions.Headings),e.Links=i("a[href]","root",o.Exclusions.Links),e.Inputs=i("input, select, textarea","root",o.Exclusions.Container),e.Contrast=i("*","root",o.Exclusions.Contrast),e.Labels=i("label","root",o.Exclusions.Container),e.Readability=i("p, li","readability",o.Exclusions.Readability),e.Paragraphs=i("p","root",o.Exclusions.Container),e.Lists=i("li","root",o.Exclusions.Container),e.Spans=i("span","root",o.Exclusions.Container),e.Blockquotes=i("blockquote","root",o.Exclusions.Container),e.Tables=i('table:not([role="presentation"])',"root",o.Exclusions.Container),e.StrongItalics=i("strong, em","root",o.Exclusions.Container),e.Ids=i("[id]","document",o.Exclusions.Container),e.Underlines=i("u","root",o.Exclusions.Container),e.Subscripts=i("sup, sub","root",o.Exclusions.Container),e.Language=o.Global.html.getAttribute("lang"),e.CustomErrorLinks=t?i(t,"root",o.Exclusions.Container):[],e.iframes=i("iframe:not(hidden), audio, video","root",o.Exclusions.Container),e.Videos=e.iframes.filter((e=>e.matches(o.EmbeddedContent.Video))),e.Audio=e.iframes.filter((e=>e.matches(o.EmbeddedContent.Audio))),e.Visualizations=e.iframes.filter((e=>e.matches(o.EmbeddedContent.Visualization))),e.EmbeddedContent=e.iframes.filter((e=>!e.matches(o.EmbeddedContent.All)))},Found:e,initializeAnnotations:function(){t.Array=i("sa11y-annotation","document"),t.Array.forEach(((e,t)=>{e.setAttribute("data-sa11y-position",t)}))},Annotations:t}}();function E(e,t,n){if(!0===e){let e=window.location.pathname;const o=function(e,t){let n=null;return(...o)=>{window.clearTimeout(n),n=window.setTimeout((()=>{e(...o)}),t)}}((async()=>{e!==window.location.pathname&&("Closed"!==g.getItem("sa11y-remember-panel")&&g.getItem("sa11y-remember-panel")?(n(!1),await t()):t(),e=window.location.pathname)}),250);window.addEventListener("mousemove",o),window.addEventListener("keydown",o)}}let L,k;function I(e,n,a,r){if(o.Global.dismissAnnotations){k=n=>{(async(e,n,o,a)=>{let r=JSON.parse(g.getItem("sa11y-dismissed"));const s=e.target;if(document.querySelector("sa11y-dismiss-tooltip").hidden=!1,"BUTTON"===s.tagName&&s.hasAttribute("data-sa11y-dismiss")){const e=parseInt(s.getAttribute("data-sa11y-dismiss"),10),l=n.find((t=>t.id===e));if(null===r&&(setTimeout((()=>h(t._("DISMISS_REMINDER"))),0),r=[]),l.dismiss){const e={key:l.dismiss,href:window.location.pathname},t=i(`[data-sa11y-annotation='${l.id}']`),n=t[0]?t[0].getAttribute("data-sa11y-position"):0;g.setItem("sa11y-latest-dismissed",n),g.setItem("sa11y-dismiss-item",JSON.stringify(e)),r.push(e),g.setItem("sa11y-dismissed",JSON.stringify(r)),g.removeItem("sa11y-dismiss-item"),null!==s.closest("[data-tippy-root]")&&s.closest("[data-tippy-root]").remove(),a(!1),await o()}}})(n,e,a,r)};document.querySelector("sa11y-tooltips").shadowRoot.addEventListener("click",k),o.Panel.panel.addEventListener("click",k)}L=()=>{(async(e,t,n)=>{document.querySelector("sa11y-dismiss-tooltip").hidden=!0;const i=e.filter((e=>e.href!==window.location.pathname));g.setItem("sa11y-dismissed",JSON.stringify(i)),o.Panel.dismissButton.classList.remove("active"),n(!1),await t()})(n,a,r)},o.Panel.dismissButton?.addEventListener("click",L)}var T=':root{--font-primary:system-ui,"Segoe UI",roboto,helvetica,arial,sans-serif;--font-secondary:Consolas,monaco,"Ubuntu Mono","Liberation Mono","Courier New",Courier,monospace;--body-text:#333;--bg-primary:#fff;--bg-secondary:#f6f8fa;--bg-tertiary:#d7d7d7;--link-primary:#004c9b;--red-text:#d30017}@media (prefers-color-scheme:dark){:root{--body-text:#dde8ff;--bg-primary:#0a2051;--bg-secondary:#072c7c;--bg-tertiary:#0041c9;--link-primary:#64b2ff;--red-text:#fe5b5f}}*{margin:0;padding:0}article,aside,nav,ol,p,pre,section,ul{margin-bottom:1rem}body{background:var(--bg-primary);font-family:var(--font-primary);font-size:1rem;line-height:1.5;margin:0 auto;max-width:70ch;overflow-wrap:break-word;overflow-x:hidden;padding:2rem;word-break:break-word}body,h1,h2,h3{color:var(--body-text)}h1,h2,h3{line-height:1;margin-bottom:8px;padding-bottom:2px;padding-top:.875rem}h1{font-size:2.25rem}h2{font-size:1.85rem}h3{font-size:1.55rem}a{color:var(--link-primary)}a:focus,a:hover{text-decoration:none}footer,header{background:var(--bg-secondary);padding:2rem calc(50vw - 50%)}header{border-bottom:1px solid var(--bg-tertiary);margin:-2rem calc(-50vw + 50%) 2rem}footer{border-top:1px solid var(--bg-tertiary);margin:3rem calc(-50vw + 50%) -2rem;text-align:center}header>:first-child{margin-top:0;padding-top:0}header>:last-child{margin-bottom:0}code,kbd,pre,samp{background:var(--bg-secondary);border:1px solid var(--bg-tertiary);border-radius:4px;font-family:var(--font-secondary);font-size:.9rem;padding:3px 6px}pre{display:block;max-width:100%;overflow:auto;padding:1rem 1.4rem}code pre,pre code{background:inherit;border:0;color:inherit;font-size:inherit;margin:0;padding:0}code pre{display:inline}details{background:var(--bg-primary);border:2px solid var(--link-primary);border-radius:4px;padding:.6rem 1rem}summary{cursor:pointer;font-weight:700}details[open]{padding-bottom:.75rem}details[open] summary{margin-bottom:6px}details[open]>:last-child{margin-bottom:0}.two-columns{display:flex}.column{flex:1;margin-inline-end:20px}.count{max-width:220px}.column dl{width:100%}dl{padding-top:10px}dt{font-weight:700}dd{padding-bottom:10px}ol ol,ol ul,ul ol,ul ul{margin-bottom:0}ul li{margin-bottom:.5rem}ol,ul{padding-left:2rem}li li:has(pre,img,iframe,video,audio){list-style:none;margin-top:1rem}ol li:not(li li){margin-bottom:3rem}iframe,img{max-width:50%}audio,iframe,img,video{border:0;display:block}.red-text{color:var(--red-text)}.visually-hidden{clip:rect(1px,1px,1px,1px);border:0;-webkit-clip-path:inset(50%);clip-path:inset(50%);display:block;height:1px;overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:1px}';function _(){const e=new Date,t=String(e.getDate()).padStart(2,"0"),n=String(e.getMonth()+1).padStart(2,"0"),o=e.getFullYear(),i=(new Date).toLocaleString(),a=`${n}-${t}-${o}`,r=document.querySelector("head title"),s=!r||0===r.textContent.trim().length;return{date:i,numericDate:a,titleCheck:s,metaTitle:s?"":r.textContent,pageURL:window.location.href}}function S(e,n){const o=function(e,n){const o=e.filter((e=>"error"===e.type)),i=e.filter((e=>"warning"===e.type)),a={error:o.length,warning:i.length,dismiss:n.length};function s(e,n){const o={error:t._("ERRORS"),warning:t._("WARNINGS"),dismissed:t._("DISMISSED")}[n];if(!(e.length>0))return"";let i=`<h2>${o}</h2>`,s="<ol>",l="</ol>";return"dismissed"===n&&(s=`<details><summary>${t.sprintf("PANEL_DISMISS_BUTTON",a.dismiss)}</summary><ol>`,l="</details>"),i+=s,e.forEach((e=>{let n="";e.element&&(n=["IMG","IFRAME","AUDIO","VIDEO"].includes(e.element.tagName)?`\n              <li>\n                <strong>${t._("PREVIEW")}:</strong>\n                ${w(e)}\n              </li>\n              <li>\n                <strong>${t._("ELEMENT")}:</strong>\n                <pre><code>${r(e.htmlPath)}</code></pre>\n              </li>`:`\n              <li>\n                <strong>${t._("ELEMENT")}:</strong>\n                <pre><code>${r(e.htmlPath)}</code></pre>\n              </li>`);const o=e.cssPath?`<li>\n            <strong>${t._("PATH")}:</strong>\n            <pre><code>${e.cssPath}</code></pre>\n          </li>`:"";i+=`<li>\n                <p>${e.content.replace('<hr aria-hidden="true">'," | ")}</p>\n                <ul>${n}${o}</ul>\n              </li>`})),i+=l,i}const l=s(o,"error"),d=s(i,"warning"),c=s(n,"dismissed"),p=_(),u=p.titleCheck?"":`<dt>${t._("PAGE_TITLE")}</dt><dd>${p.metaTitle}</dd>`,g=0!==a.error?`<dt>${t._("ERRORS")}</dt><dd>${a.error}</dd>`:"",m=0!==a.warning?`<dt>${t._("WARNINGS")}</dt><dd>${a.warning}</dd>`:"",f=0!==a.dismiss?`<dt>${t._("DISMISSED")}</dt><dd>${a.dismiss}</dd>`:"";return`\n      <!DOCTYPE html>\n      <html lang="${t._("LANG_CODE")}">\n      <head>\n        <meta charset="UTF-8">\n        <meta name="viewport" content="width=device-width, initial-scale=1.0">\n        <title>${t._("RESULTS")}: ${p.metaTitle}</title>\n        <style>${T}</style>\n      </head>\n      <body>\n        <header>\n          <h1>${t._("RESULTS")}</h1>\n          <dl class="two-columns">\n            <div class="column">\n              ${u}\n              <dt>URL</dt>\n              <dd><a href="${p.pageURL}">${p.pageURL}</a></dd>\n              <dt>${t._("DATE")}</dt>\n              <dd>${p.date}</dd>\n            </div>\n            <div class="column count">\n              ${g}\n              ${m}\n              ${f}\n            </div>\n        </dl>\n        </header>\n        ${l}\n        ${d}\n        ${c}\n        <footer>\n          <p>${t.sprintf("GENERATED",'<a href="https://sa11y.netlify.app">Sa11y</a>')}</p>\n        </footer>\n      </body>\n      </html>\n    `}(e,n),i=_(),a=new Blob([o],{type:"text/html"}),s=document.createElement("a"),l=i.titleCheck?"":`_${i.metaTitle.trim().replace(/ /g,"")}`;s.href=window.URL.createObjectURL(a),s.download=`Sa11y_${i.numericDate+l}.html`,document.body.appendChild(s),s.click(),setTimeout((()=>{document.body.removeChild(s),window.URL.revokeObjectURL(s.href)}),100)}function P(e){const t=_(),n=e.filter((e=>"warning"===e.type||"error"===e.type)).map((e=>{const{type:n,content:o,htmlPath:i,cssPath:a}=e,r=o.replaceAll(/<span\s+class="visually-hidden"[^>]*>.*?<\/span>/gi,"").replaceAll('<hr aria-hidden="true">'," | ");const s=function(e){return e.replace(/&(#?[a-zA-Z0-9]+);/g,((e,t)=>{switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":case"#39":return"'";default:return"#"===t.charAt(0)?String.fromCharCode("x"===t.charAt(1)?parseInt(t.substr(2),16):parseInt(t.substr(1),10)):e}}))}(String(r).replace(/<[^>]*>/g,"")),l={Title:`"${t.metaTitle}"`,URL:`"${t.pageURL}"`,Type:`"${String(n)}"`,Issue:`"${s}"`,Element:`"${i}"`};return a&&(l.Path=`"${a}"`),l})),o=Object.keys(n[0]),i=`${o.join(",")}\n${n.map((e=>o.map((t=>e[t])).join(","))).join("\n")}`,a=new Blob([i],{type:"text/csv"}),r=window.URL.createObjectURL(a),s=document.createElement("a");s.href=r,s.href=window.URL.createObjectURL(a);const l=t.titleCheck?"":`_${t.metaTitle.trim().replace(/ /g,"")}`;s.setAttribute("download",`Sa11y_${t.numericDate+l}.csv`),document.body.appendChild(s),s.click(),setTimeout((()=>{document.body.removeChild(s),window.URL.revokeObjectURL(s.href)}),100)}let O,C;var $='.visually-hidden{clip:rect(1px,1px,1px,1px);border:0;-webkit-clip-path:inset(50%);clip-path:inset(50%);display:block;height:1px;overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:1px}[hidden]{display:none!important}.header-text,.header-text-inline,h2{color:var(--sa11y-panel-primary);display:block;font-size:var(--sa11y-large-text);font-weight:600;margin-bottom:3px}.header-text-inline{display:inline-block!important}code{font-family:monospace!important}.kbd,code,kbd{background-color:var(--sa11y-panel-badge);border-radius:3.2px;color:var(--sa11y-panel-primary);padding:1.6px 4.8px}.bold{font-weight:600}.red-text{color:var(--sa11y-red-text)}.red-text,.yellow-text{font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text)}.yellow-text{color:var(--sa11y-yellow-text)}.close-btn{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:50%;color:var(--sa11y-panel-primary);cursor:pointer;float:var(--sa11y-float-rtl);font-size:var(--sa11y-normal-text);font-weight:400;height:32px;margin:0;position:relative;transition:all .2s ease-in-out;width:32px}.close-btn:focus,.close-btn:hover{background-color:var(--sa11y-shortcut-hover)}.close-btn:after{background:var(--sa11y-setting-switch-bg-off);bottom:-7px;content:"";left:-7px;-webkit-mask:var(--sa11y-close-btn-svg) center no-repeat;mask:var(--sa11y-close-btn-svg) center no-repeat;position:absolute;right:-7px;top:-7px}@media screen and (forced-colors:active){.close-btn:after{filter:invert(1)}}#container [tabindex="-1"]:focus,#container [tabindex="0"]:focus,#container a:focus,#container button:not(#settings-toggle):not(#outline-toggle):not(.switch):focus,#container select:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}#container #outline-toggle:focus,#container #settings-toggle:focus,#container .switch:focus{box-shadow:inset 0 0 0 4px var(--sa11y-focus-color);outline:0}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus,.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] button:active,.tippy-box[data-theme~=sa11y-theme] button:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}#container #outline-toggle:focus:not(:focus-visible),#container #settings-toggle:focus:not(:focus-visible),#container [tabindex="-1"]:focus:not(:focus-visible),#container [tabindex="0"]:focus:not(:focus-visible),#container button:focus:not(:focus-visible),#container select:focus:not(:focus-visible){box-shadow:none;outline:0}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus:not(:focus-visible),.tippy-box[data-theme~=sa11y-theme] a:focus:not(:focus-visible),.tippy-box[data-theme~=sa11y-theme] button:focus:not(:focus-visible){box-shadow:none;outline:0}#container [tabindex="-1"]:focus-visible,#container [tabindex="0"]:focus-visible,#container a:focus-visible,#container button:not(#settings-toggle):not(#outline-toggle):not(.switch):focus-visible,#container select:focus-visible{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}#container #outline-toggle:focus-visible,#container #settings-toggle:focus-visible,#container .switch:focus-visible{box-shadow:inset 0 0 0 4px var(--sa11y-focus-color);outline:0}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus-visible,.tippy-box[data-theme~=sa11y-theme] a:focus-visible,.tippy-box[data-theme~=sa11y-theme] button:focus-visible{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){#outline-toggle:focus,#settings-toggle:focus{border:3px solid transparent}#container [tabindex="-1"]:focus,#container [tabindex="0"]:focus,#container a:focus,#container button:focus,#container select:focus,.close-btn:focus,.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus,.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] button:focus{outline:3px solid transparent!important}}';class N extends HTMLElement{constructor(e){super(),this.error=e}connectedCallback(){const e=this.attachShadow({mode:"open"}),n=document.createElement("style");n.innerHTML=":host{background:var(--sa11y-panel-bg);border-top:5px solid var(--sa11y-panel-bg-splitter);bottom:0;display:block;height:-moz-fit-content;height:fit-content;position:fixed;width:100%;z-index:999999}*{-webkit-font-smoothing:auto!important;color:var(--sa11y-panel-primary);font-family:var(--sa11y-font-face)!important;font-size:var(--sa11y-normal-text);line-height:22px!important}#dialog{margin:20px auto;max-width:900px;padding:20px}h2{font-size:var(--sa11y-large-text);margin-top:0}a{color:var(--sa11y-hyperlink);cursor:pointer;text-decoration:underline}a:focus,a:hover{text-decoration:none}p{margin-top:0}.error{background:var(--sa11y-error);border:2px dashed #f08080;color:var(--sa11y-error-text);margin-bottom:0;padding:5px}"+$,e.appendChild(n);const i=document.createElement("div");i.setAttribute("id","dialog"),i.setAttribute("tabindex","-1");const a=window.location,s=`https://github.com/ryersondmp/sa11y/issues/new?title=Bug%20report&body=%23%23%20Error%20Description%0A%60%60%60javascript%0A${encodeURIComponent(this.error.stack)}%0A%60%60%60%0A%0A%23%23%20URL%0A%60${a}%60%0A%0A%23%23%20Comments%0A`;i.innerHTML=`\n      <button class="close-btn" aria-label="${t._("ALERT_CLOSE")}"></button>\n      <h2>${t._("ERROR")}</h2>\n      <p>${t.sprintf("CONSOLE_ERROR_MESSAGE","https://forms.gle/sjzK9XykETaoqZv99",s)}</p>\n      <p class="error">${r(this.error.stack)}<br><br>URL: ${a}</p>\n    `,e.appendChild(i),setTimeout((()=>{o.Panel.toggle.style.display="none";const e=document.querySelector("sa11y-console-error");e.shadowRoot.getElementById("dialog").focus();e.shadowRoot.querySelector(".close-btn").addEventListener("click",(()=>{e.remove()}))}),0)}}class R extends HTMLElement{connectedCallback(){this.attachShadow({mode:"open"});const e=document.createElement("style");e.textContent='a,button,code,div,h1,h2,kbd,label,li,ol,p,pre,span,strong,svg,ul{all:unset;box-sizing:border-box!important}:after,:before{all:unset}div{display:block}*{-webkit-font-smoothing:auto!important;font-family:var(--sa11y-font-face)!important;line-height:22px!important}label,li,ol,p,ul{font-size:var(--sa11y-normal-text);font-weight:400;letter-spacing:normal;text-align:start;word-break:break-word}.sa11y-overflow{overflow:auto}iframe,img,video{border:0;display:block;height:auto;max-width:100%}audio{max-width:100%}#toggle{align-items:center;background:linear-gradient(0deg,#e040fb,#00bcd4);background-color:var(--sa11y-blue);background-size:150% 150%;border-radius:50%;bottom:15px;color:#fff;cursor:pointer;display:flex;height:55px;inset-inline-end:18px;justify-content:center;margin:0;overflow:visible;position:fixed;transition:all .2s ease-in-out;width:55px;z-index:2147483644}#toggle.left,#toggle.top-left{inset-inline-start:18px}#toggle.top-left,#toggle.top-right{bottom:unset;top:15px}@media screen and (forced-colors:active){#toggle{border:2px solid transparent}}#toggle svg{height:35px;width:35px}#toggle svg path{fill:var(--sa11y-panel-bg)}#toggle:focus,#toggle:hover{animation:sa11y-toggle-gradient 3s ease}#toggle:disabled:focus,#toggle:disabled:hover{animation:none}#toggle.on{background:linear-gradient(180deg,#e040fb,#00bcd4);background-color:var(--sa11y-blue)}#notification-badge{text-wrap:nowrap;align-items:center;background-color:#eb0000;border:1px solid transparent;border-radius:12px;color:#fff;display:none;font-size:13.5px;font-weight:400;height:20px;justify-content:center;min-width:20px;padding:3px;position:absolute;right:-3px;top:-5.5px}#notification-badge.notification-badge-warning{background-color:var(--sa11y-warning-hover);border:1px solid var(--sa11y-warning);color:var(--sa11y-warning-text)}#panel{background:var(--sa11y-panel-bg);border-radius:4px;bottom:25px;box-shadow:0 0 20px 4px rgba(154,161,177,.15),0 4px 80px -8px rgba(36,40,47,.25),0 4px 4px -2px rgba(91,94,105,.15);inset-inline-end:42px;opacity:0;overflow:visible;position:fixed;transform:scale(0);transform-origin:100% 100%;transition:transform .2s,opacity background .2s .2s;visibility:hidden;z-index:2147483643}#panel.left,#panel.top-left{inset-inline-start:42px}#panel.top-left,#panel.top-right{bottom:unset;top:50px}#panel.active{height:auto;opacity:1;transform:scale(1);transform-origin:bottom right;transition:transform .2s,opacity .2s;visibility:visible}@media screen and (forced-colors:active){#panel{border:2px solid transparent}}#panel.active.left,[dir=rtl] #panel.active{transform-origin:bottom left}#panel.active.top-left{transform-origin:top left}#panel.active.top-right{transform-origin:top right}#panel-alert{display:none;opacity:0}#panel-alert.active{display:block;opacity:1}#panel-alert-content{align-items:center;border-bottom:1px solid var(--sa11y-panel-bg-splitter);color:var(--sa11y-panel-primary);max-height:400px;overflow-y:auto;padding:15px 20px 15px 15px;position:relative}#panel-alert-preview .close-tooltip{display:none}#panel-alert-preview,#panel-alert-text{font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);font-weight:400;line-height:22px}.panel-alert-preview{background:var(--sa11y-panel-bg-secondary);border:1px dashed var(--sa11y-panel-bg-splitter);border-radius:5px;margin-top:15px;padding:10px}.element-preview{background-color:var(--sa11y-panel-badge);border-radius:3.2px;margin-bottom:10px;overflow-wrap:break-word;padding:5px}button[data-sa11y-dismiss]{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;display:block;margin:10px 5px 5px 0;padding:4px 8px}button[data-sa11y-dismiss]:focus,button[data-sa11y-dismiss]:hover{background:var(--sa11y-shortcut-hover)}h2{display:block;font-size:var(--sa11y-large-text);margin-bottom:3px}h2,strong{font-weight:600}a:not(#outline-list a){border-bottom:0;color:var(--sa11y-hyperlink);cursor:pointer;text-decoration:underline}a:focus,a:hover{text-decoration:none!important}hr{background:var(--sa11y-panel-bg-splitter);border:none;height:1px;margin:10px 0;opacity:1;padding:0}#dismiss-button,#skip-button{background:var(--sa11y-panel-bg-secondary);border:1px solid var(--sa11y-button-outline);border-radius:50px;cursor:pointer;display:none;height:36px;margin-inline-end:8px;margin-inline-start:2px;overflow:visible;position:relative;text-align:center;transition:all .1s ease-in-out;width:36px}#dismiss-button.active,#skip-button.active{display:block}#dismiss-button:disabled,#skip-button:disabled{background:none;border:0;box-shadow:none;cursor:default}#dismiss-button:before,#skip-button:before{bottom:-5px;content:"";left:-5px;position:absolute;right:-5px;top:-5px}#dismiss-button:focus:not(:disabled),#dismiss-button:hover:not(:disabled),#skip-button:focus:not(:disabled),#skip-button:hover:not(:disabled){background-color:var(--sa11y-shortcut-hover)}#panel.left #dismiss-button,#panel.left #skip-button,#panel.top-left #dismiss-button,#panel.top-left #skip-button{margin-inline-end:2px;margin-inline-start:8px}.dismiss-icon{background:var(--sa11y-setting-switch-bg-off);display:inline-block;height:24px;margin-bottom:-4px;-webkit-mask:var(--sa11y-dismiss-icon) center no-repeat;mask:var(--sa11y-dismiss-icon) center no-repeat;width:24px}@media screen and (forced-colors:active){.dismiss-icon{filter:invert(1)}}#panel-content{align-items:center;color:var(--sa11y-panel-primary);display:flex;padding:6px}#panel-content.errors .panel-icon,#panel-content.good .panel-icon,#panel-content.warnings .panel-icon{height:26px;margin:0 auto;width:26px}#panel-content.errors .panel-icon{background:var(--sa11y-panel-error);margin-top:-2px;-webkit-mask:var(--sa11y-error-svg) center no-repeat;mask:var(--sa11y-error-svg) center no-repeat}#panel-content.good .panel-icon{background:var(--sa11y-good);-webkit-mask:var(--sa11y-good-svg) center no-repeat;mask:var(--sa11y-good-svg) center no-repeat}#panel-content.warnings .panel-icon{background:var(--sa11y-warning-svg-color);-webkit-mask:var(--sa11y-warning-svg) center no-repeat;mask:var(--sa11y-warning-svg) center no-repeat;transform:scaleX(var(--sa11y-icon-direction))}@media screen and (forced-colors:active){#panel-content.errors .panel-icon,#panel-content.good .panel-icon,#panel-content.warnings .panel-icon{filter:invert(1)}}#panel.left #panel-content,#panel.top-left #panel-content{flex-direction:row-reverse}#status{font-size:var(--sa11y-large-text)}#status,.panel-count{color:var(--sa11y-panel-primary)}.panel-count{background-color:var(--sa11y-panel-badge);border-radius:4px;font-size:15px;font-weight:400;margin-left:3px;margin-right:3px;padding:2px 4px}#outline-panel,#page-issues,#settings-panel{color:var(--sa11y-panel-primary);display:none;opacity:0}#outline-panel.active,#page-issues.active,#settings-panel.active{display:block;opacity:1}.panel-header{padding:10px 15px 0;text-align:start}#outline-content,#page-issues-content,#settings-content{border-bottom:1px solid var(--sa11y-panel-bg-splitter);padding:0 15px 10px}#page-issues-content{max-height:160px;overflow-y:auto}#outline-content{max-height:250px;overflow-y:auto}#outline-panel .outline-list-item.sa11y-red-text,#settings-panel .sa11y-red-text{color:var(--sa11y-red-text)}#outline-list{display:block;margin:0;padding:0}#outline-list a{cursor:pointer;display:block;text-decoration:none}#outline-list li{display:block;list-style-type:none;margin-bottom:3px;margin-top:0;padding:0}#outline-list li:first-child{margin-top:5px}#outline-list li a:focus,#outline-list li a:hover{background:var(--sa11y-panel-outline-hover);border-radius:5px;box-shadow:0 0 0 2px var(--sa11y-panel-outline-hover);display:block}#outline-list .outline-2{margin-inline-start:15px}#outline-list .outline-3{margin-inline-start:30px}#outline-list .outline-4{margin-inline-start:45px}#outline-list .outline-5{margin-inline-start:60px}#outline-list .outline-6{margin-inline-start:75px}.badge{background-color:var(--sa11y-panel-badge);border:1px solid transparent;border-radius:10px;color:var(--sa11y-panel-primary);display:inline;font-size:13px;font-weight:700;min-width:10px;padding:2px 5px;text-align:center;white-space:nowrap}.error-badge{background:var(--sa11y-error);color:var(--sa11y-error-text)}.warning-badge{background:var(--sa11y-yellow-text);color:var(--sa11y-panel-bg)}.error-icon{background:var(--sa11y-error-text);-webkit-mask:var(--sa11y-error-svg) center no-repeat;mask:var(--sa11y-error-svg) center no-repeat}.error-icon,.hidden-icon{display:inline-block;height:16px;margin-bottom:-3px;width:16px}.hidden-icon{background:var(--sa11y-panel-primary);-webkit-mask:var(--sa11y-hidden-icon-svg) center no-repeat;mask:var(--sa11y-hidden-icon-svg) center no-repeat}.error-badge .hidden-icon{background:var(--sa11y-error-text)}.warning-badge .hidden-icon{background:var(--sa11y-panel-bg)}@media screen and (forced-colors:active){.hidden-icon{filter:invert(1)}}#panel-controls{border-radius:0 0 4px 4px;display:flex;overflow:hidden}#outline-toggle,#settings-toggle{background:var(--sa11y-panel-bg-secondary);background-color:var(--sa11y-panel-bg-secondary);border-bottom:1px solid var(--sa11y-panel-bg-splitter);border-top:1px solid var(--sa11y-panel-bg-splitter);color:var(--sa11y-panel-secondary);cursor:pointer;display:block;font-size:var(--sa11y-normal-text);font-weight:400;height:30px;line-height:0;margin:0;opacity:1;outline:0;padding:0;position:relative;text-align:center;transition:background .2s;width:100%}#outline-toggle.outline-active,#outline-toggle.settings-active,#outline-toggle:hover,#settings-toggle.outline-active,#settings-toggle.settings-active,#settings-toggle:hover{background-color:var(--sa11y-shortcut-hover)}#outline-toggle.outline-active,#outline-toggle.settings-active,#settings-toggle.outline-active,#settings-toggle.settings-active{font-weight:500}#outline-toggle{border-inline-end:1px solid var(--sa11y-panel-bg-splitter)}#export-results-mode,label{color:var(--sa11y-panel-primary);display:inline-block;font-weight:400;margin:0;width:100%}label:not(#colour-filter-mode,#export-results-mode){cursor:pointer}#settings-panel #export-csv,#settings-panel #export-html{padding:0;text-align:center;width:unset}#settings-panel #export-csv span,#settings-panel #export-html span{background:var(--sa11y-panel-bg-secondary);border-radius:5px;box-shadow:inset 0 0 0 2px var(--sa11y-setting-switch-bg-off);display:block;margin:0 4px;padding:7px 9px;width:65px}#settings-panel #export-csv:focus span,#settings-panel #export-csv:focus-within span,#settings-panel #export-csv:hover span,#settings-panel #export-html:focus span,#settings-panel #export-html:focus-within span,#settings-panel #export-html:hover span{background:var(--sa11y-shortcut-hover)}#settings-panel .switch{background:none;border:0;border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;font-size:var(--sa11y-normal-text);font-weight:400;height:44px;margin:0;padding:7px 10px;position:relative;text-align:end;width:105px}#settings-panel .switch[aria-pressed=false]:after,#settings-panel .switch[aria-pressed=true]:after{content:"";display:inline-block;height:27px;margin:0 4px 4px;vertical-align:middle;width:27px}#settings-panel .switch[aria-pressed=true]:after{background:var(--sa11y-setting-switch-bg-on);-webkit-mask:var(--sa11y-setting-switch-on-svg) center no-repeat;mask:var(--sa11y-setting-switch-on-svg) center no-repeat}#settings-panel .switch[aria-pressed=false]:after{background:var(--sa11y-setting-switch-bg-off);-webkit-mask:var(--sa11y-setting-switch-off-svg) center no-repeat;mask:var(--sa11y-setting-switch-off-svg) center no-repeat}@media screen and (forced-colors:active){#settings-panel .switch[aria-pressed=false]:after,#settings-panel .switch[aria-pressed=true]:after{filter:invert(1)}}#settings-panel #settings-options li{align-items:center;border-bottom:1px solid var(--sa11y-panel-bg-splitter);display:flex;justify-content:space-between;list-style-type:none;padding:1px 0}#settings-panel #settings-options li:last-child{border:none}#page-issues{align-items:center;color:var(--sa11y-panel-primary)}#page-issues-list{display:block;margin-top:4px}#page-issues-list li{display:block;margin:0 0 10px}#page-issues-list strong{display:block}#panel-colour-filters{align-items:center;color:var(--sa11y-panel-primary);display:none;font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);font-weight:400;line-height:22px}#panel-colour-filters.active{display:flex}#panel-colour-filters p{padding:6px 20px 6px 6px;width:100%}#panel-colour-filters[data-colour=protanopia]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(94deg,#786719 11%,#e0c600 36%,#e0c600 47%,#0059e3 75%,#0042aa 91%);border-image:linear-gradient(94deg,#786719 11%,#e0c600 36%,#e0c600 47%,#0059e3 75%,#0042aa 91%);border-image-slice:1}#panel-colour-filters[data-colour=deuteranopia]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(270deg,#567fdb,#a4a28d 48%,#c3ad14 69%,#a79505);border-image:linear-gradient(270deg,#567fdb,#a4a28d 48%,#c3ad14 69%,#a79505);border-image-slice:1}#panel-colour-filters[data-colour=tritanopia]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(270deg,#b1506f,#0696c1 35%,#f3a9ba 70%,#d91c5d 87%,#fe015c);border-image:linear-gradient(270deg,#b1506f,#0696c1 35%,#f3a9ba 70%,#d91c5d 87%,#fe015c);border-image-slice:1}#panel-colour-filters[data-colour=monochromacy]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(270deg,#000,#a7a7a7 50%,#000);border-image:linear-gradient(270deg,#000,#a7a7a7 50%,#000);border-image-slice:1}#panel-colour-filters[data-colour=protanopia] .panel-icon{background:var(--sa11y-panel-error)}#panel-colour-filters[data-colour=deuteranopia] .panel-icon{background:var(--sa11y-good-hover)}#panel-colour-filters[data-colour=tritanopia] .panel-icon{background:var(--sa11y-blue)}#panel-colour-filters[data-colour=monochromacy] .panel-icon{background:linear-gradient(90deg,#38a459 20%,red 50%,#0077c8 80%)}#panel-colour-filters .panel-icon{height:30px;margin-inline-end:5px;margin-inline-start:10px;-webkit-mask:var(--sa11y-low-vision-icon) center no-repeat;mask:var(--sa11y-low-vision-icon) center no-repeat;width:30px}@media screen and (forced-colors:active){#panel-colour-filters .panel-icon{forced-color-adjust:none}}.select-dropdown:after{border-left:5px solid transparent;border-right:5px solid transparent;border-top:5px solid var(--sa11y-setting-switch-bg-off);content:" ";height:0;inset-inline-end:25px;margin-top:22.5px;position:absolute;width:0}#colour-filter-select{-webkit-appearance:none;-moz-appearance:none;appearance:none;background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-setting-switch-bg-off);border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;font-size:var(--sa11y-normal-text);font-weight:400;height:30px;margin-inline-end:4px;padding-inline-end:25px;padding-inline-start:5px;position:relative;text-align:end;vertical-align:middle}#colour-filter-select:focus,#colour-filter-select:hover{background:var(--sa11y-shortcut-hover)}#colour-filter-select.active{box-shadow:0 0 0 2px var(--sa11y-setting-switch-bg-on)}#colour-filter-item label,#colour-filter-item select{margin-bottom:9px;margin-top:10px}#readability-panel{display:none;opacity:0}#readability-panel.active{display:block;opacity:1}#readability-content{border-bottom:1px solid var(--sa11y-panel-bg-splitter);color:var(--sa11y-panel-primary);padding:10px 15px;width:100%}#readability-details{list-style-type:none;margin:0;padding:0;white-space:normal}#readability-details li{display:inline-block;list-style-type:none;margin:0;padding-inline-end:10px}.readability-score{background-color:var(--sa11y-panel-badge);border-radius:4px;color:var(--sa11y-panel-primary);margin-inline-start:5px;padding:2px 5px}#readability-info{margin-inline-start:10px}#skip-to-page-issues{display:none}#panel.has-page-issues #skip-to-page-issues{clip:rect(0,0,0,0);background:var(--sa11y-panel-bg);border:0;border-radius:5px;display:block;height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:1px}#panel.has-page-issues #skip-to-page-issues:focus{clip:auto;height:auto;margin:0;overflow:visible;padding:5px 7px;white-space:normal;width:auto;z-index:1}.hide-settings-border{border-bottom:0!important;padding:0 15px!important}::-webkit-scrollbar{height:6px;width:7px}::-webkit-scrollbar-thumb{background-color:var(--sa11y-button-outline);border-radius:6px}*{scrollbar-color:var(--sa11y-button-outline);scrollbar-width:thin}.scrollable:before{animation:fade 1s ease-in-out;background-image:linear-gradient(180deg,transparent 0,transparent 70%,var(--sa11y-panel-scrollable) 100%);background-position:bottom;bottom:auto;content:"";height:250px;left:0;position:absolute;right:0;top:auto;transition:opacity 1s ease-in-out;z-index:-1}#page-issues-content.scrollable:before{height:160px}#panel-alert.scrollable:before{height:200px}@keyframes sa11y-toggle-gradient{0%{background-position:50% 0}50%{background-position:50% 100%}to{background-position:50% 0}}@keyframes fade{0%{opacity:0}to{opacity:1}}@media (prefers-reduced-motion:reduce){*{animation:none!important;transform:none!important;transition:none!important}}#panel{width:375px}#container:lang(en) #panel{width:305px}#container:lang(da) #panel,#container:lang(de) #panel,#container:lang(nb) #panel,#container:lang(pl) #panel,#container:lang(sv) #panel,#container:lang(zh) #panel{width:335px}#container:lang(es) .switch{width:225px!important}#container:not(:lang(en)):not(:lang(de)) .switch{width:205px}'+$,this.shadowRoot.appendChild(e);const n="On"===g.getItem("sa11y-remember-contrast"),i="On"===g.getItem("sa11y-remember-labels"),a="On"===g.getItem("sa11y-remember-links-advanced"),r="On"===g.getItem("sa11y-remember-readability"),s=o.Global.checkAllHideToggles,{panelPosition:l}=o.Global,d=o.Global.contrastPlugin?`\n      <li id="contrast-item" ${s?"hidden":""}>\n        <label id="check-contrast" for="contrast-toggle">${t._("CONTRAST")}</label>\n        <button id="contrast-toggle"\n          aria-labelledby="check-contrast"\n          class="switch"\n          aria-pressed="${n?"true":"false"}">${n?t._("ON"):t._("OFF")}</button>\n      </li>`:"",c=o.Global.formLabelsPlugin?`\n      <li id="form-labels-item" ${s?"hidden":""}>\n        <label id="check-labels" for="labels-toggle">${t._("FORM_LABELS")}</label>\n        <button id="labels-toggle"\n          aria-labelledby="check-labels"\n          class="switch"\n          aria-pressed="${i?"true":"false"}">${i?t._("ON"):t._("OFF")}</button>\n      </li>`:"",p=o.Global.linksAdvancedPlugin?`\n      <li id="links-advanced-item" ${s?"hidden":""}>\n        <label id="check-changerequest" for="links-advanced-toggle">${t._("LINKS_ADVANCED")} <span class="badge">AAA</span></label>\n        <button id="links-advanced-toggle"\n          aria-labelledby="check-changerequest"\n          class="switch"\n          aria-pressed="${a?"true":"false"}">${a?t._("ON"):t._("OFF")}</button>\n      </li>`:"",u=o.Readability.Plugin?`\n      <li id="readability-item">\n        <label id="check-readability" for="readability-toggle">${t._("LANG_READABILITY")} <span class="badge">AAA</span></label>\n        <button id="readability-toggle"\n          aria-labelledby="check-readability"\n          class="switch"\n          aria-pressed="${r?"true":"false"}">${r?t._("ON"):t._("OFF")}</button>\n      </li>`:"",m=o.Global.colourFilterPlugin?`\n      <li id="colour-filter-item">\n        <label id="colour-filter-mode" for="colour-filter">${t._("COLOUR_FILTER")}</label>\n        <div class="select-dropdown">\n          <select id="colour-filter-select">\n            <option value="0">${t._("OFF")}</option>\n            <option value="1">${t._("PROTANOPIA")}</option>\n            <option value="2">${t._("DEUTERANOPIA")}</option>\n            <option value="3">${t._("TRITANOPIA")}</option>\n            <option value="4">${t._("MONOCHROMACY")}</option>\n          </select>\n        </div>\n      </li>`:"",f=o.Global.colourFilterPlugin?`\n      <div id="panel-colour-filters" role="region" aria-labelledby="colour-filter-mode">\n        <div id="filter-icon" class="panel-icon" role="img"></div>\n        <p>${t._("COLOUR_FILTER_MESSAGE")}</p>\n      </div>`:"",b=o.Global.exportResultsPlugin?`\n      <li id="export-results-item">\n        <span id="export-results-mode">${t._("EXPORT_RESULTS")}</span>\n        <button id="export-csv" class="switch" aria-describedby="export-results-mode">\n          <span>CSV</span>\n        </button>\n        <button id="export-html" class="switch" aria-describedby="export-results-mode">\n          <span>HTML</span>\n        </button>\n      </li>`:"",h=`\n      <button type="button" aria-expanded="false" id="toggle" aria-describedby="notification-badge" aria-label="${t._("MAIN_TOGGLE_LABEL")}" class="${l}" disabled>\n        <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 48c114.953 0 208 93.029 208 208 0 114.953-93.029 208-208 208-114.953 0-208-93.029-208-208 0-114.953 93.029-208 208-208m0-40C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 56C149.961 64 64 149.961 64 256s85.961 192 192 192 192-85.961 192-192S362.039 64 256 64zm0 44c19.882 0 36 16.118 36 36s-16.118 36-36 36-36-16.118-36-36 16.118-36 36-36zm117.741 98.023c-28.712 6.779-55.511 12.748-82.14 15.807.851 101.023 12.306 123.052 25.037 155.621 3.617 9.26-.957 19.698-10.217 23.315-9.261 3.617-19.699-.957-23.316-10.217-8.705-22.308-17.086-40.636-22.261-78.549h-9.686c-5.167 37.851-13.534 56.208-22.262 78.549-3.615 9.255-14.05 13.836-23.315 10.217-9.26-3.617-13.834-14.056-10.217-23.315 12.713-32.541 24.185-54.541 25.037-155.621-26.629-3.058-53.428-9.027-82.141-15.807-8.6-2.031-13.926-10.648-11.895-19.249s10.647-13.926 19.249-11.895c96.686 22.829 124.283 22.783 220.775 0 8.599-2.03 17.218 3.294 19.249 11.895 2.029 8.601-3.297 17.219-11.897 19.249z"/></svg>\n        <div id="notification-badge">\n          <span id="notification-count"></span>\n          <span id="notification-text" class="visually-hidden"></span>\n        </div>\n      </button>`,y=`\n      <div id="page-issues">\n        <div class="panel-header">\n          <h2 id="page-issues-header" tabindex="-1">${t._("PAGE_ISSUES")}</h2>\n        </div>\n        <div id="page-issues-content">\n          <ul id="page-issues-list" role="list" aria-labelledby="page-issues-header"></ul>\n        </div>\n      </div>`,v=`\n      <div id="outline-panel" role="tabpanel" aria-labelledby="outline-header">\n        <div class="panel-header">\n          <h2 id="outline-header" tabindex="-1">${t._("OUTLINE")}</h2>\n        </div>\n        <div id="outline-content">\n          <ul\n            id="outline-list"\n            tabindex="0"\n            role="list"\n            aria-labelledby="outline-header"></ul>\n        </div>\n        <div id="readability-panel">\n          <div id="readability-content">\n            <h2 class="header-text-inline">${t._("LANG_READABILITY")}</h2>\n            <p id="readability-info"></p>\n            <ul id="readability-details"></ul>\n          </div>\n        </div>\n      </div>`,x=`\n      <div id="settings-panel" role="tabpanel" aria-labelledby="settings-header">\n        <div class="panel-header">\n          <h2 id="settings-header" tabindex="-1">${t._("SETTINGS")}</h2>\n        </div>\n        <div id="settings-content">\n          <ul id="settings-options">\n            ${d}\n            ${c}\n            ${p}\n            ${u}\n            <li id="dark-mode-item">\n              <label id="dark-mode" for="theme-toggle">${t._("DARK_MODE")}</label>\n              <button id="theme-toggle"\n                aria-labelledby="dark-mode"\n                class="switch"></button>\n            </li>\n            ${b}\n            ${m}\n          </ul>\n        </div>\n      </div>`,w=`\n      <div\n        id="panel-alert"\n        role="alertdialog"\n        aria-labelledby="alert-heading"\n        aria-describedby="panel-alert-text">\n        <div id="panel-alert-content">\n          <div class="header-text">\n            <button id="close-alert" class="close-btn" aria-label="${t._("ALERT_CLOSE")}"></button>\n            <h2 id="alert-heading">${t._("ALERT_TEXT")}</h2>\n          </div>\n          <p id="panel-alert-text"></p>\n          <div id="panel-alert-preview"></div>\n        </div>\n      </div>`,A=`\n      <div id="panel-content">\n        <button id="skip-to-page-issues" type="button">\n          ${t._("SKIP_TO_PAGE_ISSUES")}\n        </button>\n        <button id="skip-button" type="button">\n          <div class="panel-icon"></div>\n          <span class="visually-hidden">${t._("SHORTCUT_SCREEN_READER")}</span>\n        </button>\n        <button id="dismiss-button" type="button">\n          <div class="dismiss-icon"></div>\n          <span id="dismiss-tooltip" class="visually-hidden"></span>\n        </button>\n        <div id="panel-text">\n          <h1 class="visually-hidden">${t._("PANEL_HEADING")}</h1>\n          <p id="status" aria-live="polite"></p>\n        </div>\n      </div>`,E=`\n      <div id="panel-controls" role="tablist" aria-orientation="horizontal">\n        ${"left"===l?'<div style="width:40px"></div>':""}\n        <button type="button" role="tab" aria-expanded="false" id="outline-toggle" aria-controls="outline-panel">${t._("OUTLINE")}</button>\n        <button type="button" role="tab" aria-expanded="false" id="settings-toggle" aria-controls="settings-panel">${t._("SETTINGS")}</button>\n        ${"right"===l?'<div style="width:40px"></div>':""}\n      </div>`,L=document.createElement("div");L.setAttribute("id","container"),L.setAttribute("role","region"),L.setAttribute("lang",t._("LANG_CODE")),L.setAttribute("aria-label",t._("CONTAINER_LABEL")),L.setAttribute("dir",o.Global.langDirection),L.innerHTML="top-left"===l||"top-right"===l?`\n        ${h}\n        <div id="panel" class="${l}">\n          ${A}\n          ${f}\n          ${E}\n          ${v}\n          ${x}\n          ${w}\n          ${y}\n        </div>`:`\n        ${h}\n        <div id="panel" class="${l}">\n          ${y}\n          ${v}\n          ${x}\n          ${w}\n          ${f}\n          ${A}\n          ${E}\n        </div>`,this.shadowRoot.appendChild(L),o.initializePanelSelectors()}}function D(e,n,a){const r=[];return e.map((e=>{const t=n.find((t=>e.key.includes(t.dismiss)&&e.href===window.location.pathname));return void 0===t?"":t})).forEach((e=>{Object.assign(e,{dismissedHeading:!0})})),n.forEach((e=>{const n=e.element,i=e.headingLevel,s=e.text,l=e.index,d=e.type,c=e.hidden,p=e.visibleParent,u=e.dismissedHeading,{isWithinRoot:m}=e;if(!(o.Exclusions.Outline?Array.from(document.querySelectorAll(o.Exclusions.Outline)):[]).includes(n)){const e=!0===c?'<span class="hidden-icon"></span><span class="visually-hidden">Hidden</span>':"",o=!0===c?'class="hidden-h"':"",f=!0===a||1===a?"H":"";let b;"error"===d&&!0===m?(b=`\n        <li class="outline-${i}">\n          <a role="button" id="sa11y-link-${l}" tabindex="-1" ${o}>\n            <span class="badge error-badge">\n            <span aria-hidden="true">${e}\n              <span class="error-icon"></span>\n            </span>\n            <span class="visually-hidden">${t._("ERROR")}</span> ${f+i}</span>\n            <strong class="outline-list-item red-text">${s}</strong>\n          </a>\n        </li>`,r.push(b)):"warning"!==d||u||!0!==m?(b=`\n        <li class="outline-${i}">\n          <a role="button" id="sa11y-link-${l}" tabindex="-1" ${o}>\n            <span class="badge">${e} ${f+i}</span>\n            <span class="outline-list-item">${s}</span>\n          </a>\n        </li>`,r.push(b)):(b=`\n        <li class="outline-${i}">\n          <a role="button" id="sa11y-link-${l}" tabindex="-1" ${o}>\n            <span class="badge warning-badge">\n            <span aria-hidden="true">${e} &#x3f;</span>\n            <span class="visually-hidden">${t._("WARNING")}</span> ${f+i}</span>\n            <strong class="outline-list-item yellow-text">${s}</strong>\n          </a>\n        </li>`,r.push(b));const h=document.createElement("sa11y-heading-label"),y=document.createElement("sa11y-heading-anchor");if(h.hidden=!0,null!==p){n.insertAdjacentElement("beforeend",h);const e=p.previousElementSibling;y.setAttribute("id",`sa11y-h${l}`),e?(e.insertAdjacentElement("beforebegin",y),e.setAttribute("data-sa11y-parent",`h${l}`)):(p.parentNode.insertAdjacentElement("beforebegin",y),p.parentNode.setAttribute("data-sa11y-parent",`h${l}`))}else n.insertAdjacentElement("beforeend",h),h.insertAdjacentElement("beforebegin",y),y.setAttribute("id",`sa11y-h${l}`);const v=document.createElement("span");v.classList.add("heading-label"),v.innerHTML=`H${i}`,h.shadowRoot.appendChild(v),"Opened"===g.getItem("sa11y-remember-outline")&&(h.hidden=!1)}})),o.Panel.outlineList.innerHTML=0===r.length?`<li>${t._("PANEL_NO_HEADINGS")}</li>`:r.join(" "),setTimeout((()=>{const e=document.querySelector("sa11y-control-panel").shadowRoot,n=Array.from(e.querySelectorAll("#outline-list a"));n.forEach(((n,a)=>{const r=e.getElementById(`sa11y-link-${a}`),s=i(`#sa11y-h${a}, [data-sa11y-parent="h${a}"]`,"document",o.Exclusions.Container),l=e=>{("keyup"===e.type&&"Enter"===e.code||"click"===e.type)&&(s.forEach((e=>{(e=>{m(e.parentElement),e.scrollIntoView({behavior:`${o.Global.scrollBehaviour}`,block:"center"})})(e)})),r.classList.contains("hidden-h")?h(`${t._("HEADING_NOT_VISIBLE_ALERT")}`):o.Panel.alert.classList.contains("active")&&b()),e.preventDefault()};r?.addEventListener("click",l,!1),r?.addEventListener("keyup",l,!1)}));let a=0;const r=e=>{if(!["ArrowUp","ArrowDown","Space"].includes(e.code))return;if("Space"===e.code)return void n[a].click();let t;n[a].setAttribute("tabindex",-1),"ArrowDown"===e.code?(t=a+1,a===n.length-1&&(t=0)):"ArrowUp"===e.code&&(t=a-1,0===a&&(t=n.length-1)),n[t].setAttribute("tabindex",0),n[t].focus(),a=t,e.preventDefault()};o.Panel.outlineList.addEventListener("focus",(()=>{n.length>0&&(o.Panel.outlineList.setAttribute("tabindex",-1),n[a].setAttribute("tabindex",0),n[a].focus()),o.Panel.outlineList.addEventListener("keydown",r)})),o.Panel.outlineList.addEventListener("blur",(()=>{o.Panel.outlineList.removeEventListener("keydown",r)}))}),0),e}var M="top",G="bottom",B="right",H="left",F="auto",U=[M,G,B,H],z="start",j="end",q="clippingParents",W="viewport",V="popper",Q="reference",K=U.reduce((function(e,t){return e.concat([t+"-"+z,t+"-"+j])}),[]),Y=[].concat(U,[F]).reduce((function(e,t){return e.concat([t,t+"-"+z,t+"-"+j])}),[]),X=["beforeRead","read","afterRead","beforeMain","main","afterMain","beforeWrite","write","afterWrite"];function Z(e){return e?(e.nodeName||"").toLowerCase():null}function J(e){if(null==e)return window;if("[object Window]"!==e.toString()){var t=e.ownerDocument;return t&&t.defaultView||window}return e}function ee(e){return e instanceof J(e).Element||e instanceof Element}function te(e){return e instanceof J(e).HTMLElement||e instanceof HTMLElement}function ne(e){return"undefined"!=typeof ShadowRoot&&(e instanceof J(e).ShadowRoot||e instanceof ShadowRoot)}var oe={name:"applyStyles",enabled:!0,phase:"write",fn:function(e){var t=e.state;Object.keys(t.elements).forEach((function(e){var n=t.styles[e]||{},o=t.attributes[e]||{},i=t.elements[e];te(i)&&Z(i)&&(Object.assign(i.style,n),Object.keys(o).forEach((function(e){var t=o[e];!1===t?i.removeAttribute(e):i.setAttribute(e,!0===t?"":t)})))}))},effect:function(e){var t=e.state,n={popper:{position:t.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};return Object.assign(t.elements.popper.style,n.popper),t.styles=n,t.elements.arrow&&Object.assign(t.elements.arrow.style,n.arrow),function(){Object.keys(t.elements).forEach((function(e){var o=t.elements[e],i=t.attributes[e]||{},a=Object.keys(t.styles.hasOwnProperty(e)?t.styles[e]:n[e]).reduce((function(e,t){return e[t]="",e}),{});te(o)&&Z(o)&&(Object.assign(o.style,a),Object.keys(i).forEach((function(e){o.removeAttribute(e)})))}))}},requires:["computeStyles"]};function ie(e){return e.split("-")[0]}var ae=Math.max,re=Math.min,se=Math.round;function le(){var e=navigator.userAgentData;return null!=e&&e.brands&&Array.isArray(e.brands)?e.brands.map((function(e){return e.brand+"/"+e.version})).join(" "):navigator.userAgent}function de(){return!/^((?!chrome|android).)*safari/i.test(le())}function ce(e,t,n){void 0===t&&(t=!1),void 0===n&&(n=!1);var o=e.getBoundingClientRect(),i=1,a=1;t&&te(e)&&(i=e.offsetWidth>0&&se(o.width)/e.offsetWidth||1,a=e.offsetHeight>0&&se(o.height)/e.offsetHeight||1);var r=(ee(e)?J(e):window).visualViewport,s=!de()&&n,l=(o.left+(s&&r?r.offsetLeft:0))/i,d=(o.top+(s&&r?r.offsetTop:0))/a,c=o.width/i,p=o.height/a;return{width:c,height:p,top:d,right:l+c,bottom:d+p,left:l,x:l,y:d}}function pe(e){var t=ce(e),n=e.offsetWidth,o=e.offsetHeight;return Math.abs(t.width-n)<=1&&(n=t.width),Math.abs(t.height-o)<=1&&(o=t.height),{x:e.offsetLeft,y:e.offsetTop,width:n,height:o}}function ue(e,t){var n=t.getRootNode&&t.getRootNode();if(e.contains(t))return!0;if(n&&ne(n)){var o=t;do{if(o&&e.isSameNode(o))return!0;o=o.parentNode||o.host}while(o)}return!1}function ge(e){return J(e).getComputedStyle(e)}function me(e){return["table","td","th"].indexOf(Z(e))>=0}function fe(e){return((ee(e)?e.ownerDocument:e.document)||window.document).documentElement}function be(e){return"html"===Z(e)?e:e.assignedSlot||e.parentNode||(ne(e)?e.host:null)||fe(e)}function he(e){return te(e)&&"fixed"!==ge(e).position?e.offsetParent:null}function ye(e){for(var t=J(e),n=he(e);n&&me(n)&&"static"===ge(n).position;)n=he(n);return n&&("html"===Z(n)||"body"===Z(n)&&"static"===ge(n).position)?t:n||function(e){var t=/firefox/i.test(le());if(/Trident/i.test(le())&&te(e)&&"fixed"===ge(e).position)return null;var n=be(e);for(ne(n)&&(n=n.host);te(n)&&["html","body"].indexOf(Z(n))<0;){var o=ge(n);if("none"!==o.transform||"none"!==o.perspective||"paint"===o.contain||-1!==["transform","perspective"].indexOf(o.willChange)||t&&"filter"===o.willChange||t&&o.filter&&"none"!==o.filter)return n;n=n.parentNode}return null}(e)||t}function ve(e){return["top","bottom"].indexOf(e)>=0?"x":"y"}function xe(e,t,n){return ae(e,re(t,n))}function we(e){return Object.assign({},{top:0,right:0,bottom:0,left:0},e)}function Ae(e,t){return t.reduce((function(t,n){return t[n]=e,t}),{})}var Ee={name:"arrow",enabled:!0,phase:"main",fn:function(e){var t,n=e.state,o=e.name,i=e.options,a=n.elements.arrow,r=n.modifiersData.popperOffsets,s=ie(n.placement),l=ve(s),d=[H,B].indexOf(s)>=0?"height":"width";if(a&&r){var c=function(e,t){return we("number"!=typeof(e="function"==typeof e?e(Object.assign({},t.rects,{placement:t.placement})):e)?e:Ae(e,U))}(i.padding,n),p=pe(a),u="y"===l?M:H,g="y"===l?G:B,m=n.rects.reference[d]+n.rects.reference[l]-r[l]-n.rects.popper[d],f=r[l]-n.rects.reference[l],b=ye(a),h=b?"y"===l?b.clientHeight||0:b.clientWidth||0:0,y=m/2-f/2,v=c[u],x=h-p[d]-c[g],w=h/2-p[d]/2+y,A=xe(v,w,x),E=l;n.modifiersData[o]=((t={})[E]=A,t.centerOffset=A-w,t)}},effect:function(e){var t=e.state,n=e.options.element,o=void 0===n?"[data-popper-arrow]":n;null!=o&&("string"!=typeof o||(o=t.elements.popper.querySelector(o)))&&ue(t.elements.popper,o)&&(t.elements.arrow=o)},requires:["popperOffsets"],requiresIfExists:["preventOverflow"]};function Le(e){return e.split("-")[1]}var ke={top:"auto",right:"auto",bottom:"auto",left:"auto"};function Ie(e){var t,n=e.popper,o=e.popperRect,i=e.placement,a=e.variation,r=e.offsets,s=e.position,l=e.gpuAcceleration,d=e.adaptive,c=e.roundOffsets,p=e.isFixed,u=r.x,g=void 0===u?0:u,m=r.y,f=void 0===m?0:m,b="function"==typeof c?c({x:g,y:f}):{x:g,y:f};g=b.x,f=b.y;var h=r.hasOwnProperty("x"),y=r.hasOwnProperty("y"),v=H,x=M,w=window;if(d){var A=ye(n),E="clientHeight",L="clientWidth";if(A===J(n)&&"static"!==ge(A=fe(n)).position&&"absolute"===s&&(E="scrollHeight",L="scrollWidth"),i===M||(i===H||i===B)&&a===j)x=G,f-=(p&&A===w&&w.visualViewport?w.visualViewport.height:A[E])-o.height,f*=l?1:-1;if(i===H||(i===M||i===G)&&a===j)v=B,g-=(p&&A===w&&w.visualViewport?w.visualViewport.width:A[L])-o.width,g*=l?1:-1}var k,I=Object.assign({position:s},d&&ke),T=!0===c?function(e,t){var n=e.x,o=e.y,i=t.devicePixelRatio||1;return{x:se(n*i)/i||0,y:se(o*i)/i||0}}({x:g,y:f},J(n)):{x:g,y:f};return g=T.x,f=T.y,l?Object.assign({},I,((k={})[x]=y?"0":"",k[v]=h?"0":"",k.transform=(w.devicePixelRatio||1)<=1?"translate("+g+"px, "+f+"px)":"translate3d("+g+"px, "+f+"px, 0)",k)):Object.assign({},I,((t={})[x]=y?f+"px":"",t[v]=h?g+"px":"",t.transform="",t))}var Te={passive:!0};var _e={left:"right",right:"left",bottom:"top",top:"bottom"};function Se(e){return e.replace(/left|right|bottom|top/g,(function(e){return _e[e]}))}var Pe={start:"end",end:"start"};function Oe(e){return e.replace(/start|end/g,(function(e){return Pe[e]}))}function Ce(e){var t=J(e);return{scrollLeft:t.pageXOffset,scrollTop:t.pageYOffset}}function $e(e){return ce(fe(e)).left+Ce(e).scrollLeft}function Ne(e){var t=ge(e),n=t.overflow,o=t.overflowX,i=t.overflowY;return/auto|scroll|overlay|hidden/.test(n+i+o)}function Re(e){return["html","body","#document"].indexOf(Z(e))>=0?e.ownerDocument.body:te(e)&&Ne(e)?e:Re(be(e))}function De(e,t){var n;void 0===t&&(t=[]);var o=Re(e),i=o===(null==(n=e.ownerDocument)?void 0:n.body),a=J(o),r=i?[a].concat(a.visualViewport||[],Ne(o)?o:[]):o,s=t.concat(r);return i?s:s.concat(De(be(r)))}function Me(e){return Object.assign({},e,{left:e.x,top:e.y,right:e.x+e.width,bottom:e.y+e.height})}function Ge(e,t,n){return t===W?Me(function(e,t){var n=J(e),o=fe(e),i=n.visualViewport,a=o.clientWidth,r=o.clientHeight,s=0,l=0;if(i){a=i.width,r=i.height;var d=de();(d||!d&&"fixed"===t)&&(s=i.offsetLeft,l=i.offsetTop)}return{width:a,height:r,x:s+$e(e),y:l}}(e,n)):ee(t)?function(e,t){var n=ce(e,!1,"fixed"===t);return n.top=n.top+e.clientTop,n.left=n.left+e.clientLeft,n.bottom=n.top+e.clientHeight,n.right=n.left+e.clientWidth,n.width=e.clientWidth,n.height=e.clientHeight,n.x=n.left,n.y=n.top,n}(t,n):Me(function(e){var t,n=fe(e),o=Ce(e),i=null==(t=e.ownerDocument)?void 0:t.body,a=ae(n.scrollWidth,n.clientWidth,i?i.scrollWidth:0,i?i.clientWidth:0),r=ae(n.scrollHeight,n.clientHeight,i?i.scrollHeight:0,i?i.clientHeight:0),s=-o.scrollLeft+$e(e),l=-o.scrollTop;return"rtl"===ge(i||n).direction&&(s+=ae(n.clientWidth,i?i.clientWidth:0)-a),{width:a,height:r,x:s,y:l}}(fe(e)))}function Be(e,t,n,o){var i="clippingParents"===t?function(e){var t=De(be(e)),n=["absolute","fixed"].indexOf(ge(e).position)>=0&&te(e)?ye(e):e;return ee(n)?t.filter((function(e){return ee(e)&&ue(e,n)&&"body"!==Z(e)})):[]}(e):[].concat(t),a=[].concat(i,[n]),r=a[0],s=a.reduce((function(t,n){var i=Ge(e,n,o);return t.top=ae(i.top,t.top),t.right=re(i.right,t.right),t.bottom=re(i.bottom,t.bottom),t.left=ae(i.left,t.left),t}),Ge(e,r,o));return s.width=s.right-s.left,s.height=s.bottom-s.top,s.x=s.left,s.y=s.top,s}function He(e){var t,n=e.reference,o=e.element,i=e.placement,a=i?ie(i):null,r=i?Le(i):null,s=n.x+n.width/2-o.width/2,l=n.y+n.height/2-o.height/2;switch(a){case M:t={x:s,y:n.y-o.height};break;case G:t={x:s,y:n.y+n.height};break;case B:t={x:n.x+n.width,y:l};break;case H:t={x:n.x-o.width,y:l};break;default:t={x:n.x,y:n.y}}var d=a?ve(a):null;if(null!=d){var c="y"===d?"height":"width";switch(r){case z:t[d]=t[d]-(n[c]/2-o[c]/2);break;case j:t[d]=t[d]+(n[c]/2-o[c]/2)}}return t}function Fe(e,t){void 0===t&&(t={});var n=t,o=n.placement,i=void 0===o?e.placement:o,a=n.strategy,r=void 0===a?e.strategy:a,s=n.boundary,l=void 0===s?q:s,d=n.rootBoundary,c=void 0===d?W:d,p=n.elementContext,u=void 0===p?V:p,g=n.altBoundary,m=void 0!==g&&g,f=n.padding,b=void 0===f?0:f,h=we("number"!=typeof b?b:Ae(b,U)),y=u===V?Q:V,v=e.rects.popper,x=e.elements[m?y:u],w=Be(ee(x)?x:x.contextElement||fe(e.elements.popper),l,c,r),A=ce(e.elements.reference),E=He({reference:A,element:v,strategy:"absolute",placement:i}),L=Me(Object.assign({},v,E)),k=u===V?L:A,I={top:w.top-k.top+h.top,bottom:k.bottom-w.bottom+h.bottom,left:w.left-k.left+h.left,right:k.right-w.right+h.right},T=e.modifiersData.offset;if(u===V&&T){var _=T[i];Object.keys(I).forEach((function(e){var t=[B,G].indexOf(e)>=0?1:-1,n=[M,G].indexOf(e)>=0?"y":"x";I[e]+=_[n]*t}))}return I}function Ue(e,t){void 0===t&&(t={});var n=t,o=n.placement,i=n.boundary,a=n.rootBoundary,r=n.padding,s=n.flipVariations,l=n.allowedAutoPlacements,d=void 0===l?Y:l,c=Le(o),p=c?s?K:K.filter((function(e){return Le(e)===c})):U,u=p.filter((function(e){return d.indexOf(e)>=0}));0===u.length&&(u=p);var g=u.reduce((function(t,n){return t[n]=Fe(e,{placement:n,boundary:i,rootBoundary:a,padding:r})[ie(n)],t}),{});return Object.keys(g).sort((function(e,t){return g[e]-g[t]}))}var ze={name:"flip",enabled:!0,phase:"main",fn:function(e){var t=e.state,n=e.options,o=e.name;if(!t.modifiersData[o]._skip){for(var i=n.mainAxis,a=void 0===i||i,r=n.altAxis,s=void 0===r||r,l=n.fallbackPlacements,d=n.padding,c=n.boundary,p=n.rootBoundary,u=n.altBoundary,g=n.flipVariations,m=void 0===g||g,f=n.allowedAutoPlacements,b=t.options.placement,h=ie(b),y=l||(h===b||!m?[Se(b)]:function(e){if(ie(e)===F)return[];var t=Se(e);return[Oe(e),t,Oe(t)]}(b)),v=[b].concat(y).reduce((function(e,n){return e.concat(ie(n)===F?Ue(t,{placement:n,boundary:c,rootBoundary:p,padding:d,flipVariations:m,allowedAutoPlacements:f}):n)}),[]),x=t.rects.reference,w=t.rects.popper,A=new Map,E=!0,L=v[0],k=0;k<v.length;k++){var I=v[k],T=ie(I),_=Le(I)===z,S=[M,G].indexOf(T)>=0,P=S?"width":"height",O=Fe(t,{placement:I,boundary:c,rootBoundary:p,altBoundary:u,padding:d}),C=S?_?B:H:_?G:M;x[P]>w[P]&&(C=Se(C));var $=Se(C),N=[];if(a&&N.push(O[T]<=0),s&&N.push(O[C]<=0,O[$]<=0),N.every((function(e){return e}))){L=I,E=!1;break}A.set(I,N)}if(E)for(var R=function(e){var t=v.find((function(t){var n=A.get(t);if(n)return n.slice(0,e).every((function(e){return e}))}));if(t)return L=t,"break"},D=m?3:1;D>0;D--){if("break"===R(D))break}t.placement!==L&&(t.modifiersData[o]._skip=!0,t.placement=L,t.reset=!0)}},requiresIfExists:["offset"],data:{_skip:!1}};function je(e,t,n){return void 0===n&&(n={x:0,y:0}),{top:e.top-t.height-n.y,right:e.right-t.width+n.x,bottom:e.bottom-t.height+n.y,left:e.left-t.width-n.x}}function qe(e){return[M,B,G,H].some((function(t){return e[t]>=0}))}var We={name:"offset",enabled:!0,phase:"main",requires:["popperOffsets"],fn:function(e){var t=e.state,n=e.options,o=e.name,i=n.offset,a=void 0===i?[0,0]:i,r=Y.reduce((function(e,n){return e[n]=function(e,t,n){var o=ie(e),i=[H,M].indexOf(o)>=0?-1:1,a="function"==typeof n?n(Object.assign({},t,{placement:e})):n,r=a[0],s=a[1];return r=r||0,s=(s||0)*i,[H,B].indexOf(o)>=0?{x:s,y:r}:{x:r,y:s}}(n,t.rects,a),e}),{}),s=r[t.placement],l=s.x,d=s.y;null!=t.modifiersData.popperOffsets&&(t.modifiersData.popperOffsets.x+=l,t.modifiersData.popperOffsets.y+=d),t.modifiersData[o]=r}};var Ve={name:"preventOverflow",enabled:!0,phase:"main",fn:function(e){var t=e.state,n=e.options,o=e.name,i=n.mainAxis,a=void 0===i||i,r=n.altAxis,s=void 0!==r&&r,l=n.boundary,d=n.rootBoundary,c=n.altBoundary,p=n.padding,u=n.tether,g=void 0===u||u,m=n.tetherOffset,f=void 0===m?0:m,b=Fe(t,{boundary:l,rootBoundary:d,padding:p,altBoundary:c}),h=ie(t.placement),y=Le(t.placement),v=!y,x=ve(h),w="x"===x?"y":"x",A=t.modifiersData.popperOffsets,E=t.rects.reference,L=t.rects.popper,k="function"==typeof f?f(Object.assign({},t.rects,{placement:t.placement})):f,I="number"==typeof k?{mainAxis:k,altAxis:k}:Object.assign({mainAxis:0,altAxis:0},k),T=t.modifiersData.offset?t.modifiersData.offset[t.placement]:null,_={x:0,y:0};if(A){if(a){var S,P="y"===x?M:H,O="y"===x?G:B,C="y"===x?"height":"width",$=A[x],N=$+b[P],R=$-b[O],D=g?-L[C]/2:0,F=y===z?E[C]:L[C],U=y===z?-L[C]:-E[C],j=t.elements.arrow,q=g&&j?pe(j):{width:0,height:0},W=t.modifiersData["arrow#persistent"]?t.modifiersData["arrow#persistent"].padding:{top:0,right:0,bottom:0,left:0},V=W[P],Q=W[O],K=xe(0,E[C],q[C]),Y=v?E[C]/2-D-K-V-I.mainAxis:F-K-V-I.mainAxis,X=v?-E[C]/2+D+K+Q+I.mainAxis:U+K+Q+I.mainAxis,Z=t.elements.arrow&&ye(t.elements.arrow),J=Z?"y"===x?Z.clientTop||0:Z.clientLeft||0:0,ee=null!=(S=null==T?void 0:T[x])?S:0,te=$+X-ee,ne=xe(g?re(N,$+Y-ee-J):N,$,g?ae(R,te):R);A[x]=ne,_[x]=ne-$}if(s){var oe,se="x"===x?M:H,le="x"===x?G:B,de=A[w],ce="y"===w?"height":"width",ue=de+b[se],ge=de-b[le],me=-1!==[M,H].indexOf(h),fe=null!=(oe=null==T?void 0:T[w])?oe:0,be=me?ue:de-E[ce]-L[ce]-fe+I.altAxis,he=me?de+E[ce]+L[ce]-fe-I.altAxis:ge,we=g&&me?function(e,t,n){var o=xe(e,t,n);return o>n?n:o}(be,de,he):xe(g?be:ue,de,g?he:ge);A[w]=we,_[w]=we-de}t.modifiersData[o]=_}},requiresIfExists:["offset"]};function Qe(e,t,n){void 0===n&&(n=!1);var o,i,a=te(t),r=te(t)&&function(e){var t=e.getBoundingClientRect(),n=se(t.width)/e.offsetWidth||1,o=se(t.height)/e.offsetHeight||1;return 1!==n||1!==o}(t),s=fe(t),l=ce(e,r,n),d={scrollLeft:0,scrollTop:0},c={x:0,y:0};return(a||!a&&!n)&&(("body"!==Z(t)||Ne(s))&&(d=(o=t)!==J(o)&&te(o)?{scrollLeft:(i=o).scrollLeft,scrollTop:i.scrollTop}:Ce(o)),te(t)?((c=ce(t,!0)).x+=t.clientLeft,c.y+=t.clientTop):s&&(c.x=$e(s))),{x:l.left+d.scrollLeft-c.x,y:l.top+d.scrollTop-c.y,width:l.width,height:l.height}}function Ke(e){var t=new Map,n=new Set,o=[];function i(e){n.add(e.name),[].concat(e.requires||[],e.requiresIfExists||[]).forEach((function(e){if(!n.has(e)){var o=t.get(e);o&&i(o)}})),o.push(e)}return e.forEach((function(e){t.set(e.name,e)})),e.forEach((function(e){n.has(e.name)||i(e)})),o}var Ye={placement:"bottom",modifiers:[],strategy:"absolute"};function Xe(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return!t.some((function(e){return!(e&&"function"==typeof e.getBoundingClientRect)}))}function Ze(e){void 0===e&&(e={});var t=e,n=t.defaultModifiers,o=void 0===n?[]:n,i=t.defaultOptions,a=void 0===i?Ye:i;return function(e,t,n){void 0===n&&(n=a);var i,r,s={placement:"bottom",orderedModifiers:[],options:Object.assign({},Ye,a),modifiersData:{},elements:{reference:e,popper:t},attributes:{},styles:{}},l=[],d=!1,c={state:s,setOptions:function(n){var i="function"==typeof n?n(s.options):n;p(),s.options=Object.assign({},a,s.options,i),s.scrollParents={reference:ee(e)?De(e):e.contextElement?De(e.contextElement):[],popper:De(t)};var r,d,u=function(e){var t=Ke(e);return X.reduce((function(e,n){return e.concat(t.filter((function(e){return e.phase===n})))}),[])}((r=[].concat(o,s.options.modifiers),d=r.reduce((function(e,t){var n=e[t.name];return e[t.name]=n?Object.assign({},n,t,{options:Object.assign({},n.options,t.options),data:Object.assign({},n.data,t.data)}):t,e}),{}),Object.keys(d).map((function(e){return d[e]}))));return s.orderedModifiers=u.filter((function(e){return e.enabled})),s.orderedModifiers.forEach((function(e){var t=e.name,n=e.options,o=void 0===n?{}:n,i=e.effect;if("function"==typeof i){var a=i({state:s,name:t,instance:c,options:o}),r=function(){};l.push(a||r)}})),c.update()},forceUpdate:function(){if(!d){var e=s.elements,t=e.reference,n=e.popper;if(Xe(t,n)){s.rects={reference:Qe(t,ye(n),"fixed"===s.options.strategy),popper:pe(n)},s.reset=!1,s.placement=s.options.placement,s.orderedModifiers.forEach((function(e){return s.modifiersData[e.name]=Object.assign({},e.data)}));for(var o=0;o<s.orderedModifiers.length;o++)if(!0!==s.reset){var i=s.orderedModifiers[o],a=i.fn,r=i.options,l=void 0===r?{}:r,p=i.name;"function"==typeof a&&(s=a({state:s,options:l,name:p,instance:c})||s)}else s.reset=!1,o=-1}}},update:(i=function(){return new Promise((function(e){c.forceUpdate(),e(s)}))},function(){return r||(r=new Promise((function(e){Promise.resolve().then((function(){r=void 0,e(i())}))}))),r}),destroy:function(){p(),d=!0}};if(!Xe(e,t))return c;function p(){l.forEach((function(e){return e()})),l=[]}return c.setOptions(n).then((function(e){!d&&n.onFirstUpdate&&n.onFirstUpdate(e)})),c}}var Je=Ze({defaultModifiers:[{name:"eventListeners",enabled:!0,phase:"write",fn:function(){},effect:function(e){var t=e.state,n=e.instance,o=e.options,i=o.scroll,a=void 0===i||i,r=o.resize,s=void 0===r||r,l=J(t.elements.popper),d=[].concat(t.scrollParents.reference,t.scrollParents.popper);return a&&d.forEach((function(e){e.addEventListener("scroll",n.update,Te)})),s&&l.addEventListener("resize",n.update,Te),function(){a&&d.forEach((function(e){e.removeEventListener("scroll",n.update,Te)})),s&&l.removeEventListener("resize",n.update,Te)}},data:{}},{name:"popperOffsets",enabled:!0,phase:"read",fn:function(e){var t=e.state,n=e.name;t.modifiersData[n]=He({reference:t.rects.reference,element:t.rects.popper,strategy:"absolute",placement:t.placement})},data:{}},{name:"computeStyles",enabled:!0,phase:"beforeWrite",fn:function(e){var t=e.state,n=e.options,o=n.gpuAcceleration,i=void 0===o||o,a=n.adaptive,r=void 0===a||a,s=n.roundOffsets,l=void 0===s||s,d={placement:ie(t.placement),variation:Le(t.placement),popper:t.elements.popper,popperRect:t.rects.popper,gpuAcceleration:i,isFixed:"fixed"===t.options.strategy};null!=t.modifiersData.popperOffsets&&(t.styles.popper=Object.assign({},t.styles.popper,Ie(Object.assign({},d,{offsets:t.modifiersData.popperOffsets,position:t.options.strategy,adaptive:r,roundOffsets:l})))),null!=t.modifiersData.arrow&&(t.styles.arrow=Object.assign({},t.styles.arrow,Ie(Object.assign({},d,{offsets:t.modifiersData.arrow,position:"absolute",adaptive:!1,roundOffsets:l})))),t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-placement":t.placement})},data:{}},oe,We,ze,Ve,Ee,{name:"hide",enabled:!0,phase:"main",requiresIfExists:["preventOverflow"],fn:function(e){var t=e.state,n=e.name,o=t.rects.reference,i=t.rects.popper,a=t.modifiersData.preventOverflow,r=Fe(t,{elementContext:"reference"}),s=Fe(t,{altBoundary:!0}),l=je(r,o),d=je(s,i,a),c=qe(l),p=qe(d);t.modifiersData[n]={referenceClippingOffsets:l,popperEscapeOffsets:d,isReferenceHidden:c,hasPopperEscaped:p},t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-reference-hidden":c,"data-popper-escaped":p})}}]}),et="tippy-content",tt="tippy-backdrop",nt="tippy-arrow",ot="tippy-svg-arrow",it={passive:!0,capture:!0},at=function(){return document.body};function rt(e,t,n){if(Array.isArray(e)){var o=e[t];return null==o?Array.isArray(n)?n[t]:n:o}return e}function st(e,t){var n={}.toString.call(e);return 0===n.indexOf("[object")&&n.indexOf(t+"]")>-1}function lt(e,t){return"function"==typeof e?e.apply(void 0,t):e}function dt(e,t){return 0===t?e:function(o){clearTimeout(n),n=setTimeout((function(){e(o)}),t)};var n}function ct(e){return[].concat(e)}function pt(e,t){-1===e.indexOf(t)&&e.push(t)}function ut(e){return[].slice.call(e)}function gt(e){return Object.keys(e).reduce((function(t,n){return void 0!==e[n]&&(t[n]=e[n]),t}),{})}function mt(){return document.createElement("div")}function ft(e){return["Element","Fragment"].some((function(t){return st(e,t)}))}function bt(e){return ft(e)?[e]:function(e){return st(e,"NodeList")}(e)?ut(e):Array.isArray(e)?e:ut(document.querySelectorAll(e))}function ht(e,t){e.forEach((function(e){e&&(e.style.transitionDuration=t+"ms")}))}function yt(e,t){e.forEach((function(e){e&&e.setAttribute("data-state",t)}))}function vt(e,t,n){var o=t+"EventListener";["transitionend","webkitTransitionEnd"].forEach((function(t){e[o](t,n)}))}function xt(e,t){for(var n=t;n;){var o;if(e.contains(n))return!0;n=null==n.getRootNode||null==(o=n.getRootNode())?void 0:o.host}return!1}var wt={isTouch:!1},At=0;function Et(){wt.isTouch||(wt.isTouch=!0,window.performance&&document.addEventListener("mousemove",Lt))}function Lt(){var e=performance.now();e-At<20&&(wt.isTouch=!1,document.removeEventListener("mousemove",Lt)),At=e}function kt(){var e,t=document.activeElement;if((e=t)&&e._tippy&&e._tippy.reference===e){var n=t._tippy;t.blur&&!n.state.isVisible&&t.blur()}}var It=!!("undefined"!=typeof window&&"undefined"!=typeof document)&&!!window.msCrypto,Tt=Object.assign({appendTo:at,aria:{content:"auto",expanded:"auto"},delay:0,duration:[300,250],getReferenceClientRect:null,hideOnClick:!0,ignoreAttributes:!1,interactive:!1,interactiveBorder:2,interactiveDebounce:0,moveTransition:"",offset:[0,10],onAfterUpdate:function(){},onBeforeUpdate:function(){},onCreate:function(){},onDestroy:function(){},onHidden:function(){},onHide:function(){},onMount:function(){},onShow:function(){},onShown:function(){},onTrigger:function(){},onUntrigger:function(){},onClickOutside:function(){},placement:"top",plugins:[],popperOptions:{},render:null,showOnCreate:!1,touch:!0,trigger:"mouseenter focus",triggerTarget:null},{animateFill:!1,followCursor:!1,inlinePositioning:!1,sticky:!1},{allowHTML:!1,animation:"fade",arrow:!0,content:"",inertia:!1,maxWidth:350,role:"tooltip",theme:"",zIndex:9999}),_t=Object.keys(Tt);function St(e){var t=(e.plugins||[]).reduce((function(t,n){var o,i=n.name,a=n.defaultValue;i&&(t[i]=void 0!==e[i]?e[i]:null!=(o=Tt[i])?o:a);return t}),{});return Object.assign({},e,t)}function Pt(e,t){var n=Object.assign({},t,{content:lt(t.content,[e])},t.ignoreAttributes?{}:function(e,t){return(t?Object.keys(St(Object.assign({},Tt,{plugins:t}))):_t).reduce((function(t,n){var o=(e.getAttribute("data-tippy-"+n)||"").trim();if(!o)return t;if("content"===n)t[n]=o;else try{t[n]=JSON.parse(o)}catch(e){t[n]=o}return t}),{})}(e,t.plugins));return n.aria=Object.assign({},Tt.aria,n.aria),n.aria={expanded:"auto"===n.aria.expanded?t.interactive:n.aria.expanded,content:"auto"===n.aria.content?t.interactive?null:"describedby":n.aria.content},n}var Ot=function(){return"innerHTML"};function Ct(e,t){e[Ot()]=t}function $t(e){var t=mt();return!0===e?t.className=nt:(t.className=ot,ft(e)?t.appendChild(e):Ct(t,e)),t}function Nt(e,t){ft(t.content)?(Ct(e,""),e.appendChild(t.content)):"function"!=typeof t.content&&(t.allowHTML?Ct(e,t.content):e.textContent=t.content)}function Rt(e){var t=e.firstElementChild,n=ut(t.children);return{box:t,content:n.find((function(e){return e.classList.contains(et)})),arrow:n.find((function(e){return e.classList.contains(nt)||e.classList.contains(ot)})),backdrop:n.find((function(e){return e.classList.contains(tt)}))}}function Dt(e){var t=mt(),n=mt();n.className="tippy-box",n.setAttribute("data-state","hidden"),n.setAttribute("tabindex","-1");var o=mt();function i(n,o){var i=Rt(t),a=i.box,r=i.content,s=i.arrow;o.theme?a.setAttribute("data-theme",o.theme):a.removeAttribute("data-theme"),"string"==typeof o.animation?a.setAttribute("data-animation",o.animation):a.removeAttribute("data-animation"),o.inertia?a.setAttribute("data-inertia",""):a.removeAttribute("data-inertia"),a.style.maxWidth="number"==typeof o.maxWidth?o.maxWidth+"px":o.maxWidth,o.role?a.setAttribute("role",o.role):a.removeAttribute("role"),n.content===o.content&&n.allowHTML===o.allowHTML||Nt(r,e.props),o.arrow?s?n.arrow!==o.arrow&&(a.removeChild(s),a.appendChild($t(o.arrow))):a.appendChild($t(o.arrow)):s&&a.removeChild(s)}return o.className=et,o.setAttribute("data-state","hidden"),Nt(o,e.props),t.appendChild(n),n.appendChild(o),i(e.props,e.props),{popper:t,onUpdate:i}}Dt.$$tippy=!0;var Mt=1,Gt=[],Bt=[];function Ht(e,t){var n,o,i,a,r,s,l,d,c=Pt(e,Object.assign({},Tt,St(gt(t)))),p=!1,u=!1,g=!1,m=!1,f=[],b=dt(V,c.interactiveDebounce),h=Mt++,y=(d=c.plugins).filter((function(e,t){return d.indexOf(e)===t})),v={id:h,reference:e,popper:mt(),popperInstance:null,props:c,state:{isEnabled:!0,isVisible:!1,isDestroyed:!1,isMounted:!1,isShown:!1},plugins:y,clearDelayTimeouts:function(){clearTimeout(n),clearTimeout(o),cancelAnimationFrame(i)},setProps:function(t){if(v.state.isDestroyed)return;$("onBeforeUpdate",[v,t]),q();var n=v.props,o=Pt(e,Object.assign({},n,gt(t),{ignoreAttributes:!0}));v.props=o,j(),n.interactiveDebounce!==o.interactiveDebounce&&(D(),b=dt(V,o.interactiveDebounce));n.triggerTarget&&!o.triggerTarget?ct(n.triggerTarget).forEach((function(e){e.removeAttribute("aria-expanded")})):o.triggerTarget&&e.removeAttribute("aria-expanded");R(),C(),A&&A(n,o);v.popperInstance&&(X(),J().forEach((function(e){requestAnimationFrame(e._tippy.popperInstance.forceUpdate)})));$("onAfterUpdate",[v,t])},setContent:function(e){v.setProps({content:e})},show:function(){var e=v.state.isVisible,t=v.state.isDestroyed,n=!v.state.isEnabled,o=wt.isTouch&&!v.props.touch,i=rt(v.props.duration,0,Tt.duration);if(e||t||n||o)return;if(_().hasAttribute("disabled"))return;if($("onShow",[v],!1),!1===v.props.onShow(v))return;v.state.isVisible=!0,T()&&(w.style.visibility="visible");C(),H(),v.state.isMounted||(w.style.transition="none");if(T()){var a=P();ht([a.box,a.content],0)}s=function(){var e;if(v.state.isVisible&&!m){if(m=!0,w.offsetHeight,w.style.transition=v.props.moveTransition,T()&&v.props.animation){var t=P(),n=t.box,o=t.content;ht([n,o],i),yt([n,o],"visible")}N(),R(),pt(Bt,v),null==(e=v.popperInstance)||e.forceUpdate(),$("onMount",[v]),v.props.animation&&T()&&function(e,t){U(e,t)}(i,(function(){v.state.isShown=!0,$("onShown",[v])}))}},function(){var e,t=v.props.appendTo,n=_();e=v.props.interactive&&t===at||"parent"===t?n.parentNode:lt(t,[n]);e.contains(w)||e.appendChild(w);v.state.isMounted=!0,X()}()},hide:function(){var e=!v.state.isVisible,t=v.state.isDestroyed,n=!v.state.isEnabled,o=rt(v.props.duration,1,Tt.duration);if(e||t||n)return;if($("onHide",[v],!1),!1===v.props.onHide(v))return;v.state.isVisible=!1,v.state.isShown=!1,m=!1,p=!1,T()&&(w.style.visibility="hidden");if(D(),F(),C(!0),T()){var i=P(),a=i.box,r=i.content;v.props.animation&&(ht([a,r],o),yt([a,r],"hidden"))}N(),R(),v.props.animation?T()&&function(e,t){U(e,(function(){!v.state.isVisible&&w.parentNode&&w.parentNode.contains(w)&&t()}))}(o,v.unmount):v.unmount()},hideWithInteractivity:function(e){S().addEventListener("mousemove",b),pt(Gt,b),b(e)},enable:function(){v.state.isEnabled=!0},disable:function(){v.hide(),v.state.isEnabled=!1},unmount:function(){v.state.isVisible&&v.hide();if(!v.state.isMounted)return;Z(),J().forEach((function(e){e._tippy.unmount()})),w.parentNode&&w.parentNode.removeChild(w);Bt=Bt.filter((function(e){return e!==v})),v.state.isMounted=!1,$("onHidden",[v])},destroy:function(){if(v.state.isDestroyed)return;v.clearDelayTimeouts(),v.unmount(),q(),delete e._tippy,v.state.isDestroyed=!0,$("onDestroy",[v])}};if(!c.render)return v;var x=c.render(v),w=x.popper,A=x.onUpdate;w.setAttribute("data-tippy-root",""),w.id="tippy-"+v.id,v.popper=w,e._tippy=v,w._tippy=v;var E=y.map((function(e){return e.fn(v)})),L=e.hasAttribute("aria-expanded");return j(),R(),C(),$("onCreate",[v]),c.showOnCreate&&ee(),w.addEventListener("mouseenter",(function(){v.props.interactive&&v.state.isVisible&&v.clearDelayTimeouts()})),w.addEventListener("mouseleave",(function(){v.props.interactive&&v.props.trigger.indexOf("mouseenter")>=0&&S().addEventListener("mousemove",b)})),v;function k(){var e=v.props.touch;return Array.isArray(e)?e:[e,0]}function I(){return"hold"===k()[0]}function T(){var e;return!(null==(e=v.props.render)||!e.$$tippy)}function _(){return l||e}function S(){var e,t,n=_().parentNode;return n?null!=(t=ct(n)[0])&&null!=(e=t.ownerDocument)&&e.body?t.ownerDocument:document:document}function P(){return Rt(w)}function O(e){return v.state.isMounted&&!v.state.isVisible||wt.isTouch||a&&"focus"===a.type?0:rt(v.props.delay,e?0:1,Tt.delay)}function C(e){void 0===e&&(e=!1),w.style.pointerEvents=v.props.interactive&&!e?"":"none",w.style.zIndex=""+v.props.zIndex}function $(e,t,n){var o;(void 0===n&&(n=!0),E.forEach((function(n){n[e]&&n[e].apply(n,t)})),n)&&(o=v.props)[e].apply(o,t)}function N(){var t=v.props.aria;if(t.content){var n="aria-"+t.content,o=w.id;ct(v.props.triggerTarget||e).forEach((function(e){var t=e.getAttribute(n);if(v.state.isVisible)e.setAttribute(n,t?t+" "+o:o);else{var i=t&&t.replace(o,"").trim();i?e.setAttribute(n,i):e.removeAttribute(n)}}))}}function R(){!L&&v.props.aria.expanded&&ct(v.props.triggerTarget||e).forEach((function(e){v.props.interactive?e.setAttribute("aria-expanded",v.state.isVisible&&e===_()?"true":"false"):e.removeAttribute("aria-expanded")}))}function D(){S().removeEventListener("mousemove",b),Gt=Gt.filter((function(e){return e!==b}))}function M(t){if(!wt.isTouch||!g&&"mousedown"!==t.type){var n=t.composedPath&&t.composedPath()[0]||t.target;if(!v.props.interactive||!xt(w,n)){if(ct(v.props.triggerTarget||e).some((function(e){return xt(e,n)}))){if(wt.isTouch)return;if(v.state.isVisible&&v.props.trigger.indexOf("click")>=0)return}else $("onClickOutside",[v,t]);!0===v.props.hideOnClick&&(v.clearDelayTimeouts(),v.hide(),u=!0,setTimeout((function(){u=!1})),v.state.isMounted||F())}}}function G(){g=!0}function B(){g=!1}function H(){var e=S();e.addEventListener("mousedown",M,!0),e.addEventListener("touchend",M,it),e.addEventListener("touchstart",B,it),e.addEventListener("touchmove",G,it)}function F(){var e=S();e.removeEventListener("mousedown",M,!0),e.removeEventListener("touchend",M,it),e.removeEventListener("touchstart",B,it),e.removeEventListener("touchmove",G,it)}function U(e,t){var n=P().box;function o(e){e.target===n&&(vt(n,"remove",o),t())}if(0===e)return t();vt(n,"remove",r),vt(n,"add",o),r=o}function z(t,n,o){void 0===o&&(o=!1),ct(v.props.triggerTarget||e).forEach((function(e){e.addEventListener(t,n,o),f.push({node:e,eventType:t,handler:n,options:o})}))}function j(){var e;I()&&(z("touchstart",W,{passive:!0}),z("touchend",Q,{passive:!0})),(e=v.props.trigger,e.split(/\s+/).filter(Boolean)).forEach((function(e){if("manual"!==e)switch(z(e,W),e){case"mouseenter":z("mouseleave",Q);break;case"focus":z(It?"focusout":"blur",K);break;case"focusin":z("focusout",K)}}))}function q(){f.forEach((function(e){var t=e.node,n=e.eventType,o=e.handler,i=e.options;t.removeEventListener(n,o,i)})),f=[]}function W(e){var t,n=!1;if(v.state.isEnabled&&!Y(e)&&!u){var o="focus"===(null==(t=a)?void 0:t.type);a=e,l=e.currentTarget,R(),!v.state.isVisible&&st(e,"MouseEvent")&&Gt.forEach((function(t){return t(e)})),"click"===e.type&&(v.props.trigger.indexOf("mouseenter")<0||p)&&!1!==v.props.hideOnClick&&v.state.isVisible?n=!0:ee(e),"click"===e.type&&(p=!n),n&&!o&&te(e)}}function V(e){var t=e.target,n=_().contains(t)||w.contains(t);if("mousemove"!==e.type||!n){var o=J().concat(w).map((function(e){var t,n=null==(t=e._tippy.popperInstance)?void 0:t.state;return n?{popperRect:e.getBoundingClientRect(),popperState:n,props:c}:null})).filter(Boolean);(function(e,t){var n=t.clientX,o=t.clientY;return e.every((function(e){var t=e.popperRect,i=e.popperState,a=e.props.interactiveBorder,r=i.placement.split("-")[0],s=i.modifiersData.offset;if(!s)return!0;var l="bottom"===r?s.top.y:0,d="top"===r?s.bottom.y:0,c="right"===r?s.left.x:0,p="left"===r?s.right.x:0,u=t.top-o+l>a,g=o-t.bottom-d>a,m=t.left-n+c>a,f=n-t.right-p>a;return u||g||m||f}))})(o,e)&&(D(),te(e))}}function Q(e){Y(e)||v.props.trigger.indexOf("click")>=0&&p||(v.props.interactive?v.hideWithInteractivity(e):te(e))}function K(e){v.props.trigger.indexOf("focusin")<0&&e.target!==_()||v.props.interactive&&e.relatedTarget&&w.contains(e.relatedTarget)||te(e)}function Y(e){return!!wt.isTouch&&I()!==e.type.indexOf("touch")>=0}function X(){Z();var t=v.props,n=t.popperOptions,o=t.placement,i=t.offset,a=t.getReferenceClientRect,r=t.moveTransition,l=T()?Rt(w).arrow:null,d=a?{getBoundingClientRect:a,contextElement:a.contextElement||_()}:e,c={name:"$$tippy",enabled:!0,phase:"beforeWrite",requires:["computeStyles"],fn:function(e){var t=e.state;if(T()){var n=P().box;["placement","reference-hidden","escaped"].forEach((function(e){"placement"===e?n.setAttribute("data-placement",t.placement):t.attributes.popper["data-popper-"+e]?n.setAttribute("data-"+e,""):n.removeAttribute("data-"+e)})),t.attributes.popper={}}}},p=[{name:"offset",options:{offset:i}},{name:"preventOverflow",options:{padding:{top:2,bottom:2,left:5,right:5}}},{name:"flip",options:{padding:5}},{name:"computeStyles",options:{adaptive:!r}},c];T()&&l&&p.push({name:"arrow",options:{element:l,padding:3}}),p.push.apply(p,(null==n?void 0:n.modifiers)||[]),v.popperInstance=Je(d,w,Object.assign({},n,{placement:o,onFirstUpdate:s,modifiers:p}))}function Z(){v.popperInstance&&(v.popperInstance.destroy(),v.popperInstance=null)}function J(){return ut(w.querySelectorAll("[data-tippy-root]"))}function ee(e){v.clearDelayTimeouts(),e&&$("onTrigger",[v,e]),H();var t=O(!0),o=k(),i=o[0],a=o[1];wt.isTouch&&"hold"===i&&a&&(t=a),t?n=setTimeout((function(){v.show()}),t):v.show()}function te(e){if(v.clearDelayTimeouts(),$("onUntrigger",[v,e]),v.state.isVisible){if(!(v.props.trigger.indexOf("mouseenter")>=0&&v.props.trigger.indexOf("click")>=0&&["mouseleave","mousemove"].indexOf(e.type)>=0&&p)){var t=O(!1);t?o=setTimeout((function(){v.state.isVisible&&v.hide()}),t):i=requestAnimationFrame((function(){v.hide()}))}}else F()}}function Ft(e,t){void 0===t&&(t={});var n=Tt.plugins.concat(t.plugins||[]);document.addEventListener("touchstart",Et,it),window.addEventListener("blur",kt);var o=Object.assign({},t,{plugins:n}),i=bt(e).reduce((function(e,t){var n=t&&Ht(t,o);return n&&e.push(n),e}),[]);return ft(e)?i[0]:i}Ft.defaultProps=Tt,Ft.setDefaultProps=function(e){Object.keys(e).forEach((function(t){Tt[t]=e[t]}))},Ft.currentInput=wt,Object.assign({},oe,{effect:function(e){var t=e.state,n={popper:{position:t.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};Object.assign(t.elements.popper.style,n.popper),t.styles=n,t.elements.arrow&&Object.assign(t.elements.arrow.style,n.arrow)}}),Ft.setDefaultProps({render:Dt});var Ut='a,button,code,div,h1,h2,kbd,li,ol,p,span,strong,svg,ul{all:unset;box-sizing:border-box!important}div{display:block}:after,:before{all:unset}.tippy-box[data-animation=fade][data-state=hidden]{opacity:0}[data-tippy-root]{max-width:calc(100vw - 10px)}@media (forced-colors:active){[data-tippy-root]{border:2px solid transparent;border-radius:5px}}.tippy-box[data-placement^=top]>.tippy-arrow{bottom:0}.tippy-box[data-placement^=top]>.tippy-arrow:before{border-top-color:initial;border-width:8px 8px 0;bottom:-7px;left:0;transform-origin:center top}.tippy-box[data-placement^=bottom]>.tippy-arrow{top:0}.tippy-box[data-placement^=bottom]>.tippy-arrow:before{border-bottom-color:initial;border-width:0 8px 8px;left:0;top:-7px;transform-origin:center bottom}.tippy-box[data-placement^=left]>.tippy-arrow{right:0}.tippy-box[data-placement^=left]>.tippy-arrow:before{border-left-color:initial;border-width:8px 0 8px 8px;right:-7px;transform-origin:center left}.tippy-box[data-placement^=right]>.tippy-arrow{left:0}.tippy-box[data-placement^=right]>.tippy-arrow:before{border-right-color:initial;border-width:8px 8px 8px 0;left:-7px;transform-origin:center right}.tippy-arrow{color:#333;height:16px;width:16px}.tippy-arrow:before{border-color:transparent;border-style:solid;content:"";position:absolute}.tippy-content{padding:5px 9px;position:relative;z-index:1}.tippy-box[data-theme~=sa11y-theme][role=tooltip]{box-sizing:border-box!important}.tippy-box[data-theme~=sa11y-theme][role=tooltip][data-animation=fade][data-state=hidden]{opacity:0}.tippy-box[data-theme~=sa11y-theme][role=tooltip][data-inertia][data-state=visible]{transition-timing-function:cubic-bezier(.54,1.5,.38,1.11)}[role=dialog]{min-width:300px;text-align:start}[role=tooltip]{min-width:185px;text-align:center}.tippy-box[data-theme~=sa11y-theme]{-webkit-font-smoothing:auto;background-color:var(--sa11y-panel-bg);border-radius:4px;box-shadow:0 0 20px 4px rgba(154,161,177,.15),0 4px 80px -8px rgba(36,40,47,.25),0 4px 4px -2px rgba(91,94,105,.15)!important;color:var(--sa11y-panel-primary);display:block;font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);font-weight:400;letter-spacing:normal;line-height:22px;outline:0;padding:8px;position:relative;transition-property:transform,visibility,opacity}.tippy-box[data-theme~=sa11y-theme] code{font-family:monospace;font-size:calc(var(--sa11y-normal-text) - 1px)}.tippy-box[data-theme~=sa11y-theme] code,.tippy-box[data-theme~=sa11y-theme] kbd{-webkit-font-smoothing:auto;background-color:var(--sa11y-panel-badge);border-radius:3.2px;color:var(--sa11y-panel-primary);letter-spacing:normal;line-height:22px;padding:1.6px 4.8px}.tippy-box[data-theme~=sa11y-theme][data-placement^=top]{text-align:center}.tippy-box[data-theme~=sa11y-theme] .tippy-content{padding:5px 9px}.tippy-box[data-theme~=sa11y-theme] sub,.tippy-box[data-theme~=sa11y-theme] sup{font-size:var(--sa11y-small-text)}.tippy-box[data-theme~=sa11y-theme] ul{margin:0;margin-block-end:0;margin-block-start:0;padding:0;position:relative}.tippy-box[data-theme~=sa11y-theme] li{display:list-item;margin:5px 10px 0 20px;padding-bottom:5px}.tippy-box[data-theme~=sa11y-theme] a{color:var(--sa11y-hyperlink);cursor:pointer;text-decoration:underline}.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] a:hover{text-decoration:none}.tippy-box[data-theme~=sa11y-theme] strong{font-weight:600}.tippy-box[data-theme~=sa11y-theme] hr{background:var(--sa11y-panel-bg-splitter);border:none;height:1px;margin:10px 0;opacity:1;padding:0}.tippy-box[data-theme~=sa11y-theme] button.close-btn{margin:0}.tippy-box[data-theme~=sa11y-theme] button[data-sa11y-dismiss]{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;display:block;margin:10px 5px 5px 0;padding:4px 8px}.tippy-box[data-theme~=sa11y-theme] button[data-sa11y-dismiss]:focus,.tippy-box[data-theme~=sa11y-theme] button[data-sa11y-dismiss]:hover{background:var(--sa11y-shortcut-hover)}.tippy-box[data-theme~=sa11y-theme][data-placement^=top]>.tippy-arrow:before{border-top-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=bottom]>.tippy-arrow:before{border-bottom-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=left]>.tippy-arrow:before{border-left-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=right]>.tippy-arrow:before{border-right-color:var(--sa11y-panel-bg)}@media (forced-colors:active){.tippy-box[data-theme~=sa11y-theme][data-placement^=bottom]>.tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=left]>.tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=right]>.tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=top]>.tippy-arrow:before{filter:invert(1);forced-color-adjust:none}.tippy-box[data-theme~=sa11y-theme] .tippy-arrow{z-index:-1}}';class zt extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),n=document.createElement("style");n.innerHTML=Ut+$,e.appendChild(n);const i=[];A.Annotations.Array.forEach((e=>{const t=e.shadowRoot.querySelectorAll(".sa11y-btn");t&&i.push(...Array.from(t))}));const a=Ft(i,{interactive:!0,trigger:"mouseenter click",arrow:!0,delay:[0,400],theme:"sa11y-theme",placement:"right-start",allowHTML:!0,role:"dialog",aria:{content:null,expanded:"auto"},appendTo:e,zIndex:2147483645,onShow(e){const t=e.popper;a.forEach((e=>{e!==t&&e.hide()}));e.reference.getRootNode().host.setAttribute("data-sa11y-opened","");const n=t.querySelector(".close-btn"),o=()=>{e.hide(),e.reference.focus()};n.addEventListener("click",o);const i=t=>{"Escape"===t.key&&(e.hide(),e.reference.focus())};t.addEventListener("keydown",i);const r=()=>{n.removeEventListener("click",o),t.removeEventListener("keydown",i),t.removeEventListener("hidden",r)};t.addEventListener("hidden",r)},onTrigger(e,t){"click"===t.type&&setTimeout((()=>{e.popper.querySelector(".close-btn").focus(),function(e){const t=e.querySelectorAll("a[href]:not([disabled]), button:not([disabled])"),n=t[0],o=t[t.length-1];e.addEventListener("keydown",(t=>{const i="Tab"===t.key||9===t.keyCode,a=e.getRootNode();i&&(t.shiftKey?a.activeElement===n&&(o.focus(),t.preventDefault()):a.activeElement===o&&(n.focus(),t.preventDefault()))}))}(e.popper)}),0)},onHide(e){e.popper.querySelector(".close-btn").removeEventListener("click",(()=>{e.hide()}));e.reference.getRootNode().host.removeAttribute("data-sa11y-opened")}});let r;r=-1!==navigator.userAgent.indexOf("Mac")?'<span class="kbd">Option</span> + <span class="kbd">S</span>':'<span class="kbd">Alt</span> + <span class="kbd">S</span>',Ft(o.Panel.skipButton,{content:`${t._("SHORTCUT_TOOLTIP")} &raquo; <br> ${r}`,allowHTML:!0,delay:[500,0],trigger:"mouseenter focusin",arrow:!0,placement:"top",theme:"sa11y-theme",maxWidth:165,role:"tooltip",aria:{content:null,expanded:!1},appendTo:e,zIndex:2147483645})}}class jt extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),t=document.createElement("style");t.innerHTML=Ut+$,e.appendChild(t),this.object=Ft(o.Panel.dismissButton,{delay:[500,0],trigger:"mouseenter focusin",arrow:!0,placement:"top",theme:"sa11y-theme",maxWidth:165,role:"tooltip",aria:{content:null,expanded:!1},appendTo:e,zIndex:2147483645})}}class qt extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),t=document.createElement("style");t.innerHTML='.instance{display:block}.instance-inline{display:inline-block;text-align:end}button{border-radius:50%;box-shadow:0 0 16px 0 rgba(0,0,0,.31);cursor:pointer;display:block;font-size:0;line-height:normal;min-width:0;padding:0;transition:all .2s ease-in-out;z-index:8888}button,button:after{height:36px;position:absolute;width:36px}button:after{content:"";left:-7px;padding:7px;top:-7px}button.warning-btn{margin:20px}button.error-btn,button.good-btn{margin:10px}button.error-btn-text,button.good-btn-text,button.warning-btn-text{margin:-30px 10px}button.error-btn,button.error-btn-text{background:50% 50% var(--sa11y-error-svg) no-repeat;background-color:var(--sa11y-error);background-size:22px;border:1px solid var(--sa11y-error)}button.error-btn-text:focus,button.error-btn-text:hover,button.error-btn:focus,button.error-btn:hover{background-color:var(--sa11y-error-hover)}button.good-btn,button.good-btn-text{background:50% 50% var(--sa11y-good) var(--sa11y-good-svg) no-repeat;background-color:var(--sa11y-good);background-size:20px;border:1px solid var(--sa11y-good)}button.good-btn-text:focus,button.good-btn-text:hover,button.good-btn:focus,button.good-btn:hover{background-color:var(--sa11y-good-hover)}button.warning-btn,button.warning-btn-text{background:50% 50% var(--sa11y-warning) var(--sa11y-warning-svg) no-repeat;background-color:var(--sa11y-warning);background-size:24px;border:1px solid var(--sa11y-warning);transform:scaleX(var(--sa11y-icon-direction))}button.warning-btn-text:focus,button.warning-btn-text:hover,button.warning-btn:focus,button.warning-btn:hover{background-color:var(--sa11y-warning-hover)}button.sa11y-btn:active,button.sa11y-btn:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){button.sa11y-btn{border:1px solid transparent!important;forced-color-adjust:none;outline:3px solid transparent!important}}'+$,e.appendChild(t)}}const Wt=()=>{document.querySelectorAll("sa11y-annotation").forEach((e=>{const t=((e,t,n)=>{let o=e;for(;null!==o;){if(window.getComputedStyle(o).getPropertyValue(t)===n)return o;o=o.parentElement}return null})(e,"overflow","hidden");null!==t&&t.setAttribute("data-sa11y-overflow","")}))};class Vt extends HTMLElement{connectedCallback(){this.attachShadow({mode:"open"})}}class Qt extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),t=document.createElement("style");t.textContent="\n      span.heading-label {\n        background-color: #777678;\n        background-image: linear-gradient(to bottom right, #b629ce, #16aec2);\n        border-radius: 5px;\n        border: 1px solid #36a5c3;\n        color: white;\n        display: inline-block;\n        font-family: var(--sa11y-font-face);\n        font-weight: 500;\n        font-size: 17px;\n        line-height: normal;\n        letter-spacing: normal;\n        margin: -5px 0 0 5px;\n        padding: 3px;\n        position: absolute;\n        text-shadow: 1px 1px black;\n        -webkit-text-fill-color: white;\n        z-index: 200;\n      }\n      @media screen and (forced-colors: active) {\n        span.heading-label {\n          border: 2px solid transparent;\n        }\n      }",e.appendChild(t)}}const Kt=(e,n)=>{if(0===e.offsetTop){const o=e.getRootNode().host,i=p(o,"display","none"),a=parseInt(o.getAttribute("data-sa11y-annotation"),10),r=w(n.find((e=>e.id===a)));(e=>{const t=p(e.getRootNode().host,"display","none");if(null!==t){m(t.previousElementSibling||t.parentNode)}})(e);const s=e.getAttribute("data-tippy-content");if(h(`${t._("NOT_VISIBLE_ALERT")}`,s,r),(()=>{const e=document.querySelector("sa11y-tooltips").shadowRoot.querySelector("button");null!==e&&e.click()})(),i){const e=i.previousElementSibling,{parentNode:t}=i;return e?u(e).top-150:u(t).top-150}}else b(),o.Panel.skipButton.focus();return u(e).top-150};let Yt=-1;const Xt=()=>{const e=g.getItem("sa11y-latest-dismissed");null!==e&&(Yt=parseInt(e,10)-1),g.removeItem("sa11y-latest-dismissed");const t=i("[data-sa11y-opened]","root");t[0]&&(Yt=parseInt(t[0].getAttribute("data-sa11y-position"),10))},Zt=e=>{Xt();const t=A.Annotations.Array;Yt>=t.length-1&&(Yt=-1);const n=t[Yt+1].shadowRoot.querySelector("button"),i=Kt(n,e);window.scrollTo({top:i,behavior:`${o.Global.scrollBehaviour}`}),0!==n.offsetTop&&(n.focus(),n.click()),Yt+=1},Jt=e=>{if(Xt(),Yt>0){const t=A.Annotations.Array[Yt-1].shadowRoot.querySelector("button"),n=Kt(t,e);window.scrollTo({top:n,behavior:`${o.Global.scrollBehaviour}`}),0!==t.offsetTop&&(t.focus(),t.click()),Yt-=1,-1===Yt&&(Yt=A.Annotations.Array.length-1)}};let en,tn;function nn(e){en=t=>{!function(e,t){A.Annotations.Array.length&&!o.Panel.skipButton.hasAttribute("disabled")&&(e.altKey&&"KeyS"===e.code?(e.preventDefault(),Zt(t)):e.altKey&&"KeyW"===e.code&&(e.preventDefault(),Jt(t)))}(t,e)},tn=()=>{Zt(e)},document.addEventListener("keydown",en),o.Panel.skipButton.addEventListener("click",tn)}const on=(e,t)=>{const n=[];return n[0]=window.getComputedStyle(e,":before").getPropertyValue("content"),n[1]=window.getComputedStyle(e,":after").getPropertyValue("content"),n[0]="none"===n[0]?"":n[0].replace(/^"(.*)"$/,"$1"),n[1]="none"===n[1]?"":n[1].replace(/^"(.*)"$/,"$1"),` ${n[0]}${t}${n[1]}`},an=e=>{for(let t=0;t<1e3;t++){if(e.nextSibling())return e.previousNode();if(!e.parentNode())return!1}return!1},rn=(e,t=!1)=>{const n=e.getAttribute("aria-labelledby");if(!t&&n){const e=n.split(/\s+/);if(e.length>0){let t="";return e.forEach((e=>{const n=document.querySelector(`#${CSS.escape(e)}`);t+=n?`${sn(n,"",1)}`:""})),t}}const o=e.getAttribute("aria-label");return o&&o.trim().length>0?o:"noAria"},sn=(e,t,n=0)=>{const o=rn(e,n);if("noAria"!==o)return o;let i="";if(!e.children.length)return i=on(e,e.textContent),!i.trim()&&e.hasAttribute("title")?e.getAttribute("title"):i;const a=(r=e,s=!0,l=!0,document.createTreeWalker(r,NodeFilter.SHOW_ALL,{acceptNode:e=>s&&e.nodeType===Node.ELEMENT_NODE||l&&e.nodeType===Node.TEXT_NODE?NodeFilter.FILTER_ACCEPT:NodeFilter.FILTER_REJECT}));var r,s,l;let d=!1,c=!1,p=0,u=!0;const g=t?e.querySelectorAll(t):"";for(;a.nextNode()&&u;){p+=1;if(Array.from(g).some((e=>e.contains(a.currentNode))));else if(a.currentNode.nodeType===Node.TEXT_NODE)i+=` ${a.currentNode.nodeValue}`;else if(d&&!a.currentNode.closest("a"))c===i&&(i+=d),d=!1,c=!1;else if(!a.currentNode.hasAttribute("aria-hidden")||n&&p<3){const e=rn(a.currentNode,n);if("noAria"!==e)i+=` ${e}`,an(a)||(u=!1);else switch(a.currentNode.tagName){case"STYLE":case"NOSCRIPT":an(a)||(u=!1);break;case"IMG":a.currentNode.hasAttribute("alt")&&(i+=a.currentNode.getAttribute("alt"));break;case"SVG":case"svg":"image"===a.currentNode.getAttribute("role")&&a.currentNode.hasAttribute("alt")&&(i+=on(a.currentNode,a.currentNode.getAttribute("alt")),an(a)||(u=!1));break;case"A":a.currentNode.hasAttribute("title")?(d=a.currentNode.getAttribute("title"),c=i):(d=!1,c=!1),i+=on(a.currentNode,"");break;default:i+=on(a.currentNode,"")}}else an(a)||(u=!1)}d&&!c&&(i+=` ${d}`);return i=i.replace(/[\uE000-\uF8FF]/gu,""),!i.trim()&&e.hasAttribute("title")?e.getAttribute("title"):i};function ln(e,n){return A.Found.Images.forEach((i=>{const a=i.getAttribute("alt"),r=i.closest("a[href]"),l=r?c(r,o.Exclusions.LinkSpan).textContent:"",p=n.linkIgnoreStrings?l.replace(n.linkIgnoreStrings,""):l,u=r?d(p).length:0;if("true"!==i.getAttribute("aria-hidden"))if(r&&"true"===r.getAttribute("aria-hidden")){"-1"===r.getAttribute("tabindex")||e.push({element:i,type:"error",content:t.sprintf("LINK_HIDDEN_FOCUSABLE"),inline:!1,position:"beforebegin"})}else if(null===a)if(r){const n=0===u?t.sprintf("MISSING_ALT_LINK_MESSAGE"):t.sprintf("MISSING_ALT_LINK_BUT_HAS_TEXT_MESSAGE");e.push({element:i,type:"error",content:n,inline:!1,position:"beforebegin"})}else e.push({element:i,type:"error",content:t.sprintf("MISSING_ALT_MESSAGE"),inline:!1,position:"beforebegin"});else{const o=s(a),l=(e=>{const n=[null,null,null];return[".png",".jpg",".jpeg",".webp",".gif",".tiff",".svg","DSC_","IMG_","Photo_","Pic_","Pexels_","AdobeStock_","ScreenShot_","Picture_","Snap_","Capture_"].forEach((t=>{const o=t.toLowerCase();e.toLowerCase().indexOf(o)>=0&&(n[0]=t)})),t._("SUSPICIOUS_ALT_STOPWORDS").forEach((t=>{e.toLowerCase().indexOf(t)>=0&&(n[1]=t)})),t._("PLACEHOLDER_ALT_STOPWORDS").forEach((t=>{e.length===t.length&&e.toLowerCase().indexOf(t)>=0&&(n[2]=t)})),n})(o),c=""===a||" "===a,p=i.closest("figure"),g=p?.querySelector("figcaption"),m=g?g.textContent.trim():"",b=i.getAttribute("src")?i.getAttribute("src"):i.getAttribute("srcset");if(c){const n=f(`DECORATIVE${b}`);if(r){const n=0===u?"error":"good",o=0===u?t.sprintf("LINK_IMAGE_NO_ALT_TEXT"):t.sprintf("LINK_IMAGE_HAS_TEXT");e.push({element:i,type:n,content:o,inline:!1,position:"beforebegin"})}else if(p){const o=g&&m.length?t.sprintf("IMAGE_FIGURE_DECORATIVE"):t.sprintf("IMAGE_DECORATIVE");e.push({element:i,type:"warning",content:o,inline:!1,position:"beforebegin",dismiss:n})}else e.push({element:i,type:"warning",content:t.sprintf("IMAGE_DECORATIVE"),inline:!1,position:"beforebegin",dismiss:n});return}if(null!==l[0]){const n=r?t.sprintf("LINK_ALT_HAS_FILE_EXTENSION",l[0],o):t.sprintf("ALT_HAS_FILE_EXTENSION",l[0],o);e.push({element:i,type:"error",content:n,inline:!1,position:"beforebegin"})}else if(null!==l[2]){const n=r?t.sprintf("LINK_IMAGE_PLACEHOLDER_ALT_MESSAGE",o):t.sprintf("ALT_PLACEHOLDER_MESSAGE",o);e.push({element:i,type:"error",content:n,inline:!1,position:"beforebegin"})}else if(null!==l[1]){const n=f(`${b+o}`),a=r?t.sprintf("LINK_IMAGE_SUS_ALT_MESSAGE",l[1],o):t.sprintf("ALT_HAS_SUS_WORD",l[1],o);e.push({element:i,type:"warning",content:a,inline:!1,position:"beforebegin",dismiss:n})}else if(a.length>n.altTextMaxCharLength){const n=f(`${b+o+a.length}`),s=r?t.sprintf("LINK_IMAGE_LONG_ALT",a.length,o):t.sprintf("IMAGE_ALT_TOO_LONG",a.length,o);e.push({element:i,type:"warning",content:s,inline:!1,position:"beforebegin",dismiss:n})}else if(r){const n=f(`${b+o}`),a=s(d(sn(r))),l=0===u?t.sprintf("LINK_IMAGE_ALT_WARNING",o):t.sprintf("LINK_IMAGE_ALT_AND_TEXT_WARNING",o,a);e.push({element:i,type:"warning",content:l,inline:!1,position:"beforebegin",dismiss:n})}else if(p){if(!!g&&m.toLowerCase()===o.trim().toLowerCase()){const n=f(`FIGURE${b+o}`);e.push({element:i,type:"warning",content:t.sprintf("IMAGE_FIGURE_DUPLICATE_ALT",o),inline:!1,position:"beforebegin",dismiss:n})}else e.push({element:i,type:"good",content:t.sprintf("IMAGE_PASS",o),inline:!1,position:"beforebegin"})}else e.push({element:i,type:"good",content:t.sprintf("IMAGE_PASS",o),inline:!1,position:"beforebegin"})}})),e}function dn(e,n,i){let a;return A.Found.Headings.forEach(((r,l)=>{const c=s(d(sn(r))),u=o.Global.Root.contains(r),g=o.Global.Root.contains(r.getRootNode().host),m=u||g,b=parseInt(r.getAttribute("aria-level")||r.tagName.slice(1),10),h=c.length;let y=null,v=null;if(b-a>1&&0!==l)if(n.nonConsecutiveHeadingIsError)y=t.sprintf("HEADING_NON_CONSECUTIVE_LEVEL",a,b),e.push({element:r,type:"error",content:y,inline:!1,position:"beforebegin",isWithinRoot:m});else{v=t.sprintf("HEADING_NON_CONSECUTIVE_LEVEL",a,b);const n=f(`HEADING${b+c}`);e.push({element:r,type:"warning",content:v,inline:!1,position:"beforebegin",dismiss:n,isWithinRoot:m})}else if(0===h)if(r.querySelectorAll("img").length){const n=r.querySelector("img").getAttribute("alt");null!==n&&" "!==n&&""!==n||(y=t.sprintf("HEADING_EMPTY_WITH_IMAGE",b),e.push({element:r,type:"error",content:y,inline:!1,position:"beforebegin",isWithinRoot:m}))}else y=t.sprintf("HEADING_EMPTY",b),e.push({element:r,type:"error",content:y,inline:!1,position:"beforebegin",isWithinRoot:m});else if(0===l&&1!==b&&2!==b)y=t.sprintf("HEADING_FIRST"),e.push({element:r,type:"error",content:y,inline:!1,position:"beforebegin",isWithinRoot:m});else if(h>n.headingMaxCharLength&&n.flagLongHeadings){v=t.sprintf("HEADING_LONG",h);const n=f(`HEADING${b+c}`);e.push({element:r,type:"warning",content:v,inline:!1,position:"beforebegin",dismiss:n,isWithinRoot:m})}a=b;const x=!!((w=r).getAttribute("hidden")||0===w.offsetWidth&&0===w.offsetHeight||1===w.clientHeight&&1===w.clientWidth)||"none"===getComputedStyle(w).getPropertyValue("display");var w;const A=p(r,"display","none");if(null!==y)i.push({element:r,headingLevel:b,text:c,index:l,type:"error",hidden:x,visibleParent:A,isWithinRoot:m});else if(null!==v){const e=f(`HEADING${b+c}`);i.push({element:r,headingLevel:b,text:c,index:l,type:"warning",hidden:x,visibleParent:A,dismiss:e,isWithinRoot:m})}else null!==y&&null!==v||i.push({element:r,headingLevel:b,text:c,index:l,hidden:x,visibleParent:A,isWithinRoot:m})})),0===A.Found.HeadingOne.length&&n.missingH1&&e.push({type:"warning",content:t.sprintf("HEADING_MISSING_ONE"),dismiss:"missingH1"}),{results:e,headingOutline:i}}function cn(e,n){const i={};return A.Found.Links.forEach((a=>{const r=sn(a,o.Exclusions.LinkSpan),l=d(n.linkIgnoreStrings?r.replace(n.linkIgnoreStrings,""):r),c=(e=>{const n=[null,null,null,null];return t._("PARTIAL_ALT_STOPWORDS").forEach((t=>(e.length===t.length&&e.toLowerCase().indexOf(t)>=0&&(n[0]=t),!1))),t._("WARNING_ALT_STOPWORDS").forEach((t=>(e.toLowerCase().indexOf(t)>=0&&(n[1]=t),!1))),["doiorg/","dlacmorg/","linkspringercom/","pubmedncbinlmnihgov/","scholargooglecom/","ieeexploreieeeorg/","researchgatenet/publication","sciencedirectcom/science/article"].forEach((t=>(e.toLowerCase().indexOf(t)>=0&&(n[2]=t),!1))),["http","edu/","com/","net/","org/","us/","ca/","de/","icu/","uk/","ru/","info/","top/","xyz/","tk/","cn/","ga/","cf/","nl/","io/","fr/","pe/","nz/","pt/","es/","pl/","ua/"].forEach((t=>(e.toLowerCase().indexOf(t)>=0&&(n[3]=t),!1))),n})(l.replace(/[^\w\s/]/g,"").replace(/\s+/g," ").trim()),p=1===l.length&&/[^a-zA-Z0-9]/g.test(l),u=l.match(/([<>↣↳←→↓«»↴]+)/),m=u?u[1]:null,b=a.getAttribute("href"),h="true"===a.getAttribute("aria-hidden"),y="-1"===a.getAttribute("tabindex"),v=a.querySelector(":scope [aria-labelledby], :scope [aria-label]")||a.getAttribute("aria-labelledby")||a.getAttribute("aria-label");if(a.querySelectorAll("img").length);else if(h)y||e.push({element:a,type:"error",content:t.sprintf("LINK_HIDDEN_FOCUSABLE"),inline:!0,position:"afterend"});else if(b&&0===l.length)a.children.length?e.push({element:a,type:"error",content:t.sprintf("LINK_EMPTY_LINK_NO_LABEL"),inline:!0,position:"afterend"}):e.push({element:a,type:"error",content:t.sprintf("LINK_EMPTY"),inline:!0,position:"afterend"});else if(null!==c[0])e.push({element:a,type:"error",content:t.sprintf("LINK_STOPWORD",c[0]),inline:!0,position:"afterend"});else if(null!==c[1]||null!==m){const n=f(`LINK${l+b}`),o=m||c[1];e.push({element:a,type:"warning",content:t.sprintf("LINK_BEST_PRACTICES",o),inline:!0,position:"beforebegin",dismiss:n})}else if(null!==c[2]&&n.linksToDOI){const n=f(`LINK${l+c[2]+b}`);l.length>8&&e.push({element:a,type:"warning",content:t.sprintf("LINK_DOI"),inline:!0,position:"beforebegin",dismiss:n})}else if(null!==c[3]&&n.URLAsLinkTextWarning){const o=f(`LINK${l+c[2]+b}`);l.length>n.URLTextMaxCharLength&&e.push({element:a,type:"warning",content:t.sprintf("LINK_URL"),inline:!0,position:"beforebegin",dismiss:o})}else if(v){if(n.showGoodLinkButton){const n=s(l);e.push({element:a,type:"good",content:t.sprintf("LINK_LABEL",n),inline:!0,position:"afterend"})}}else p&&e.push({element:a,type:"error",content:t.sprintf("LINK_EMPTY"),inline:!0,position:"afterend"});if(n.linksAdvancedPlugin){if("On"===g.getItem("sa11y-remember-links-advanced")||n.headless||n.checkAllHideToggles){const n=t._("NEW_WINDOW_PHRASES").some((e=>l.toLowerCase().includes(e))),o=["pdf","doc","docx","word","mp3","ppt","text","pptx","txt","exe","dmg","rtf","windows","macos","csv","xls","xlsx","mp4","mov","avi","zip"].concat(t._("FILE_TYPE_PHRASES")).some((e=>l.toLowerCase().includes(e))),r=a.matches("\n          a[href$='.pdf'],\n          a[href$='.doc'],\n          a[href$='.docx'],\n          a[href$='.zip'],\n          a[href$='.mp3'],\n          a[href$='.txt'],\n          a[href$='.exe'],\n          a[href$='.dmg'],\n          a[href$='.rtf'],\n          a[href$='.pptx'],\n          a[href$='.ppt'],\n          a[href$='.xls'],\n          a[href$='.xlsx'],\n          a[href$='.csv'],\n          a[href$='.mp4'],\n          a[href$='.mov'],\n          a[href$='.avi']\n        "),d=l.replace(/'|"|-|\.|\s+/g,"").toLowerCase();if(0!==d.length)if(i[d]&&!i[b]){const n=f(`LINK${d+b}`),o=s(l);e.push({element:a,type:"warning",content:t.sprintf("LINK_IDENTICAL_NAME",o),inline:!0,position:"beforebegin",dismiss:n})}else if("_blank"!==a.getAttribute("target")||r||n)if(r&&!o){const n=f(`LINK${d+b}`);e.push({element:a,type:"warning",content:t.sprintf("FILE_TYPE_WARNING"),inline:!0,position:"beforebegin",dismiss:n})}else i[d]=!0,i[b]=!0;else{const n=f(`LINK${d+b}`);e.push({element:a,type:"warning",content:t.sprintf("NEW_TAB_WARNING"),inline:!0,position:"beforebegin",dismiss:n})}}}})),e}class pn{constructor(n){const p={...e,...n};this.initialize=()=>{var e;(()=>{const{doNotRun:e}=p;return e.trim().length>0&&document.querySelector(e)})()||(customElements.define("sa11y-heading-label",Qt),customElements.define("sa11y-heading-anchor",Vt),customElements.define("sa11y-annotation",qt),customElements.define("sa11y-tooltips",zt),customElements.define("sa11y-dismiss-tooltip",jt),customElements.define("sa11y-control-panel",R),customElements.define("sa11y-console-error",N),o.initializeGlobal(p),o.initializeReadability(p),o.initializeExclusions(p),o.initializeEmbeddedContent(p),e=()=>{if(p.headless)this.checkAll(),g.removeItem("sa11y-dismissed");else{const i=new R;document.body.appendChild(i),function(e,n){o.Global.contrastPlugin?o.Panel.contrastToggle.onclick=async()=>{"On"===g.getItem("sa11y-remember-contrast")?(g.setItem("sa11y-remember-contrast","Off"),o.Panel.contrastToggle.textContent=`${t._("OFF")}`,o.Panel.contrastToggle.setAttribute("aria-pressed","false"),n(!1),await e()):(g.setItem("sa11y-remember-contrast","On"),o.Panel.contrastToggle.textContent=`${t._("ON")}`,o.Panel.contrastToggle.setAttribute("aria-pressed","true"),n(!1),await e())}:g.setItem("sa11y-remember-contrast","Off"),o.Global.formLabelsPlugin?o.Panel.labelsToggle.onclick=async()=>{"On"===g.getItem("sa11y-remember-labels")?(g.setItem("sa11y-remember-labels","Off"),o.Panel.labelsToggle.textContent=`${t._("OFF")}`,o.Panel.labelsToggle.setAttribute("aria-pressed","false"),n(!1),await e()):(g.setItem("sa11y-remember-labels","On"),o.Panel.labelsToggle.textContent=`${t._("ON")}`,o.Panel.labelsToggle.setAttribute("aria-pressed","true"),n(!1),await e())}:g.setItem("sa11y-remember-labels","Off"),o.Global.linksAdvancedPlugin?o.Panel.linksToggle.onclick=async()=>{"On"===g.getItem("sa11y-remember-links-advanced")?(g.setItem("sa11y-remember-links-advanced","Off"),o.Panel.linksToggle.textContent=`${t._("OFF")}`,o.Panel.linksToggle.setAttribute("aria-pressed","false"),n(!1),await e()):(g.setItem("sa11y-remember-links-advanced","On"),o.Panel.linksToggle.textContent=`${t._("ON")}`,o.Panel.linksToggle.setAttribute("aria-pressed","true"),n(!1),await e())}:g.setItem("sa11y-remember-links-advanced","Off"),o.Readability.Plugin&&(o.Panel.readabilityToggle.onclick=async()=>{"On"===g.getItem("sa11y-remember-readability")?(g.setItem("sa11y-remember-readability","Off"),o.Panel.readabilityToggle.textContent=`${t._("OFF")}`,o.Panel.readabilityToggle.setAttribute("aria-pressed","false"),o.Panel.readability.classList.remove("active"),n(!1),await e()):(g.setItem("sa11y-remember-readability","On"),o.Panel.readabilityToggle.textContent=`${t._("ON")}`,o.Panel.readabilityToggle.setAttribute("aria-pressed","true"),o.Panel.readability.classList.add("active"),n(!1),await e())},"On"===g.getItem("sa11y-remember-readability")&&o.Panel.readability.classList.add("active"));const i=window.matchMedia("(prefers-color-scheme: dark)");i.matches?(o.Panel.themeToggle.textContent=`${t._("ON")}`,o.Panel.themeToggle.setAttribute("aria-pressed","true")):(o.Panel.themeToggle.textContent=`${t._("OFF")}`,o.Panel.themeToggle.setAttribute("aria-pressed","false")),i.addEventListener("change",(()=>{i.matches?(o.Global.html.setAttribute("data-sa11y-theme","dark"),o.Panel.themeToggle.textContent=`${t._("ON")}`,o.Panel.themeToggle.setAttribute("aria-pressed","true"),g.setItem("sa11y-remember-theme","")):(o.Global.html.setAttribute("data-sa11y-theme","light"),o.Panel.themeToggle.textContent=`${t._("OFF")}`,o.Panel.themeToggle.setAttribute("aria-pressed","false"),g.setItem("sa11y-remember-theme",""))})),o.Panel.themeToggle.onclick=async()=>{const e=g.getItem("sa11y-remember-theme");"dark"===e?(o.Global.html.setAttribute("data-sa11y-theme","light"),g.setItem("sa11y-remember-theme","light"),o.Panel.themeToggle.textContent=`${t._("OFF")}`,o.Panel.themeToggle.setAttribute("aria-pressed","false")):"light"===e?(o.Global.html.setAttribute("data-sa11y-theme","dark"),g.setItem("sa11y-remember-theme","dark"),o.Panel.themeToggle.textContent=`${t._("ON")}`,o.Panel.themeToggle.setAttribute("aria-pressed","true")):i.matches?(o.Global.html.setAttribute("data-sa11y-theme","light"),g.setItem("sa11y-remember-theme","light"),o.Panel.themeToggle.textContent=`${t._("OFF")}`,o.Panel.themeToggle.setAttribute("aria-pressed","false")):(o.Global.html.setAttribute("data-sa11y-theme","dark"),g.setItem("sa11y-remember-theme","dark"),o.Panel.themeToggle.textContent=`${t._("ON")}`,o.Panel.themeToggle.setAttribute("aria-pressed","true"))};const a=g.getItem("sa11y-remember-theme");"dark"===a?(o.Global.html.setAttribute("data-sa11y-theme","dark"),g.setItem("sa11y-remember-theme","dark"),o.Panel.themeToggle.textContent=`${t._("ON")}`,o.Panel.themeToggle.setAttribute("aria-pressed","true")):"light"===a&&(o.Global.html.setAttribute("data-sa11y-theme","light"),g.setItem("sa11y-remember-theme","light"),o.Panel.themeToggle.textContent=`${t._("OFF")}`,o.Panel.themeToggle.setAttribute("aria-pressed","false")),o.Global.colourFilterPlugin&&o.Panel.colourFilterSelect.addEventListener("change",(async()=>{const i=parseInt(o.Panel.colourFilterSelect.value,10),a=["protanopia","deuteranopia","tritanopia","monochromacy"],r=[t._("RED_EYE"),t._("GREEN_EYE"),t._("BLUE_EYE"),t._("MONO_EYE")];i>=1&&i<=4?window.matchMedia("(forced-colors: active)").matches?h(t._("COLOUR_FILTER_HIGH_CONTRAST_MESSAGE")):(o.Global.Root.setAttribute("data-sa11y-filter",a[i-1]),o.Panel.colourFilterIcon.setAttribute("aria-label",r[i-1]),y(["data-sa11y-error","data-sa11y-warning","data-sa11y-good","data-sa11y-error-inline","data-sa11y-warning-inline","data-sa11y-overflow"],"document"),v(["sa11y-annotation","sa11y-tooltips","sa11y-heading-label"],"document"),o.Panel.skipButton.disabled=!0,o.Panel.pageIssues.classList.remove("active"),"left"!==o.Global.panelPosition&&"right"!==o.Global.panelPosition||o.Panel.settingsContent.classList.add("hide-settings-border"),o.Panel.colourFilterSelect.classList.add("active"),o.Panel.colourPanel.classList.add("active"),o.Panel.colourPanel.setAttribute("data-colour",a[i-1]),o.Panel.content.hidden=!0):(o.Global.Root.removeAttribute("data-sa11y-filter"),o.Panel.settingsContent.classList.remove("hide-settings-border"),o.Panel.colourFilterSelect.classList.remove("active"),o.Panel.colourPanel.classList.remove("active"),o.Panel.colourPanel.removeAttribute("data-colour"),o.Panel.content.hidden=!1,n(!1),await e())}))}(this.checkAll,this.resetAll),o.Panel.outlineToggle.addEventListener("click",(()=>{"true"===o.Panel.outlineToggle.getAttribute("aria-expanded")?(o.Panel.outlineToggle.classList.remove("outline-active"),o.Panel.outline.classList.remove("active"),o.Panel.outlineToggle.setAttribute("aria-expanded","false"),g.setItem("sa11y-remember-outline","Closed"),document.querySelectorAll("sa11y-heading-label").forEach((e=>e.hidden=!0)),x(o.Panel.outlineList,o.Panel.outlineContent)):(o.Panel.outlineToggle.classList.add("outline-active"),o.Panel.outline.classList.add("active"),o.Panel.outlineToggle.setAttribute("aria-expanded","true"),g.setItem("sa11y-remember-outline","Opened"),g.setItem("sa11y-remember-settings","Closed"),document.querySelectorAll("sa11y-heading-label").forEach((e=>e.hidden=!1))),o.Panel.outlineHeader.focus(),o.Panel.settings.classList.remove("active"),o.Panel.settingsToggle.classList.remove("settings-active"),o.Panel.settingsToggle.setAttribute("aria-expanded","false"),x(o.Panel.outlineList,o.Panel.outlineContent)})),"Opened"===g.getItem("sa11y-remember-outline")&&(o.Panel.outlineToggle.classList.add("outline-active"),o.Panel.outline.classList.add("active"),o.Panel.outlineToggle.setAttribute("aria-expanded","true"),setTimeout((()=>{x(o.Panel.outlineList,o.Panel.outlineContent)}),0)),o.Panel.settingsToggle.addEventListener("click",(()=>{"true"===o.Panel.settingsToggle.getAttribute("aria-expanded")?(o.Panel.settingsToggle.classList.remove("settings-active"),o.Panel.settings.classList.remove("active"),o.Panel.settingsToggle.setAttribute("aria-expanded","false"),g.setItem("sa11y-remember-settings","Closed")):(o.Panel.settingsToggle.classList.add("settings-active"),o.Panel.settings.classList.add("active"),o.Panel.settingsToggle.setAttribute("aria-expanded","true"),g.setItem("sa11y-remember-settings","Opened"),g.setItem("sa11y-remember-outline","Closed")),o.Panel.settingsHeader.focus(),document.querySelectorAll("sa11y-heading-label").forEach((e=>e.hidden=!0)),o.Panel.outline.classList.remove("active"),o.Panel.outlineToggle.classList.remove("outline-active"),o.Panel.outlineToggle.setAttribute("aria-expanded","false"),g.setItem("sa11y-remember-outline","Closed"),o.Panel.settingsContent.clientHeight>350&&(o.Panel.settingsContent.setAttribute("tabindex","0"),o.Panel.settingsContent.setAttribute("aria-label",`${t._("SETTINGS")}`),o.Panel.settingsContent.setAttribute("role","region")),o.Panel.outline.classList.remove("active"),o.Panel.outlineToggle.classList.remove("settings-active"),o.Panel.outlineToggle.setAttribute("aria-expanded","false")})),"Opened"===g.getItem("sa11y-remember-settings")&&(o.Panel.settingsToggle.classList.add("settings-active"),o.Panel.settings.classList.add("active"),o.Panel.settingsToggle.setAttribute("aria-expanded","true")),o.Panel.skipToPageIssues.addEventListener("click",(()=>{o.Panel.pageIssuesHeader.focus()})),setTimeout((()=>{x(o.Panel.pageIssuesList,o.Panel.pageIssuesContent)}),0),o.Panel.controls.addEventListener("keydown",(e=>{const t=o.Panel.panel.querySelectorAll("#outline-toggle[role=tab], #settings-toggle[role=tab]");if("ArrowRight"===e.key)for(let n=0;n<t.length;n++)if("true"===t[n].getAttribute("aria-expanded")||"false"===t[n].getAttribute("aria-expanded")){t[n+1].focus(),e.preventDefault();break}if("ArrowDown"===e.key)for(let n=0;n<t.length;n++)if("true"===t[n].getAttribute("aria-expanded")||"false"===t[n].getAttribute("aria-expanded")){t[n+1].focus(),e.preventDefault();break}if("ArrowLeft"===e.key)for(let n=t.length-1;n>0;n--)if("true"===t[n].getAttribute("aria-expanded")||"false"===t[n].getAttribute("aria-expanded")){t[n-1].focus(),e.preventDefault();break}if("ArrowUp"===e.key)for(let n=t.length-1;n>0;n--)if("true"===t[n].getAttribute("aria-expanded")||"false"===t[n].getAttribute("aria-expanded")){t[n-1].focus(),e.preventDefault();break}})),function(){if(o.Global.colourFilterPlugin&&!1===o.Global.headless){const e=document.createElement("div");e.id="sa11y-colour-filters",e.setAttribute("aria-hidden","true"),e.innerHTML='\n        \x3c!-- DaltonLens SVG filters to simulate color vision deficiencies --\x3e\n        <svg id="sa11y-svg-filters" xmlns="http://www.w3.org/2000/svg">\n          <filter id="sa11y-protanopia" color-interpolation-filters="linearRGB">\n            <feColorMatrix type="matrix" in="SourceGraphic" values="\n                0.10889,0.89111,-0.00000,0,0\n                0.10889,0.89111,0.00000,0,0\n                0.00447,-0.00447,1.00000,0,0\n                0,0,0,1,0"\n            />\n          </filter>\n          <filter id="sa11y-deuteranopia" color-interpolation-filters="linearRGB">\n            <feColorMatrix type="matrix" in="SourceGraphic" values="\n                0.29031,0.70969,-0.00000,0,0\n                0.29031,0.70969,-0.00000,0,0\n                -0.02197,0.02197,1.00000,0,0\n                0,0,0,1,0"\n            />\n          </filter>\n          <filter id="sa11y-tritanopia" color-interpolation-filters="linearRGB">\n            <feColorMatrix type="matrix" in="SourceGraphic" result="ProjectionOnPlane1" values="\n                1.01354, 0.14268, -0.15622, 0, 0\n                -0.01181, 0.87561, 0.13619, 0, 0\n                0.07707, 0.81208, 0.11085, 0, 0\n                7.92482, -5.66475, -2.26007, 1, -0.2"\n            />\n            <feComponentTransfer in="ProjectionOnPlane1" result="ProjectionOnPlane1">\n                <feFuncA type="discrete" tableValues="0 0 0 0 1"/>\n            </feComponentTransfer>\n            <feColorMatrix type="matrix" in="SourceGraphic" result="ProjectionOnPlane2" values="\n                0.93337, 0.19999, -0.13336, 0, 0\n                0.05809, 0.82565, 0.11626, 0, 0\n                -0.37923, 1.13825, 0.24098, 0, 0\n                0,0,0,1,0"\n            />\n            <feBlend in="ProjectionOnPlane1" in2="ProjectionOnPlane2" mode="normal"/>\n          </filter>\n          <filter id="sa11y-monochromacy">\n            <feColorMatrix values="0.33 0.33 0.33 0 0                           0.33 0.33 0.33 0 0                           0.33 0.33 0.33 0 0                           0 0 0 1 0"></feColorMatrix>\n          </filter>\n        </svg>',document.body.appendChild(e)}}(),E(p.detectSPArouting,this.checkAll,this.resetAll),this.dismissTooltip=new jt,document.body.appendChild(this.dismissTooltip),o.Panel.toggle.disabled=!1,this.checkAll(),e=this.checkAll,n=this.resetAll,o.Panel.toggle.addEventListener("click",(t=>{"Opened"===g.getItem("sa11y-remember-panel")?(t.preventDefault(),g.setItem("sa11y-remember-panel","Closed"),o.Panel.toggle.classList.remove("on"),o.Panel.toggle.setAttribute("aria-expanded","false"),n(),0===o.Panel.notifCount.innerHTML.trim().length?o.Panel.notifBadge.style.display="none":o.Panel.notifBadge.style.display="flex"):(t.preventDefault(),g.setItem("sa11y-remember-panel","Opened"),o.Panel.toggle.classList.add("on"),o.Panel.toggle.setAttribute("aria-expanded","true"),e(),x(o.Panel.outlineList,o.Panel.outlineContent))})),"Opened"===g.getItem("sa11y-remember-panel")&&(o.Panel.toggle.classList.add("on"),o.Panel.toggle.setAttribute("aria-expanded","true"),o.Panel.panel.style.transform=""),document.onkeydown=e=>{const t=e||window.event;t.altKey&&"KeyA"===t.code&&(o.Panel.toggle.click(),o.Panel.toggle.focus())}}var e,n},"complete"===document.readyState?e():window.addEventListener("load",e))},this.checkAll=async()=>{try{this.results=[],this.headingOutline=[],this.errorCount=0,this.warningCount=0;if(document.querySelector(p.checkRoot)||h(`${t.sprintf("ERROR_MISSING_ROOT_TARGET",p.checkRoot)}`),o.initializeShadowSearch(p),A.initializeElements(p.linksToFlag),dn(this.results,p,this.headingOutline),cn(this.results,p),ln(this.results,p),function(e,n){if(n.contrastPlugin&&("On"===g.getItem("sa11y-remember-contrast")||n.headless||n.checkAllHideToggles)){let n={errors:[],warnings:[]};const o={parseRgb(e){let t,n,o,i,a;if(n=e.match(/rgb\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*\)/)){for(o=n.slice(1,4),t=i=0;i<=2;t=++i)o[t]=+o[t];o[3]=1}else if(n=e.match(/rgba\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*,\s*([01]|[01]?\.\d+)\)/))for(o=n.slice(1,5),t=a=0;a<=3;t=++a)o[t]=+o[t];return o},relativeLuminance(e){const t=[];for(let n=0;n<3;n++){const o=e[n]/255;t.push(o<.03928?o/12.92:Math.pow((o+.055)/1.055,2.4))}return.2126*t[0]+.7152*t[1]+.0722*t[2]},contrastRatio(e,t){const n=o.relativeLuminance(o.parseRgb(e)),i=o.relativeLuminance(o.parseRgb(t));return(Math.max(n,i)+.05)/(Math.min(n,i)+.05)},getBackground(e){if(11===e.nodeType){const t=e.getRootNode().host.parentNode;if(null===t)return"alpha";e=t}const t=getComputedStyle(e),n=t.backgroundColor,i=t.backgroundImage,a=`${o.parseRgb(n)}`.split(",");return a[3]<1&&a[3]>0?"alpha":"rgba(0, 0, 0, 0)"!==n&&"transparent"!==n&&"none"===i&&"0"!==a[3]?n:"none"!==i?"image":"HTML"===e.tagName?"rgb(255, 255, 255)":o.getBackground(e.parentNode)},check(){n={errors:[],warnings:[]};for(let e=0;e<A.Found.Contrast.length;e++){const t=A.Found.Contrast[e];if(A.Found.Contrast){const e=getComputedStyle(t),{color:i}=e,{fill:a}=e,r=parseInt(e.fontSize,10)*(3/4),{fontWeight:s}=e,l=t.tagName,d=o.getBackground(t),c=[].reduce.call(t.childNodes,((e,t)=>e+(3===t.nodeType?t.textContent:"")),"").trim(),p=window.getComputedStyle(t).clip.replace(/\s/g,""),u=parseFloat(window.getComputedStyle(t).width),g=parseFloat(window.getComputedStyle(t).height);let m,f,b;if(1!==u||1!==g||"rect(0,0,0,0)"!==p&&"rect(1px,1px,1px,1px)"!==p)if("SVG"===l)m=Math.round(100*o.contrastRatio(a,d))/100,m<3&&(f={elem:t,ratio:`${m}:1`},n.errors.push(f));else if(c.length||"INPUT"===l||"SELECT"===l||"TEXTAREA"===l){const e=t.getAttribute("type");"range"===e||"color"===e||("image"===d||"alpha"===d?(b={elem:t},n.warnings.push(b)):(m=Math.round(100*o.contrastRatio(i,d))/100,r>=18||r>=14&&s>=700?m<3&&(f={elem:t,ratio:`${m}:1`},n.errors.push(f)):m<4.5&&(f={elem:t,ratio:`${m}:1`},n.errors.push(f))))}}}return n}};o.check(),n.errors.forEach((n=>{const o=n.elem,i=n.ratio,a=s(c(o.cloneNode(!0),"script, style").textContent);"INPUT"===o.tagName?e.push({element:o,type:"error",content:t.sprintf("CONTRAST_INPUT_ERROR",i),inline:!1,position:"beforebegin"}):e.push({element:o,type:"error",content:t.sprintf("CONTRAST_ERROR",i,a),inline:!1,position:"beforebegin"})})),n.warnings.forEach((n=>{const o=n.elem,i=c(o.cloneNode(!0),"script, style").textContent,a=f(`CONTRAST${i}`),r=s(i);e.push({element:o,type:"warning",content:t.sprintf("CONTRAST_WARNING",r),inline:!1,position:"beforebegin",dismiss:a})}))}}(this.results,p),function(e,n){n.formLabelsPlugin&&("On"===g.getItem("sa11y-remember-labels")||n.headless||n.checkAllHideToggles)&&A.Found.Inputs.forEach((n=>{const o="true"===n.getAttribute("aria-hidden"),i="-1"===n.getAttribute("tabindex");if(a(n)||o&&i)return;const r=d(sn(n)),l=n.getAttribute("alt"),c=n.getAttribute("type"),p=n.getAttribute("title"),u=n.getAttribute("aria-label")||n.getAttribute("aria-labelledby");if("submit"===c||"button"===c||"hidden"===c)return;if("image"===c&&(!l||" "===l))return void(u||p||e.push({element:n,type:"error",content:t.sprintf("LABELS_MISSING_IMAGE_INPUT_MESSAGE"),inline:!1,position:"beforebegin"}));if("reset"===c){const o=f(`INPUT${r}`);return void e.push({element:n,type:"warning",content:t.sprintf("LABELS_INPUT_RESET_MESSAGE"),inline:!1,position:"beforebegin",dismiss:o})}if(u||p){if(0===r.length)e.push({element:n,type:"error",content:t.sprintf("LABELS_MISSING_LABEL_MESSAGE"),inline:!1,position:"beforebegin"});else{const o=f(`INPUT${r}`),i=s(r);e.push({element:n,type:"warning",content:t.sprintf("LABELS_ARIA_LABEL_INPUT_MESSAGE",i),inline:!1,position:"beforebegin",dismiss:o})}return}const g=n.closest("label"),m=g?d(sn(g)):"";if(g&&m.length)return;const b=n.getAttribute("id");b?A.Found.Labels.some((e=>e.getAttribute("for")===b))||e.push({element:n,type:"error",content:t.sprintf("LABELS_NO_FOR_ATTRIBUTE_MESSAGE",b),inline:!1,position:"beforebegin"}):e.push({element:n,type:"error",content:t.sprintf("LABELS_MISSING_LABEL_MESSAGE"),inline:!1,position:"beforebegin"})}))}(this.results,p),function(e,n){if(n.badLinksQA&&A.Found.CustomErrorLinks.forEach((n=>{e.push({element:n,type:"error",content:t.sprintf("QA_BAD_LINK",n),inline:!0,position:"beforebegin"})})),n.strongItalicsQA&&A.Found.StrongItalics.forEach((n=>{const o=n.textContent.trim().length,i=f(n.tagName+n.textContent);o>400&&e.push({element:n.parentNode,type:"warning",content:t.sprintf("QA_BAD_ITALICS"),inline:!1,position:"beforebegin",dismiss:i})})),A.Found.Links.forEach((i=>{const a=i.getAttribute("href"),r=o.Global.documentLinks.split(", ");if(a){const o=r.some((e=>a.includes(e))),s=a.includes(".pdf"),l=f(`DOCUMENT${a}`);n.documentQA&&o?e.push({element:i,type:"warning",content:t.sprintf("QA_DOCUMENT"),inline:!0,position:"beforebegin",dismiss:l}):n.pdfQA&&s&&e.push({element:i,type:"warning",content:t.sprintf("QA_PDF"),inline:!0,position:"beforebegin",dismiss:l})}})),n.langQA&&(!A.Found.Language||A.Found.Language.length<2)&&e.push({type:"error",content:t.sprintf("QA_PAGE_LANGUAGE")}),n.blockquotesQA&&A.Found.Blockquotes.forEach((n=>{const o=n.textContent;if(o.trim().length<25){const i=s(o),a=f(`BLOCKQUOTE${i}`);e.push({element:n,type:"warning",content:t.sprintf("QA_BLOCKQUOTE_MESSAGE",i),inline:!1,position:"beforebegin",dismiss:a})}})),n.tablesQA&&A.Found.Tables.forEach((o=>{const i=o.querySelectorAll("th"),a=o.querySelectorAll("h1, h2, h3, h4, h5, h6");n.tablesQAmissingTH&&0===i.length&&e.push({element:o,type:"error",content:t.sprintf("TABLES_MISSING_HEADINGS"),inline:!1,position:"beforebegin"}),n.tablesQAsemanticHeadings&&a.length>0&&a.forEach((n=>{e.push({element:n,type:"error",content:t.sprintf("TABLES_SEMANTIC_HEADING"),inline:!1,position:"beforebegin"})})),i.forEach((i=>{if(n.tablesQAemptyTH&&0===i.textContent.trim().length){const a=n.tablesQAemptyTHisError?"error":"warning",r=f(`TABLE${o.textContent}`);e.push({element:i,type:a,content:t.sprintf("TABLES_EMPTY_HEADING"),inline:!1,position:"afterbegin",dismiss:r})}}))})),n.fakeHeadingsQA){const n='h1, h2, h3, h4, h5, h6, [role="heading"][aria-level], blockquote, table',o=o=>{const i=getComputedStyle(o).fontSize.replace("px",""),a=l(o),r=null===a.match(/[.;?!"]/),d=a.length>=4&&a.length<=120;if(i>=24&&!o.closest(n)&&d&&r){const n=s(a),i=f(`BOLD${n}`);e.push({element:o,type:"warning",content:t.sprintf("QA_FAKE_HEADING",n),inline:!1,position:"beforebegin",dismiss:i})}},i=o=>{if(/^(<strong>|<b>)/i.test(o.innerHTML.trim())&&!o.closest(n)){const n=o.querySelector("strong, b"),i=l(n),a=null===i.match(/[.:;?!"']/);if(i.length>=3&&i.length<=120&&a){const a=c(o,"strong, bold").textContent.trim().length;if(0!==a&&a<=250)return;const r=s(i),l=f(`BOLD${r}`);e.push({element:n,type:"warning",content:t.sprintf("QA_FAKE_HEADING",r),inline:!1,position:"beforebegin",dismiss:l})}}};A.Found.Paragraphs.forEach((e=>{o(e),i(e)}))}let i="",a="",r=!1;const d={2:"1",b:"a",B:"A","β":"α","Β":"Α","б":"а","Б":"А"},p=new RegExp(/([aA1]|[аА]|[αΑ]|[^\p{Alphabetic}\s])[-\s.)]/,"u"),u=new RegExp(/\p{Emoji}/,"u"),g=/[([{#]/,m=e=>e.replace(/^b|^B|^б|^Б|^β|^В|^2/,(e=>d[e]));if(A.Found.Paragraphs.forEach(((n,o)=>{let s=!1,d=!1;const c=a||l(n).substring(0,2),b=c.match(p),h=g.test(c.charAt(0)),y=b||c.match(u)||h;if(c.length>0&&c!==i&&y){const a=A.Found.Paragraphs[o+1];if(a){if(s=l(a).substring(0,2),"A"===s)return;const e=m(s);b?(r=!1,"A "!==c&&c===e&&(d=!0)):r||(e.match(u)&&(d=!0),r=d)}if(!d){let e=n?.querySelector("br")?.nextSibling?.nodeValue;e&&(e=e.replace(/<\/?[^>]+(>|$)/g,"").trim().substring(0,2),(h||c===m(e)||!b&&!r&&e.match(u))&&(d=!0))}if(d){const o=f(`LIST${n.textContent}`);e.push({element:n,type:"warning",content:t.sprintf("QA_SHOULD_BE_LIST",c),inline:!1,position:"beforebegin",dismiss:o}),i=c}else i=""}a=s?"":s})),n.allCapsQA){const n=n=>{let o="";"LI"===n.tagName?n.childNodes.forEach((e=>{3===e.nodeType&&(o+=e.textContent)})):o=l(n);const i=o.match(/([A-Z]{2,}[ ])([A-Z]{2,}[ ])([A-Z]{2,}[ ])([A-Z]{2,})/g);if(i&&i[0].length>10){const i=f(`UPPERCASE${o}`);e.push({element:n,type:"warning",content:t.sprintf("QA_UPPERCASE_WARNING"),inline:!1,position:"beforebegin",dismiss:i})}};A.Found.Paragraphs.forEach((e=>n(e))),A.Found.Headings.forEach((e=>n(e))),A.Found.Lists.forEach((e=>n(e))),A.Found.Blockquotes.forEach((e=>n(e)))}if(n.duplicateIdQA){const n={};A.Found.Ids.forEach((o=>{const{id:i}=o;i&&(void 0===n[i]?n[i]=1:e.push({element:o,type:"error",content:t.sprintf("QA_DUPLICATE_ID",i),inline:!0,position:"beforebegin"}))}))}if(n.underlinedTextQA){A.Found.Underlines.forEach((n=>{const o=f(`UNDERLINE${l(n)}`);e.push({element:n,type:"warning",content:t.sprintf("QA_TEXT_UNDERLINE_WARNING"),inline:!0,position:"beforebegin",dismiss:o})}));const n=n=>{const o=getComputedStyle(n).textDecorationLine,i=l(n);if("underline"===o){const o=f(`UNDERLINE${i}`);e.push({element:n,type:"warning",content:t.sprintf("QA_TEXT_UNDERLINE_WARNING"),inline:!1,position:"beforebegin",dismiss:o})}};A.Found.Paragraphs.forEach((e=>n(e))),A.Found.Headings.forEach((e=>n(e))),A.Found.Lists.forEach((e=>n(e))),A.Found.Blockquotes.forEach((e=>n(e))),A.Found.Spans.forEach((e=>n(e)))}if(n.pageTitleQA){const n=document.querySelector("head title");n&&0!==n.textContent.trim().length||e.push({type:"error",content:t.sprintf("QA_PAGE_TITLE")})}n.subscriptQA&&A.Found.Subscripts.forEach((n=>{const o=l(n);if(o.length>=80){const i=f(n.tagName+o);e.push({element:n,type:"warning",content:t.sprintf("QA_SUBSCRIPT_WARNING"),inline:!0,position:"beforebegin",dismiss:i})}}))}(this.results,p),function(e,n){n.embeddedContentAll&&(n.embeddedContentAudio&&A.Found.Audio.forEach((n=>{const o=f(`AUDIO${"undefined"!==n.getAttribute("src")?n.getAttribute("src"):n.querySelector("[src]")?.getAttribute("src")}`);e.push({element:n,type:"warning",content:t.sprintf("EMBED_AUDIO"),inline:!1,position:"beforebegin",dismiss:o})})),n.embeddedContentVideo&&A.Found.Videos.forEach((n=>{const o="undefined"!==n.getAttribute("src")?n.getAttribute("src"):n.querySelector("[src]")?.getAttribute("src"),i=n.querySelector("track"),a=i?.getAttribute("src");if(null===i||null===a||0===a.trim().length){const i=f(`VIDEO${o}`);e.push({element:n,type:"warning",content:t.sprintf("EMBED_VIDEO"),inline:!1,position:"beforebegin",dismiss:i})}})),n.embeddedContentDataViz&&A.Found.Visualizations.forEach((n=>{const o=f(`DATAVIZ${"undefined"!==n.getAttribute("src")?n.getAttribute("src"):n.querySelector("[src]")?.getAttribute("src")}`);e.push({element:n,type:"warning",content:t.sprintf("EMBED_DATA_VIZ"),inline:!1,position:"beforebegin",dismiss:o})})),n.embeddedContentTitles&&A.Found.iframes.forEach((n=>{const o=a(n),i="VIDEO"===n.tagName||"AUDIO"===n.tagName,r="true"===n.getAttribute("aria-hidden"),s="-1"===n.getAttribute("tabindex");if(o||i||r&&s)return;if(s)return void e.push({element:n,type:"error",content:t.sprintf("EMBED_UNFOCUSABLE"),inline:!1,position:"beforebegin"});const l=rn(n);0===d("noAria"===l?n.getAttribute("title")||"":l).length&&e.push({element:n,type:"error",content:t.sprintf("EMBED_MISSING_TITLE"),inline:!1,position:"beforebegin"})})),n.embeddedContentGeneral&&A.Found.EmbeddedContent.forEach((n=>{const o="true"===n.getAttribute("aria-hidden"),i="-1"===n.getAttribute("tabindex");if(a(n)||o&&i)return;if("VIDEO"===n.tagName||"AUDIO"===n.tagName)return;const r=f(`IFRAME${"undefined"!==n.getAttribute("src")?n.getAttribute("src"):n.querySelector("[src]")?.getAttribute("src")}`);e.push({element:n,type:"warning",content:t.sprintf("EMBED_GENERAL_WARNING"),inline:!1,position:"beforebegin",dismiss:r})})))}(this.results,p),function(){let e;if(o.Readability.Plugin&&"On"===g.getItem("sa11y-remember-readability")){A.Found.Readability.forEach((e=>{const t=e.textContent;t.length>=120&&"."!==t.charAt(t.length-1)&&e.insertAdjacentHTML("beforeend","<span data-sa11y-readability-period>.</span>")}));const n=[];for(let e=0;e<A.Found.Readability.length;e++){const t=l(c(A.Found.Readability[e]));""!==t&&n.push(t)}const i=n.join(" ").toString();if(["en","es","fr","de","nl","it","pt"].includes(o.Readability.Lang)){const n=e=>{let t=e;if(t=t.toLowerCase().replace(".","").replace("\n",""),t.length<=3)return 1;t=t.replace(/(?:[^laeiouy]es|ed|[^laeiouy]e)$/,""),t=t.replace(/^y/,"");const n=t.match(/[aeiouy]{1,2}/g);let o=0;return!!n&&(o=n.length),o},a=i.replace(/[.!?-]+/g," ").split(" ");let r=0;for(let e=0;e<a.length;e++)0!=a[e]&&(r+=1);const s=i.split(/[.!?]+/);let l=0;for(let e=0;e<s.length;e++)""!==s[e]&&(l+=1);let d=0,c=0,p=0;for(let e=0;e<a.length;e++)if(0!=a[e]){const t=n(a[e]);1===t&&(c+=1),2===t&&(p+=1),d+=t}let u=!1;"en"===o.Readability.Lang?u=206.835-r/l*1.015-d/r*84.6:"fr"===o.Readability.Lang?u=207-r/l*1.015-d/r*73.6:"es"===o.Readability.Lang?u=206.84-r/l*1.02-d/r*100*.6:"de"===o.Readability.Lang?u=180-r/l-d/r*58.5:"nl"===o.Readability.Lang?u=206.84-d/r*100*.77-r/l*.93:"it"===o.Readability.Lang?u=217-r/l*1.3-d/r*100*.6:"pt"===o.Readability.Lang&&(u=248.835-r/l*1.015-d/r*84.6),u>100?u=100:u<0&&(u=0);const g=u.toFixed(1),m=(r/l).toFixed(1),f=Math.round((r-(c+p))/r*100);let b;b=g>=0&&g<30?t._("LANG_VERY_DIFFICULT"):g>31&&g<49?t._("LANG_DIFFICULT"):g>50&&g<60?t._("LANG_FAIRLY_DIFFICULT"):t._("LANG_GOOD"),e={score:g,averageWordsPerSentence:m,complexWords:f,difficultyLevel:b,wordCount:r}}else if(["sv","fi","da","no","nb","nn"].includes(o.Readability.Lang)){const n=(e=>{const n=()=>e.replace(/[-'.]/gi,"").split(/[^a-zA-ZöäåÖÄÅÆæØø0-9]/g).filter(Boolean),o=n().length,i=n().filter((e=>e.length>6)).length,a=e.split(/\?|!|\.|\n/g).filter(Boolean).length,r=Math.round(o/a+100*i/o),s=(o/a).toFixed(1),l=Math.round(i/o*100);let d;return d=r>=0&&r<39?t._("LANG_GOOD"):r>40&&r<50?t._("LANG_FAIRLY_DIFFICULT"):r>51&&r<61?t._("LANG_DIFFICULT"):t._("LANG_VERY_DIFFICULT"),{score:r,difficulty:d,avgWordsPerSentence:s,complexWords:l,wordCount:o}})(i);e={score:n.score,averageWordsPerSentence:n.avgWordsPerSentence,complexWords:n.complexWords,difficultyLevel:n.difficulty,wordCount:n.wordCount}}!1===o.Global.headless&&(0===i.length?o.Panel.readabilityInfo.innerHTML=t._("READABILITY_NO_P_OR_LI_MESSAGE"):e.wordCount>30?(o.Panel.readabilityInfo.innerHTML=`${e.score} <span class="readability-score">${e.difficultyLevel}</span>`,o.Panel.readabilityDetails.innerHTML=`\n            <li>\n              <strong>${t._("LANG_AVG_SENTENCE")}</strong>\n              ${e.averageWordsPerSentence}\n            </li>\n            <li>\n              <strong>${t._("LANG_COMPLEX_WORDS")}</strong>\n              ${e.complexWords}%\n            </li>\n            <li>\n              <strong>${t._("LANG_TOTAL_WORDS")}</strong>\n              ${e.wordCount}\n            </li>`):o.Panel.readabilityInfo.textContent=t._("READABILITY_NOT_ENOUGH_CONTENT_MESSAGE"))}}(),p.customChecks&&function(e){const t="More than one Announcement component found! The Announcement component should be used strategically and sparingly. It should be used to get attention or indicate that something is important. Misuse of this component makes it less effective or impactful. Secondly, this component is semantically labeled as an Announcement for people who use screen readers.",n="Do <strong>not nest forms</strong> within the Accordion component. If the form contains validation issues, a person may not see the form feedback since the accordion panel goes back to its original closed state.",o=i(".sa11y-announcement-component","root");if(o.length>1)for(let n=1;n<o.length;n++){const i=f(o[n].textContent);e.push({element:o[n],type:"warning",content:t,inline:!1,position:"beforebegin",dismiss:i})}i(".sa11y-accordion-example","root").forEach((t=>{const o=t.querySelector("form");o&&o.length&&e.push({element:t,type:"error",content:n,inline:!1,position:"beforebegin"})}))}(this.results),this.results=this.results.filter((e=>!1!==e.isWithinRoot)),this.results.forEach((e=>{const t=p.selectorPath?function(e){const t=[];let n=e;for(;n;){let e=n.localName;if(n.id){e+=`#${n.id}`,t.unshift(e);break}n.className&&(e+=`.${n.className.replace(/\s+/g,".")}`);const o=n.parentNode;if(!o)break;{const i=o.children;i.length>1&&(e+=`:nth-child(${Array.prototype.indexOf.call(i,n)+1})`),t.unshift(e)}n=n.parentNode.host||n.parentNode}return t.join(" > ")}(e.element):"",n=e.element?.outerHTML.replace(/\s{2,}/g," ").trim()||"";Object.assign(e,{htmlPath:n,cssPath:t})})),!1===p.headless){const i=function(e,n){let i=g.getItem("sa11y-dismissed");i=i?JSON.parse(i):[];const a=i.map((t=>{const n=e.find((e=>t.key.includes(e.dismiss)&&t.href===window.location.pathname));return void 0===n?"":n})),r=e.filter((e=>!a.find((t=>t.dismiss===e.dismiss)))),s=e.filter((e=>a.find((t=>t.dismiss===e.dismiss)))),l=s.length;return l>=1?(o.Panel.dismissButton.classList.add("active"),o.Panel.dismissTooltip.innerText=t.sprintf("PANEL_DISMISS_BUTTON",l),n.object.setContent(t.sprintf("PANEL_DISMISS_BUTTON",l))):o.Panel.dismissButton.classList.remove("active"),{dismissedIssues:i,updatedResults:r,dismissCount:l,dismissedResults:s}}(this.results,this.dismissTooltip,this.checkAll,this.resetAll);this.results=i.updatedResults,this.dismissed=i.dismissedIssues;const a=function(e,t,n){let o=t,i=n;return e.forEach(((t,n)=>{const a=e[n].type;"error"===a?o+=1:"warning"===a&&(i+=1)})),{error:o,warning:i}}(this.results,this.errorCount,this.warningCount);if(function(e,n){const i=e+n;0===i?(o.Panel.notifCount.innerText="",o.Panel.notifText.innerText="",o.Panel.notifBadge.style.display="none"):n>0&&0===e?(o.Panel.notifBadge.classList.add("notification-badge-warning"),o.Panel.notifCount.innerText=`${n}`,o.Panel.notifText.innerText=`${t._("PANEL_ICON_WARNINGS")}`):(o.Panel.notifBadge.classList.remove("notification-badge-warning"),o.Panel.notifCount.innerText=`${i}`,o.Panel.notifText.innerText=t._("PANEL_ICON_TOTAL")),"Opened"===g.getItem("sa11y-remember-panel")||0===i?o.Panel.notifBadge.style.display="none":o.Panel.notifBadge.style.display="flex"}(a.error,a.warning),"Opened"===g.getItem("sa11y-remember-panel")){this.results.forEach(((e,n)=>{Object.assign(e,{id:n}),function(e,n,i,a=!1,s,l,d,c){const p=["error","warning","good"];if(-1===p.indexOf(n))throw Error(`Invalid type [${n}] for annotation`);[n].forEach((t=>{if("error"===t&&void 0!==e){const t=a?"data-sa11y-error-inline":"data-sa11y-error";e.setAttribute(t,l)}else if("warning"===t&&void 0!==e){const t=a?"data-sa11y-warning-inline":"data-sa11y-warning";e.setAttribute(t,l)}}));const u={[p[0]]:t._("ERROR"),[p[1]]:t._("WARNING"),[p[2]]:t._("GOOD")},g=!0===c&&"warning"===n&&void 0!==d?`<button data-sa11y-dismiss='${l}' type='button'>${t._("DISMISS")}</button>`:"",m=document.createElement("sa11y-annotation");m.setAttribute("data-sa11y-annotation",l);const f=document.createElement("div"),b=document.createElement("li");void 0===e?(o.Panel.pageIssues.classList.add("active"),o.Panel.panel.classList.add("has-page-issues"),b.innerHTML=`<strong>${u[n]}</strong> ${i}${g}`,o.Panel.pageIssuesList.insertAdjacentElement("afterbegin",b)):(f.classList.add(a?"instance-inline":"instance"),f.innerHTML=`\n    <button\n      type="button"\n      aria-label="${u[n]}"\n      aria-haspopup="dialog"\n      class="sa11y-btn ${[n]}-btn${a?"-text":""}"\n      data-tippy-content=\n        "<div lang='${t._("LANG_CODE")}'>\n          <button type='button' class='close-btn close-tooltip' aria-label='${t._("ALERT_CLOSE")}'></button>\n          <div class='header-text'><h2>${u[n]}</h2></div>\n          ${r(i)}\n          ${g}\n        </div>"\n    ></button>`,(e.closest("a, button")||e).insertAdjacentElement(s,m),m.shadowRoot.appendChild(f))}(e.element,e.type,e.content,e.inline,e.position,e.id,e.dismiss,p.dismissAnnotations)})),A.initializeAnnotations();const s=new zt;document.body.appendChild(s),I(this.results,this.dismissed,this.checkAll,this.resetAll),D(this.dismissed,this.headingOutline,p.showHinPageOutline),u=i.dismissCount,m=a.error,b=a.warning,o.Panel.skipButton.disabled=!1,o.Panel.panel.classList.add("active"),o.Global.html.setAttribute("data-sa11y-active","true"),o.Panel.skipButton.classList.add("active"),m>0&&b>0?(o.Panel.content.setAttribute("class","errors"),o.Panel.status.innerHTML=`${t._("ERRORS")} <span class="panel-count">${m}</span> ${t._("WARNINGS")} <span class="panel-count" id="warning-count">${b}</span>`):m>0?(o.Panel.content.setAttribute("class","errors"),o.Panel.status.innerHTML=`${t._("ERRORS")} <span class="panel-count">${m}</span>`):b>0?(o.Panel.content.setAttribute("class","warnings"),o.Panel.status.innerHTML=`${t._("WARNINGS")} <span class="panel-count" id="warning-count">${b}</span>`):u>0?(o.Panel.status.innerHTML=`${t._("DISMISSED")} <span class="panel-count">${u}</span>`,o.Panel.skipButton.classList.remove("active")):(o.Panel.content.setAttribute("class","good"),o.Panel.status.innerHTML=`${t._("PANEL_STATUS_NONE")}`),0===document.querySelectorAll("sa11y-annotation").length&&(o.Panel.skipButton.disabled=!0),nn(this.results),p.exportResultsPlugin&&(e=this.results,n=i.dismissedResults,o.Global.exportResultsPlugin&&(O=()=>{S(e,n)},C=()=>{P(e)},o.Panel.exportHTML.addEventListener("click",O),o.Panel.exportCSV.addEventListener("click",C))),Wt(),document.querySelectorAll("sa11y-annotation").forEach((e=>{const t=e.nextElementSibling;null!==t&&"SA11Y-ANNOTATION"===t.tagName&&customElements.get("sa11y-annotation")&&t.shadowRoot.querySelector("button").setAttribute("style","margin: -5px -15px !important;")}))}}const y=new CustomEvent("sa11y-check-complete",{detail:{results:this.results,page:window.location.pathname}});document.dispatchEvent(y)}catch(e){const t=new N(e);document.body.appendChild(t),console.error(e)}var e,n,u,m,b},this.resetAll=(e=!0)=>{for(o.Global.html.removeAttribute("data-sa11y-active"),y(["data-sa11y-parent","data-sa11y-error","data-sa11y-warning","data-sa11y-good","data-sa11y-error-inline","data-sa11y-warning-inline","data-sa11y-overflow","data-sa11y-pulse-border","data-sa11y-filter"],"document"),v(["sa11y-annotation","sa11y-heading-label","sa11y-heading-anchor","sa11y-tooltips","[data-sa11y-readability-period]","[data-sa11y-clone-image-text]",".sa11y-css-utilities"],"document"),o.Panel.outlineList.innerHTML="",o.Panel.pageIssuesList.innerHTML="",o.Panel.readabilityInfo.innerHTML="",o.Panel.readabilityDetails.innerHTML="",o.Panel.panel.classList.remove("has-page-issues"),o.Panel.pageIssues.classList.remove("active"),b(),document.removeEventListener("keydown",en),o.Panel.skipButton.removeEventListener("click",tn),o.Global.exportResultsPlugin&&(o.Panel.exportHTML.removeEventListener("click",O),o.Panel.exportCSV.removeEventListener("click",C)),o.Panel.panel?.removeEventListener("click",k),o.Panel.dismissButton?.removeEventListener("click",L),o.Global.colourFilterPlugin&&(o.Panel.colourFilterSelect.value=0,o.Panel.colourPanel.classList.remove("active"),o.Panel.colourFilterSelect.classList.remove("active"),o.Panel.content.hidden=!1);o.Panel.status.firstChild;)o.Panel.status.removeChild(o.Panel.status.firstChild);e&&o.Panel.panel.classList.remove("active")},this.initialize()}}export{t as Lang,pn as Sa11y};
