
/*!
  * Sa11y, the accessibility quality assurance assistant.
  * @version 3.1.1
  * @author Adam Chaboryk, Toronto Metropolitan University
  * @license GPL-2.0-or-later
  * @copyright © 2020 - 2024 Toronto Metropolitan University (formerly Ryerson University).
  * @contact adam.chaboryk@torontomu.ca
  * GitHub: git+https://github.com/ryersondmp/sa11y.git | Website: https://sa11y.netlify.app
  * For all acknowledgements, please visit: https://sa11y.netlify.app/acknowledgements/
  * The above copyright notice shall be included in all copies or substantial portions of the Software.
**/
/*! WARNING: This is a machine-generated translation and may contain errors or inaccuracies. */
var id = {
  // Indonesian
  strings: {
    LANG_CODE: 'id',
    MAIN_TOGGLE_LABEL: 'Periksa Aksesibilitas',
    CONTAINER_LABEL: 'Pemeriksa Aksesibilitas',
    ERROR: 'Kesalahan',
    ERRORS: 'Kesalahan',
    WARNING: 'Peringatan',
    WARNINGS: 'Peringatan',
    GOOD: 'Bagus.',
    ON: 'Pada',
    OFF: 'Mati',
    ALERT_TEXT: 'Waspada',
    ALERT_CLOSE: 'Tutup',
    OUTLINE: 'Garis Besar Halaman',
    PAGE_ISSUES: 'Masalah Halaman',
    SETTINGS: 'Pengaturan',
    CONTRAST: 'Kontras',
    FORM_LABELS: 'Label formulir',
    LINKS_ADVANCED: 'Tautan (Lanjutan)',
    DARK_MODE: 'Mode gelap',
    SHORTCUT_SCREEN_READER: 'Loncat ke masalah. Pintasan papan ketik: Alt S',
    SHORTCUT_TOOLTIP: 'Loncat ke masalah',
    NEW_TAB: 'Membuka tab baru',
    PANEL_HEADING: 'Pemeriksaan aksesibilitas',
    PANEL_STATUS_NONE: 'Tidak ditemukan kesalahan.',
    PANEL_ICON_WARNINGS: 'peringatan ditemukan.',
    PANEL_ICON_TOTAL: 'total masalah yang ditemukan.',
    NOT_VISIBLE_ALERT: 'Item yang ingin Anda lihat tidak terlihat; item tersebut mungkin tersembunyi atau berada di dalam komponen akordeon atau tab. Berikut ini adalah pratinjau:',
    ERROR_MISSING_ROOT_TARGET: 'Halaman penuh diperiksa aksesibilitasnya karena area target <kode>%(root)</kode> tidak ada.',
    HEADING_NOT_VISIBLE_ALERT: 'Judul tidak terlihat; judul mungkin tersembunyi atau berada di dalam komponen akordeon atau tab.',
    SKIP_TO_PAGE_ISSUES: 'Loncat ke Halaman Masalah',
    CONSOLE_ERROR_MESSAGE: 'Maaf, ada masalah dengan pemeriksa aksesibilitas di halaman ini. Bisakah Anda <a href="%(link)">melaporkannya melalui formulir ini</a> atau di <a href="%(link)">GitHub</a>?',

    // Dismiss
    PANEL_DISMISS_BUTTON: 'Tampilkan %(dismissCount) peringatan yang diberhentikan',
    DISMISS: 'Bubarkan.',
    DISMISSED: 'Peringatan yang diabaikan',
    DISMISS_REMINDER: 'Harap diperhatikan bahwa peringatan hanya bersifat <strong>sementara</strong>. Menghapus riwayat browser dan cookie Anda akan mengembalikan semua peringatan yang sebelumnya diberhentikan di semua halaman.',

    // Export
    DATE: 'Tanggal',
    PAGE_TITLE: 'Judul Halaman',
    RESULTS: 'Hasil',
    EXPORT_RESULTS: 'Ekspor hasil',
    GENERATED: 'Hasil dihasilkan dengan %(tool).',
    PREVIEW: 'Pratinjau',
    ELEMENT: 'Elemen',
    PATH: 'Jalur',

    // Colour filters
    COLOUR_FILTER: 'Filter warna',
    PROTANOPIA: 'Protanopia',
    DEUTERANOPIA: 'Deuteranopia',
    TRITANOPIA: 'Tritanopia',
    MONOCHROMACY: 'Monokromasi',
    COLOUR_FILTER_MESSAGE: 'Periksa elemen yang sulit dilihat atau dibedakan dari warna lainnya.',
    RED_EYE: 'Merah buta.',
    GREEN_EYE: 'Hijau buta.',
    BLUE_EYE: 'Biru buta.',
    MONO_EYE: 'Buta merah, biru, dan hijau.',
    COLOUR_FILTER_HIGH_CONTRAST_MESSAGE: 'Filter warna tidak berfungsi dalam mode kontras tinggi.',

    // Alternative text stop words
    SUSPICIOUS_ALT_STOPWORDS: [
      'gambar',
      'grafik',
      'gambar',
      'foto',
      'photo',
      'image',
      'graphic',
    ],
    PLACEHOLDER_ALT_STOPWORDS: [
      'alt',
      'gambar',
      'foto',
      'photo',
      'image',
      'graphic',
      'dekoratif',
      'penampung',
      'gambar penampung',
      'spacer',
    ],
    PARTIAL_ALT_STOPWORDS: [
      'klik',
      'klik di sini',
      'klik di sini untuk informasi lebih lanjut',
      'klik di sini untuk mempelajari lebih lanjut',
      'lihat',
      'dirinci di sini',
      'induh',
      'unduh di sini',
      'cari tahu',
      'cari tahu lebih lanjut',
      'formulir',
      'di sini',
      'info',
      'informasi',
      'tautan',
      'belajar',
      'pelajari lebih lanjut',
      'belajar untuk',
      'lebih lanjut',
      'halaman',
      'kertas',
      'baca lebih lanjut',
      'baca',
      'baca ini',
      'ini',
      'halaman ini',
      'situs web ini',
      'melihat',
      'lihat kami',
      'situs web',
    ],
    WARNING_ALT_STOPWORDS: [
      'klik di sini',
    ],
    NEW_WINDOW_PHRASES: [
      'eksternal',
      'tab baru',
      'jendela baru',
      'pop-up',
      'muncul',
    ],
    FILE_TYPE_PHRASES: ['dokumen', 'spreadsheet', 'lembar kalkulasi', 'file terkompresi', 'file yang diarsipkan', 'lembar kerja', 'powerpoint', 'presentasi', 'instal', 'video', 'audio', 'pdf'],
    LANG_READABILITY: 'Keterbacaan',
    LANG_AVG_SENTENCE: 'Rata-rata kata per kalimat:',
    LANG_COMPLEX_WORDS: 'Kata-kata yang kompleks:',
    LANG_TOTAL_WORDS: 'Kata-kata:',
    LANG_VERY_DIFFICULT: 'Sangat sulit',
    LANG_DIFFICULT: 'Sulit',
    LANG_FAIRLY_DIFFICULT: 'Cukup sulit',
    LANG_GOOD: 'Bagus.',
    READABILITY_NO_P_OR_LI_MESSAGE: 'Tidak dapat menghitung skor keterbacaan. Tidak ditemukan paragraf <kode>&lt;p&gt;</kode> atau konten daftar <kode>&lt;li&gt;</kode>.',
    READABILITY_NOT_ENOUGH_CONTENT_MESSAGE: 'Konten tidak cukup untuk menghitung skor keterbacaan.',
    HEADING_NON_CONSECUTIVE_LEVEL: 'Level heading yang digunakan tidak berurutan. Judul tidak boleh melompati level, atau berpindah dari <strong>Judul %(prevLevel)</strong> ke <strong {r}>Judul %(level)</strong>.',
    HEADING_EMPTY: 'Judul kosong ditemukan! Untuk memperbaikinya, hapus baris ini atau ubah formatnya dari <strong {r}>Header %(level)</strong> ke <strong>Normal</strong> atau <strong>Paragraph</strong>.',
    HEADING_LONG: 'Judulnya panjang! Judul harus digunakan untuk mengatur konten dan menyampaikan struktur. Judul harus singkat, informatif, dan unik. Harap jaga agar judul kurang dari 160 karakter (tidak lebih dari satu kalimat). <hr> Jumlah karakter: <strong {r}>%(headingLength)</strong>',
    HEADING_FIRST: 'Judul pertama pada halaman biasanya adalah Heading 1 atau Heading 2. Heading 1 harus menjadi awal dari bagian konten utama, dan merupakan judul utama yang menjelaskan tujuan keseluruhan halaman. Pelajari lebih lanjut tentang <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/">Struktur Heading.</a>',
    HEADING_MISSING_ONE: 'Heading 1. Heading 1 seharusnya menjadi awal dari area konten utama, dan merupakan heading utama yang menjelaskan tujuan keseluruhan halaman. Pelajari lebih lanjut tentang <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/">Struktur Judul.</a>',
    HEADING_EMPTY_WITH_IMAGE: 'Judul tidak memiliki teks, namun berisi gambar. Jika ini bukan judul, ubah formatnya dari <strong {r}>Judul %(level)</strong> ke <strong>Normal</strong> atau <strong>Paragraf</strong>. Jika tidak, tambahkan teks alt ke gambar jika tidak bersifat dekoratif.',
    PANEL_HEADING_MISSING_ONE: 'Hilang Heading 1!',
    PANEL_NO_HEADINGS: 'Tidak ada judul ditemukan.',
    LINK_EMPTY: 'Hapus tautan kosong tanpa teks apa pun.',
    LINK_EMPTY_LINK_NO_LABEL: 'Tautan tidak memiliki teks yang dapat dilihat oleh pembaca layar dan teknologi bantuan lainnya. Untuk memperbaiki: <ul><li>Tambahkan beberapa teks ringkas yang menjelaskan ke mana tautan tersebut membawa Anda.</li><li>Jika tautan tersebut adalah tautan <a href="https://a11y-101.com/development/icons-and-links">ikon atau SVG,</a> kemungkinan besar tautan tersebut tidak memiliki label deskriptif.</li><li>Jika Anda merasa tautan tersebut merupakan kesalahan akibat bug salin/tempel, pertimbangkan untuk menghapusnya.</li></ul>',
    LINK_LABEL: '<strong>Label tautan:</strong> %(sanitizedText)',
    LINK_STOPWORD: 'Teks tautan mungkin tidak cukup deskriptif di luar konteks: <strong {r}>%(error)</strong><hr><strong>Tip!</strong> Teks tautan harus selalu jelas, unik, dan bermakna. Hindari kata-kata umum seperti "klik di sini" atau "pelajari lebih lanjut"',
    LINK_BEST_PRACTICES: 'Pertimbangkan untuk mengganti teks tautan: <strong {r}>%(error)</strong><hr><ul><li>&quot;Klik di sini&quot; yang berfokus pada mekanisme mouse, ketika banyak orang tidak menggunakan mouse atau mungkin melihat situs web ini di perangkat seluler. Pertimbangkan untuk menggunakan kata kerja lain yang berhubungan dengan tugas tersebut.</li><li>Hindari penggunaan simbol HTML sebagai ajakan bertindak kecuali jika disembunyikan oleh teknologi bantu.</li></ul>',
    LINK_URL: 'URL yang lebih panjang dan kurang dapat dipahami yang digunakan sebagai teks tautan mungkin sulit untuk disimak dengan teknologi bantuan. Dalam kebanyakan kasus, lebih baik menggunakan teks yang dapat dibaca manusia daripada URL. URL pendek (seperti beranda situs) tidak masalah.<hr><strong>Tip!</strong> Teks tautan harus selalu jelas, unik, dan bermakna sehingga dapat dipahami di luar konteks.',
    LINK_DOI: 'Untuk halaman web atau sumber daya yang hanya tersedia secara online, <a href="https://apastyle.apa.org/style-grammar-guidelines/paper-format/accessibility/urls#:~:text=descriptive%20links">Panduan Gaya APA</a> merekomendasikan penggunaan pranala deskriptif dengan membungkus URL atau DOI karya di sekeliling judulnya. URL yang lebih panjang dan kurang dapat dipahami yang digunakan sebagai teks tautan mungkin sulit dipahami saat diakses dengan teknologi bantu.',
    NEW_TAB_WARNING: 'Tautan terbuka di tab atau jendela baru tanpa peringatan. Hal ini dapat membingungkan, terutama bagi orang yang mengalami kesulitan dalam memahami konten visual. Kedua, tidak selalu merupakan praktik yang baik untuk mengontrol pengalaman seseorang atau membuat keputusan untuk mereka. Tunjukkan bahwa tautan akan terbuka di jendela baru di dalam teks tautan <hr><strong>Tip!</strong> Pelajari praktik terbaik: <a href="https://www.nngroup.com/articles/new-browser-windows-and-tabs/">membuka tautan di jendela dan tab peramban baru</a>.',
    FILE_TYPE_WARNING: 'Tautan mengarah ke PDF atau file yang dapat diunduh (mis. MP3, Zip, Word Doc) tanpa peringatan. Tunjukkan jenis file di dalam teks tautan. Jika file berukuran besar, pertimbangkan untuk menyertakan ukuran file tersebut.<hr><strong>Contoh:</strong> Laporan Eksekutif (PDF, 3MB)',
    LINK_IDENTICAL_NAME: 'Tautan memiliki teks yang sama dengan tautan lain, meskipun mengarah ke halaman yang berbeda. Beberapa tautan dengan teks yang sama dapat menyebabkan kebingungan bagi orang yang menggunakan pembaca layar. Pertimbangkan untuk membuat tautan berikut ini lebih deskriptif untuk membantu membedakannya dari tautan lain: <strong {r}>%(sanitizedText)</strong>',
    MISSING_ALT_LINK_BUT_HAS_TEXT_MESSAGE: 'Gambar digunakan sebagai tautan dengan teks di sekitarnya, meskipun atribut alt harus ditandai sebagai dekoratif atau nol.',
    MISSING_ALT_LINK_MESSAGE: 'Gambar digunakan sebagai tautan tetapi tidak memiliki teks alt! Pastikan teks alt menjelaskan ke mana tautan tersebut membawa Anda.',
    MISSING_ALT_MESSAGE: 'Teks alt yang hilang! Jika gambar menyampaikan suatu cerita, suasana hati, atau informasi penting - pastikan untuk mendeskripsikan gambar tersebut.',
    LINK_ALT_HAS_FILE_EXTENSION: 'Ekstensi file dalam teks alt ditemukan. Pastikan teks alt menjelaskan tujuan tautan, bukan deskripsi harfiah dari gambar. Hapus: <strong {r}>%(error)</strong>.<hr><strong>Alt text:</strong> %(altText)',
    LINK_IMAGE_PLACEHOLDER_ALT_MESSAGE: 'Teks alt non-deskripsi atau placeholder dalam gambar yang ditautkan ditemukan. Pastikan teks alt mendeskripsikan tujuan tautan, bukan deskripsi harfiah gambar. Ganti teks alt berikut ini: <strong {r}>%(altText)</strong>',
    LINK_IMAGE_SUS_ALT_MESSAGE: 'Teknologi bantuan sudah menunjukkan bahwa ini adalah gambar, jadi &quot;<strong {r}>%(error)</strong>&quot; mungkin berlebihan. Pastikan teks alt menjelaskan tujuan tautan, bukan deskripsi harfiah dari gambar. <hr> <strong>Alt text:</strong> %(altText)',
    ALT_HAS_FILE_EXTENSION: 'Ekstensi file dalam teks alt ditemukan. Jika gambar menyampaikan cerita, suasana hati, atau informasi penting - pastikan untuk mendeskripsikan gambar. Hapus: <strong {r}>%(error)</strong>.<hr><strong>Alt text:</strong> %(altText)',
    ALT_PLACEHOLDER_MESSAGE: 'Teks alt non-deskripsi atau placeholder ditemukan. Ganti teks alt berikut dengan sesuatu yang lebih bermakna: <strong {r}>%(altText)</strong>',
    ALT_HAS_SUS_WORD: 'Teknologi bantuan sudah menunjukkan bahwa ini adalah gambar, jadi &quot;<strong {r}>%(error)</strong>&quot; mungkin berlebihan. <hr> <strong>Alt text:</strong> %(altText)',
    LINK_HIDDEN_FOCUSABLE: 'Tautan memiliki <code>aria-hidden=&quot;true&quot;</code> tetapi masih dapat difokuskan menggunakan keyboard. Jika Anda bermaksud menyembunyikan tautan yang redundan atau duplikat, tambahkan juga <code>tabindex=&quot;-1&quot;</code>.',
    LINK_IMAGE_NO_ALT_TEXT: 'Gambar di dalam tautan ditandai sebagai dekoratif dan tidak ada teks tautan. Tambahkan teks alt ke gambar yang menjelaskan tujuan tautan.',
    LINK_IMAGE_HAS_TEXT: 'Gambar ditandai sebagai dekoratif, meskipun tautannya menggunakan teks di sekelilingnya sebagai label deskriptif.',
    LINK_IMAGE_LONG_ALT: 'Deskripsi teks alt pada gambar yang ditautkan terlalu panjang. Teks alt pada gambar yang ditautkan harus menjelaskan ke mana tautan tersebut membawa Anda, bukan deskripsi harfiah dari gambar tersebut. <strong>Pertimbangkan untuk menggunakan judul halaman yang ditautkan sebagai teks alt.</strong> <hr> <strong>Teks alt (<span {r}>%(panjang alt)</span> karakter):</strong>%(altText)',
    LINK_IMAGE_ALT_WARNING: 'Tautan gambar berisi teks alt. <strong>Apakah teks alt menjelaskan ke mana tautan tersebut membawa Anda?</strong> Pertimbangkan untuk menggunakan judul halaman yang ditautkan sebagai teks alt. <hr> <strong>Alt text:</strong> %(altText)',
    LINK_IMAGE_ALT_AND_TEXT_WARNING: 'Tautan gambar berisi <strong>teks alt dan teks tautan di sekitarnya.</strong> Jika gambar ini bersifat dekoratif dan digunakan sebagai tautan fungsional ke halaman lain, pertimbangkan untuk menandai gambar tersebut sebagai dekoratif atau nol - teks tautan di sekitarnya sudah cukup. <hr> <strong>Alt text:</strong> %(altText) <hr> <strong>Label tautan:</strong> %(sanitizedText)',
    IMAGE_FIGURE_DECORATIVE: 'Gambar ditandai sebagai <strong>dekoratif</strong> dan akan diabaikan oleh teknologi bantuan. <hr> Meskipun <strong>caption</strong> disediakan, gambar juga harus memiliki teks alt dalam banyak kasus. <ul><li>Teks alt harus memberikan deskripsi ringkas tentang apa yang ada di dalam gambar.</li><li>Teks keterangan biasanya harus memberikan konteks untuk menghubungkan gambar kembali ke konten di sekitarnya, atau memberikan perhatian pada bagian informasi tertentu.</li></ul>Pelajari lebih lanjut: <a href="https://thoughtbot.com/blog/alt-vs-figcaption#the-figcaption-element">alt versus keterangan gambar.</a>',
    IMAGE_FIGURE_DUPLICATE_ALT: 'Jangan gunakan kata-kata yang sama persis untuk teks alt dan teks keterangan. Pembaca layar akan mengumumkan informasi tersebut dua kali.<ul><li>Teks alt harus memberikan deskripsi ringkas tentang apa yang ada dalam gambar.</li><li>Teks keterangan biasanya harus memberikan konteks untuk menghubungkan gambar kembali ke konten di sekitarnya, atau memberikan perhatian pada bagian informasi tertentu.</li></ul> Pelajari lebih lanjut: <a href="https://thoughtbot.com/blog/alt-vs-figcaption#the-figcaption-element">alt versus keterangan gambar.</a> <hr> <strong>Alt text:</strong> %(altText)',
    IMAGE_DECORATIVE: 'Gambar ditandai sebagai <strong>dekoratif</strong> dan akan diabaikan oleh teknologi bantuan. Jika gambar menyampaikan cerita, suasana hati, atau informasi penting - pastikan untuk menambahkan teks alternatif.',
    IMAGE_ALT_TOO_LONG: 'Deskripsi teks alt terlalu panjang. Teks alt harus ringkas, namun bermakna seperti <em>tweet</em> (sekitar 100 karakter). Jika ini adalah gambar yang rumit atau grafik, pertimbangkan untuk meletakkan deskripsi gambar yang panjang dalam teks di bawah ini atau komponen akordeon. <hr> <strong>Teks alt (<span {r}>%(altLength)</span> karakter):</strong> %(altText)',
    IMAGE_PASS: '<strong>Alt text:</strong> %(altText)',
    LABELS_MISSING_IMAGE_INPUT_MESSAGE: 'Tombol gambar tidak memiliki teks alt. Tambahkan teks alt untuk memberikan nama yang dapat diakses. Sebagai contoh: <em>Cari</em> atau <em>Kirim</em>.',
    LABELS_INPUT_RESET_MESSAGE: 'Tombol Reset sebaiknya <strong>tidak</strong> digunakan kecuali jika secara khusus diperlukan karena mudah diaktifkan secara tidak sengaja. <hr> <strong>Tip!</strong> Pelajari mengapa tombol <a href="https://www.nngroup.com/articles/reset-and-cancel-buttons/">Reset dan Batal menimbulkan masalah dalam hal kegunaan.</a>',
    LABELS_ARIA_LABEL_INPUT_MESSAGE: 'Input memiliki nama yang dapat diakses, meskipun pastikan ada label yang terlihat juga. <hr> <strong>Label masukan:</strong> %(sanitizedText)',
    LABELS_NO_FOR_ATTRIBUTE_MESSAGE: 'Tidak ada label yang terkait dengan input ini. Tambahkan atribut <kode>untuk</kode> ke label yang sesuai dengan <kode>id</kode> input ini. <hr> ID untuk input ini adalah: <strong>id=&#34;%(id)&#34;</strong>',
    LABELS_MISSING_LABEL_MESSAGE: 'Tidak ada label yang terkait dengan input ini. Tambahkan <kode>id</kode> ke input ini, dan tambahkan atribut <kode>untuk</kode> yang sesuai ke label.',
    EMBED_VIDEO: 'Pastikan <strong>semua video memiliki teks tertutup.</strong> Menyediakan teks untuk semua konten audio dan video adalah persyaratan Level A wajib. Teks mendukung orang-orang yang tuli atau sulit mendengar.',
    EMBED_AUDIO: 'Pastikan untuk menyediakan <strong>transkrip untuk semua podcast.</strong> Menyediakan transkrip untuk konten audio adalah persyaratan Level A wajib. Transkrip membantu orang-orang yang tuli atau sulit mendengar, tetapi dapat bermanfaat bagi semua orang. Pertimbangkan untuk menempatkan transkrip di bawah atau di dalam panel akordeon.',
    EMBED_DATA_VIZ: 'Widget visualisasi data seperti ini sering menjadi masalah bagi orang yang menggunakan keyboard atau pembaca layar untuk menavigasi, dan dapat menimbulkan kesulitan yang signifikan bagi orang yang memiliki penglihatan rendah atau buta warna. Disarankan untuk memberikan informasi yang sama dalam format alternatif (teks atau tabel) di bawah widget. <hr>Pelajari lebih lanjut tentang <a href="https://www.w3.org/WAI/tutorials/images/complex">gambar kompleks.</a>',
    EMBED_MISSING_TITLE: 'Konten yang disematkan memerlukan nama yang dapat diakses yang menjelaskan isinya. Berikan atribut <kode>judul</kode> atau <kode>label-aria</kode> yang unik pada elemen <kode>iframe</kode>. Pelajari lebih lanjut tentang <a href="https://web.dev/learn/accessibility/more-html#iframes">iFrames.</a>',
    EMBED_GENERAL_WARNING: 'Tidak dapat memeriksa konten yang disematkan. Pastikan gambar memiliki teks alt, video memiliki keterangan, teks memiliki kontras yang memadai, dan komponen interaktif dapat diakses dengan keyboard.</a>',
    EMBED_UNFOCUSABLE: '<code>&lt;iframe&gt;</code> dengan elemen yang tidak dapat difokuskan seharusnya tidak memiliki <code>tabindex="-1"</code>. Konten yang disematkan tidak akan dapat diakses menggunakan keyboard.',
    QA_BAD_LINK: 'Tautan buruk ditemukan. Tautan yang muncul mengarah ke lingkungan pengembangan. <hr> Tautan ini mengarah ke: <br> <strong {r}>%(el)</strong>',
    QA_BAD_ITALICS: 'Tag cetak tebal dan miring memiliki makna semantik, dan tidak boleh digunakan untuk menyorot seluruh paragraf. Teks yang dicetak tebal harus digunakan untuk memberikan <strong>penekanan</strong> yang kuat pada sebuah kata atau frasa. Huruf miring harus digunakan untuk menyoroti nama diri (misalnya judul buku dan artikel), kata-kata asing, kutipan. Kutipan panjang harus diformat sebagai kutipan blok.',
    QA_PDF: 'Tidak dapat memeriksa aksesibilitas PDF. PDF dianggap sebagai konten web dan harus dapat diakses juga. PDF sering kali mengandung masalah bagi orang yang menggunakan pembaca layar (tag struktural yang hilang atau label bidang formulir yang hilang) dan orang yang memiliki penglihatan rendah (teks tidak dapat dilihat ketika diperbesar). <ul><li>Jika ini adalah formulir, pertimbangkan untuk menggunakan formulir HTML yang dapat diakses sebagai alternatif.</li><li>Jika ini adalah dokumen, pertimbangkan untuk mengonversinya menjadi halaman web.</li></ul>Jika tidak, periksa <a href="https://helpx.adobe.com/acrobat/using/create-verify-pdf-accessibility.html">PDF untuk aksesibilitas di Acrobat DC.</a>',
    QA_DOCUMENT: 'Tidak dapat memeriksa aksesibilitas dokumen. Dokumen yang ditautkan dianggap sebagai konten web dan harus dapat diakses juga. Silakan tinjau dokumen ini secara manual. <ul><li>Buat dokumen atau presentasi <a href="https://support.google.com/docs/answer/6199477?hl=id">Google Workspace Anda lebih mudah diakses.</a></li><li>Buat dokumen <a href="https://support.microsoft.com/id/office/create-accessible-office-documents-868ecfcd-4f00-4224-b881-a65537a7c155">Office Anda lebih mudah diakses.</a></li></ul>',
    QA_PAGE_LANGUAGE: 'Bahasa halaman tidak dideklarasikan! Silakan <a href="https://www.w3.org/International/questions/qa-html-language-declarations">deklarasikan bahasa pada tag HTML.</a>',
    QA_PAGE_TITLE: 'Judul halaman tidak ada! Harap berikan <a href="https://developer.mozilla.org/id/docs/Web/HTML/Element/title">judul halaman.</a>',
    QA_BLOCKQUOTE_MESSAGE: 'Apakah ini sebuah judul? <strong {r}>%(sanitizedText)</strong> <hr> Kutipan blok harus digunakan hanya untuk kutipan. Jika ini dimaksudkan sebagai judul, ubahlah tanda kutip blok ini menjadi judul semantik (misalnya Judul 2 atau Judul 3).',
    QA_FAKE_HEADING: 'Apakah ini sebuah judul? <strong {r}>%(boldtext)</strong> <hr> Sebaris teks yang dicetak tebal atau besar mungkin terlihat seperti judul, namun seseorang yang menggunakan pembaca layar tidak dapat mengetahui bahwa teks tersebut penting atau langsung menuju ke isinya. Teks yang dicetak tebal atau besar tidak boleh menggantikan judul semantik (Judul 2 hingga Judul 6).',
    QA_SHOULD_BE_LIST: 'Apakah Anda mencoba membuat daftar? Item daftar yang mungkin ditemukan: <strong {r}>%(firstPrefix)</strong> <hr> Pastikan untuk menggunakan daftar semantik dengan menggunakan tombol pemformatan poin atau angka. Saat menggunakan daftar semantik, teknologi bantuan dapat menyampaikan informasi seperti jumlah total item dan posisi relatif setiap item dalam daftar. Pelajari lebih lanjut tentang <a href="https://www.w3.org/WAI/tutorials/page-structure/content/#lists">daftar semantik.</a>',
    QA_UPPERCASE_WARNING: 'Ditemukan semua huruf besar. Beberapa pembaca layar mungkin menafsirkan teks huruf besar semua sebagai akronim dan akan membaca setiap huruf satu per satu. Selain itu, beberapa orang menganggap huruf besar lebih sulit dibaca dan mungkin memberikan kesan berteriak.',
    QA_DUPLICATE_ID: 'Ditemukan <strong>duplikat ID</strong>. Kesalahan ID duplikat diketahui dapat menyebabkan masalah pada teknologi bantuan saat mencoba berinteraksi dengan konten. <hr> Harap hapus atau ubah ID berikut ini: <strong {r}>%(id)</strong>',
    QA_TEXT_UNDERLINE_WARNING: 'Teks yang digarisbawahi dapat membingungkan dengan tautan. Pertimbangkan untuk menggunakan gaya yang berbeda seperti <code>&lt;strong&gt;</code><strong>kepentingan yang kuat</strong><code>&lt;/strong&gt;</code> atau <code>&lt;em&gt;</code><em>penekanan</em><code>&lt;/em&gt;</code>.',
    QA_SUBSCRIPT_WARNING: 'Opsi pemformatan subskrip dan superskrip hanya boleh digunakan untuk mengubah posisi teks untuk konvensi atau standar tipografi. Opsi ini tidak boleh <strong>tidak</strong> digunakan hanya untuk tujuan presentasi atau penampilan. Memformat seluruh kalimat dapat menimbulkan masalah keterbacaan. Kasus penggunaan yang tepat akan mencakup menampilkan eksponen, angka ordinal seperti 4<sup>th</sup>, bukan keempat, dan rumus kimia (misalnya H<sup>2</sup>O).',
    TABLES_MISSING_HEADINGS: 'Header tabel yang hilang! Tabel yang dapat diakses membutuhkan markup HTML yang menunjukkan sel header dan sel data yang mendefinisikan hubungannya. Informasi ini memberikan konteks kepada orang yang menggunakan teknologi bantu. Tabel harus digunakan hanya untuk data tabular. <hr> Pelajari lebih lanjut tentang <a href="https://www.w3.org/WAI/tutorials/tables/">tabel yang dapat diakses.</a>',
    TABLES_SEMANTIC_HEADING: 'Judul semantik seperti Heading 2 atau Heading 3 hanya boleh digunakan untuk bagian konten; <strong>tidak</strong> dalam tabel HTML. Tunjukkan judul tabel dengan menggunakan elemen <kode>&lt;th&gt;</kode>. <hr>Pelajari lebih lanjut tentang <a href="https://www.w3.org/WAI/tutorials/tables/">tabel yang dapat diakses.</a>',
    TABLES_EMPTY_HEADING: 'Header tabel kosong ditemukan! Header tabel tidak boleh kosong. Penting untuk menentukan header baris dan/atau kolom untuk menyampaikan hubungan mereka. Informasi ini memberikan konteks kepada orang-orang yang menggunakan teknologi bantu. Harap diingat bahwa tabel harus digunakan hanya untuk data tabular. <hr>Pelajari lebih lanjut tentang <a href="https://www.w3.org/WAI/tutorials/tables/">tabel yang dapat diakses.</a>',
    CONTRAST_ERROR: 'Teks ini tidak memiliki kontras yang cukup dengan latar belakang. Rasio kontras minimal 4,5:1 untuk teks normal dan 3:1 untuk teks besar. <hr> Rasio kontras adalah <strong {r}>%(cratio)</strong> untuk teks berikut ini: <strong {r}>%(sanitizedText)</strong>',
    CONTRAST_WARNING: 'Kontras teks ini tidak diketahui dan perlu ditinjau secara manual. Pastikan teks dan latar belakang memiliki warna kontras yang kuat. Rasio kontras setidaknya 4,5:1 untuk teks normal dan 3:1 untuk teks besar. <hr> <strong>Tolong tinjau:</strong> %(sanitizedText)',
    CONTRAST_INPUT_ERROR: 'Teks dalam input ini tidak memiliki kontras yang cukup dengan latar belakang. Rasio kontras minimal 4,5:1 untuk teks normal dan 3:1 untuk teks besar. <hr> Rasio kontras: <strong {r}>%(cratio)</strong>',
  },
};

export { id as default };
