<?php defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Updater\Updater;
use Joomla\Registry\Registry;

class joomlacmsupdateruInstallerScript
{

	protected $list = ['https://update.joomla.org/core/list.xml',];

	public function postflight($type, $parent)
	{
		if (!in_array((string) $type, ['install', 'update', 'delete']))
		{
			return;
		}

		$enabled = 0;

		if ($type === 'delete')
		{
			$enabled = 1;
		}

		$db = Factory::getDbo();

		foreach ($this->list as $link)
		{

			$query      = $db->getQuery(true);
			$fields     = array(
				$db->quoteName('enabled') . ' = ' . $db->q($enabled),
			);
			$conditions = array(
				$db->quoteName('location') . ' = ' . $db->q($link),
			);
			$query->update($db->quoteName('#__update_sites'))->set($fields)->where($conditions);
			$db->setQuery($query);
			$db->execute();

		}

		$this->rebuild();
		$this->findUpdates();
	}

	protected function findUpdates()
	{
		Factory::getApplication()->getLanguage()->load('com_installer');
		BaseDatabaseModel::addIncludePath(JPATH_ROOT . '/administrator/components/com_installer/models');

		// Get the caching duration.
		$params        = ComponentHelper::getComponent('com_installer')->getParams();
		$cache_timeout = (int) $params->get('cachetimeout', 6);
		$cache_timeout = 3600 * $cache_timeout;

		// Get the minimum stability.
		$minimum_stability = (int) $params->get('minimum_stability', Updater::STABILITY_STABLE);

		$model = BaseDatabaseModel::getInstance('Update', 'InstallerModel');

		$model->purge();
		$model->findUpdates(0, $cache_timeout, $minimum_stability);
	}

	protected function rebuild()
	{
		Factory::getApplication()->getLanguage()->load('com_installer');
		BaseDatabaseModel::addIncludePath(JPATH_ROOT . '/administrator/components/com_installer/models');
		$model = BaseDatabaseModel::getInstance('Updatesites', 'InstallerModel');
		$model->rebuild();
	}


}