<?php
/*
 * @package     mod_msg_rmf
 * @version     1.0.0
 * @author      Vladislav Tsygankov
 * @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://msgru.com/
 */

namespace MSGJoomla\Module\RMFilter\Site\Adapter\Filter;

// no direct access
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormField;
use Joomla\Registry\Registry;
use MSGJoomla\Module\RMFilter\Site\Adapter\FieldAdapter;
use MSGJoomla\Module\RMFilter\Site\Helper\FilterHelper;

\defined('JPATH_PLATFORM') or die;

/**
 * HTTP client class.
 *
 * @since  1.0.0
 */
class CategoriesFieldAdapter extends FieldAdapter
{
    /**
     * @throws \Exception
     */
    public function setup(): void
    {
        parent::setup();
        $categoryId = $this->factory->categoryId;
        $categories = FilterHelper::getCategories([$categoryId]);

        $params = $categories[$categoryId]->params;

        $categories = FilterHelper::getCategories(array_merge(
            [$categoryId],
            $params->get('filter_' . $this->name, [])
        ));

        if (empty($this->label)) {
            $this->setAttribute('label', 'COM_RADICALMART_' . strtoupper($this->name));
        }

        $this->setAttribute('type', 'filter_categories');

        $options = $params->get('filter_' . $this->name, []);

        $this->show = false;

        foreach ($options as $id)
        {
            if (!empty($categories[$id]))
            {
                $this->show = true;
                $option = $this->xml->addChild('option', htmlspecialchars($categories[$id]->title));
                $option->addAttribute('value', $id);
            }
        }
    }
}