<?php
/*
 * @package     RadicalMart Fields Standard Plugin
 * @subpackage  plg_radicalmart_fields_standard
 * @version     1.0.0
 * @author      Delo Design - delo-design.ru
 * @copyright   Copyright (c) 2023 Delo Design. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://delo-design.ru/
 */

defined('_JEXEC') or die;

use Joomla\CMS\Cache\CacheControllerFactoryInterface;
use Joomla\CMS\Cache\Controller\CallbackController;
use Joomla\CMS\Cache\Exception\CacheExceptionInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\Database\DatabaseInterface;
use Joomla\Database\ParameterType;
use Joomla\Component\RadicalMart\Administrator\Helper\ParamsHelper;
use Joomla\Component\RadicalMart\Administrator\Helper\FieldsHelper;

extract($displayData);

$checkedOptions        = is_array($field->value) ? $field->value : [];
$hasValue = (isset($this->value) && !empty($this->value));
?>
<?php if(!$field->hidden):?>
<div id="<?php echo $field->id; ?>" class="radicalmart-fields-standard-filter_checkboxes">
	<ul class="list-unstyled">
		<?php foreach ($field->options as $i => $option) : ?>
			<?php
			$checked = in_array((string) $option->value, $checkedOptions, true) ? 'checked' : '';
			$checked = (!$hasValue && $option->checked) ? 'checked' : $checked;
			$optionDisabled = !empty($option->disable) ? 'disabled' : '';
			$optionHidden = !empty($option->hidden) ? 'hidden' : '';
			$onchange = $field->onchange;

			if($optionHidden) continue;

			$oid   = $field->id . $i;
			$value = htmlspecialchars($option->value, ENT_COMPAT, 'UTF-8');
			?>
			<li>
				<div class="form-check">
					<input id="<?php echo $oid; ?>" name="<?php echo $field->name ?>" type="checkbox"
						   class="form-check-input" <?php echo $checked; ?> <?php echo $optionDisabled; ?>
						   value="<?php echo $value; ?>"
						<?php if (!empty($onchange)) echo 'onChange="' . $onchange . '"'; ?>>
					<label for="<?php echo $oid; ?>" class="form-check-label">
						<?php echo $option->text; ?>
					</label>
				</div>
			</li>
		<?php endforeach; ?>
	</ul>
	<div class="text-end">
		<a href="javascript:void(0);" class="small text-danger text-lowercase text-decoration-none"
		   onclick="let lastInput = null; this.closest('.radicalmart-fields-standard-filter_checkboxes').querySelectorAll('input')
			  .forEach(function (input) {input.checked = false; lastInput = input;}); lastInput.dispatchEvent(new Event('change'));">
			<?php echo Text::_('PLG_RADICALMART_FIELDS_STANDARD_CLEAN'); ?>
		</a>
	</div>
</div>
<?php endif;?>