<?php

/**
 * @package     Joomla.Site
 * @subpackage  Layout
 *
 * @copyright   (C) 2018 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   string   $autocomplete    Autocomplete attribute for the field.
 * @var   boolean  $autofocus       Is autofocus enabled?
 * @var   string   $class           Classes for the input.
 * @var   string   $description     Description of the field.
 * @var   boolean  $disabled        Is this field disabled?
 * @var   string   $group           Group the field belongs to. <fields> section in form XML.
 * @var   boolean  $hidden          Is this field hidden in the form?
 * @var   string   $hint            Placeholder for the field.
 * @var   string   $id              DOM id of the field.
 * @var   string   $label           Label of the field.
 * @var   string   $labelclass      Classes to apply to the label.
 * @var   boolean  $multiple        Does this field support multiple values?
 * @var   string   $name            Name of the input field.
 * @var   string   $onchange        Onchange attribute for the field.
 * @var   string   $onclick         Onclick attribute for the field.
 * @var   string   $pattern         Pattern (Reg Ex) of value of the form field.
 * @var   boolean  $readonly        Is this field read only?
 * @var   boolean  $repeat          Allows extensions to duplicate elements.
 * @var   boolean  $required        Is this field required?
 * @var   integer  $size            Size attribute of the input.
 * @var   boolean  $spellcheck      Spellcheck state for the form field.
 * @var   string   $validate        Validation rules to apply.
 * @var   string   $value           Value attribute of the field.
 * @var   array    $options         Options available for this field.
 * @var   string   $dataAttribute   Miscellaneous data attributes preprocessed for HTML output
 * @var   array    $dataAttributes  Miscellaneous data attribute for eg, data-*
 */

$html = [];
$attr = '';

// Initialize the field attributes.
$attr .= !empty($field->class) ? ' class="form-select ' . $field->class . '"' : ' class="form-select"';
$attr .= !empty($field->size) ? ' size="' . $field->size . '"' : '';
$attr .= $field->multiple ? ' multiple' : '';
$attr .= $field->required ? ' required' : '';
$attr .= $field->autofocus ? ' autofocus' : '';
$attr .= $field->onchange ? ' onchange="' . $field->onchange . '"' : '';
$attr .= !empty($field->description) ? ' aria-describedby="' . ($field->id ?: $field->name) . '-desc"' : '';
$attr .= $field->dataAttribute;

// To avoid user's confusion, readonly="readonly" should imply disabled="disabled".
if ($field->readonly || $field->disabled) {
    $attr .= ' disabled="disabled"';
}

// Create a read-only list (no name) with hidden input(s) to store the value(s).
if ($field->readonly) {
    $html[] = HTMLHelper::_('select.genericlist', $field->options, '', trim($attr), 'value', 'text', $field->value, $field->id);

    // E.g. form field type tag sends $this->value as array
    if ($field->multiple && is_array($field->value)) {
        if (!count($field->value)) {
            $field->value[] = '';
        }

        foreach ($field->value as $val) {
            $html[] = '<input type="hidden" name="' . $field->name . '" value="' . htmlspecialchars($val, ENT_COMPAT, 'UTF-8') . '">';
        }
    } else {
        $html[] = '<input type="hidden" name="' . $field->name . '" value="' . htmlspecialchars($field->value, ENT_COMPAT, 'UTF-8') . '">';
    }
} else // Create a regular list passing the arguments in an array.
{
    $listoptions = [];
    $listoptions['option.key'] = 'value';
    $listoptions['option.text'] = 'text';
    $listoptions['list.select'] = $field->value;
    $listoptions['id'] = $field->id;
    $listoptions['list.translate'] = false;
    $listoptions['option.attr'] = 'optionattr';
    $listoptions['list.attr'] = trim($attr);
    $html[] = HTMLHelper::_('select.genericlist', $field->options, $field->name, $listoptions);
}

echo implode($html);
