<?php
/*
 * @package     mod_msg_rmf
 * @version     1.0.0
 * @author      Vladislav Tsygankov
 * @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://msgru.com/
 */

namespace MSGJoomla\Module\RMFilter\Site\Adapter\Filter;

// no direct access
\defined('JPATH_PLATFORM') or die;

use MSGJoomla\Module\RMFilter\Site\Adapter\FieldAdapter;
use Joomla\Component\RadicalMart\Administrator\Helper\PriceHelper;
use Joomla\Component\RadicalMart\Administrator\Helper\ParamsHelper;

/**
 * HTTP client class.
 *
 * @since  1.0.0
 */
class InStockFieldAdapter extends FieldAdapter
{
    /**
     * @throws \Exception
     */
    public function setup(): void
    {
        parent::setup();
        $this->setAttribute('type', 'filter_inStock');

        $this->show = (bool)ParamsHelper::getComponentParams()->get('stock_accounting', 0);

        if (empty($this->label)) {
            $this->setAttribute('label', 'COM_RADICALMART_IN_STOCK_FILTER');
        }
    }
}