<?php
/*
* @package     mod_msg_rmf
* @version     1.0.4
* @author      Vladislav Tsygankov
* @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
* @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
* @link        https://msgru.com/
*/

namespace MSGJoomla\Module\RMFilter\Site\Adapter\ProductField;

// no direct access
\defined('JPATH_PLATFORM') or die;

use MSGJoomla\Module\RMFilter\Site\Adapter\FieldAdapter;
use Joomla\Component\RadicalMart\Administrator\Helper\PluginsHelper;
use MSGJoomla\Module\RMFilter\Site\Helper\FilterHelper;

/**
 * Adapter for RadicalMart product field base
 *
 * @since  1.0.0
 */
class BaseFieldAdapter extends FieldAdapter
{
    protected string $layout = '';

    protected string $group = 'fields';
    protected string $fieldSet = 'fields_product';
    /**
     * @throws \Exception
     */
    public function setup(): void
    {
        $fields = FilterHelper::getCategoryFields($this->factory->categoryId, 'alias');
        $this->field = $fields[$this->name];

        $this->show = (bool)$this->field->params->get('display_filter', 0);

        $this->xml = PluginsHelper::triggerPlugin('radicalmart_fields', $this->field->plugin,
            'onRadicalMartGetFilterFieldXml', ['com_radicalmart.products', $this->field, $this->factory->data]);

        if (!empty($this->layout)) {
            $this->setAttribute('layout', $this->layout);
        }
    }
}