<?php

/*
 * @package     mod_msg_rmf
 * @version     1.0.4
 * @author      Vladislav Tsygankov
 * @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://msgru.com/
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   Form    $tmpl             The Empty form for template
 * @var   Form[]   $forms            Array of JForm instances for render the rows
 * @var   string  $name             Name of the input field.
 * @var   string  $fieldname        The field name
 * @var   string  $fieldId          The field ID
 * @var   string  $control          The forms control
 * @var   string  $label            The field label
 * @var   string  $description      The field description
 * @var   string  $class            Classes for the container
 * @var   array   $buttons          Array of the buttons that will be rendered
 * @var   bool    $groupByFieldset  Whether group the subform fields by it`s fieldset
 */

/** @var \Joomla\CMS\WebAsset\WebAssetManager $assets */
$assets         = Factory::getApplication()->getDocument()->getWebAssetManager();
$doc = Factory::getApplication()->getDocument();
$assetsRegistry = $assets->getRegistry();
$assetsRegistry
    ->addExtensionRegistryFile('mod_msg_rmf');

$doc->addScriptOptions(
    'sortable-fields',
    [
        'id'        => '#sortableFields tbody',
    ]
);

$doc->getWebAssetManager()
    ->usePreset('dragula')
    ->useScript('mod_msg_rmf.field.sortable-fields');

$class = $class ? ' ' . $class : '';
$firstForm = $forms[array_key_first($forms)];

?>
<table class="table itemList" id="sortableFields">
    <thead>
    <tr>
        <th scope="col" class="w-1 text-center d-none d-md-table-cell">

        </th>
        <th scope="col" style="min-width:100px">
            <?php echo Text::_('MOD_MSG_RMF_FIELDS_TITLE_LABEL'); ?>
        </th>
        <th scope="col" class="w-1 text-center">
            <?php echo Text::_('MOD_MSG_RMF_FIELDS_STATE_LABEL'); ?>
        </th>
        <?php foreach ($firstForm->getGroup('') as $field) : ?>
            <th scope="col" class="w-3<?php if($field->hidden):?> d-none<?php endif;?>" style="max-width: 250px;">
                <?php echo Text::_($firstForm->getFieldAttribute($field->fieldname, 'label', $field->fieldname, '')); ?>
            </th>
        <?php endforeach; ?>
        <th scope="col" class="w-1 d-none d-md-table-cell">
            <?php echo Text::_('MOD_MSG_RMF_FIELDS_TYPE_LABEL'); ?>
        </th>
    </tr>
    </thead>
    <tbody>
    <?php foreach ($fields as $i => $item) :?>
        <?php $form = $forms[$item->name];?>
        <tr class="subform-repeatable-group row<?php echo $i % 2; ?>" data-draggable-group="0"
            data-item-id="<?php echo $item->name ?>"
        >
            <td class="text-center d-none d-md-table-cell">
                <span class="sortable-handler">
                    <span class="icon-ellipsis-v" aria-hidden="true"></span>
                </span>
                <input type="text" name="order[]" size="5" value="<?php echo $item->ordering; ?>" class="width-20 text-area-order hidden">
            </td>
            <th scope="row" class="has-context">
                <div class="break-word">
                    <span title="<?php echo Text::sprintf('JFIELD_ALIAS_LABEL', $this->escape($item->name)); ?>"><?php echo $this->escape($item->title); ?></span>
                </div>
            </th>
            <td class="text-center">
                <?php if($item->state === null): ?>
                    <span class="icon-question text-info" aria-hidden="true" aria-describedby="tip-question<?php echo $i; ?>"></span>

                    <div role="tooltip" id="tip-question<?php echo $i; ?>">
                        <?php echo Text::_('MOD_MSG_RMF_FIELDS_STATE_QUESTION'); ?>
                    </div>
                <?php elseif($item->state === true): ?>
                    <span class="icon-publish text-success" aria-hidden="true" aria-describedby="tip-publish<?php echo $i; ?>"></span>

                    <div role="tooltip" id="tip-publish<?php echo $i; ?>">
                        <?php echo Text::_('MOD_MSG_RMF_FIELDS_STATE_PUBLISH'); ?>
                    </div>
                <?php elseif($item->state === false): ?>
                    <span class="icon-unpublish text-danger" aria-hidden="true" aria-describedby="tip-unpublish<?php echo $i; ?>"></span>

                    <div role="tooltip" id="tip-unpublish<?php echo $i; ?>">
                        <?php echo Text::_('MOD_MSG_RMF_FIELDS_STATE_UNPUBLISH'); ?>
                    </div>
                <?php endif;?>
            </td>
            <?php foreach ($form->getGroup('') as $field) : ?>
                <td data-column="<?php echo strip_tags($field->label); ?>" class="<?php if($field->hidden):?> d-none<?php endif;?>">
                    <div>
                        <?php
                        if(isset($item->{$field->fieldname}))
                        {
                            $field->value = $item->{$field->fieldname};
                        }
                        ?>
                        <?php echo $field->renderField(['hiddenLabel' => true, 'hiddenDescription' => true]); ?>
                    </div>
                </td>
            <?php endforeach; ?>
            <td class="small d-none d-md-table-cell">
                <?php echo $this->escape($item->type); ?>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
