<?php

namespace MSGJoomla\Module\RMFilter\Site\Adapter;

\defined('JPATH_PLATFORM') or die;

use Joomla\CMS\Factory;
use Joomla\Registry\Registry;


class AdapterFactory
{
    public int $categoryId;
    public array $categoryFields;
    public mixed $data;
    public Registry $moduleParams;
    public function __construct(int $categoryId, array $categoryFields, Registry $moduleParams, $data)
    {
        $this->data = $data;
        $this->categoryId = $categoryId;
        $this->categoryFields = $categoryFields;
        $this->moduleParams = $moduleParams;
    }

    /**
     * Method to create a Driver instance.
     *
     * @param   string $name
     * @param   string $label
     * @param   string $fieldGroup
     * @param   string $fieldType
     *
     * @return  FieldAdapter
     *
     * @since   1.0.0
     */
    public function createAdapter(string $name, string $label, string $fieldGroup, string $fieldType): FieldAdapter
    {
        // Check default class for field
        $class_name = __NAMESPACE__ . '\\' . ucfirst($fieldGroup) . '\\' . ucfirst($fieldType) . 'FieldAdapter';

        if (!class_exists($class_name))
        {
            $class_name = __NAMESPACE__ . '\\' . ucfirst($fieldGroup) . '\\BaseFieldAdapter';
            if (!class_exists($class_name))
            {
                return new FieldAdapter($name, $label, $fieldType, $this);
            }
        }

        return new $class_name($name, $label, $fieldType, $this);
    }
}
