<?php
/*
 * @package     mod_msg_rmf
 * @version     1.0.5
 * @author      Vladislav Tsygankov
 * @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://msgru.com/
 */

defined('_JEXEC') or die;

use Joomla\CMS\Extension\Service\Provider\HelperFactory;
use Joomla\CMS\Extension\Service\Provider\Module;
use Joomla\CMS\Extension\Service\Provider\ModuleDispatcherFactory;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

/**
 * The MSG RadicalMart Filter module service provider.
 *
 * @since  1.0.0
 */
return new class () implements ServiceProviderInterface
{
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   1.0.0
     */
    public function register(Container $container)
    {
        $container->registerServiceProvider(new ModuleDispatcherFactory('\\MSGJoomla\\Module\\RMFilter'));
        $container->registerServiceProvider(new HelperFactory('\\MSGJoomla\\Module\\RMFilter\\Site\\Helper'));
        $container->registerServiceProvider(new Module);
    }
};