<?php
/*
 * @package     mod_msg_rmf
 * @version     1.0.5
 * @author      Vladislav Tsygankov
 * @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://msgru.com/
 */

namespace MSGJoomla\Module\RMFilter\Site\Adapter;

// no direct access
\defined('JPATH_PLATFORM') or die;

use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormField;
use Joomla\Registry\Registry;


/**
 * Base Field Adapter
 *
 * @since  1.0.0
 */
class FieldAdapter
{
    protected string $type = 'text';
    protected string $group = 'filter';
    protected string $fieldSet = 'fields_filter';
    protected string $name;
    protected string $label;
    protected AdapterFactory $factory;
    protected \SimpleXMLElement $xml;

    protected bool $show = true;

    public function __construct(string $name, string $label, string $fieldType, AdapterFactory $factory)
    {
        $this->name = $name;
        $this->label = $label;
        $this->type = $fieldType;
        $this->factory = $factory;

        $this->xml = new \SimpleXMLElement('<field/>');
        $this->setAttribute('name', $name);
        $this->setAttribute('type', $this->type);
        $this->setAttribute('label', $this->label);

        $this->setup();
    }

    public function setup(): void
    {
    }

    function setAttribute($attributeName, $attributeValue, bool $replace = true): void
    {
        $attributes = $this->xml->attributes();
        if (isset($this->$attributeName)) {
            $this->$attributeName = $attributeValue;
        }

        if (isset($attributes[$attributeName])) {
            if (!empty($attributeValue)) {
                if ($replace) {
                    $attributes->$attributeName = (string)$attributeValue;
                } else {
                    $attributes->$attributeName = (string)$attributes->$attributeName . (string)$attributeValue;
                }
            } else {
                unset($attributes->$attributeName);
            }
        } else {
            $this->xml->addAttribute($attributeName, $attributeValue);
        }
    }

    public function handle()
    {
        if ((int)$this->factory->moduleParams->get('ajax', 0) === 1 && (int)$this->factory->moduleParams->get('auto_submit', 0)) {
            $this->setAttribute('onchange', 'window.MSGRMFilter.ajaxSubmit(event);');
        }
    }

    public function getXml(): \SimpleXMLElement
    {
        return $this->xml;
    }

    public function getFieldSet()
    {
        return $this->fieldSet;
    }

    public function getGroup()
    {
        return $this->group;
    }

    public function isShow()
    {
        return $this->show;
    }
}
