<?php

namespace MSGJoomla\Module\RMFilter\Site\Dispatcher;

\defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;
use Joomla\Input\Input;
use MSGJoomla\Module\RMFilter\Site\Helper\FilterHelper;

class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
    use HelperFactoryAwareTrait;

    /**
     * Returns the layout data.
     *
     * @throws \Exception
     *
     * @return  array Module layout data.
     *
     * @since  1.0.0
     */
    protected function getLayoutData(): array
    {
        $data = parent::getLayoutData();
        $params = $data['params'];

        $data['categoryId'] = FilterHelper::getCategoryId($params->get('category_id'));

        $data['fields']   = $params->get('fields', array());
        $data['form']   = FilterHelper::getForm($params);
        $data['action'] = FilterHelper::getAction($params);

        $app = Factory::getApplication();

        // Load language
        $app->getLanguage()->load('com_radicalmart');

        // Load assets
        /** @var \Joomla\CMS\WebAsset\WebAssetRegistry $assetsRegistry */
        $assetsRegistry = $app->getDocument()->getWebAssetManager()->getRegistry();
        $assetsRegistry
            ->addExtensionRegistryFile('mod_msg_rmf');

        return $data;
    }
}