/*
 * @package     mod_msg_rmf
 * @version     __DEPLOY_VERSION__
 * @author      Vladislav Tsygankov
 * @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://msgru.com/
 */

(() => {
  "use strict";

window.MSGRMFilter = {
  ajaxSubmit: (event) => {
    let ajaxProducts = document.querySelector('[data-radicalmart-ajax="products"],[radicalmart-ajax="products"]');
    if (ajaxProducts) {
      let form = (event.target.tagName.toLowerCase() === 'form') ? event.target : event.target.closest('form');
      if (form) {
        if (!document.dispatchEvent(new CustomEvent('onRadicalMartFilterBeforeAjax', {cancelable: true, detail: {form}}))) {
          return;
        }

        if (event.target.tagName.toLowerCase() === 'form') {
          event.preventDefault();
        }

        let loading = document.querySelector('[radicalmart-ajax="loading"],[data-radicalmart-ajax="loading"]');
        if (loading) {
          loading.style.display = '';
        }

        let formData = new FormData(form);
        formData.set('tmpl', 'radicalmart_ajax');

        let url = form.getAttribute('action');
        if (url.indexOf('?') === -1) {
          url += '?';
        }
        url += decodeURI(new URLSearchParams(formData).toString());

        Joomla.request({
          url: url,
          method: 'GET',
          onSuccess: (response) => {
            let newHtml = document.createElement('div');
            newHtml.innerHTML = response;

            newHtml.querySelectorAll('[radicalmart-ajax], [data-radicalmart-ajax]')
                .forEach((replace) => {
                  let selector = replace.getAttribute('radicalmart-ajax');
                  if (!selector) selector = replace.getAttribute('data-radicalmart-ajax');

                  if (selector) {
                    let htmlSelector = '[radicalmart-ajax="' + selector + '"]',
                        search = document.querySelector(htmlSelector);
                    if (!search) {
                      htmlSelector = '[data-radicalmart-ajax="' + selector + '"]';
                      search = document.querySelector(htmlSelector);
                    }
                    if (search) {
                      let innerHtml = replace.innerHTML;
                      innerHtml = innerHtml.replace(new RegExp('tmpl=radicalmart_ajax', 'g'), '');
                      search.innerHTML = innerHtml;
                      if (selector === 'products') {
                        try {
                          window.RadicalMartCart().loadActions(htmlSelector);
                        } catch (e) {

                        }
                      }
                    }
                  }
                })

            let pateTitle = newHtml.querySelector('#pageTitle').getAttribute('content'),
                pageUrl = newHtml.querySelector('#pageUrl').getAttribute('content');
            if (pateTitle) {
              document.title = pateTitle;
              window.history.pushState('FormData', pateTitle, pageUrl);
            }

            if (loading) {
              loading.style.display = 'none';
            }

            document.dispatchEvent(new CustomEvent('onRadicalMartFilterAfterAjax', {detail: {form, pateTitle, pageUrl}}));
          },
          onError: (e) => {
            if (e.message && e.message !== '' && e.message !== 'Request aborted') {
              console.error(e.message);
            }
            if (loading) {
              loading.style.display = 'none';
            }
          }
        });
      }
    }
  },
};
window.addEventListener('popstate', function (e) {
  window.location.href = location.href;
});
})()
;