<?php
/*
 * @package     mod_msg_rmf
 * @version     __DEPLOY_VERSION__
 * @author      Vladislav Tsygankov
 * @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://msgru.com/
 */

namespace MSGJoomla\Module\RMFilter\Site\Adapter\Filter;

// no direct access
\defined('JPATH_PLATFORM') or die;

use Joomla\CMS\Language\Text;
use MSGJoomla\Module\RMFilter\Site\Adapter\FieldAdapter;
use Joomla\Component\RadicalMart\Administrator\Helper\PriceHelper;
use MSGJoomla\Module\RMFilter\Site\Helper\FilterHelper;
use Joomla\Component\RadicalMart\Administrator\Helper\ParamsHelper;

/**
 * HTTP client class.
 *
 * @since  1.0.0
 */
class PriceFieldAdapter extends FieldAdapter
{
    /**
     * @throws \Exception
     */
    public function setup(): void
    {
        parent::setup();
        $currency = PriceHelper::getCurrency(FilterHelper::getUserStateFromRequest('com_radicalmart.products.filter.currency', 'filter_currency'));

        $this->setAttribute('label',
            Text::sprintf('COM_RADICALMART_PRICE_FILTER', trim($currency['symbol'])));
        $this->setAttribute('currency', $currency['code']);

        $this->setAttribute('type', 'filter_price');

        $this->show = !ParamsHelper::getComponentParams()->get('hide_prices', 0);

        if (empty($this->label)) {
            $this->setAttribute('label', 'COM_RADICALMART_PRICE');
        }
    }
}