/*
 * @package     mod_msg_rmf
 * @version     1.0.7
 * @author      Vladislav Tsygankov
 * @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://msgru.com/
 */

(function () {
  'use strict';

  // The container where the draggable will be enabled
  var dragElementIndex;
  var container = document.querySelector('.js-draggable');
  if (Joomla.getOptions('sortable-fields')) {
    var options = Joomla.getOptions('sortable-fields');
    container = document.querySelector(options.id);
    /**
     * This is here to make the transition to new forms easier.
     */

    if (!container.classList.contains('js-draggable')) {
      container.classList.add('js-draggable');
    }
  }

  if (container) {
    document.addEventListener('touchstart', function () {}, false);

    dragula([container], {
      // Y axis is considered when determining where an element would be dropped
      direction: 'vertical',
      // elements are moved by default, not copied
      copy: false,
      // elements in copy-source containers can be reordered
      // copySortSource: true,
      // spilling will put the element back where it was dragged from, if this is true
      revertOnSpill: true,
      // spilling will `.remove` the element, if this is true
      // removeOnSpill: false,
      accepts: function accepts(el, target, source, sibling) {
        if (isNested) {
          if (sibling !== null) {
            return sibling.dataset.draggableGroup && sibling.dataset.draggableGroup === el.dataset.draggableGroup;
          }

          return sibling === null || sibling && sibling.tagName.toLowerCase() === 'tr';
        }

        return sibling === null || sibling && sibling.tagName.toLowerCase() === 'tr';
      },
      mirrorContainer: container
    }).on('drag', function (el) {
      var rowSelector = 'tr';

      var rowElements = [].slice.call(container.querySelectorAll(rowSelector));
      dragElementIndex = rowElements.indexOf(el);
    }).on('drop', function (el) {
    });
  }

})();
