<?php
/*
 * @package     mod_msg_rmf
 * @version     1.0.7
 * @author      Vladislav Tsygankov
 * @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://msgru.com/
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\Registry\Registry;
use \Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\RadicalMart\Administrator\Helper\ParamsHelper;
use Joomla\Component\RadicalMart\Administrator\Helper\FieldsHelper;

/**
 * Template variables
 * -----------------
 *
 * @var  Form    $form Form
 * @var  string    $action Form action href.
 * @var   object   $module Module object.
 * @var   Registry $params Module params.
 * @var   FormField[] $fields Filter sorted fields.
 */

if (!$form) return;

// Load asses
/** @var Joomla\CMS\WebAsset\WebAssetManager $assets */
$assets = Factory::getApplication()->getDocument()->getWebAssetManager();
$assets->useScript('bootstrap.collapse');

$hiddenFields = array('in_stock');

if (ParamsHelper::getComponentParams()->get('hide_prices', 0))
{
    $hiddenFields[] = 'price';
}
if (!ParamsHelper::getComponentParams()->get('stock_accounting', 0))
{
    $hiddenFields[] = 'in_stock';
}

$onSubmit = '';
if ($params->get('ajax', 0))
{
    $assets->useScript('mod_msg_rmf.ajax');

    $onSubmit = 'window.MSGRMFilter.ajaxSubmit(event);';
}
?>
<form action="<?php echo $action; ?>" method="get" onsubmit="<?php echo $onSubmit; ?>"
      radicalmart-ajax="mod_msg_rmf_<?php echo $module->id; ?>">
    <div class="accordion accordion-flush" id="mod_radicalmart_<?php echo $module->id; ?>_accordion">
        <?php $i = 0;

        $app = Factory::getApplication();

        foreach ($fields as $filterField):
            switch ($filterField->group)
            {
                case "ProductField":
                    $group = 'filter.fields';
                    break;

                default:
                    $group = 'filter';
                    break;
            }

            if(!$field = $form->getField($filterField->name, $group)) continue;
            /** @var FormField $field */
            if(
                $field->hidden || $field->disabled
            ) continue;

            $name  = $field->fieldname;
            $group = $field->group;
            $value = $field->value;

            $isOpen = $filterField->default_expanded || !empty($value);

            $id   = 'mod_msg_rmf_' . $module->id . '_' . $field->id;

            $labelId   = $id . '_label';
            $contentId = $id . '_content';
            ?>
            <div class="accordion-item">
                <div class="accordion-header">
                    <div class="accordion-button<?php echo !$isOpen ? ' collapsed' : '';?>" id="<?php echo $labelId; ?>" role="button" data-bs-toggle="collapse"
                         data-bs-target="#<?php echo $contentId; ?>"
                         aria-controls="<?php echo $contentId; ?>">
                        <?php echo Text::_($field->label); ?>
                    </div>
                </div>
                <div id="<?php echo $contentId; ?>" class="accordion-collapse collapse<?php echo $isOpen ? ' show' : ''; ?>"
                     aria-labelledby="<?php echo $labelId; ?>">
                    <div class="accordion-body">
                        <?php echo $form->getInput($filterField->name, $group); ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    <div class="p-3 d-grid">
        <button type="submit" class="btn btn-primary w-100">
            <?php echo Text::_('JGLOBAL_FILTER_BUTTON'); ?>
        </button>
    </div>
</form>