<?php

namespace MSGJoomla\Module\RMFilter\Site\Dispatcher;

\defined('_JEXEC') or die;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Event\Content\ContentPrepareEvent;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;
use MSGJoomla\Module\RMFilter\Site\Helper\FilterHelper;

class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
    use HelperFactoryAwareTrait;

    /**
     * Returns the layout data.
     *
     * @throws \Exception
     *
     * @return  array Module layout data.
     *
     * @since  1.0.7
     */
    protected function getLayoutData(): array
    {
        $data = parent::getLayoutData();
        $params = $data['params'];

        $params->set('category_id', FilterHelper::getCategoryId($params->get('category_id')));

        $data['categoryId'] = $params->get('category_id');

        $data['fields']   = $params->get('fields', array());
        $data['form']   = FilterHelper::getForm($params);
        $data['action'] = FilterHelper::getAction($params);

        $app = Factory::getApplication();

        // Load language
        $app->getLanguage()->load('com_radicalmart');

        // Load assets
        /** @var \Joomla\CMS\WebAsset\WebAssetRegistry $assetsRegistry */
        $assetsRegistry = $app->getDocument()->getWebAssetManager()->getRegistry();
        $assetsRegistry
            ->addExtensionRegistryFile('mod_msg_rmf');

        return $data;
    }
}
