<?php

namespace MSGJoomla\Module\RMFilter\Site\Adapter;

\defined('JPATH_PLATFORM') or die;

use Joomla\CMS\Factory;
use Joomla\Registry\Registry;


class AdapterFactory
{
    public int $categoryId;
    public Registry $params;
    public function __construct(int $categoryId, Registry $params)
    {
        $this->categoryId = $categoryId;
        $this->params = $params;
    }

    /**
     * Method to create a Driver instance.
     *
     * @param   object $field
     * @param   string $name
     * @param   string $label
     * @param   string $fieldGroup
     * @param   string $fieldType
     *
     * @return  FieldAdapter
     *
     * @since   1.0.7
     */
    public function createAdapter(string $name, string $label, string $fieldGroup, string $fieldType): FieldAdapter
    {
        // Check default class for field
        $class_name = __NAMESPACE__ . '\\' . ucfirst($fieldGroup) . '\\' . ucfirst($fieldType) . 'FieldAdapter';

        if (!class_exists($class_name))
        {
            $class_name = __NAMESPACE__ . '\\' . ucfirst($fieldGroup) . '\\BaseFieldAdapter';
            if (!class_exists($class_name))
            {
                return new FieldAdapter($name, $label, $fieldType, $this);
            }
        }

        return new $class_name($name, $label, $fieldType, $this);
    }
}
