<?php
/*
 * @package     mod_msg_rmf
 * @version     1.0.8
 * @author      Vladislav Tsygankov
 * @copyright   Copyright (c) 2023 MSGroup. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://msgru.com/
 */

namespace MSGJoomla\Module\RMFilter\Site\Adapter\Filter;

// no direct access
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormField;
use Joomla\Component\RadicalMart\Site\Mapping\CategoryMapping;
use Joomla\Registry\Registry;
use MSGJoomla\Module\RMFilter\Site\Adapter\FieldAdapter;
use MSGJoomla\Module\RMFilter\Site\Helper\FilterHelper;
use SpomkyLabs\Pki\ASN1\Util\Flags;

\defined('JPATH_PLATFORM') or die;

/**
 * HTTP client class.
 *
 * @since  1.0.7
 */
class CategoriesFieldAdapter extends FieldAdapter
{
	/**
	 * @throws \Exception
	 */
	public function setup(): void
	{
		parent::setup();

		$this->show = false;
		$categoryId = $this->factory->categoryId;
		$categories = FilterHelper::getCategories([$categoryId], null);

		if (!isset($categories[$categoryId]))
		{
			return;
		}

		$params = $categories[$categoryId]->params;

		if (empty($this->label))
		{
			$this->setAttribute('label', 'COM_RADICALMART_' . strtoupper($this->name));
		}

		$this->setAttribute('type', 'filter_categories');

		$options = $params->get('filter_' . $this->name, []);

		switch ($this->name)
		{
			case 'manufacturers':
				$type = 'manufacturer';
				break;
			case 'badges':
				$type = 'badge';
				break;
			default:
				$type = 'category';
				break;
		}

		if (empty($options) && $type === 'category')
		{
			$options = CategoryMapping::getSubCategories($categoryId);
		}

		$optionsCategories = FilterHelper::getCategories($options, $type);

		if (count($optionsCategories) > 0)
		{
			$this->show = true;

			foreach ($optionsCategories as $optionsCategory)
			{
				$option = $this->xml->addChild('option', htmlspecialchars($optionsCategory->title));
				$option->addAttribute('value', $optionsCategory->id);
			}
		}
	}
}
