<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_listproducts
 *
 * @copyright   
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Module\Rmlistproducts\Site\Helper;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\Database\DatabaseAwareInterface;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Registry\Registry;

\defined('_JEXEC') or die;

/**
 * Helper for mod_listproducts
 *
 * @since  1.5
 */
class RmlistproductsHelper implements DatabaseAwareInterface
{
    use DatabaseAwareTrait;

    /**
     * Returns a list from an array
     *
     * @param   Registry         $moduleParams  The module parameters.
     * @param   SiteApplication  $app           The current application.
     *
     * @return  \stdClass[]
     *
     * @since   4.4.0
     */
    public function getModuleData(Registry $moduleParams, SiteApplication $app): array
    {
	    $limit = $moduleParams->get('count', 6);
		$mode = $moduleParams->get('mode', 'metas');
        if ($moduleParams->get('categories')){
            $categories = implode(",",$moduleParams->get('categories'));
        } else {
            return ['error' => 'Выберите категорию'];
        }
	    $sortby = $moduleParams->get('sortby', 'title');
	    $direction = $moduleParams->get('direction', 'ASC');

	    $db = Factory::getContainer()->get('DatabaseDriver');

	    $query = $db->getQuery(true);

		$arr = ['a.id','a.category','a.title', 'a.alias', 'a.introtext', 'a.params', 'a.ordering_price'];

	    if ($moduleParams->get('image')){
		    $arr[] = 'a.media';
	    }
	    if ($moduleParams->get('mode') === "metas"){
		    $arr[] = 'a.products';
	    }

	    $query->select($db->quoteName($arr));

	    $query->from($db->quoteName('#__radicalmart_'.$mode, 'a'));
		//Если нужно имя категории
	    if ($moduleParams->get('categoryname')){
		    $query->select($db->quoteName('b.title', 'category_title'));
		    $query->join('INNER', $db->quoteName('#__radicalmart_categories', 'b') . ' ON ' . $db->quoteName('a.category') . ' = ' . $db->quoteName('b.id'));
	    }

	    $query->where($db->quoteName('a.state') . " = 1");
        $query->where($db->quoteName('a.category'). ' IN (' . $categories . ')');
		if($direction == 'RAND'){
			$query->order('RAND()');
		} else {
			$query->order($db->quoteName($sortby) . ' '.$direction);
		}

	    $query->setLimit($limit);

	    $db->setQuery($query);

	    return $db->loadAssocList();
    }
}
