<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_rmshippinglist
 *
 * @copyright   
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die;
use Joomla\CMS\Layout\LayoutHelper;
?>
<div class="mod-rm-shippinglist">
    <?php foreach ($list as $item) : ?>
        <div class="rm-shipping-item">
	        <?php
	        $priceShipping = json_decode($item['prices']);
	        if ($params['image'])
	        {
		        $media = json_decode($item['media']);
		        if (!empty($media->icon))
		        {
			        echo LayoutHelper::render(
				        'joomla.html.image',
				        [
					        'src'   => $media->icon,
					        'alt'   => $item['title'],
					        'class' => 'mb-2',
					        'loading' => 'lazy',
				        ]
			        );
		        }
	        }
            ?>
            <div class="rm-shipping-item-title py-2 mb-3">
                <div class="row justify-content-between">
                    <div class="col fs-16 fw-400">
		                <?php echo $item['title']; ?>
                    </div>
                    <?php if ($priceShipping->rub->base > 0) : ?>
                    <div class="col text-end fs-16 fw-200">
		                <?php echo $priceShipping->rub->base; ?> ₽
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php if (!empty($item['description'])) : ?>
            <div class="rm-shipping-item-description mb-3 fs-14">
	            <?php echo $item['description']; ?>
            </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
</div>
