<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_rmshippinglist
 *
 * @copyright   
 * @license     GNU General Public License version 2 or later;
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\Service\Provider\HelperFactory;
use Joomla\CMS\Extension\Service\Provider\Module;
use Joomla\CMS\Extension\Service\Provider\ModuleDispatcherFactory;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

/**
 * выводит список способов доставки: имя, описание, цена
 *
 * @since  4.4.0
 */
return new class () implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.4.0
     */
    public function register(Container $container): void
    {
        $container->registerServiceProvider(new ModuleDispatcherFactory('\\Joomla\\Module\\Rmshippinglist'));
        $container->registerServiceProvider(new HelperFactory('\\Joomla\\Module\\Rmshippinglist\\Site\\Helper'));

        $container->registerServiceProvider(new Module());
    }
};
