<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_rmshippinglist
 *
 * @copyright   
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Module\Rmshippinglist\Site\Helper;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\Database\DatabaseAwareInterface;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Registry\Registry;

\defined('_JEXEC') or die;

/**
 * Helper for mod_rmshippinglist
 *
 * @since  1.5
 */
class RmshippinglistHelper implements DatabaseAwareInterface
{
    use DatabaseAwareTrait;

    /**
     * Returns a list from an array
     *
     * @param   Registry         $moduleParams  The module parameters.
     * @param   SiteApplication  $app           The current application.
     *
     * @return  \stdClass[]
     *
     * @since   4.4.0
     */
    public function getModuleData(Registry $moduleParams, SiteApplication $app): array
    {
	    $db = Factory::getContainer()->get('DatabaseDriver');

	    $query = $db->getQuery(true);

		$arr = ['id','title', 'prices'];
	    if ($moduleParams->get('image')){
		    $arr[] = 'media';
	    }
	    if ($moduleParams->get('description')){
		    $arr[] = 'description';
	    }
	    $query->select($db->quoteName($arr));
	    $query->from($db->quoteName('#__radicalmart_shipping_methods'));
	    $query->where($db->quoteName('state') . " = 1");

	    $db->setQuery($query);

	    return $db->loadAssocList();
    }
}
