<?php
/**
 * @package    JLSitemap Component
 * @version    1.5.1
 * @author     Joomline - joomline.ru
 * @copyright  Copyright (c) 2010 - 2018 Joomline. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link       https://joomline.ru/
 */

defined('_JEXEC') or die;

use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Uri\Uri;

class JLSitemapHelper extends ContentHelper
{
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string $vName The name of the active view.
	 *
	 * @return  void
	 *
	 * @since 0.0.1
	 */
	static function addSubmenu($vName)
	{
		JHtmlSidebar::addEntry(Text::_('COM_JLSITEMAP_CONTROL_PANEL'),
			'index.php?option=com_jlsitemap&view=controlpanel',
			$vName == 'controlpanel');

		JHtmlSidebar::addEntry(Text::_('COM_JLSITEMAP_GENERATION'),
			'index.php?option=com_jlsitemap&task=sitemap.generate',
			$vName == 'generation');

		if (File::exists(JPATH_ROOT . '/sitemap.xml'))
		{
			JHtmlSidebar::addEntry(Text::_('COM_JLSITEMAP_SITEMAP'),
				Uri::root() . 'sitemap.xml',
				$vName == 'sitemap');

			JHtmlSidebar::addEntry(Text::_('COM_JLSITEMAP_SITEMAP_DELETE'),
				'index.php?option=com_jlsitemap&task=delete',
				$vName == 'delete');
		}

		JHtmlSidebar::addEntry(Text::_('COM_JLSITEMAP_PLUGINS'),
			'index.php?option=com_plugins&filter[folder]=jlsitemap',
			$vName == 'plugins');

		if ($cron = PluginHelper::getPlugin('system', 'jlsitemap_cron'))
		{
			JHtmlSidebar::addEntry(Text::_('COM_JLSITEMAP_CRON'),
				'index.php?option=com_plugins&task=plugin.edit&extension_id=' . $cron->id,
				$vName == 'cron');
		}

		JHtmlSidebar::addEntry(Text::_('COM_JLSITEMAP_CONFIG'),
			'index.php?option=com_config&view=component&component=com_jlsitemap',
			$vName == 'config');
	}
}