<?php
/**
 * @copyright   (c) 2013-2025 Nekrasov Vitaliy <nekrasov_vitaliy@list.ru>
 * @license     GNU General Public License version 2 or later
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   stdClass  $product      Product
 * @var   integer   $categoryId   Category id
 * @var   boolean   $enableModal  Enable modal
 */
$app = Factory::getApplication();
$document = $app->getDocument();
$wa = $document->getWebAssetManager();
$wa->useScript('plg_jshopping_wishboxquickorder.script.uikit');
?>
<?php if ($enableModal) { ?>
<span
        class="uk-button uk-button-primary"
        wishboxquickorder="button"
        wishboxquickorder-category_id="<?php echo $categoryId; ?>"
        wishboxquickorder-product_id="<?php echo $product->product_id; ?>"
>
	<?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_BUTTON_TITLE'); ?>
</span>
<?php } else { ?>
<a
        class="uk-button uk-button-primary"
        href="<?php echo $product->product_link; ?>"
>
	<?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_BUTTON_TITLE'); ?>
</a>
<?php } ?>