class WishboxJShoppingQuickOrderAjax
{
    constructor()
    {
        this.systemPaths = Joomla.getOptions('system.paths');
    }

    sendAjax(url, method, ajaxData)
    {
        let options = Joomla.getOptions('wishboxquickorder');

        return new Promise
        (
            (resolve, reject) =>
            {
                if (!options || !ajaxData || !method)
                {
                    reject('Error ajax data');

                    return false;
                }

                if (options['csrf'])
                {
                    ajaxData.set(options['csrf'], 1);
                }

                Joomla.request
                (
                    {
                        url: url,
                        method: method,
                        data: ajaxData,
                        onSuccess: resp =>
                        {
                            let response;

                            try
                            {
                                response = JSON.parse(resp);
                            }
                            catch (error)
                            {
                                throw new Error('Failed to parse JSON');
                            }

                            if (response && response.success === true)
                            {
                                resolve(response);
                            }
                            else
                            {
                                reject(response);
                            }
                        },

                        onError: resp =>
                        {
                            let response;

                            try
                            {
                                response = JSON.parse(resp.response);
                            }
                            catch (error)
                            {
                                throw new Error('Failed to parse JSON');
                            }

                            reject(response);
                        }
                    }
                );
            }
        );
    }
}

export { WishboxJShoppingQuickOrderAjax as default };