<?php
/**
 * @copyright   (c) 2013-2025 Nekrasov Vitaliy <nekrasov_vitaliy@list.ru>
 * @license     GNU General Public License version 2 or later
 *
 * @noinspection PhpUndefinedFieldInspection
 */

use Joomla\CMS\Language\Text;
use Joomla\Component\Jshopping\Site\Table\ConfigTable;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   ConfigTable   $jshopConfig
 * @var   Registry      $params
 */

?>
<div wishboxquickorder="form-container">
    <div class="modal fade"
         tabindex="-1"
         aria-labelledby="wishboxJShoppingQuickOrderModalLabel"
         aria-hidden="true"
         wishboxquickorder="modal"
    >
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="modal-title fs-5">
                        <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_MODAL_TITLE'); ?>
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div aria-live="polite" wishboxquickorder="message-container">
                    </div>
                    <form wishboxquickorder="form" class="needs-validation" novalidate>
                        <div class="p-2 m-3">
                            <div class="row">
                                <div class="col-sm-12 col-md-4">
                                    <div class="image_middle position-relative">
                                        <img
                                                src=""
                                                alt=""
                                                wishboxquickorder="image"
                                        />
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md">
                                    <h3>
                                        <span wishboxquickorder="name">
                                        </span>
                                        <span class="jshop_code_prod">
                                            (<?php echo Text::_('JSHOP_EAN_PRODUCT'); ?>:
                                            <span wishboxquickorder="code"></span>)
                                        </span>
                                    </h3>
                                    <div class="row m-3">
                                        <div class="col-sm-3 col-md-12 col-lg-4 align-middle text-center">
                                            <span wishboxquickorder="price" class="fs-4">
                                            </span>
                                        </div>
                                        <div class="col-sm-6 col-md-12 col-lg-4 align-middle text-center">
                                            <div class="input-group">
                                                <span class="input-group-text"
                                                      style="cursor: pointer"
                                                      wishboxquickorder="minus"
                                                >-</span>
                                                <input
                                                        name="quantity"
                                                        type="text"
                                                        class="form-control text-center"
                                                        value=""
                                                        wishboxquickorder="quantity"
                                                        style="padding-right:16px;"
                                                />
                                                <span
                                                        class="input-group-text"
                                                        style="cursor: pointer"
                                                        wishboxquickorder="plus"
                                                >+</span>
                                            </div>
                                        </div>
                                        <div class="col-sm-3 col-md-12 col-lg-4 align-middle text-center">
                                            <span wishboxquickorder="total" class="text-primary fs-4">
                                            </span>
                                        </div>
                                    </div>
                                    <?php if ($jshopConfig->stock) { ?>
                                    <div class="qty_in_stock">
                                        <?php echo Text::_('JSHOP_QTY_IN_STOCK'); ?>:
                                        <span id="product_qty" wishboxquickorder="stock">
                                        </span>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>

                            <div class="row mt-4">

	                            <?php if ($params->get('field_f_name') != 'hidden') { ?>
                                <div class="col-lg-6">
                                    <div class="form-floating mb-3">
                                        <input
                                                type="text"
                                                name="f_name"
                                                class="form-control"
                                                id="wishboxquckiorder-f_name"
                                                value=""
                                                placeholder="<?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_FIRST_NAME_LABEL'); ?>"
                                                <?php echo $params->get('field_f_name') == 'required' ? 'required' : ''; ?>
                                        />
                                        <label for="wishboxquckiorder-f_name">
                                            <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_FIRST_NAME_LABEL'); ?>
                                        </label>
                                    </div>
                                </div>
                                <?php } ?>

	                            <?php if ($params->get('field_l_name') != 'hidden') { ?>
                                <div class="col-lg-6">
                                    <div class="form-floating mb-3">
                                        <input
                                                type="text"
                                                name="l_name"
                                                class="form-control"
                                                id="wishboxquckiorder-l_name"
                                                value=""
                                                placeholder="<?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_LAST_NAME_LABEL'); ?>"
	                                            <?php echo $params->get('field_l_name') == 'required' ? 'required' : ''; ?>
                                        />
                                        <label for="wishboxquckiorder-l_name">
                                            <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_LAST_NAME_LABEL'); ?>
                                        </label>
                                    </div>
                                </div>
	                            <?php } ?>

	                            <?php if ($params->get('field_phone') != 'hidden') { ?>
                                <div class="col-lg-6">
                                    <div class="form-floating mb-3">
                                        <input
                                                type="text"
                                                name="phone"
                                                class="form-control"
                                                id="wishboxquckiorder-phone"
                                                value=""
                                                placeholder="<?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_PHONE_LABEL'); ?>"
	                                            <?php echo $params->get('field_phone') == 'required' ? 'required' : ''; ?>
                                        />
                                        <label for="wishboxquckiorder-phone">
                                            <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_PHONE_LABEL'); ?>
                                        </label>
                                    </div>
                                </div>
                                <?php } ?>

	                            <?php if ($params->get('field_email') != 'hidden') { ?>
                                <div class="col-lg-6">
                                    <div class="form-floating mb-3">
                                        <input
                                                type="text"
                                                name="email"
                                                class="form-control"
                                                id="wishboxquckiorder-email"
                                                value=""
                                                placeholder="<?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_EMAIL_LABEL'); ?>"
	                                            <?php echo $params->get('field_email') == 'required' ? 'required' : ''; ?>
                                        />
                                        <label for="wishboxquckiorder-email">
                                            <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_EMAIL_LABEL'); ?>
                                        </label>
                                    </div>
                                </div>
                                <?php } ?>

                            </div>
                            <div class="text-center mb-3">
                                <button
                                        type="button"
                                        class="btn btn-primary"
                                        wishboxquickorder="submit"
                                >
                                    <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_SUMBIT_BUTTON_TEXT'); ?>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
                <div
                        class="position-absolute top-0 start-0 w-100 h-100 z-3"
                        style="display: none"
                        wishboxquickorder="loading"
                >
                    <div class="d-inline-flex justify-content-center align-items-center w-100 h-100"
                         style="background: rgba(255, 255, 255, 0.8)"
                    >
                        <div class="spinner-border m-5" style="width: 5rem; height: 5rem;" role="status">
                            <span class="invisible">
                                <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_LOADING'); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>