<?php
/**
 * @copyright   (c) 2013-2025 Nekrasov Vitaliy <nekrsov_vitaliy@list.ru>
 * @license     GNU General Public License version 2 or later;
 */
use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\WebAsset\WebAssetRegistry;
use Joomla\Database\DatabaseDriver;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\JShopping\WishboxQuickOrder\Extension\WishboxQuickOrder;

defined('_JEXEC') or die;

return new class implements ServiceProviderInterface
{
	/**
	 * Registers the service provider with a DI container.
	 *
	 * @param   Container  $container  The DI container.
	 *
	 * @return void
	 *
	 * @since   1.0.0
	 */
	public function register(Container $container): void
	{
		$container->set(
			PluginInterface::class,
			function (Container $container)
			{
				$container->registerServiceProvider(
					new MVCFactory('Joomla\\Plugin\\JShopping\\WishboxQuickOrder')
				);

				$dispatcher = $container->get(DispatcherInterface::class);
				$config = (array) PluginHelper::getPlugin('jshopping', 'wishboxquickorder');

				$plugin = new WishboxQuickOrder($dispatcher, $config);
				$plugin->setApplication(Factory::getApplication());
				$plugin->setDatabase(Factory::getContainer()->get(DatabaseDriver::class));

				$plugin->setMVCFactory($container->get(MVCFactoryInterface::class));

				$wa = $container->get(WebAssetRegistry::class);
				$wa->addRegistryFile('media/plg_jshopping_wishboxquickorder/joomla.asset.json');

				return $plugin;
			}
		);
	}
};
