import WishboxJShoppingQuickOrderAjax from 'plg_jshopping_wishboxquickorder.ajax.bootstrap';

class WishboxJShoppingQuickOrderForm {
    constructor(element) {
        this.modalElement = element;
        this.formElement = this.modalElement.querySelector('[wishboxquickorder="form"]');
        this.nameElement = this.modalElement.querySelector('[wishboxquickorder="name"]');
        this.codeElement = this.modalElement.querySelector('[wishboxquickorder="code"]');
        this.priceElement = this.modalElement.querySelector('[wishboxquickorder="price"]');
        this.imageElement = this.modalElement.querySelector('[wishboxquickorder="image"]');
        this.minusElement = this.modalElement.querySelector('[wishboxquickorder="minus"]');
        this.quantityElement = this.modalElement.querySelector('[wishboxquickorder="quantity"]');
        this.plusElement = this.modalElement.querySelector('[wishboxquickorder="plus"]');
        this.totalElement = this.modalElement.querySelector('[wishboxquickorder="total"]');
        this.stockElement = this.modalElement.querySelector('[wishboxquickorder="stock"]');
        this.submitElement = this.modalElement.querySelector('[wishboxquickorder="submit"]');
        this.loadingElement = this.modalElement.querySelector('[wishboxquickorder="loading"]');
        this.messageContainerElement = this.modalElement.querySelector('[wishboxquickorder="message-container"]');
        this.firstNameElement = this.modalElement.querySelector('[name="f_name"]');
        this.lastNameElement = this.modalElement.querySelector('[name="l_name"]');
        this.phoneElement = this.modalElement.querySelector('[name="phone"]');
        this.emailElement = this.modalElement.querySelector('[name="email"]');

        this.minusElement.addEventListener
        (
            'click',
            (event) => {
                this.changeQuantity('-')
            }
        );

        this.plusElement.addEventListener
        (
            'click',
            (event) => {
                this.changeQuantity('+')
            }
        );

        this.submitElement.addEventListener
        (
            'click',
            (event) => {
                event.preventDefault();
                this.submitForm()
            }
        );

        this.modal = new bootstrap.Modal(this.modalElement, {
            keyboard: false
        });

        this.modalElement.addEventListener('show.bs.modal', () => {
        });

        this.modalElement.addEventListener('hide.bs.modal', () => {
            Joomla.removeMessages(
                this.messageContainerElement
            );
            this.formElement.style.display = 'block';
        });

        if (this.firstNameElement) {
            this.firstNameElement.addEventListener('blur', (e) => {
                this.firstNameElement.parentElement.classList.add('was-validated');
            });
        }

        if (this.lastNameElement) {
            this.lastNameElement.addEventListener('blur', (e) => {
                this.lastNameElement.parentElement.classList.add('was-validated');
            });
        }

        if (this.phoneElement) {
            this.formElement.querySelector('[name="phone"]').addEventListener('blur', (e) => {
                this.phoneElement.parentElement.classList.add('was-validated');
            });
        }

        if (this.emailElement) {
            this.formElement.querySelector('[name="email"]').addEventListener('blur', (e) => {
                this.emailElement.parentElement.classList.add('was-validated');
            });
        }
    }

    reloadAttribEvents(json)
    {
        this.setPrice(json.pricefloat);
    }

    setProductFormElement(productFormElement) {
        this.productFormElement = productFormElement;
    }

    setProductData(productData) {
        this.productData = productData;

        this.update()
    }

    update()
    {
        this.nameElement.innerText = this.productData.name;

        if (this.codeElement) {
            this.codeElement.innerText = this.productData.productEan;
        }

        this.priceElement.innerText = this.formatPrice(this.getPrice(this.productData.wishboxfoldquantity));
        this.imageElement.setAttribute('src', this.productData.productImage);
        this.imageElement.setAttribute('alt', this.productData.productName);
        this.quantityElement.value = this.productData.wishboxfoldquantity;
        this.totalElement.innerText = this.formatPrice(this.productData.productPrice * this.productData.wishboxfoldquantity);

        if (this.stockElement) {
            this.stockElement.innerText = this.productData.stock;
        }
    }

    changeQuantity(type)
    {
        let quantity = parseFloat(this.quantityElement.value);

        if (type)
        {
            if (type === '-' && quantity > this.productData.wishboxfoldquantity)
            {
                quantity -= this.productData.wishboxfoldquantity;
            }
            else if (type === '+')
            {
                quantity += this.productData.wishboxfoldquantity;
            }
        }

        this.quantityElement.value = quantity;

        if (this.productFormElement) {
            jshop.reloadPrices();
        } else {
            let priceNew = this.getPrice(quantity);

            if (priceNew !== this.productData.priceForQuantity)
            {
                this.setPrice(priceNew)
            }
        }
    }

    setPrice(price)
    {
        this.productData.priceForQuantity = price;
        this.priceElement.innerHTML = this.formatPrice(price);
        this.updateTotal();
    }

    updateTotal()
    {
        let quantity = parseFloat(this.quantityElement.value);

        let total = quantity * this.productData.priceForQuantity;

        if (total > 0)
        {
            this.totalElement.innerText = this.formatPrice(total);
        }
    }

    getFormData()
    {
        let formData = new FormData();

        formData.append('product_id',   this.productData.productId);
        formData.append('category_id',  this.productData.categoryId);
        formData.append('quantity',     this.quantityElement.value);

        if (this.productFormElement)
        {
            let productForm = new FormData(this.productFormElement);

            for (let field of productForm.entries())
            {
                if (field[0] !== 'to' && field[0] !== 'quantity')
                {
                    formData.append(field[0], field[1]);
                }
            }
        }

        if (this.firstNameElement) {
            formData.append('f_name', this.firstNameElement.value);
        }

        if (this.lastNameElement) {
            formData.append('l_name', this.lastNameElement.value);
        }

        if (this.phoneElement) {
            formData.append('phone', this.phoneElement.value);
        }

        if (this.emailElement) {
            formData.append('email', this.emailElement.value);
        }

        return formData;
    }

    isValid()
    {
        if (!this.formElement.checkValidity())
        {
            if (this.firstNameElement) {
                this.firstNameElement.parentElement.classList.add('was-validated');
            }

            if (this.lastNameElement) {
                this.lastNameElement.parentElement.classList.add('was-validated');
            }

            if (this.phoneElement) {
                this.phoneElement.parentElement.classList.add('was-validated');
            }

            if (this.emailElement) {
                this.emailElement.parentElement.classList.add('was-validated');
            }

            return false;
        }

        return true;
    }

    submitForm(event)
    {
        if (this.isValid())
        {
            this.setLoading();
            const ajaxData = this.getFormData();
            const ajax = new WishboxJShoppingQuickOrderAjax();

            ajax.sendAjax(ajax.systemPaths.root + '/index.php?option=com_ajax&plugin=wishboxquickordersubmitform&group=jshopping&format=json&ignoreMessages=0',
                'post',
                ajaxData).then
            (
                response =>
                {
                    this.hideLoading();

                    if (response.success == true)
                    {
                        if (response.messages) {
                            Joomla.renderMessages(
                                response.messages,
                                this.messageContainerElement
                            );
                        }

                        this.formElement.style.display = 'none';
                    }
                    else
                    {
                        Joomla.renderMessages(
                            response.messages,
                            this.messageContainerElement
                        );
                    }
                }
            ).catch
            (
                error =>
                {
                    this.hideLoading();
                    Joomla.renderMessages(
                        error.messages,
                        this.messageContainerElement
                    );
                }
            );
        }

        return false;
    }

    setLoading()
    {
        this.loadingElement.style.display = '';
    }

    hideLoading()
    {
        this.loadingElement.style.display = 'none';
    }

    formatPrice(price)
    {
        let options = Joomla.getOptions('wishboxquickorder');

        jshopParams.decimal_count = options['decimal_count'];
        jshopParams.decimal_symbol = options['decimal_symbol'];
        jshopParams.format_currency = options['format_currency'];
        jshopParams.currency_code = options['currency_code'];

        return jshop.formatprice(price);
    }

    getPrice(quantity)
    {
        if (this.productData.prices.length > 0 && quantity)
        {
            for (let i = 0; i < this.productData.prices.length; i++)
            {
                let price = this.productData.prices[i];

                if (price.start <= quantity && price.end >= quantity)
                {
                    return price.price;
                }
            }
        }
        else
        {
            return this.productData.productPrice;
        }
    }

    show()
    {
        if (this.productFormElement)
        {
            let self = this;
            jshop.reloadAttribEvents.push(function(json) {self.reloadAttribEvents(json)});
            jshop.reloadPrices();
        }
        this.modal.show();
    }
}

export { WishboxJShoppingQuickOrderForm as default };