<?php
/**
 * @copyright   (c) 2013-2025 Nekrasov Vitaliy <nekrasov_vitaliy@list.ru>
 * @license     GNU General Public License version 2 or later
 *
 * @noinspection PhpUndefinedFieldInspection
 */

use Joomla\CMS\Language\Text;
use Joomla\Component\Jshopping\Site\Table\ConfigTable;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   ConfigTable   $jshopConfig
 */

?>


    <div
            class="uk-modal-container uk-flex-top"
            id="modal-overflow"
            uk-modal
            wishboxquickorder="modal"
    >
        <div class="uk-modal-dialog">

            <button class="uk-modal-close-default" type="button" uk-close></button>

            <div class="uk-modal-header">
                <h2 class="uk-modal-title">
	                <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_MODAL_TITLE'); ?>
                </h2>
            </div>

            <div class="uk-modal-body">
                <div aria-live="polite" wishboxquickorder="message-container">
                </div>
                <div wishboxquickorder="form-wrapper">
                    <form wishboxquickorder="form">
                        <div uk-grid>
                            <div class="uk-width-1-3">
                                <div class="image_middle position-relative">
                                    <img
                                            src=""
                                            alt=""
                                            wishboxquickorder="image"
                                    />
                                </div>
                            </div>
                            <div class="uk-width-2-3">
                                <h3>
                                        <span wishboxquickorder="name">
                                        </span>
                                    <span class="jshop_code_prod">
                                            (<?php echo Text::_('JSHOP_EAN_PRODUCT'); ?>:
                                            <span wishboxquickorder="code"></span>)
                                        </span>
                                </h3>
                                <div uk-grid>
                                    <div class="uk-width-1-1 uk-width-1-1@s uk-width-1-3@m">
                                            <span wishboxquickorder="price" class="fs-4">
                                            </span>
                                    </div>
                                    <div class="uk-width-1-1 uk-width-1-1@s uk-width-1-3@m">
                                        <div class="uk-inline">
                                            <button
                                                    class="uk-button uk-button-primary uk-button-small"
                                                    type="button"
                                                    wishboxquickorder="minus"
                                            >-</button>
                                            <input
                                                    class="uk-input uk-input-small uk-form-width-small uk-text-center"
                                                    type="number"
                                                    name="quantity"
                                                    value="1"
                                                    min="1"
                                                    max="99"
                                                    style="width: 50px; margin: 0 3px;"
                                                    wishboxquickorder="quantity"
                                            >
                                            <button
                                                    class="uk-button uk-button-primary uk-button-small"
                                                    type="button"
                                                    wishboxquickorder="plus"
                                            >+</button>
                                        </div>
                                    </div>
                                    <div class="uk-width-1-1 uk-width-1-1@s uk-width-1-3@m">
                                            <span wishboxquickorder="total" class="text-primary fs-4">
                                            </span>
                                    </div>
                                </div>
                                <?php if ($jshopConfig->stock) { ?>
                                    <div class="qty_in_stock">
                                        <?php echo Text::_('JSHOP_QTY_IN_STOCK'); ?>:
                                        <span id="product_qty" wishboxquickorder="stock">
                                        </span>
                                    </div>
                                <?php } ?>
                            </div>

                        </div>
                        <div class="uk-form-stacked uk-margin-top" uk-grid>

	                        <?php if ($params->get('field_f_name') != 'hidden') { ?>
                            <div class="uk-margin uk-margin-top uk-width-1-1 uk-width-1-2@m">
                                <label
                                        for="wishboxquckiorder-f_name"
                                        class="uk-form-label"
                                >
                                    <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_FIRST_NAME_LABEL'); ?>
                                </label>
                                <div class="uk-form-controls">
                                    <input
                                            type="text"
                                            name="f_name"
                                            class="uk-input"
                                            id="wishboxquckiorder-f_name"
                                            value=""
                                            placeholder="<?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_FIRST_NAME_LABEL'); ?>"
	                                    <?php echo $params->get('field_f_name') == 'required' ? 'required' : ''; ?>
                                    />
                                </div>
                            </div>
	                        <?php } ?>

	                        <?php if ($params->get('field_l_name', 'required') != 'hidden') { ?>
                            <div class="uk-margin uk-width-1-1 uk-width-1-2@m">
                                <label
                                        for="wishboxquckiorder-l_name"
                                        class="uk-form-label"
                                >
                                    <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_LAST_NAME_LABEL'); ?>
                                </label>
                                <div class="uk-form-controls">
                                    <input
                                            type="text"
                                            name="l_name"
                                            class="uk-input"
                                            id="wishboxquckiorder-l_name"
                                            value=""
                                            placeholder="<?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_LAST_NAME_LABEL'); ?>"
	                                        <?php echo $params->get('field_email', 'required') == 'required' ? 'required' : ''; ?>
                                    />
                                </div>
                            </div>
                            <?php } ?>

	                        <?php if ($params->get('field_phone') != 'hidden') { ?>
                            <div class="uk-margin uk-width-1-1 uk-width-1-2@m">
                                <label
                                        for="wishboxquckiorder-phone"
                                        class="uk-form-label"
                                >
                                    <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_PHONE_LABEL'); ?>
                                </label>
                                <div class="uk-form-controls">
                                    <input
                                            type="text"
                                            name="phone"
                                            class="uk-input"
                                            id="wishboxquckiorder-phone"
                                            value=""
                                            placeholder="<?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_PHONE_LABEL'); ?>"
                                            required
                                    />
                                </div>
                            </div>
	                        <?php } ?>

	                        <?php if ($params->get('field_email') != 'hidden') { ?>
                            <div class="uk-margin uk-width-1-1 uk-width-1-2@m">
                                <label
                                        for="wishboxquckiorder-email"
                                        class="uk-form-label"
                                >
                                    <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_EMAIL_LABEL'); ?>
                                </label>
                                <div class="uk-form-controls">
                                    <input
                                            type="text"
                                            name="email"
                                            class="uk-input"
                                            id="wishboxquckiorder-email"
                                            value=""
                                            placeholder="<?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_EMAIL_LABEL'); ?>"
	                                        <?php echo $params->get('field_email') == 'required' ? 'required' : ''; ?>
                                    />
                                </div>
                            </div>
                            <?php } ?>

                        </div>
                        <div>
                            <div class="uk-margin">
                                <button
                                        type="button"
                                        class="uk-button uk-button-primary uk-align-center"
                                        wishboxquickorder="submit"
                                >
                                    <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_FORM_SUMBIT_BUTTON_TEXT'); ?>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

                <div
                        class="uk-position-absolute uk-position-top uk-width-1-1 uk-height-1-1"
                        style="display: none; z-index: 3;"
                        wishboxquickorder="loading"

                >
                    <div
                            class="uk-flex-inline uk-flex-center uk-flex-middle uk-width-1-1 uk-height-1-1"
                            style="background: rgba(255, 255, 255, 0.8)"
                    >
                        <div
                                style="width: 5rem; height: 5rem;"
                                role="status"
                                uk-spinner="ratio: 8"
                        >
                            <span class="uk-invisible">
                                <?php echo Text::_('PLG_JSHOPPING_WISHBOXQUICKORDER_LOADING'); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
