import WishboxJShoppingQuickOrderAjax from 'plg_jshopping_wishboxquickorder.ajax.bootstrap';

class WishboxJShoppingQuickOrderButton {
    constructor(element, form) {
        this.buttonElement = element;
        this.form = form;
        this.categoryId = parseInt(this.buttonElement.getAttribute('wishboxquickorder-category_id'));
        this.productId = parseInt(this.buttonElement.getAttribute('wishboxquickorder-product_id'));

        let productFormElement = this.buttonElement.closest('form[name="product"]');

        if (productFormElement) {
            this.productFormElement = productFormElement
        } else {
            this.productFormElement = false;
        }

        this.buttonElement.addEventListener
        (
            'click',
            (event) =>
            {
                this.openForm();
            }
        );
    }

    openForm()
    {
        this.loadProductData(
            () => {
                if (this.productFormElement)
                {
                    this.form.setProductFormElement(this.productFormElement);
                }

                this.form.setProductData(this.productData);

                this.form.show();
            }
        );
    }

    loadProductData(callback)
    {
        if (!this.productData) {
            let ajaxData = new FormData();
            ajaxData.set('category_id', this.categoryId);
            ajaxData.set('product_id', this.productId);
            const ajax = new WishboxJShoppingQuickOrderAjax();
            ajax.sendAjax(
                ajax.systemPaths.root + '/index.php?option=com_ajax&plugin=wishboxquickordergetproductdata&group=jshopping&format=json&ignoreMessages=0',
                'post',
                ajaxData
            ).then(
                response => {
                    if (response.data)
                    {
                        this.productData = {
                            'productId': this.productId,
                            'categoryId': this.categoryId,
                            'name': response.data.productName,
                            'productEan': response.data.productEan,
                            'productPrice': parseFloat(response.data.productPrice),
                            'priceForQuantity': parseFloat(response.data.productPrice),
                            'productImage': response.data.productImage,
                            'wishboxfoldquantity': response.data.wishboxfoldquantity,
                            'stock': response.data.stock,
                            'prices': response.data.prices ? response.data.prices : []
                        }
                    }

                    callback();
                }
            ).catch(
                error => {
                    console.error(error);
                }
            );
        }
        else
        {
            callback();
        }
    }
}

export { WishboxJShoppingQuickOrderButton as default };