import WishboxJShoppingQuickOrderAjax from 'plg_jshopping_wishboxquickorder.ajax.uikit';

class WishboxJShoppingQuickOrderForm {
    constructor(element) {
        this.modalElement = element;
        this.formWrapperElement = this.modalElement.querySelector('[wishboxquickorder="form-wrapper"]');
        this.formElement = this.modalElement.querySelector('[wishboxquickorder="form"]');
        this.nameElement = this.modalElement.querySelector('[wishboxquickorder="name"]');
        this.codeElement = this.modalElement.querySelector('[wishboxquickorder="code"]');
        this.priceElement = this.modalElement.querySelector('[wishboxquickorder="price"]');
        this.imageElement = this.modalElement.querySelector('[wishboxquickorder="image"]');
        this.minusElement = this.modalElement.querySelector('[wishboxquickorder="minus"]');
        this.quantityElement = this.modalElement.querySelector('[wishboxquickorder="quantity"]');
        this.plusElement = this.modalElement.querySelector('[wishboxquickorder="plus"]');
        this.totalElement = this.modalElement.querySelector('[wishboxquickorder="total"]');
        this.stockElement = this.modalElement.querySelector('[wishboxquickorder="stock"]');
        this.submitElement = this.modalElement.querySelector('[wishboxquickorder="submit"]');
        this.loadingElement = this.modalElement.querySelector('[wishboxquickorder="loading"]');
        this.messageContainerElement = this.modalElement.querySelector('[wishboxquickorder="message-container"]');
        this.firstNameElement = this.modalElement.querySelector('[name="f_name"]');
        this.lastNameElement = this.modalElement.querySelector('[name="l_name"]');
        this.phoneElement = this.modalElement.querySelector('[name="phone"]');
        this.emailElement = this.modalElement.querySelector('[name="email"]');

        this.minusElement.addEventListener
        (
            'click',
            (event) => {
                this.changeQuantity('-')
            }
        );

        this.plusElement.addEventListener
        (
            'click',
            (event) => {
                this.changeQuantity('+')
            }
        );

        this.submitElement.addEventListener
        (
            'click',
            (event) => {
                event.preventDefault();
                this.submitForm()
            }
        );

        this.modal = UIkit.modal(this.modalElement, {});

        UIkit.util.on(this.modalElement, 'show', (e) => {
            this.removeMessages(
                this.messageContainerElement
            );

            this.formWrapperElement.style.display = 'block';
        });

        if (this.firstNameElement) {
            this.firstNameElement.addEventListener('blur', (e) => {
                this.validateElement(this.firstNameElement);
            });
        }

        if (this.lastNameElement) {
            this.lastNameElement.addEventListener('blur', (e) => {
                this.validateElement(this.lastNameElement);
            });
        }

        if (this.phoneElement) {
            this.phoneElement.addEventListener('blur', (e) => {
                this.validateElement(this.phoneElement);
            });
        }

        if (this.emailElement) {
            this.emailElement.addEventListener('blur', (e) => {
                this.validateElement(this.emailElement);
            });
        }
    }

    reloadAttribEvents(json)
    {
        this.setPrice(json.pricefloat);
    }

    setProductFormElement(productFormElement) {
        this.productFormElement = productFormElement;
    }

    setProductData(productData) {
        this.productData = productData;

        this.update()
    }

    update()
    {
        this.nameElement.innerText = this.productData.name;

        if (this.codeElement) {
            this.codeElement.innerText = this.productData.productEan;
        }

        this.priceElement.innerText = this.formatPrice(this.getPrice(this.productData.wishboxfoldquantity));
        this.imageElement.setAttribute('src', this.productData.productImage);
        this.imageElement.setAttribute('alt', this.productData.productName);
        this.quantityElement.value = this.productData.wishboxfoldquantity;
        this.totalElement.innerText = this.formatPrice(this.productData.productPrice * this.productData.wishboxfoldquantity);

        if (this.stockElement) {
            this.stockElement.innerText = this.productData.stock;
        }
    }

    changeQuantity(type)
    {
        let quantity = parseFloat(this.quantityElement.value);

        if (type) {
            if (type === '-' && quantity > this.productData.wishboxfoldquantity) {
                quantity -= this.productData.wishboxfoldquantity;
            }
            else if (type === '+') {
                quantity += this.productData.wishboxfoldquantity;
            }
        }

        this.quantityElement.value = quantity;

        if (this.productFormElement) {
            jshop.reloadPrices();
        } else {
            let priceNew = this.getPrice(quantity);

            if (priceNew !== this.productData.priceForQuantity) {
                this.setPrice(priceNew)
            }
        }
    }

    setPrice(price)
    {
        this.productData.priceForQuantity = price;
        this.priceElement.innerHTML = this.formatPrice(price);
        this.updateTotal();
    }

    updateTotal()
    {
        let quantity = parseFloat(this.quantityElement.value);

        let total = quantity * this.productData.priceForQuantity;

        if (total > 0)
        {
            this.totalElement.innerText = this.formatPrice(total);
        }
    }

    getFormData()
    {
        let formData = new FormData();

        formData.append('product_id',   this.productData.productId);
        formData.append('category_id',  this.productData.categoryId);
        formData.append('quantity',     this.quantityElement.value);

        if (this.productFormElement)
        {
            let productForm = new FormData(this.productFormElement);

            for (let field of productForm.entries())
            {
                if (field[0] !== 'to' && field[0] !== 'quantity')
                {
                    formData.append(field[0], field[1]);
                }
            }
        }

        if (this.firstNameElement) {
            formData.append('f_name', this.firstNameElement.value);
        }

        if (this.lastNameElement) {
            formData.append('l_name', this.lastNameElement.value);
        }

        if (this.phoneElement) {
            formData.append('phone', this.phoneElement.value);
        }

        if (this.emailElement) {
            formData.append('email', this.emailElement.value);
        }

        return formData;
    }

    isValid()
    {
        if (!this.formElement.checkValidity())
        {
            const elements = [];

            if (this.firstNameElement) {
                elements.push(this.firstNameElement);
            }

            if (this.lastNameElement) {
                elements.push(this.lastNameElement);
            }

            if (this.phoneElement) {
                elements.push(this.phoneElement);
            }

            if (this.emailElement) {
                elements.push(this.emailElement);
            }

            elements.forEach((element) => {
                this.validateElement(element);
            });

            return false;
        }

        return true;
    }

    validateElement(element)
    {
        if (element.checkValidity()) {
            element.classList.remove('uk-form-danger');
            element.classList.add('uk-form-success');
        } else {
            element.classList.remove('uk-form-success');
            element.classList.add('uk-form-danger');
        }
    }

    submitForm(event)
    {
        if (this.isValid())
        {
            this.setLoading();
            const ajaxData = this.getFormData();
            const ajax = new WishboxJShoppingQuickOrderAjax();

            ajax.sendAjax(ajax.systemPaths.root + '/index.php?option=com_ajax&plugin=wishboxquickordersubmitform&group=jshopping&format=json&ignoreMessages=0',
                'post',
                ajaxData).then
            (
                response =>
                {
                    this.hideLoading();

                    if (response.success == true)
                    {
                        if (response.messages) {
                            this.renderMessages(
                                response.messages,
                                this.messageContainerElement
                            );
                        }

                        this.formWrapperElement.style.display = 'none';
                    }
                    else
                    {
                        this.renderMessages(
                            response.messages,
                            this.messageContainerElement
                        );
                    }
                }
            ).catch
            (
                error =>
                {
                    this.hideLoading();
                    this.renderMessages(
                        error.messages,
                        this.messageContainerElement
                    );
                }
            );
        }

        return false;
    }

    setLoading()
    {
        this.loadingElement.style.display = '';
    }

    hideLoading()
    {
        this.loadingElement.style.display = 'none';
    }

    formatPrice(price)
    {
        let options = Joomla.getOptions('wishboxquickorder');

        jshopParams.decimal_count = options['decimal_count'];
        jshopParams.decimal_symbol = options['decimal_symbol'];
        jshopParams.format_currency = options['format_currency'];
        jshopParams.currency_code = options['currency_code'];

        return jshop.formatprice(price);
    }

    getPrice(quantity)
    {
        if (this.productData.prices.length > 0 && quantity)
        {
            for (let i = 0; i < this.productData.prices.length; i++)
            {
                let price = this.productData.prices[i];

                if (price.start <= quantity && price.end >= quantity)
                {
                    return price.price;
                }
            }
        }
        else
        {
            return this.productData.productPrice;
        }
    }

    show()
    {
        if (this.productFormElement)
        {
            let self = this;
            jshop.reloadAttribEvents.push(function(json) {self.reloadAttribEvents(json)});
            jshop.reloadPrices();
        }
        this.modal.show();
    }

    renderMessages(messages, messageContainer, keepOld, timeout)
    {
        messageContainer.querySelectorAll('.uk-alert').forEach(
            (alert) => {
                UIkit.alert(alert).close();
            }
        );

        Object.keys(messages).forEach(type => {
            let alertClass = type;

            const typeMessages = messages[type];
            const messagesBox = document.createElement('div');

            messagesBox.setAttribute('uk-alert', '');

            if (['success', 'info', 'danger', 'warning'].indexOf(type) < 0) {
                alertClass = type === 'notice' ? 'uk-alert-primary' : type;
                alertClass = type === 'message' ? 'uk-alert-success' : alertClass;
                alertClass = type === 'error' ? 'uk-alert-danger' : alertClass;
                alertClass = type === 'warning' ? 'uk-alert-warning' : alertClass;
            }

            messagesBox.setAttribute('class', alertClass);

            const title = Joomla.Text._(type);

            const messageWrapper = document.createElement('div');

            typeMessages.forEach(typeMessage => {
                messageWrapper.innerHTML += Joomla.sanitizeHtml(`<div class="alert-message">${typeMessage}</div>`);
            });
            messagesBox.appendChild(messageWrapper);
            messageContainer.appendChild(messagesBox);
        });
    }

    removeMessages(messageContainer)
    {
        messageContainer.querySelectorAll('.uk-alert').forEach(
            (alert) => {
                UIkit.alert(alert).close();
            }
        );
    }
}

export { WishboxJShoppingQuickOrderForm as default };