<?php namespace Joomla\Component\QuantumManager\Site\Dispatcher;

/**
 * @package    quantummanager
 * @author     Dmitry Tsymbal <cymbal@delo-design.ru>
 * @copyright  Copyright © 2019 Delo Design & NorrNext. All rights reserved.
 * @license    GNU General Public License version 3 or later; see license.txt
 * @link       https://www.norrnext.com
 */

use Joomla\CMS\Dispatcher\ComponentDispatcher;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * ComponentDispatcher class for com_quantummanager
 *
 * @since  4.0.0
 */
class Dispatcher extends ComponentDispatcher
{

	protected function loadLanguage()
	{
		// Load common and local language files.
		$this->app->getLanguage()->load($this->option, JPATH_BASE) ||
		$this->app->getLanguage()->load($this->option, JPATH_COMPONENT);
		$this->app->getLanguage()->load($this->option, JPATH_ADMINISTRATOR);
	}

}
