# Группа полей layouts


## Поля

### Поле layouts
#### Описание
Универсальное поле поиска шаблонов. Это поле не запрашивает в базу какая у нас главная тема для сайта, она анализирует все доступные папки шаблонов.

#### Атрибуты
- values - строка | вы можете добавить кастомные пути для поиска шаблонов. Вы должны для этого создать свой класс php и там статический метод и указать в этом параметре. <br/>
Например, у нас есть класс PathsHelper, в нем есть статический публичный метод getLayouts, который возвращает массив путей. И записывается в атрибуте как: values="PathsHelper::getLayouts". Так же не забывайте, что этот класс должен быть загружен, где у вас исполняется форма. <br/>
  В возвращаемом массиве у вас доступна переменная {TEMPLATES}, то есть вы можете, например, вернуть в массиве один из элементов, например, {TEMPLATES}/html/plg_fields_radicaluniversalfield. Алгоритм просканирует во всех доступных папках шаблонов этот путь и вытащит все доступные шаблоны.
- target - строка | через запятую можете указать сущность, для которой ищется. Например, вам надо найти шаблоны компонента, то пишите имя вашего компонента, например "components/com_content". Или надо получить все шаблоны для плагина, то пишите "plugin.fields.radicaluniversalfield"

#### Пример xml
```xml
<field
    name="mytemplate"
    type="layouts"
    label="Мое название поля"
    description="Мое описание поля"
    values="PathsHelper::getLayouts"
    target="plugin.fields.radicaluniversalfield"
    addfieldpath="libraries/lib_fields/layouts"
/>
```


<br />


### Поле layoutsplugin
#### Описание
Для выбора в плагине дополнительного слоя шаблонизации чего-либо внутри плагина. <br/>
Слои шаблонизации располагаются в папке */layouts* в папке плагина и переопределяются в папке */html/layouts/plugin/{тип плагина}/{имя плагина}/* в папке основного шаблона сайта. <br/>
Для указания слоя по умолчанию задать значение `default="_:default"`, где после двоеточия - имя файла слоя без расширения. Файл слоя, переопределённый в основном шаблоне (имеющий совпадающее имя файла), считается как слой из плагина.

#### Атрибуты
- client_id - число | где искать на фронтовой части или в административной части. Принимаются значения: 0 и 1. 0 - фронтовая часть, 1 - административная часть

#### Пример xml
```xml
<field
    name="mytemplate"
    type="layoutsplugin"
    label="Мое название поля"
    description="Мое описание поля"
    client_id="0"
    addfieldpath="libraries/lib_fields/layouts"
/>
```

<br />

### Поле layoutsmodule
#### Описание
Для выбора в модуле дополнительного слоя шаблонизации чего-либо внутри модуля. <br/>
Слои шаблонизации располагаются в папке */layouts* в папке модуля и переопределяются в папке */html/layouts/mod_{имя модуля}/* в папке основного шаблона сайта. <br/>
Для указания слоя по умолчанию задать значение `default="_:default"`, где после двоеточия - имя файла слоя без расширения. Файл слоя, переопределённый в основном шаблоне (имеющий совпадающее имя файла), считается как слой из модуля. <br/>

#### Атрибуты
- client_id - число | где искать на фронтовой части или в административной части. Принимаются значения: 0 и 1. 0 - фронтовая часть, 1 - административная часть

#### Пример xml
```xml
<field
    name="mytemplate"
    type="layoutsmodule"
    label="Мое название поля"
    description="Мое описание поля"
    addfieldpath="libraries/lib_fields/layouts"
/>
```