<?php
/*
 * @package   pkg_radicalmart_favorites
 * @version   1.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\RadicalMart\Site\Helper\RouteHelper;

$this->document->getWebAssetManager()->usePreset('com_radicalmart_favorites.administrator.form');

$user      = Factory::getApplication()->getIdentity();
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));

$columns = 5;

?>
<form action="<?php echo Route::_('index.php?option=com_radicalmart_favorites&view=favorites'); ?>" method="post"
      name="adminForm" id="adminForm">
    <div id="j-main-container" class="span10">
		<?php echo LayoutHelper::render('joomla.searchtools.default',
			array('view' => $this, 'options' => array('filtersHidden' => false))); ?>
		<?php if (empty($this->items)) : ?>
            <div class="alert alert-no-items">
				<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
		<?php else : ?>
            <table id="commentsList" class="table table-striped">
                <thead>
                <tr>
                    <th width="1%" class="text-center">
						<?php echo HTMLHelper::_('grid.checkall'); ?>
                    </th>
                    <th class="break-word">
						<?php echo HTMLHelper::_('searchtools.sort', 'COM_RADICALMART_FAVORITES_PRODUCT', 'product_title',
							$listDirn, $listOrder); ?>
                    </th>
                    <th class="break-word">
						<?php echo HTMLHelper::_('searchtools.sort', 'COM_RADICALMART_FAVORITES_USER', 'user_name',
							$listDirn, $listOrder); ?>
                    </th>
                    <th class="break-word text-center">
						<?php echo HTMLHelper::_('searchtools.sort', 'COM_RADICALMART_FAVORITES_DATE', 'f.date',
							$listDirn, $listOrder); ?>
                    </th>
                    <th width="1%" class="break-word text-center">
						<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'f.id', $listDirn, $listOrder); ?>
                    </th>
                </tr>
                </thead>
                <tfoot>
                <tr>
                    <td colspan="<?php echo $columns; ?>">
                        <div class="uk-clearfix">
                            <div class="pull-right"><?php echo $this->pagination->getResultsCounter(); ?></div>
                            <div class="pull-left"><?php echo $this->pagination->getListFooter(); ?></div>
                        </div>
                    </td>
                </tr>
                </tfoot>
                <tbody>
				<?php foreach ($this->items as $i => $item) : ?>
                    <tr class="row<?php echo $i % 2; ?>" item-id="<?php echo $item->id ?>">
                        <td class="text-center">
							<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                        </td>
                        <td class="break-word">
							<a href="<?php echo Route::link('site', RouteHelper::getProductRoute($item->product_id), false); ?>" target="_blank"><?php echo $item->product_title; ?>
                        </td>
                        <td class="break-word">
							<?php echo $item->user_name; ?>
                        </td>
                        <td class="text-center small break-word">
							<?php echo ($item->date > 0) ? HTMLHelper::_('date', $item->date,
								Text::_('DATE_FORMAT_LC2')) : '-'; ?>
                        </td>
                        <td class="text-center"><?php echo $item->id; ?></td>
                    </tr>
				<?php endforeach; ?>
                </tbody>
            </table>
		<?php endif; ?>
        <input type="hidden" name="task" value=""/>
        <input type="hidden" name="boxchecked" value="0"/>
		<?php echo HTMLHelper::_('form.token'); ?>
    </div>
</form>