<?php
/*
 * @package   pkg_radicalmart_favorites
 * @version   1.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\RadicalMartFavorites\Site\Helper\RouteHelper;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 *
 * @var  int $product_id Product id.
 * @var  int $context    Context.
 */

HTMLHelper::_('bootstrap.dropdown');

?>

<div class="dropdown">
    <button class="btn btn-success btn-sm" type="button" data-bs-toggle="dropdown" aria-expanded="false">
        <span class="icon-heart"></span>
    </button>
    <ul class="dropdown-menu">
        <li><a class="dropdown-item" href="<?php echo Route::link('site', RouteHelper::getFavoritesRoute(), false); ?>"><?php echo Text::_('COM_RADICALMART_FAVORITES_GOTO_FAVORITES'); ?></a></li>
        <li><a class="dropdown-item text-danger" href="#" radicalmart-favorite="button" data-state="1" data-product="<?php echo $product_id; ?>" onclick="window.RadicalMartFavorites().toggle(event);"><?php echo Text::_('COM_RADICALMART_FAVORITES_REMOVE'); ?></a></li>
    </ul>
</div>