/*
 * @package   pkg_radicalmart_favorites
 * @version   1.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	/************************************************************************/
var __webpack_exports__ = {};
/*!*****************************************************!*\
  !*** ./com_radicalmart_favorites/es6/favorites.es6 ***!
  \*****************************************************/
/*
 * @package   pkg_radicalmart_favorites
 * @version   1.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */



function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var RadicalMartFavorites = /*#__PURE__*/function () {
  function RadicalMartFavorites() {
    _classCallCheck(this, RadicalMartFavorites);
    this.options = null;
    this.controller = '/index.php?option=com_radicalmart_favorites&view=favorite';
    this.containers = null;
    this.csrf = null;
  }
  _createClass(RadicalMartFavorites, [{
    key: "initialization",
    value: function initialization() {
      var _this = this;
      // Update module
      document.addEventListener('onRadicalMartFavoriteAdd', function (event) {
        var modules = document.querySelectorAll('[radicalmart-favorites="module"], [data-radicalmart-favorites="module"]');
        if (modules.length) {
          _this.sendAjax('favorite.count').then(function (result) {
            modules.forEach(function (module) {
              module.textContent = result;
              if (parseInt(result) === 0) {
                module.style.display = 'none';
              } else {
                module.style.display = 'block';
              }
            });
          }).catch(function (error) {
            _this.triggerEvent('onRadicalMartFavoriteError', error.message);
            console.error(error.message);
          });
        }
      });
    }
  }, {
    key: "toggle",
    value: function toggle(event) {
      var _this2 = this;
      event.preventDefault();
      var target = event.currentTarget,
        product_id = target.getAttribute('data-product'),
        container = target.closest('[radicalmart-favorite="container"]'),
        simple = parseInt(container.getAttribute('data-simple')),
        context = container.getAttribute('data-context'),
        state = parseInt(target.getAttribute('data-state'));
      var formData = new FormData();
      formData.set('product_id', product_id);
      formData.set('state', state);
      formData.set('simple', simple);
      formData.set('context', context);
      this.sendAjax('favorite.toggle', formData).then(function (result) {
        _this2.triggerEvent('onRadicalMartFavoriteAdd', {
          product_id: product_id,
          action: state === 0 ? 'add' : 'remove'
        });
        container.innerHTML = result.html;
      }).catch(function (error) {
        _this2.triggerEvent('onRadicalMartFavoriteError', error.message);
        console.error(error.message);
      });
    }
  }, {
    key: "setVariable",
    value: function setVariable(key, value) {
      this[key] = value;
    }
  }, {
    key: "getVariable",
    value: function getVariable(key) {
      var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return !this[key] || this[key] === null ? defaultValue : this[key];
    }
  }, {
    key: "triggerEvent",
    value: function triggerEvent() {
      var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      if (name) {
        console.debug('RadicalMart Favorites Triggered:' + name);
        document.dispatchEvent(new CustomEvent(name, {
          detail: data
        }));
      }
    }
  }, {
    key: "sendAjax",
    value: function sendAjax() {
      var _this3 = this;
      var task = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var csrfCache = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      return new Promise(function (success, error) {
        if (task === null) {
          return error({
            message: 'Task is empty'
          });
        }
        var controller = _this3.controller;
        if (!controller) {
          return error({
            message: 'Controller not found'
          });
        }
        var isFormData = data instanceof FormData,
          formData = isFormData ? data : new FormData();
        if (!isFormData) {
          formData = _this3.objectToFormData(data, formData);
        }
        formData.set('task', task);
        var csrf = _this3.getVariable('csrf', false);
        if (!csrfCache || !csrf) {
          _this3.getCSRF().then(function (csrf) {
            formData.set(csrf, '1');
            _this3.sendRequest(controller, formData).then(function (s) {
              return success(s);
            }).catch(function (e) {
              return error(e);
            });
          }).catch(function (e) {
            if (e.message === 'Request aborted' || e.message === null || e.message === '') {
              console.error('aborted');
            } else {
              return error(e);
            }
          });
        } else {
          formData.set(csrf, '1');
          _this3.sendRequest(controller, formData).then(function (s) {
            return success(s);
          }).catch(function (e) {
            return error(e);
          });
        }
      });
    }
  }, {
    key: "objectToFormData",
    value: function objectToFormData() {
      var _this4 = this;
      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var formData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      if (formData === null) {
        formData = new FormData();
      }
      if (path === null) {
        path = '';
      }
      Object.keys(data).forEach(function (key) {
        var name = path ? path + '[' + key + ']' : key,
          value = data[key];
        if (Array.isArray(value)) {
          value.forEach(function (val) {
            formData.append(name + '[]', val);
          });
        } else if (_typeof(value) === 'object') {
          formData = _this4.objectToFormData(value, formData, name);
        } else {
          formData.set(name, value);
        }
      });
      return formData;
    }
  }, {
    key: "sendRequest",
    value: function sendRequest(controller, formData) {
      return new Promise(function (success, error) {
        Joomla.request({
          url: controller,
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            try {
              response = JSON.parse(response);
              if (response.success) {
                return success(response.data);
              } else {
                return error({
                  message: response.message
                });
              }
            } catch (je) {
              return error(je);
            }
          },
          onError: function onError(e) {
            return error(e);
          }
        });
      });
    }
  }, {
    key: "getCSRF",
    value: function getCSRF() {
      var _this5 = this;
      return new Promise(function (success, error) {
        var controller = _this5.controller;
        if (!controller) {
          return error({
            message: 'Controller not found'
          });
        }
        var formData = new FormData();
        formData.set('task', 'getCSRF');
        formData.set('check_post', '1');
        Joomla.request({
          url: controller,
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            try {
              response = JSON.parse(response);
              if (response.success) {
                var token = response.data;
                if (token) {
                  success(token);
                  _this5.setVariable('csrf', token);
                } else {
                  return error({
                    message: 'Token not found'
                  });
                }
              } else {
                return error({
                  message: response.message
                });
              }
            } catch (je) {
              return error(je);
            }
          },
          onError: function onError(e) {
            if (e.message === 'Request aborted' || e.message === null || e.message === '') {
              console.error('aborted');
            } else {
              return error(e);
            }
          }
        });
      });
    }
  }]);
  return RadicalMartFavorites;
}();
window.RadicalMartFavoritesClass = null;
window.RadicalMartFavorites = function () {
  if (window.RadicalMartFavoritesClass === null) {
    window.RadicalMartFavoritesClass = new RadicalMartFavorites();
  }
  return window.RadicalMartFavoritesClass;
};
document.addEventListener('DOMContentLoaded', function () {
  window.RadicalMartFavorites().initialization();
});
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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