<?php
/*
 * @package   pkg_radicalmart_favorites
 * @version   1.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\Component\RadicalMartFavorites\Site\Helper\FavoritesHelper;
use Joomla\Component\RadicalMartFavorites\Site\Helper\RouteHelper;

// Load assets
$app       = Factory::getApplication();
$assets = $app->getDocument()->getWebAssetManager();
$assets->getRegistry()->addExtensionRegistryFile('com_radicalmart_favorites');
$assets->useScript('com_radicalmart_favorites.site.favorites');

$count = FavoritesHelper::getFavoritesCount();

?>

<div class="radicalmart-favorites-module <?php echo $params->get('moduleclass_sfx');?>">
    <a href="<?php echo Route::link('site', RouteHelper::getFavoritesRoute(), false); ?>" class="position-relative">
        <span class="icon-heart"></span>
        <span class="radicalmart-favorites-module__counter position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger quantity"
              radicalmart-favorites="module" style="<?php echo !$count ? 'display:none' : ''; ?>">
            <?php echo $count; ?>
        </span>
    </a>
</div>