/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	/************************************************************************/
var __webpack_exports__ = {};
/*!*****************************************************!*\
  !*** ./com_radicalmart_favorites/es6/favorites.es6 ***!
  \*****************************************************/
/*
 * @package   pkg_radicalmart_favorites
 * @version   1.0.1
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */



function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var RadicalMartFavorites = /*#__PURE__*/function () {
  function RadicalMartFavorites() {
    _classCallCheck(this, RadicalMartFavorites);
    this.options = null;
    this.controller = '/index.php?option=com_radicalmart_favorites&view=favorite';
    this.containers = null;
    this.csrf = null;
  }
  _createClass(RadicalMartFavorites, [{
    key: "initialization",
    value: function initialization() {
      var _this = this;
      // Update module
      document.addEventListener('onRadicalMartFavoriteAdd', function (event) {
        var modules = document.querySelectorAll('[radicalmart-favorites="module"], [data-radicalmart-favorites="module"]');
        if (modules.length) {
          _this.sendAjax('favorite.count').then(function (result) {
            modules.forEach(function (module) {
              module.textContent = result;
              if (parseInt(result) === 0) {
                module.style.display = 'none';
              } else {
                module.style.display = 'block';
              }
              _this.triggerEvent('onRadicalMartFavoriteModuleUpdate', {
                module: module,
                count: parseInt(result)
              });
            });
          }).catch(function (error) {
            _this.triggerEvent('onRadicalMartFavoriteError', error.message);
            console.error(error.message);
          });
        }
      });
    }
  }, {
    key: "toggle",
    value: function toggle(event) {
      var _this2 = this;
      event.preventDefault();
      var target = event.currentTarget,
        product_id = target.getAttribute('data-product'),
        container = target.closest('[radicalmart-favorite="container"]'),
        simple = parseInt(container.getAttribute('data-simple')),
        context = container.getAttribute('data-context'),
        state = parseInt(target.getAttribute('data-state'));
      var formData = new FormData();
      formData.set('product_id', product_id);
      formData.set('state', state);
      formData.set('simple', simple);
      formData.set('context', context);
      this.sendAjax('favorite.toggle', formData).then(function (result) {
        _this2.triggerEvent('onRadicalMartFavoriteAdd', {
          product_id: product_id,
          content: context,
          action: state === 0 ? 'add' : 'remove'
        });
        container.innerHTML = result.html;
      }).catch(function (error) {
        _this2.triggerEvent('onRadicalMartFavoriteError', error.message);
        console.error(error.message);
      });
    }
  }, {
    key: "setVariable",
    value: function setVariable(key, value) {
      this[key] = value;
    }
  }, {
    key: "getVariable",
    value: function getVariable(key) {
      var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return !this[key] || this[key] === null ? defaultValue : this[key];
    }
  }, {
    key: "triggerEvent",
    value: function triggerEvent() {
      var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      if (name) {
        console.debug('RadicalMart Favorites Triggered:' + name);
        document.dispatchEvent(new CustomEvent(name, {
          detail: data
        }));
      }
    }
  }, {
    key: "sendAjax",
    value: function sendAjax() {
      var _this3 = this;
      var task = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var csrfCache = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      return new Promise(function (success, error) {
        if (task === null) {
          return error({
            message: 'Task is empty'
          });
        }
        var controller = _this3.controller;
        if (!controller) {
          return error({
            message: 'Controller not found'
          });
        }
        var isFormData = data instanceof FormData,
          formData = isFormData ? data : new FormData();
        if (!isFormData) {
          formData = _this3.objectToFormData(data, formData);
        }
        formData.set('task', task);
        var csrf = _this3.getVariable('csrf', false);
        if (!csrfCache || !csrf) {
          _this3.getCSRF().then(function (csrf) {
            formData.set(csrf, '1');
            _this3.sendRequest(controller, formData).then(function (s) {
              return success(s);
            }).catch(function (e) {
              return error(e);
            });
          }).catch(function (e) {
            if (e.message === 'Request aborted' || e.message === null || e.message === '') {
              console.error('aborted');
            } else {
              return error(e);
            }
          });
        } else {
          formData.set(csrf, '1');
          _this3.sendRequest(controller, formData).then(function (s) {
            return success(s);
          }).catch(function (e) {
            return error(e);
          });
        }
      });
    }
  }, {
    key: "objectToFormData",
    value: function objectToFormData() {
      var _this4 = this;
      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var formData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      if (formData === null) {
        formData = new FormData();
      }
      if (path === null) {
        path = '';
      }
      Object.keys(data).forEach(function (key) {
        var name = path ? path + '[' + key + ']' : key,
          value = data[key];
        if (Array.isArray(value)) {
          value.forEach(function (val) {
            formData.append(name + '[]', val);
          });
        } else if (_typeof(value) === 'object') {
          formData = _this4.objectToFormData(value, formData, name);
        } else {
          formData.set(name, value);
        }
      });
      return formData;
    }
  }, {
    key: "sendRequest",
    value: function sendRequest(controller, formData) {
      return new Promise(function (success, error) {
        Joomla.request({
          url: controller,
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            try {
              response = JSON.parse(response);
              if (response.success) {
                return success(response.data);
              } else {
                return error({
                  message: response.message
                });
              }
            } catch (je) {
              return error(je);
            }
          },
          onError: function onError(e) {
            return error(e);
          }
        });
      });
    }
  }, {
    key: "getCSRF",
    value: function getCSRF() {
      var _this5 = this;
      return new Promise(function (success, error) {
        var controller = _this5.controller;
        if (!controller) {
          return error({
            message: 'Controller not found'
          });
        }
        var formData = new FormData();
        formData.set('task', 'getCSRF');
        formData.set('check_post', '1');
        Joomla.request({
          url: controller,
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            try {
              response = JSON.parse(response);
              if (response.success) {
                var token = response.data;
                if (token) {
                  success(token);
                  _this5.setVariable('csrf', token);
                } else {
                  return error({
                    message: 'Token not found'
                  });
                }
              } else {
                return error({
                  message: response.message
                });
              }
            } catch (je) {
              return error(je);
            }
          },
          onError: function onError(e) {
            if (e.message === 'Request aborted' || e.message === null || e.message === '') {
              console.error('aborted');
            } else {
              return error(e);
            }
          }
        });
      });
    }
  }]);
  return RadicalMartFavorites;
}();
window.RadicalMartFavoritesClass = null;
window.RadicalMartFavorites = function () {
  if (window.RadicalMartFavoritesClass === null) {
    window.RadicalMartFavoritesClass = new RadicalMartFavorites();
  }
  return window.RadicalMartFavoritesClass;
};
document.addEventListener('DOMContentLoaded', function () {
  window.RadicalMartFavorites().initialization();
});
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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