<?php
/*
 * @package   pkg_radicalmart_favorites
 * @version   1.0.1
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

namespace Joomla\Component\RadicalMartFavorites\Site\Controller;

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Response\JsonResponse;
use Joomla\CMS\Session\Session;

class DisplayController extends BaseController
{
	/**
	 * Typical view method for MVC based architecture.
	 *
	 * @param   bool   $cachable   If true, the view output will be cached
	 * @param   array  $urlparams  An array of safe URL parameters and their variable types.
	 *
	 * @return  BaseController  A BaseController object to support chaining.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public function display($cachable = false, $urlparams = [])
	{
		return parent::display($cachable, $urlparams);
	}

	/**
	 * Method to send form token.
	 *
	 * @return bool True on success, False on failure.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public function getCSRF()
	{
		$check = (!empty($this->input->post->getInt('check_post')));

		$message  = ($check) ? '' : Text::_('COM_RADICALMART_FAVORITES_ACCESS_DENIED');
		$code     = ($check) ? 200 : 401;
		$response = ($check) ? Session::getFormToken() : 1;

		header('Content-Type: application/json');
		echo new JsonResponse($response, $message, ($code !== 200));
		Factory::getApplication()->close($code);

		return ($code === 200);
	}
}