<?php
/*
 * @package   pkg_radicalmart_favorites
 * @version   1.0.1
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

namespace Joomla\Component\RadicalMartFavorites\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Helper\RouteHelper as RouteHelperCore;

class RouteHelper extends RouteHelperCore
{

	/**
	 * Fetches favorites route.
	 *
	 * @param   string  $language  The language code.
	 *
	 * @throws  \Exception
	 *
	 * @return  string  Page view link.
	 *
	 * @since  1.0.0
	 */
	public static function getFavoritesRoute()
	{
		$link = 'index.php?option=com_radicalmart_favorites&view=favorites';

		return $link;
	}
}