<?php
/*
 * @package   pkg_radicalmart_favorites
 * @version   1.0.2
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 *
 * @var  int $product_id Product id.
 * @var  int $active     Check favorite state.
 * @var  int $context    Context.
 */

// Load assets
$app    = Factory::getApplication();
$assets = $app->getDocument()->getWebAssetManager();
$assets->getRegistry()->addExtensionRegistryFile('com_radicalmart_favorites');
$assets->useScript('com_radicalmart_favorites.site.favorites');

$simple = $app->input->get('option') === 'com_radicalmart_favorites';

if (!$simple)
{
	$assets->useScript('bootstrap.dropdown');
}

$app->getLanguage()->load('com_radicalmart_favorites', JPATH_SITE);

?>

<div radicalmart-favorite="container" data-simple="<?php echo (int) $simple; ?>" data-context="<?php echo $context; ?>">
	<?php
	if (!$active)
	{
		echo $this->subLayout('add', ['product_id' => $product_id, 'context' => $context]);
	}
	else
	{
		if ($simple)
		{
			echo $this->subLayout('remove', ['product_id' => $product_id, 'context' => $context]);
		}
		else
		{
			echo $this->subLayout('dropdown', ['product_id' => $product_id, 'context' => $context]);
		}

	}
	?>
</div>