<?php
/*
 * @package   pkg_radicalmart_favorites
 * @version   2.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2026 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

namespace Joomla\Component\RadicalMartFavorites\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Table\Table;
use Joomla\Registry\Registry;

class FavoriteModel extends AdminModel
{
	/**
	 * Model context string.
	 *
	 * @var  string
	 *
	 * @since  1.0.0
	 */
	protected $context = 'com_radicalmart_favorites.favorite';

	/**
	 * The URL option for the component.
	 *
	 * @var    string
	 * @since  3.0
	 */
	protected $option = 'com_radicalmart_favorites';

	/**
	 * Returns a Table object, always creating it.
	 *
	 * @param   string  $name     The table type to instantiate
	 * @param   string  $prefix   A prefix for the table class name.
	 * @param   array   $options  Configuration array for model.
	 *
	 * @return  Table  A database object.
	 *
	 * @since  1.0.0
	 */
	public function getTable($name = 'Favorites', $prefix = 'Administrator', $options = array())
	{
		return parent::getTable($name, $prefix, $options);
	}

	/**
	 * Abstract method for getting the form from the model.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 *
	 * @return  Form|boolean  A Form object on success, false on failure.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$form = $this->loadForm('com_radicalmart_favorites.favorite', 'favorite', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			return false;
		}

		return $form;
	}

	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public function save($data)
	{
		$pk      = (!empty($data['id'])) ? $data['id'] : (int) $this->getState($this->getName() . '.id');
		$table   = $this->getTable();
		$isNew   = true;
		$app     = Factory::getApplication();
		$nowDate = Factory::getDate()->toSql();
		$userId  = $app->getIdentity()->id;

		// Load the row if saving an existing review
		if ($pk > 0)
		{
			$table->load($pk);
			$isNew = false;
		}

		if ($isNew)
		{
			// Set created field data
			if (empty($data['date']))
			{
				$data['date'] = $nowDate;
			}

			// Set created_by field data
			if (empty($data['user_id']))
			{
				$data['user_id'] = $userId;
			}
		}

		// Prepare source field data
		if (isset($data['plugins']))
		{
			$data['plugins'] = (new Registry($data['plugins']))->toString();
		}

		if (parent::save($data))
		{
			$id = $this->getState($this->getName() . '.id');

			if (empty($id))
			{
				$id = $table->id;
			}

			return $id;
		}

		return false;
	}

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object  $record  A record object.
	 *
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission for the component.
	 *
	 * @since   1.0.0
	 */
	protected function canDelete($record)
	{
		$user   = Factory::getApplication()->getIdentity();

		return $record->user_id === $user->id;
	}
}