<?php
/*
 * @package   pkg_radicalmart_favorites
 * @version   2.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2026 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 *
 * @var  int  $product_id Product id.
 * @var  int  $active     Check favorite state.
 * @var  int  $context    Context.
 */

// Load assets
$app    = Factory::getApplication();
$assets = $app->getDocument()->getWebAssetManager();
$assets->getRegistry()->addExtensionRegistryFile('com_radicalmart_favorites');
$assets->useScript('com_radicalmart_favorites.site.favorites');

$simple = $app->input->get('option') === 'com_radicalmart_favorites';

if (!$simple)
{
	$assets->useScript('bootstrap.dropdown');
}

?>

<div radicalmart-favorite="container"
     data-simple="<?php echo (int) $simple; ?>"
     data-context="<?php echo $context; ?>">
	<?php
	if (!$active)
	{
		echo $this->subLayout('add', $displayData);
	}
	else
	{
		if ($simple)
		{
			echo $this->subLayout('remove', $displayData);
		}
		else
		{
			echo $this->subLayout('dropdown', $displayData);
		}
	}
	?>
</div>