/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	/************************************************************************/
var __webpack_exports__ = {};
/*!*****************************************************!*\
  !*** ./com_radicalmart_favorites/es6/favorites.es6 ***!
  \*****************************************************/
/*
 * @package   pkg_radicalmart_favorites
 * @version   2.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2026 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */



function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var RadicalMartFavorites = /*#__PURE__*/function () {
  function RadicalMartFavorites() {
    _classCallCheck(this, RadicalMartFavorites);
    this.options = null;
    this.controller = '/index.php?option=com_radicalmart_favorites&view=favorite';
  }
  _createClass(RadicalMartFavorites, [{
    key: "initialization",
    value: function initialization() {
      var _this = this;
      // Update module
      document.addEventListener('onRadicalMartFavoriteToggle', function (event) {
        var modules = document.querySelectorAll('[radicalmart-favorites="module"], [data-radicalmart-favorites="module"]');
        if (modules.length) {
          var formData = new FormData();
          formData.set('task', 'favorite.count');
          _this.sendRequest(formData).then(function (result) {
            modules.forEach(function (module) {
              module.textContent = result;
              if (parseInt(result) === 0) {
                module.style.display = 'none';
              } else {
                module.style.display = 'block';
              }
              _this.triggerEvent('onRadicalMartFavoriteModuleUpdate', {
                module: module,
                count: parseInt(result)
              });
            });
          }).catch(function (error) {
            _this.triggerEvent('onRadicalMartFavoriteError', error.message);
            console.error(error.message);
          });
        }
      });
    }
  }, {
    key: "toggle",
    value: function toggle(event) {
      var _this2 = this;
      event.preventDefault();
      var target = event.currentTarget,
        product_id = target.getAttribute('data-product'),
        container = target.closest('[radicalmart-favorite="container"]'),
        simple = parseInt(container.getAttribute('data-simple')),
        context = container.getAttribute('data-context'),
        state = parseInt(target.getAttribute('data-state'));
      var formData = new FormData();
      formData.set('item_id', product_id);
      formData.set('state', state);
      formData.set('simple', simple);
      formData.set('context', context);
      formData.set('task', 'favorite.toggle');
      this.sendRequest(formData).then(function (result) {
        _this2.triggerEvent('onRadicalMartFavoriteToggle', {
          item_id: product_id,
          context: context,
          action: state === 0 ? 'add' : 'remove'
        });
        container.innerHTML = result.html;
      }).catch(function (error) {
        _this2.triggerEvent('onRadicalMartFavoriteError', error.message);
        console.error(error.message);
      });
    }
  }, {
    key: "setVariable",
    value: function setVariable(key, value) {
      this[key] = value;
    }
  }, {
    key: "getVariable",
    value: function getVariable(key) {
      var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return !this[key] || this[key] === null ? defaultValue : this[key];
    }
  }, {
    key: "triggerEvent",
    value: function triggerEvent() {
      var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      if (name) {
        console.debug('RadicalMart Favorites Triggered:' + name);
        document.dispatchEvent(new CustomEvent(name, {
          detail: data
        }));
      }
    }
  }, {
    key: "sendRequest",
    value: function sendRequest(formData) {
      var _this3 = this;
      return new Promise(function (success, error) {
        Joomla.request({
          url: _this3.controller,
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            try {
              response = JSON.parse(response);
              if (response.success) {
                return success(response.data);
              } else {
                return error({
                  message: response.message
                });
              }
            } catch (je) {
              return error(je);
            }
          },
          onError: function onError(e) {
            return error(e);
          }
        });
      });
    }
  }]);
  return RadicalMartFavorites;
}();
window.RadicalMartFavoritesClass = null;
window.RadicalMartFavorites = function () {
  if (window.RadicalMartFavoritesClass === null) {
    window.RadicalMartFavoritesClass = new RadicalMartFavorites();
  }
  return window.RadicalMartFavoritesClass;
};
document.addEventListener('DOMContentLoaded', function () {
  window.RadicalMartFavorites().initialization();
});
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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