<?php
/*
 * @package   pkg_radicalmart_favorites
 * @version   2.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2026 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

// Load assets
/** @var \Joomla\CMS\WebAsset\WebAssetManager $assets */
$assets = $this->document->getWebAssetManager();
$assets->getRegistry()->addExtensionRegistryFile('com_radicalmart');

if ($this->mode === 'shop')
{
	$assets->useScript('com_radicalmart.site.cart');
	if ($this->params->get('radicalmart_js', 1))
	{
		$assets->useScript('com_radicalmart.site')
			->useScript('bootstrap.toast');
	}
}

if ($this->params->get('trigger_js', 1))
{
	$assets->useScript('com_radicalmart.site.trigger');
}

$showAddition = ((!$this->pagination || (int) $this->pagination->pagesCurrent === 1));

?>
    <div id="RadicalMartFavorites" class="radicalmart-container favorites">
        <h1 class="h2 mb-3">
			<?php echo $this->escape($this->params->get('page_heading')); ?>
        </h1>

        <div>
			<?php if (empty($this->items)) : ?>
                <div class="alert alert-info">
                    <span class="icon-info-circle" aria-hidden="true"></span>
                    <span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
					<?php echo Text::_('COM_RADICALMART_FAVORITES_ERROR_PRODUCTS_NOT_FOUND'); ?>
                </div>
			<?php else: ?>
                <div class="products-list">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered align-top">
							<?php foreach ($this->items as $item)
							{
								echo LayoutHelper::render('components.radicalmart_favorites.products.item.table', ['product' => $item, 'mode' => $this->mode]);
							} ?>
                        </table>
                    </div>
                </div>
			<?php endif; ?>
        </div>
    </div>

<?php if ($this->items && $this->pagination): ?>
    <div class="list-pagination mt-3">
		<?php echo $this->pagination->getPaginationLinks(); ?>
    </div>
<?php endif; ?>